/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.common.utils;

import cn.kinyun.scrm.weixin.recommend.common.dto.Condition;
import cn.kinyun.scrm.weixin.recommend.common.dto.Edge;
import cn.kinyun.scrm.weixin.recommend.common.dto.Expression;
import cn.kinyun.scrm.weixin.recommend.common.dto.Graph;
import cn.kinyun.scrm.weixin.recommend.common.dto.Node;
import cn.kinyun.scrm.weixin.recommend.common.dto.Op;
import cn.kinyun.scrm.weixin.recommend.common.utils.SvgUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.kuaike.scrm.dal.activity.entity.BehaviorConf;
import com.kuaike.scrm.dal.activity.entity.OpConf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class GraphSvgsUtils {
    public static String getGraphSvg(Graph graph, Map<Integer, OpConf> opMap, Map<Integer, BehaviorConf> bConfMap) {
        Node firstNode;
        StringBuilder texts;
        StringBuilder sb = new StringBuilder();
        List<List<Integer>> paths = Graph.caculeAllpath(graph);
        Map<Integer, SvgUtils.Point> pointMap = SvgUtils.caculatePoint(paths);
        sb.append("<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \n\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n\n<svg width=\"100%\" height=\"100%\" version=\"1.1\"\nxmlns=\"http://www.w3.org/2000/svg\">");
        sb.append("<defs>\n\t<marker id=\"arrow\" \n\tmarkerUnits=\"strokeWidth\" \n\tmarkerWidth=\"12\" \n\tmarkerHeight=\"12\"\n\tviewBox=\"0 0 12 12\"\n\trefX=\"6\"\n\trefY=\"6\"\n\torient=\"auto\">\n\t<path d=\"M2,2 L10,6 L2,10 L6,6 L2,2\" style=\"fill: #000000;\"/>\n</marker>\n</defs>");
        sb.append(SvgUtils.getStartSvg(pointMap.get(0)));
        Map nodeMap = graph.getNodes().stream().collect(Collectors.toMap(a -> a.getId(), Function.identity()));
        for (Node node : graph.getNodes()) {
            texts = new StringBuilder();
            for (int i = 0; i < node.getOps().size(); ++i) {
                Op op = node.getOps().get(i);
                texts.append(opMap.get(op.getConfId()).getRemark());
                if (op.getContext() != null) {
                    texts.append("\n").append(JSONObject.toJSON(op.getContext()));
                }
                if (i >= node.getOps().size() - 1) continue;
                texts.append(",");
            }
            sb.append(SvgUtils.getRectSvg(pointMap.get(node.getId()), texts.toString(), node.getActivationTime() != null));
        }
        for (Edge edge : graph.getEdges()) {
            texts = new StringBuilder();
            ArrayList conditions = Lists.newArrayList();
            conditions.addAll(edge.getConditions());
            if (CollectionUtils.isNotEmpty(edge.getMatchConditions())) {
                conditions.addAll(edge.getMatchConditions());
            }
            for (int i = 0; i < conditions.size(); ++i) {
                Condition condition = (Condition)conditions.get(i);
                texts.append(bConfMap.get(condition.getBehaviorConfId()).getRemark());
                if (CollectionUtils.isNotEmpty(condition.getExps())) {
                    texts.append("\n");
                    for (Expression exp : condition.getExps()) {
                        texts.append(exp.toString()).append(";");
                    }
                }
                if (i >= conditions.size() - 1) continue;
                texts.append(",");
            }
            Node fromNode = (Node)nodeMap.get(edge.getFromNodeId());
            Node toNode = (Node)nodeMap.get(edge.getToNodeId());
            if (fromNode.getActivationTime() != null && toNode.getActivationTime() != null) {
                sb.append(SvgUtils.getLine(pointMap.get(edge.getFromNodeId()), pointMap.get(edge.getToNodeId()), edge.getFromNodeId(), true, texts.toString()));
                continue;
            }
            sb.append(SvgUtils.getLine(pointMap.get(edge.getFromNodeId()), pointMap.get(edge.getToNodeId()), edge.getFromNodeId(), false, texts.toString()));
        }
        StringBuilder triggertexts = new StringBuilder();
        ArrayList triggerConditions = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(graph.getMatchTriggers())) {
            triggerConditions.addAll(graph.getMatchTriggers());
        }
        triggerConditions.addAll(graph.getTriggers());
        for (int i = 0; i < triggerConditions.size(); ++i) {
            Condition condition = (Condition)triggerConditions.get(i);
            triggertexts.append(bConfMap.get(condition.getBehaviorConfId()).getRemark());
            if (CollectionUtils.isNotEmpty(condition.getExps())) {
                triggertexts.append("\n");
                for (Expression exp : condition.getExps()) {
                    triggertexts.append(exp.toString()).append(";");
                }
            }
            if (i >= triggerConditions.size() - 1) continue;
            triggertexts.append(",");
        }
        sb.append(SvgUtils.getLine(pointMap.get(0), pointMap.get(graph.getStartNodeId()), 0, (firstNode = (Node)nodeMap.get(graph.getStartNodeId())).getActivationTime() != null, triggertexts.toString()));
        sb.append("</svg>");
        return sb.toString();
    }
}

