/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.common.component;

import cn.kinyun.scrm.weixin.recommend.common.component.DistributedLock;
import cn.kinyun.scrm.weixin.recommend.common.enums.RedissonLockType;
import cn.kinyun.scrm.weixin.recommend.common.utils.HashUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RedisDLock
implements DistributedLock {
    private static final Logger log = LoggerFactory.getLogger(RedisDLock.class);
    @Autowired
    RedissonClient redisson;
    @Value(value="${spring.redis.key.prefix}")
    private String redisPrefix;
    ThreadLocal<Map<String, Lock>> lockThreadLocal = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(String key, RedissonLockType lockType) throws InterruptedException {
        Preconditions.checkArgument((lockType != null ? 1 : 0) != 0, (Object)"lockType is null");
        if (StringUtils.isBlank((CharSequence)key)) {
            return;
        }
        String redisKey = this.redisPrefix + key;
        Lock lock = null;
        String string = key.intern();
        synchronized (string) {
            ConcurrentMap key2Locks = this.lockThreadLocal.get();
            if (key2Locks == null) {
                key2Locks = Maps.newConcurrentMap();
                this.lockThreadLocal.set(key2Locks);
            }
            if ((lock = (Lock)key2Locks.get(key)) == null) {
                switch (lockType) {
                    case REENTRANT_LOCK: {
                        lock = this.redisson.getLock(redisKey);
                        break;
                    }
                    case FAIR_LOCK: {
                        lock = this.redisson.getFairLock(redisKey);
                        break;
                    }
                    default: {
                        lock = this.redisson.getLock(redisKey);
                    }
                }
            }
            if (lock == null) {
                log.error("get lock is null,lock fail with key={}", (Object)key);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "get lock is null,lock fail");
            }
            lock.lock();
            boolean acquired = true;
            if (!acquired) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5728\u7b49\u5f85\u65f6\u95f4\u5185\u672a\u83b7\u53d6\u5230\u9501");
            }
            key2Locks.put(key, lock);
        }
    }

    @Override
    public void lock(String key) throws InterruptedException {
        this.lock(key, RedissonLockType.REENTRANT_LOCK);
    }

    @Override
    public void unlock(String localKey) {
        if (StringUtils.isBlank((CharSequence)localKey)) {
            return;
        }
        Map<String, Lock> key2Locks = this.lockThreadLocal.get();
        if (MapUtils.isEmpty(key2Locks)) {
            return;
        }
        Lock lock = key2Locks.get(localKey);
        if (lock != null) {
            key2Locks.remove(localKey);
            lock.unlock();
            return;
        }
        log.warn("thread without lock, not need to unlock");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void multiLock(Collection<String> keys) throws InterruptedException {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        keys.stream().forEach(a -> Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)a), (Object)"lock object can not be null or empty"));
        List<String> lockKeys = keys.stream().distinct().sorted().collect(Collectors.toList());
        String localKey = HashUtils.hash(lockKeys);
        Lock lock = null;
        String string = localKey.intern();
        synchronized (string) {
            ConcurrentMap lockMap = this.lockThreadLocal.get();
            if (lockMap == null) {
                lockMap = Maps.newConcurrentMap();
                this.lockThreadLocal.set(lockMap);
            }
            if ((lock = (Lock)lockMap.get(localKey)) == null) {
                lock = this.getRedissonMultiLock(lockKeys);
            }
            if (lock == null) {
                log.error("get lock is null,lock fail with key={}", keys);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "get lock is null,lock fail");
            }
            log.info("key={} ready to lock", (Object)localKey);
            lock.lock();
            boolean acquired = true;
            if (!acquired) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5728\u7b49\u5f85\u65f6\u95f4\u5185\u672a\u83b7\u53d6\u5230\u9501");
            }
            lockMap.put(localKey, lock);
            log.info("key={} locked ", (Object)localKey);
        }
    }

    private Lock getRedissonMultiLock(List<String> lockKeys) {
        ArrayList subLocks = Lists.newArrayList();
        for (String lockKey : lockKeys) {
            lockKey = this.redisPrefix + lockKey;
            subLocks.add(this.redisson.getLock(lockKey));
        }
        return this.redisson.getMultiLock(subLocks.toArray(new RLock[lockKeys.size()]));
    }

    @Override
    public void unlockMultiLock(Collection<String> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        keys.stream().forEach(a -> Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)a), (Object)"lock object can not be null or empty"));
        List<String> lockKeys = keys.stream().distinct().sorted().collect(Collectors.toList());
        String keyCode = HashUtils.hash(lockKeys);
        try {
            this.unlock(keyCode);
        }
        catch (Exception e) {
            log.error("unlock fail with error", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        list1.add(new String("aaaa"));
        list1.add(new String("bbbb"));
        list2.add(new String("bbbb"));
        list2.add(new String("aaaa"));
        System.out.println(HashUtils.hash(list2));
        System.out.println(HashUtils.hash(list1));
    }
}

