/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.officialAccount.service.impl;

import cn.kinyun.scrm.weixin.officialAccount.service.OperatorService;
import cn.kinyun.scrm.weixin.officialAccount.service.TemplateService;
import cn.kinyun.scrm.weixin.sdk.api.WxTemplateMsgAPI;
import cn.kinyun.scrm.weixin.sdk.entity.template.PrivateTemplate;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.template.req.AppIdReq;
import cn.kinyun.scrm.weixin.template.req.TemplateIdReq;
import cn.kinyun.scrm.weixin.template.req.TemplateReq;
import cn.kinyun.scrm.weixin.template.resp.PrivateTemplateResp;
import cn.kinyun.scrm.weixin.token.OfficialTokenService;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountTemplateInfoExtend;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountTemplateInfoExtendMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountTemplateInfoMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TemplateServiceImpl
implements TemplateService {
    private static final Logger log = LoggerFactory.getLogger(TemplateServiceImpl.class);
    @Autowired
    private OfficialTokenService officialTokenService;
    @Autowired
    private WxTemplateMsgAPI wxTemplateMsgApi;
    @Autowired
    private OperatorService operatorService;
    @Resource
    private OfficialAccountTemplateInfoMapper templateInfoMapper;
    @Resource
    private OfficialAccountTemplateInfoExtendMapper templateInfoExtendMapper;

    @Override
    public String add(TemplateIdReq params) {
        log.info("addOrMod template with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()}), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getTemplateId()}), (Object)"\u6a21\u677fid\u4e3a\u7a7a");
        try {
            String accessToken = this.officialTokenService.getOfficialAccessToken(params.getAppId());
            return this.wxTemplateMsgApi.addPrivateTemplate(accessToken, params.getTemplateId());
        }
        catch (WeixinException e) {
            e.printStackTrace();
            log.error("Failed to send msg={}", (Object)params, (Object)e);
            throw e;
        }
    }

    @Override
    public List<PrivateTemplateResp> list(AppIdReq params) {
        log.info("get all template with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()}), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        List list = null;
        try {
            String accessToken = this.officialTokenService.getOfficialAccessToken(params.getAppId());
            list = this.wxTemplateMsgApi.getAllPrivateTemplate(accessToken);
        }
        catch (WeixinException e) {
            e.printStackTrace();
            log.error("Failed to send msg={}", (Object)params, (Object)e);
            throw e;
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (PrivateTemplate t : list) {
            PrivateTemplateResp dto = new PrivateTemplateResp();
            dto.setTemplateId(t.getTemplateId());
            dto.setTitle(t.getTitle());
            dto.setContent(t.getContent());
            dto.setPrimaryIndustry(t.getPrimaryIndustry());
            dto.setDeputyIndustry(t.getDeputyIndustry());
            dto.setExample(t.getExample());
            result.add(dto);
        }
        return result;
    }

    @Override
    public void delete(TemplateIdReq params) {
        log.info("delete template with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()}), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getTemplateId()}), (Object)"\u6a21\u677fid\u4e3a\u7a7a");
        try {
            String accessToken = this.officialTokenService.getOfficialAccessToken(params.getAppId());
            this.wxTemplateMsgApi.deletePrivateTemplate(accessToken, params.getTemplateId());
        }
        catch (WeixinException e) {
            e.printStackTrace();
            log.error("Failed to send msg={}", (Object)params, (Object)e);
            throw e;
        }
    }

    @Override
    public String getTemplateId(String appId, String publicTemplateCode) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId}), (Object)"appId is blank");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{publicTemplateCode}), (Object)"public template code is blank");
        return this.templateInfoMapper.getByTemplateCode(appId, publicTemplateCode);
    }

    @Override
    public Map<String, String> getTemplateIds(String appId, List<String> publicTemplateCodes) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId}), (Object)"appId is blank");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(publicTemplateCodes), (Object)"public template code is empty");
        return this.templateInfoMapper.getByTemplateCodes(appId, publicTemplateCodes);
    }

    @Override
    public List<PrivateTemplateResp> cachedList(TemplateReq params) {
        log.info("query template cached list with params={}", (Object)params);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()}), (Object)"\u8bf7\u5148\u9009\u62e9\u516c\u4f17\u53f7");
        List<String> managerAppIds = this.operatorService.getCurrentManagerAppIds();
        if (!managerAppIds.contains(params.getAppId())) {
            this.setPage(params.getPageDto(), 0, 0);
            return Lists.newArrayList();
        }
        int count = this.templateInfoExtendMapper.count(params.getAppId(), params.getTitle());
        if (count == 0) {
            this.setPage(params.getPageDto(), 0, 0);
            return Lists.newArrayList();
        }
        List templateList = this.templateInfoExtendMapper.queryList(params.getAppId(), params.getTitle(), params.getPageDto());
        this.setPage(params.getPageDto(), count, templateList.size());
        ArrayList result = Lists.newArrayList();
        templateList.forEach(t -> {
            PrivateTemplateResp resp = new PrivateTemplateResp();
            resp.setTemplateId(t.getTemplateId());
            resp.setContent(t.getContent());
            resp.setExample(t.getExample());
            resp.setPrimaryIndustry(t.getPrimaryIndustry());
            resp.setDeputyIndustry(t.getDeputyIndustry());
            resp.setTitle(t.getTitle());
            result.add(resp);
        });
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sync(String appId) {
        log.info("sync template from weixin with appId={} by operatorId={}", (Object)appId, (Object)LoginUtils.getCurrentUserId());
        List<String> managerAppIds = this.operatorService.getCurrentManagerAppIds();
        if (!managerAppIds.contains(appId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u65e0\u516c\u4f17\u53f7\u7ba1\u7406\u6743\u9650");
        }
        AppIdReq idReq = new AppIdReq();
        idReq.setAppId(appId);
        List<PrivateTemplateResp> list = this.list(idReq);
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList templateInfoExtendList = Lists.newArrayList();
            this.templateInfoExtendMapper.delByAppId(appId);
            list.forEach(resp -> {
                if (StringUtils.isBlank((CharSequence)resp.getExample())) {
                    return;
                }
                OfficialAccountTemplateInfoExtend extend = new OfficialAccountTemplateInfoExtend();
                extend.setAppId(appId);
                extend.setContent(resp.getContent());
                extend.setTemplateId(resp.getTemplateId());
                extend.setPrimaryIndustry(resp.getPrimaryIndustry());
                extend.setDeputyIndustry(resp.getDeputyIndustry());
                extend.setTitle(resp.getTitle());
                extend.setExample(resp.getExample());
                templateInfoExtendList.add(extend);
            });
            this.templateInfoExtendMapper.batchInsert((List)templateInfoExtendList);
        }
    }

    private void setPage(PageDto pageDto, int count, int currentPageCount) {
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf(count));
            pageDto.setCurPageCount(Integer.valueOf(currentPageCount));
        }
    }
}

