/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.officialAccount.service.impl;

import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.service.ScrmOfficialService;
import com.kuaike.scrm.common.service.dto.resp.GetLatestOfficialAppIdResp;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScrmOfficialServiceImpl
implements ScrmOfficialService {
    private static final Logger log = LoggerFactory.getLogger(ScrmOfficialServiceImpl.class);
    @Resource
    private OfficialAccountMapper officialAccountMapper;
    @Resource
    private ComponentTokenService componentTokenService;

    public GetLatestOfficialAppIdResp getLatestOfficialAppIdByBizId(Long bizId) {
        log.info("getLatestOfficialAppIdByBizId bizId:{}", (Object)bizId);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId\u4e0d\u80fd\u4e3a\u7a7a");
        OfficialAccount officialAccount = this.officialAccountMapper.queryLatestByBizId(bizId);
        GetLatestOfficialAppIdResp resp = new GetLatestOfficialAppIdResp();
        resp.setAppId(officialAccount == null ? null : officialAccount.getAppId());
        resp.setComponentAppId(this.componentTokenService.getWechatAppId());
        return resp;
    }
}

