/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.officialAccount.service.impl;

import cn.kinyun.scrm.weixin.officialAccount.dto.req.CodeReqDto;
import cn.kinyun.scrm.weixin.officialAccount.service.OfficialService;
import cn.kinyun.scrm.weixin.sdk.api.WxOAuth2API;
import cn.kinyun.scrm.weixin.sdk.entity.sns.SnsAccessToken;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OfficialServiceImpl
implements OfficialService {
    private static final Logger log = LoggerFactory.getLogger(OfficialServiceImpl.class);
    @Resource
    private ComponentTokenService platformInfoService;
    @Resource
    private WxOAuth2API wxOAuth2API;
    @Value(value="${wx.component.appid}")
    private String componentAppId;

    @Override
    public String getOpenIdByAppIdAndCode(CodeReqDto dto) {
        SnsAccessToken snsAccessToken;
        log.info("getOpenIdByAppIdAndCode dto:{}", (Object)dto);
        dto.validate();
        String componentToken = this.platformInfoService.getComponentAccessToken();
        try {
            snsAccessToken = this.wxOAuth2API.getComponentAccessToken(dto.getAppId(), dto.getCode(), this.componentAppId, componentToken);
        }
        catch (WeixinException e) {
            log.error("getOpenIdByAppIdAndCode getComponentAccessToken error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return snsAccessToken.getOpenId();
    }

    @Override
    public void userAuthRedirect(String redirectUrl, String code, String appId, HttpServletResponse response) {
        log.info("userAuthRedirect redirectUrl:{} code:{}", (Object)redirectUrl, (Object)code);
        redirectUrl = redirectUrl.contains("?") ? redirectUrl + "&openId=" : redirectUrl + "?openId=";
        String openId = "null";
        CodeReqDto dto = new CodeReqDto();
        dto.setCode(code);
        dto.setAppId(appId);
        try {
            openId = this.getOpenIdByAppIdAndCode(dto);
        }
        catch (Exception e) {
            log.error("getOpenIdByAppIdAndCode error", (Throwable)e);
        }
        try {
            response.sendRedirect(redirectUrl + openId);
        }
        catch (IOException e) {
            log.error("userAuthRedirect sendRedirect error", (Throwable)e);
        }
    }
}

