/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.officialAccount.service.impl;

import cn.kinyun.scrm.weixin.common.dto.IdAndNameDto;
import cn.kinyun.scrm.weixin.common.dto.ModifierDto;
import cn.kinyun.scrm.weixin.common.dto.UserInfoRespDto;
import cn.kinyun.scrm.weixin.common.service.BlackReasonService;
import cn.kinyun.scrm.weixin.common.service.UserInfoService;
import cn.kinyun.scrm.weixin.enums.Sex;
import cn.kinyun.scrm.weixin.enums.UserIdentity;
import cn.kinyun.scrm.weixin.officialAccount.dto.req.BlacklistAddReqDto;
import cn.kinyun.scrm.weixin.officialAccount.dto.req.BlacklistDelReqDto;
import cn.kinyun.scrm.weixin.officialAccount.dto.req.BlacklistReqDto;
import cn.kinyun.scrm.weixin.officialAccount.dto.resp.BlacklistRespDto;
import cn.kinyun.scrm.weixin.officialAccount.dto.resp.BlacklistSimpleRespDto;
import cn.kinyun.scrm.weixin.officialAccount.service.BlacklistService;
import cn.kinyun.scrm.weixin.officialAccount.service.OfficialAccountFansTagService;
import cn.kinyun.scrm.weixin.officialAccount.service.OperatorService;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.kuaike.common.enums.EnumConstant;
import com.kuaike.common.enums.EnumService;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.fans.dto.BlacklistQueryParam;
import com.kuaike.scrm.dal.official.fans.entity.OfficialAccountFans;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialAccountFansMapper;
import com.kuaike.scrm.dal.weworkTag.WeworkTagDto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlacklistServiceImpl
implements BlacklistService {
    private static final Logger log = LoggerFactory.getLogger(BlacklistServiceImpl.class);
    @Resource
    private OfficialAccountFansMapper fansMapper;
    @Autowired
    private OfficialAccountFansTagService fansTagService;
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private BlackReasonService blackReasonService;
    @Autowired
    private UserInfoService userInfoService;
    private static final String SPLIT = ",";

    @Override
    public List<BlacklistRespDto> list(BlacklistReqDto params) {
        log.info("query fans blacklist with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        StopWatchDto timer = new StopWatchDto("blackList", true, log);
        CurrentUserInfo loginUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((loginUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        timer.start("getPermitAppIds");
        List<String> appIds = this.operatorService.getPermitAppIds(loginUser.getId(), UserIdentity.MANAGER.getValue());
        timer.stop();
        if (CollectionUtils.isEmpty(appIds)) {
            timer.print();
            return Collections.emptyList();
        }
        BlacklistQueryParam query = new BlacklistQueryParam();
        query.setAppIds(appIds);
        query.setOpenId(params.getOpenId());
        query.setNickname(params.getNickName());
        query.setReason(params.getReason());
        query.setPageDto(params.getPageDto());
        if (params.getBanTimeAsc() != null) {
            query.setBanTimeAsc(params.getBanTimeAsc());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getReason()})) {
            timer.start("reasonLike");
            List<Long> blackReasonIds = this.blackReasonService.reasonLike(params.getReason());
            timer.stop();
            if (CollectionUtils.isEmpty(blackReasonIds)) {
                timer.print();
                return Collections.emptyList();
            }
            query.setBanReasonIdStrs(blackReasonIds.stream().map(a -> Stream.of(a).map(String::valueOf).collect(Collectors.joining(SPLIT, SPLIT, SPLIT))).collect(Collectors.toList()));
        }
        timer.start("countBlacklist");
        int count = this.fansMapper.countBlacklist(query);
        timer.stop();
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(count));
        }
        if (count <= 0) {
            timer.print();
            return Collections.emptyList();
        }
        timer.start("queryBlacklist");
        List fansList = this.fansMapper.queryBlacklist(query);
        timer.stop();
        Set<String> uniqueIds = fansList.stream().map(it -> it.getUniqueId()).collect(Collectors.toSet());
        timer.start("queryFansTagInfo");
        Map<String, List<WeworkTagDto>> tagMap = this.fansTagService.queryFansTagInfo(uniqueIds);
        timer.stop();
        String joinIdStr = fansList.stream().map(a -> a.getBlackReasonIds()).collect(Collectors.joining(SPLIT));
        List joinIdStrList = Splitter.on((String)SPLIT).omitEmptyStrings().splitToList((CharSequence)joinIdStr);
        Set<Long> blackReasonIds = joinIdStrList.stream().distinct().map(Long::parseLong).collect(Collectors.toSet());
        timer.start("getByIds");
        List<IdAndNameDto> blackReasons = this.blackReasonService.getByIds(blackReasonIds);
        timer.stop();
        Map<Long, IdAndNameDto> blackReasonMap = blackReasons.stream().collect(Collectors.toMap(a -> a.getId(), Function.identity()));
        Set<Long> staffIds = fansList.stream().map(a -> a.getBanOperatorId()).collect(Collectors.toSet());
        Map<Long, UserInfoRespDto> staffMap = this.userInfoService.queryUserInfoMap(staffIds);
        ArrayList result = Lists.newArrayListWithCapacity((int)fansList.size());
        for (OfficialAccountFans fans : fansList) {
            BlacklistRespDto dto = new BlacklistRespDto();
            dto.setId(fans.getId());
            dto.setHeadImgUrl(fans.getHeadImgUrl());
            dto.setNickName(fans.getNickname());
            dto.setAppId(fans.getAppId());
            dto.setOpenId(fans.getOpenId());
            dto.setMobile(fans.getMobile());
            dto.setCountry(fans.getCountry());
            dto.setProvince(fans.getProvince());
            dto.setCity(fans.getCity());
            dto.setBanReason(fans.getBanReason());
            dto.setBanTime(fans.getBanTime());
            dto.setSexEnum(EnumConstant.from((EnumService)Sex.getByValue(fans.getSex())));
            dto.setTagAndFlowInfoList(tagMap.getOrDefault(fans.getUniqueId(), Lists.newArrayList()));
            dto.setBanReasons(this.getReasons(blackReasonMap, fans.getBlackReasonIds()));
            UserInfoRespDto userInfo = staffMap.get(fans.getBanOperatorId());
            if (userInfo != null) {
                dto.setBanOperator(new ModifierDto(userInfo.getId(), userInfo.getUsername(), userInfo.getNickname()));
            }
            result.add(dto);
        }
        timer.print();
        return result;
    }

    private List<IdAndNameDto> getReasons(Map<Long, IdAndNameDto> blackReasonMap, String blackReasonIds) {
        if (StringUtils.isBlank((CharSequence)blackReasonIds) || MapUtils.isEmpty(blackReasonMap)) {
            return Collections.emptyList();
        }
        List blackReasonIdList = Splitter.on((String)SPLIT).omitEmptyStrings().splitToList((CharSequence)blackReasonIds).stream().map(Long::parseLong).collect(Collectors.toList());
        ArrayList dtos = Lists.newArrayList();
        for (Long id : blackReasonIdList) {
            IdAndNameDto idAndNameDto = blackReasonMap.get(id);
            if (idAndNameDto == null) continue;
            dtos.add(idAndNameDto);
        }
        return dtos;
    }

    @Override
    public List<BlacklistSimpleRespDto> simpleList(BlacklistReqDto params) {
        log.info("query fans blacklist simple list with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)params.getNickName())) {
            if (params.getPageDto() != null) {
                params.getPageDto().setCount(Integer.valueOf(0));
            }
            return Collections.emptyList();
        }
        StopWatchDto timer = new StopWatchDto("blackListSimpleList", true, log);
        CurrentUserInfo loginUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((loginUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        timer.start("getPermitAppIds");
        List<String> appIds = this.operatorService.getPermitAppIds(loginUser.getId(), UserIdentity.MANAGER.getValue());
        timer.stop();
        if (CollectionUtils.isEmpty(appIds)) {
            timer.print();
            return Collections.emptyList();
        }
        BlacklistQueryParam query = new BlacklistQueryParam();
        query.setAppIds(appIds);
        query.setNickname(params.getNickName());
        query.setPageDto(params.getPageDto());
        timer.start("countBlacklist");
        int count = this.fansMapper.countBlacklist(query);
        timer.stop();
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(count));
        }
        if (count <= 0) {
            timer.print();
            return Collections.emptyList();
        }
        timer.start("querySimpleBlacklist");
        List fansList = this.fansMapper.querySimpleBlacklist(query);
        timer.stop();
        ArrayList result = Lists.newArrayListWithCapacity((int)fansList.size());
        for (OfficialAccountFans fans : fansList) {
            BlacklistSimpleRespDto dto = new BlacklistSimpleRespDto();
            dto.setId(fans.getId());
            dto.setNickName(fans.getNickname());
            dto.setAppId(fans.getAppId());
            dto.setOpenId(fans.getOpenId());
            result.add(dto);
        }
        timer.print();
        return result;
    }

    @Override
    public void add(BlacklistAddReqDto params) {
        List<String> appIds;
        log.info("addOrMod fans into blacklist with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()}), (Object)"\u7c89\u4e1dappId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getOpenId()}), (Object)"\u7c89\u4e1dopenId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(params.getBlackReasonIds()), (Object)"\u62c9\u9ed1\u539f\u56e0\u4e3a\u7a7a");
        CurrentUserInfo loginUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((loginUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Boolean isSystemUser = this.userInfoService.checkIsSystemUser(loginUser.getId());
        if (!(isSystemUser.booleanValue() || !CollectionUtils.isEmpty(appIds = this.operatorService.getPermitAppIds(loginUser.getId(), null)) && appIds.contains(params.getAppId()))) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u60a8\u4e0d\u662f\u8be5\u7c89\u4e1d\u6240\u5c5e\u516c\u4f17\u53f7\u7684\u8fd0\u8425\u8005\u6216\u8005\u5ba2\u670d\uff0c\u65e0\u6743\u64cd\u4f5c\u8be5\u7c89\u4e1d\u3002");
        }
        OfficialAccountFans fans = this.fansMapper.queryByAppIdOpenId(params.getAppId(), params.getOpenId());
        if (fans == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7c89\u4e1d\u4e0d\u5b58\u5728");
        }
        if (fans.getIsInBlacklist() == 1) {
            log.warn("\u7c89\u4e1did={}\u5df2\u7ecf\u5728\u9ed1\u540d\u5355\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u62c9\u9ed1\u3002", (Object)fans.getId());
            return;
        }
        fans.setIsInBlacklist(Integer.valueOf(1));
        fans.setBlackReasonIds(params.getBlackReasonIds().stream().map(String::valueOf).collect(Collectors.joining(SPLIT, SPLIT, SPLIT)));
        fans.setBanTime(new Date());
        fans.setUpdateTime(new Date());
        fans.setBanOperatorId(LoginUtils.getCurrentUserId());
        this.fansMapper.updateByPrimaryKey((Object)fans);
    }

    @Override
    public void remove(BlacklistDelReqDto params) {
        log.info("remove fans from blacklist with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()}), (Object)"\u7c89\u4e1dappId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getOpenId()}), (Object)"\u7c89\u4e1dopenId\u4e3a\u7a7a");
        CurrentUserInfo loginUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((loginUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        List<String> appIds = this.operatorService.getPermitAppIds(loginUser.getId(), UserIdentity.MANAGER.getValue());
        if (CollectionUtils.isEmpty(appIds) || !appIds.contains(params.getAppId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u60a8\u4e0d\u662f\u8be5\u7c89\u4e1d\u6240\u5c5e\u516c\u4f17\u53f7\u7684\u8fd0\u8425\u8005\uff0c\u65e0\u6743\u64cd\u4f5c\u8be5\u7c89\u4e1d\u3002");
        }
        OfficialAccountFans fans = this.fansMapper.queryByAppIdOpenId(params.getAppId(), params.getOpenId());
        if (fans == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7c89\u4e1d\u4e0d\u5b58\u5728");
        }
        if (fans.getIsInBlacklist() == 0) {
            log.warn("\u7c89\u4e1did={}\u4e0d\u5728\u9ed1\u540d\u5355\u4e2d\uff0c\u65e0\u9700\u4ece\u9ed1\u540d\u5355\u79fb\u9664\u3002", (Object)fans.getId());
            return;
        }
        fans.setIsInBlacklist(Integer.valueOf(0));
        fans.setBanReason("");
        fans.setBlackReasonIds("");
        fans.setBanTime(null);
        fans.setUpdateTime(new Date());
        fans.setBanOperatorId(Long.valueOf(-1L));
        this.fansMapper.updateByPrimaryKey((Object)fans);
    }
}

