/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.message.service.impl;

import cn.kinyun.scrm.weixin.enums.MaterialType;
import cn.kinyun.scrm.weixin.enums.MsgSendType;
import cn.kinyun.scrm.weixin.enums.MsgSyncStatus;
import cn.kinyun.scrm.weixin.enums.PlateformType;
import cn.kinyun.scrm.weixin.enums.Subscribe;
import cn.kinyun.scrm.weixin.material.service.CommonMaterialService;
import cn.kinyun.scrm.weixin.message.dto.ConvrMsg;
import cn.kinyun.scrm.weixin.message.dto.MsgData;
import cn.kinyun.scrm.weixin.message.dto.req.SendCustomMsgReqDto;
import cn.kinyun.scrm.weixin.message.service.EsMessageService;
import cn.kinyun.scrm.weixin.message.service.MessageService;
import cn.kinyun.scrm.weixin.message.service.SendMessageService;
import cn.kinyun.scrm.weixin.message.service.ServantSessionService;
import cn.kinyun.scrm.weixin.officialAccount.service.OfficialAccountFansService;
import cn.kinyun.scrm.weixin.officialAccount.service.OperatorService;
import cn.kinyun.scrm.weixin.sdk.api.custom.WxCustomMsgAPI;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.BaseRespMsg;
import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.OfficialTokenService;
import cn.kinyun.scrm.weixin.utils.DownloadUtils;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMessage;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountServantSession;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMessageMapper;
import com.kuaike.scrm.dal.official.fans.entity.OfficialAccountFans;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterial;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SendMessageServiceImpl
implements SendMessageService {
    private static final Logger log = LoggerFactory.getLogger(SendMessageServiceImpl.class);
    @Autowired
    private OfficialTokenService officialTokenService;
    @Autowired
    private WxCustomMsgAPI wxCustomeMsgApi;
    @Autowired
    private MessageService messageService;
    @Autowired
    private EsMessageService esMessageService;
    @Autowired
    private ServantSessionService servantSessionService;
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private OfficialAccountFansService officialAccountFansService;
    @Autowired
    private CommonMaterialService commonMaterialService;
    @Resource
    private OfficialAccountMessageMapper messageMapper;
    private static final ExecutorService executorService = Executors.newFixedThreadPool(2);
    private static final ExecutorService asyncExecutor = Executors.newFixedThreadPool(20);

    @Override
    public ConvrMsg send(SendCustomMsgReqDto params) {
        log.info("send custom msg with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u6d88\u606f\u4f53\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getOpenId()}), (Object)"\u7c89\u4e1dopenId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()}), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getMsgType()}), (Object)"\u6d88\u606f\u7c7b\u578b\u4e3a\u7a7a");
        BaseRespMsg respMsg = params.toBaseRespMsg();
        Preconditions.checkArgument((respMsg != null ? 1 : 0) != 0, (Object)"\u6d88\u606f\u7c7b\u578b\u4e0d\u5408\u6cd5");
        OfficialAccountMessage message = this.send(respMsg, params.getUserId());
        if (message == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5fae\u4fe1\u63a5\u53e3\u53d1\u9001\u6d88\u606f\u5931\u8d25");
        }
        return this.messageService.newConvrMsg(message);
    }

    @Override
    public OfficialAccountMessage send(BaseRespMsg msg, Long operatorId) {
        log.info("send custom msg={}, operatorId={}", (Object)msg, (Object)operatorId);
        Preconditions.checkArgument((msg != null ? 1 : 0) != 0, (Object)"\u6d88\u606f\u4f53\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg.getToUserName()}), (Object)"toUserName is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg.getFromUserName()}), (Object)"fromUserName is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg.getMsgType()}), (Object)"msgType is null!");
        Preconditions.checkArgument((operatorId != null ? 1 : 0) != 0, (Object)"\u64cd\u4f5c\u8005ID\u4e3a\u7a7a");
        String appId = msg.getFromUserName();
        String openId = msg.getToUserName();
        Long servantSessionId = this.getValidateSessionId(appId, openId, operatorId);
        this.send(msg);
        return this.messageService.record(msg, MsgSendType.SEND, servantSessionId, operatorId);
    }

    private Long getValidateSessionId(String appId, String openId, Long operatorId) {
        OfficialAccountFans fans = this.officialAccountFansService.queryByFansId(appId, openId);
        if (fans == null || fans.getSubscribe().intValue() == Subscribe.NO.getValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7c89\u4e1d\u672a\u5173\u6ce8\uff0c\u53d1\u9001\u5931\u8d25");
        }
        if (fans.getIsInBlacklist() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7c89\u4e1d\u88ab\u62c9\u9ed1\uff0c\u53d1\u9001\u5931\u8d25");
        }
        Long servantSessionId = null;
        List<OfficialAccountServantSession> sessionList = this.servantSessionService.queryValidateSession(appId, openId, operatorId);
        if (CollectionUtils.isNotEmpty(sessionList)) {
            servantSessionId = sessionList.get(0).getId();
        }
        Preconditions.checkArgument((servantSessionId != null ? 1 : 0) != 0, (Object)"\u5ba2\u670d\u4f1a\u8bdd\u5df2\u8fc7\u671f");
        return servantSessionId;
    }

    @Override
    public void send(BaseRespMsg msg) {
        log.info("send custom msg={}", (Object)msg);
        Preconditions.checkArgument((msg != null ? 1 : 0) != 0, (Object)"\u6d88\u606f\u4f53\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg.getToUserName()}), (Object)"toUserName is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg.getFromUserName()}), (Object)"fromUserName is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{msg.getMsgType()}), (Object)"msgType is null!");
        String appId = msg.getFromUserName();
        try {
            String accessToken = this.officialTokenService.getOfficialAccessToken(appId);
            this.wxCustomeMsgApi.sendCustomMsg(accessToken, msg, null);
        }
        catch (WeixinException e) {
            e.printStackTrace();
            log.error("Failed to send msg={}", (Object)msg, (Object)e);
            throw e;
        }
    }

    @Override
    public Long sendMaterial(SendCustomMsgReqDto params) {
        log.info("send material msg with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u6d88\u606f\u4f53\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getOpenId()}), (Object)"\u7c89\u4e1dopenId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()}), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        Long materialId = params.getMaterialId();
        OfficialMaterial mat = this.commonMaterialService.getMaterial(materialId);
        if (mat == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7d20\u6750\u4e0d\u5b58\u5728");
        }
        if ((mat.getPlatformType() & PlateformType.OFFICAL_ACCOUNT.getType()) == 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u7d20\u6750\u4e0d\u9002\u7528\u4e8e\u516c\u4f17\u53f7");
        }
        if (MaterialType.NEWS.getValue().equalsIgnoreCase(mat.getmType()) && mat.getNum() > 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5ba2\u670d\u6d88\u606f\u53ea\u652f\u6301\u5355\u56fe\u6587\uff0c\u4e0d\u652f\u6301\u591a\u56fe\u6587");
        }
        String mType = mat.getmType();
        WxMsgType msgType = this.commonMaterialService.toWxMsgType(mType);
        Preconditions.checkArgument((msgType != null ? 1 : 0) != 0, (String)"\u516c\u4f17\u53f7\u4e0d\u652f\u6301\u6b64\u79cd\u7d20\u6750\u7c7b\u578b:%s", (Object)mType);
        params.setMsgType(msgType.getValue());
        String appId = params.getAppId();
        String openId = params.getOpenId();
        Long operatorId = params.getUserId();
        Long servantSessionId = this.getValidateSessionId(appId, openId, operatorId);
        OfficialAccountMessage message = new OfficialAccountMessage();
        message.setOpenId(openId);
        message.setAppId(appId);
        message.setMsgId(Long.valueOf(-1L));
        message.setMsgType(msgType.getValue());
        message.setSendType(Integer.valueOf(MsgSendType.SEND.getValue()));
        message.setSyncStatus(Integer.valueOf(MsgSyncStatus.PENDING.getValue()));
        message.setUserId(operatorId);
        message.setServantSessionId(servantSessionId);
        message.setCreateTime(new Date());
        message.setContent("");
        this.messageService.record(message);
        AsyncUploadTask uploadTask = new AsyncUploadTask(mat, params.getAppId());
        Future<MsgData> future = asyncExecutor.submit(uploadTask);
        AsyncSendTask sendTask = new AsyncSendTask(future, params, message);
        asyncExecutor.submit(sendTask);
        return message.getId();
    }

    private void onSuccess(OfficialAccountMessage msg, MsgData msgData) {
        log.info("\u5f02\u6b65\u53d1\u9001\u6d88\u606f\u6210\u529f, msg={}, msgData={}", (Object)msg, (Object)msgData);
        msg.setContent(JacksonUtil.obj2Str((Object)msgData));
        msg.setCreateTime(new Date());
        msg.setSyncStatus(Integer.valueOf(MsgSyncStatus.SUCCESS.getValue()));
        this.messageMapper.updateByPrimaryKeySelective((Object)msg);
        this.esMessageService.save(msg);
    }

    private void onFailed(OfficialAccountMessage msg, Throwable e) {
        log.error("\u5f02\u6b65\u53d1\u9001\u6d88\u606f\u5931\u8d25.", e);
        msg.setSyncStatus(Integer.valueOf(MsgSyncStatus.FAILED.getValue()));
        this.messageMapper.updateByPrimaryKeySelective((Object)msg);
        this.esMessageService.save(msg);
    }

    private class AsyncSendTask
    implements Runnable {
        private Future<MsgData> future;
        private SendCustomMsgReqDto params;
        private OfficialAccountMessage message;

        public AsyncSendTask(Future<MsgData> future, SendCustomMsgReqDto params, OfficialAccountMessage message) {
            this.future = future;
            this.params = params;
            this.message = message;
        }

        @Override
        public void run() {
            MsgData msgData;
            try {
                msgData = this.future.get(30L, TimeUnit.SECONDS);
                if (msgData == null) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0a\u4f20\u7d20\u6750\u5230\u516c\u4f17\u53f7\u7d20\u6750\u5e93\u5931\u8d25");
                }
                if ("mpnews".equalsIgnoreCase(this.message.getMsgType()) && msgData.getArticles() != null && msgData.getArticles().size() > 1) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5ba2\u670d\u6d88\u606f\u53ea\u652f\u6301\u5355\u56fe\u6587\uff0c\u4e0d\u652f\u6301\u591a\u56fe\u6587\u3002");
                }
            }
            catch (TimeoutException e) {
                e.printStackTrace();
                SendMessageServiceImpl.this.onFailed(this.message, (Throwable)new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0a\u4f20\u7d20\u6750\u8d85\u65f6"));
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                SendMessageServiceImpl.this.onFailed(this.message, e);
                return;
            }
            try {
                this.params.setMsgData(msgData);
                BaseRespMsg msg = this.params.toBaseRespMsg();
                SendMessageServiceImpl.this.send(msg);
                SendMessageServiceImpl.this.onSuccess(this.message, msgData);
            }
            catch (Exception e) {
                e.printStackTrace();
                SendMessageServiceImpl.this.onFailed(this.message, e);
            }
        }
    }

    private class AsyncUploadTask
    implements Callable<MsgData> {
        private OfficialMaterial mat;
        private String appId;

        private AsyncUploadTask(OfficialMaterial mat, String appId) {
            this.mat = mat;
            this.appId = appId;
        }

        @Override
        public MsgData call() throws Exception {
            try {
                MsgData msgData = SendMessageServiceImpl.this.commonMaterialService.convertMaterialMsg(this.mat, this.appId);
                if (msgData.getMediaType().equals(MaterialType.VOICE.getValue())) {
                    String mediaUrl = msgData.getMediaUrl();
                    File file = DownloadUtils.loadFile(mediaUrl, null);
                    if (file != null) {
                        SendMessageServiceImpl.this.messageService.setVoiceTranscodeInfo(this.appId, file, msgData);
                    }
                    return msgData;
                }
                return msgData;
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u540c\u6b65\u7d20\u6750\u5230\u516c\u4f17\u53f7\u5931\u8d25, material={}, appId={}", new Object[]{this.mat, this.appId, e});
                return null;
            }
        }
    }
}

