/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.message.service.impl;

import cn.kinyun.scrm.weixin.enums.MaterialType;
import cn.kinyun.scrm.weixin.enums.MsgSendType;
import cn.kinyun.scrm.weixin.enums.MsgSyncStatus;
import cn.kinyun.scrm.weixin.enums.SendStatus;
import cn.kinyun.scrm.weixin.material.service.CommonMaterialService;
import cn.kinyun.scrm.weixin.message.dto.MassMessageSendCondition;
import cn.kinyun.scrm.weixin.message.dto.MsgData;
import cn.kinyun.scrm.weixin.message.dto.req.SendCustomMsgReqDto;
import cn.kinyun.scrm.weixin.message.service.MessageService;
import cn.kinyun.scrm.weixin.message.service.SendMassMessageService;
import cn.kinyun.scrm.weixin.officialAccount.service.OfficialAccountFansTagService;
import cn.kinyun.scrm.weixin.sdk.api.WxMassMsgAPI;
import cn.kinyun.scrm.weixin.sdk.entity.message.mass.resp.MsgId;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.BaseRespMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.TextMsg;
import cn.kinyun.scrm.weixin.sdk.enums.WxMsgStatus;
import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.OfficialTokenService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMessage;
import com.kuaike.scrm.dal.official.massMsg.dto.MassMessageQueryParam;
import com.kuaike.scrm.dal.official.massMsg.entity.OfficialAccountMassMessage;
import com.kuaike.scrm.dal.official.massMsg.entity.OfficialAccountMassMessageDetail;
import com.kuaike.scrm.dal.official.massMsg.mapper.OfficialAccountMassMessageDetailMapper;
import com.kuaike.scrm.dal.official.massMsg.mapper.OfficialAccountMassMessageMapper;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SendMassMessageServiceImpl
implements SendMassMessageService {
    private static final Logger log = LoggerFactory.getLogger(SendMassMessageServiceImpl.class);
    @Resource
    private OfficialAccountMassMessageMapper massMessageMapper;
    @Resource
    private OfficialAccountMassMessageDetailMapper massMessageDetailMapper;
    @Autowired
    private OfficialTokenService officialTokenService;
    @Autowired
    private WxMassMsgAPI wxMassMsgAPI;
    @Autowired
    private CommonMaterialService commonMaterialService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private OfficialAccountFansTagService fansTagService;
    private ThreadPoolExecutor pool = new ThreadPoolExecutor(8, 16, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(100));
    private static final String SPLITTER = ",";

    @Override
    public void send(Long massMessageId) {
        Date now = new Date();
        List massMessages = this.massMessageMapper.queryWaitingSendMsg(now);
        if (massMessageId != null) {
            OfficialAccountMassMessage massMessage = (OfficialAccountMassMessage)this.massMessageMapper.selectByPrimaryKey((Object)massMessageId);
            if (massMessage != null && massMessage.getSendStatus().equals(SendStatus.WAITTING_SEND.getValue())) {
                massMessages = Lists.newArrayList((Object[])new OfficialAccountMassMessage[]{massMessage});
            } else {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8981\u53d1\u9001\u7684\u7fa4\u53d1\u6d88\u606f\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u4e3a\u5f85\u53d1\u9001\u72b6\u6001");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)massMessages)) {
            for (OfficialAccountMassMessage massMessage : massMessages) {
                this.pool.submit(() -> {
                    String sendCondition = massMessage.getSendCondition();
                    MassMessageSendCondition condition = (MassMessageSendCondition)JSONObject.parseObject((String)sendCondition, MassMessageSendCondition.class);
                    try {
                        this.sendWithCondition(condition);
                        this.massMessageMapper.changeSendStatus(SendStatus.SENDING.getValue(), massMessage.getId());
                    }
                    catch (Exception e) {
                        log.error("send mass message task", (Throwable)e);
                    }
                });
            }
        }
    }

    private void sendWithCondition(MassMessageSendCondition sendCondition) throws Exception {
        sendCondition.validate(false);
        log.info("send mass message with condition={}", (Object)sendCondition);
        MaterialType materialType = MaterialType.getByValue(sendCondition.getMaterialType());
        OfficialMaterial material = null;
        if (materialType == MaterialType.TEXT && (sendCondition.getMaterialId() == null || sendCondition.getMaterialId() <= 0L)) {
            material = new OfficialMaterial();
            material.setmType(MaterialType.TEXT.getValue());
            material.setContent(sendCondition.getContent());
        } else {
            material = this.commonMaterialService.getMaterial(sendCondition.getMaterialId());
        }
        List<String> appIds = sendCondition.getAppIds();
        for (String appId : appIds) {
            Map<String, List<String>> sendAppOpenIdsMap;
            boolean error = false;
            BaseRespMsg baseRespMsg = this.buildWechatMsg(materialType, material, appId);
            if (baseRespMsg == null) {
                error = true;
            }
            int pageSize = 50000;
            PageDto pageDto = new PageDto();
            pageDto.setPageSize(Integer.valueOf(pageSize));
            ArrayList openIds = Lists.newArrayList();
            while (!(sendAppOpenIdsMap = this.fansTagService.getOpenIdsByCondition(Lists.newArrayList((Object[])new String[]{appId}), sendCondition.getTagIds(), sendCondition.getTagRelation(), sendCondition.getSendScope(), sendCondition.getAreaInfo(), sendCondition.getSex(), pageDto)).isEmpty()) {
                openIds.addAll((Collection)sendAppOpenIdsMap.getOrDefault(appId, Lists.newArrayList()));
                int nextPageNum = pageDto.getPageNum() + 1;
                pageDto.setPageNum(Integer.valueOf(nextPageNum));
            }
            if (error || openIds.size() < 2) {
                log.warn("\u7fa4\u53d1\u5931\u8d25, appId:{}, sendCondition:{}, error:{}, size:{}", new Object[]{appId, sendCondition, error, openIds.size()});
                this.appMassMsgFailRecord(appId, openIds.size(), sendCondition.getId());
                continue;
            }
            SendMassMessageTask sendMassMessageTask = new SendMassMessageTask(openIds, appId, baseRespMsg, sendCondition.getId());
            this.pool.submit(sendMassMessageTask);
        }
    }

    private void appMassMsgFailRecord(String appId, int failTotalCount, Long massMsgId) {
        this.massMessageMapper.updateFailApps(massMsgId, appId);
    }

    private OfficialAccountMassMessageDetail buildMassMagDetail(String appId, String msgId, Long massMsgId, String sendStatus, Integer totalCount, Integer successCount, Integer failCount) {
        OfficialAccountMassMessageDetail detail = new OfficialAccountMassMessageDetail();
        detail.setAppId(appId);
        detail.setMsgId(msgId);
        detail.setMassMessageId(massMsgId);
        detail.setTotalCount(totalCount);
        detail.setSuccessCount(successCount);
        detail.setFailCount(failCount);
        detail.setSendStatus(sendStatus);
        return detail;
    }

    private BaseRespMsg buildWechatMsg(MaterialType materialType, OfficialMaterial material, String appId) {
        if (material == null) {
            return null;
        }
        TextMsg baseRespMsg = null;
        try {
            if (materialType == MaterialType.TEXT && material.getId() == null) {
                if (material.getContent() != null) {
                    baseRespMsg = new TextMsg();
                    baseRespMsg.print(material.getContent());
                }
                return baseRespMsg;
            }
            SendCustomMsgReqDto params = new SendCustomMsgReqDto();
            WxMsgType type = null;
            type = "video".equals(material.getmType()) ? WxMsgType.MpVideo : this.commonMaterialService.toWxMsgType(material.getmType());
            MsgData msgData = this.commonMaterialService.convertMaterialMsg(material.getId(), appId);
            params.setMsgType(type.getValue());
            params.setMsgData(msgData);
            baseRespMsg = params.toBaseRespMsg();
            baseRespMsg.setSendIgnoreReprint(Integer.valueOf(1));
        }
        catch (Exception e) {
            log.error("build wechat msg error", (Throwable)e);
        }
        return baseRespMsg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void updateStatus(Long massMessageId) {
        List massMessages;
        if (massMessageId != null) {
            OfficialAccountMassMessage massMessage = (OfficialAccountMassMessage)this.massMessageMapper.selectByPrimaryKey((Object)massMessageId);
            if (massMessage == null || !massMessage.getSendStatus().equals(SendStatus.SENDING.getValue())) throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8981\u68c0\u67e5\u72b6\u6001\u7684\u7fa4\u53d1\u6d88\u606f\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u4e3a\u53d1\u9001\u4e2d\u72b6\u6001");
            massMessages = Lists.newArrayList((Object[])new OfficialAccountMassMessage[]{massMessage});
        } else {
            MassMessageQueryParam queryParam = new MassMessageQueryParam();
            queryParam.setSendStatus(SendStatus.SENDING.getValue());
            massMessages = this.massMessageMapper.queryList(queryParam);
        }
        if (CollectionUtils.isEmpty((Collection)massMessages)) {
            return;
        }
        List massMsgIds = massMessages.stream().map(OfficialAccountMassMessage::getId).collect(Collectors.toList());
        List messageDetails = this.massMessageDetailMapper.queryByMassMsgIds(massMsgIds);
        Map<Long, List<OfficialAccountMassMessageDetail>> messageDetailMap = messageDetails.stream().collect(Collectors.groupingBy(OfficialAccountMassMessageDetail::getMassMessageId));
        for (OfficialAccountMassMessage message : massMessages) {
            CheckMassMsgStatusTask task = new CheckMassMsgStatusTask(message, messageDetailMap.getOrDefault(message.getId(), Lists.newArrayList()));
            this.pool.submit(task);
        }
    }

    static <K, T> List<T> getMapList(Map<K, List<T>> map, K key) {
        ArrayList list = map.get(key);
        if (list == null) {
            list = Lists.newArrayList();
            map.put(key, list);
        }
        return list;
    }

    private class CheckMassMsgStatusTask
    implements Runnable {
        private OfficialAccountMassMessage message;
        private List<OfficialAccountMassMessageDetail> details;

        private CheckMassMsgStatusTask(OfficialAccountMassMessage message, List<OfficialAccountMassMessageDetail> details) {
            this.message = message;
            this.details = details;
        }

        @Override
        public void run() {
            try {
                if (CollectionUtils.isEmpty(this.details)) {
                    log.warn("no subTask of mass message, massMassage={}", (Object)this.message);
                    return;
                }
                Map<String, Long> failSubTaskCountMap = this.details.stream().filter(a -> a.getSendStatus().equals(SendStatus.SEND_FAIL.getValue())).collect(Collectors.groupingBy(OfficialAccountMassMessageDetail::getAppId, Collectors.counting()));
                Map<String, Long> totalSubTaskCountMap = this.details.stream().collect(Collectors.groupingBy(OfficialAccountMassMessageDetail::getAppId, Collectors.counting()));
                this.details = this.details.stream().filter(a -> a.getSendStatus().equals(SendStatus.SENDING.getValue())).collect(Collectors.toList());
                String failApps = this.message.getFailApps();
                if (CollectionUtils.isEmpty(this.details)) {
                    this.message.setSendStatus(SendStatus.SENDED.getValue());
                    SendMassMessageServiceImpl.this.massMessageMapper.updateByPrimaryKeySelective((Object)this.message);
                    return;
                }
                Map<String, List<OfficialAccountMassMessageDetail>> app2DetailMap = this.details.stream().collect(Collectors.groupingBy(OfficialAccountMassMessageDetail::getAppId));
                int appNum = app2DetailMap.size();
                int finishedAppNum = 0;
                for (String appId : app2DetailMap.keySet()) {
                    List<OfficialAccountMassMessageDetail> appMassMsgDetails = app2DetailMap.get(appId);
                    int sendFailCount = 0;
                    int sendingCount = 0;
                    HashMap status2IdListMap = Maps.newHashMap();
                    if (CollectionUtils.isNotEmpty(appMassMsgDetails)) {
                        for (OfficialAccountMassMessageDetail appDetail : appMassMsgDetails) {
                            String msgId = appDetail.getMsgId();
                            String token = SendMassMessageServiceImpl.this.officialTokenService.getOfficialAccessToken(appId);
                            WxMsgStatus msgStatus = SendMassMessageServiceImpl.this.wxMassMsgAPI.getMsgStatus(token, msgId);
                            SendMassMessageServiceImpl.getMapList(status2IdListMap, msgStatus.name()).add(appDetail.getId());
                            if (msgStatus == WxMsgStatus.SEND_FAIL) {
                                ++sendFailCount;
                                continue;
                            }
                            if (msgStatus == WxMsgStatus.SENDING) {
                                ++sendingCount;
                                continue;
                            }
                            if (msgStatus != WxMsgStatus.SEND_SUCCESS || appDetail.getSuccessCount() != 0) continue;
                            ++sendFailCount;
                            SendMassMessageServiceImpl.getMapList(status2IdListMap, WxMsgStatus.SEND_SUCCESS.name()).remove(appDetail.getId());
                            SendMassMessageServiceImpl.getMapList(status2IdListMap, WxMsgStatus.SEND_FAIL.name()).add(appDetail.getId());
                        }
                    }
                    if (!status2IdListMap.isEmpty()) {
                        for (String msgStatus : status2IdListMap.keySet()) {
                            List msgDetailIds;
                            if (msgStatus.equals(SendStatus.SENDING.getValue()) || !CollectionUtils.isNotEmpty((Collection)(msgDetailIds = (List)status2IdListMap.get(msgStatus)))) continue;
                            SendMassMessageServiceImpl.this.massMessageDetailMapper.changeSendStatus(msgDetailIds, msgStatus);
                        }
                    }
                    if (sendingCount != 0) continue;
                    ++finishedAppNum;
                    if (failSubTaskCountMap.getOrDefault(appId, 0L) + (long)sendFailCount == totalSubTaskCountMap.getOrDefault(appId, 0L)) {
                        StringBuilder sb = new StringBuilder();
                        if (StringUtils.isNotBlank((CharSequence)failApps)) {
                            sb.append(failApps).append(appId).append(SendMassMessageServiceImpl.SPLITTER);
                        } else {
                            sb.append(SendMassMessageServiceImpl.SPLITTER).append(appId).append(SendMassMessageServiceImpl.SPLITTER);
                        }
                        failApps = sb.toString();
                        SendMassMessageServiceImpl.this.massMessageMapper.updateFailApps(this.message.getId(), appId);
                        continue;
                    }
                    SendMassMessageServiceImpl.this.massMessageMapper.updateSuccessApps(this.message.getId(), appId);
                }
                if (appNum == finishedAppNum) {
                    this.message.setSendStatus(SendStatus.SENDED.getValue());
                }
            }
            catch (Exception e) {
                log.error("CheckMassMsgStatusTask error:", (Throwable)e);
            }
        }
    }

    private class RecordMessageTask
    implements Callable<Void> {
        private String appId;
        private List<String> openIds;
        private String materialType;
        private MsgId msgId;
        private MsgData msgData;
        private Long bizId;
        private String corpId;

        private RecordMessageTask(String appId, List<String> openIds, String materialType, MsgId msgId, MsgData msgData, Long bizId, String corpId) {
            this.appId = appId;
            this.openIds = openIds;
            this.materialType = materialType;
            this.msgId = msgId;
            this.msgData = msgData;
            this.bizId = bizId;
            this.corpId = corpId;
        }

        @Override
        public Void call() throws Exception {
            for (String openId : this.openIds) {
                OfficialAccountMessage message = new OfficialAccountMessage();
                message.setBizId(this.bizId);
                message.setCorpId(this.corpId);
                message.setOpenId(openId);
                message.setAppId(this.appId);
                message.setMsgId(Long.valueOf(this.msgId == null ? -1L : Long.parseLong(this.msgId.getMsgId())));
                message.setMsgType(this.materialType);
                message.setContent(JacksonUtil.obj2Str((Object)this.msgData));
                message.setSendType(Integer.valueOf(MsgSendType.SYS_MASS_SEND_FANS.getValue()));
                message.setSyncStatus(Integer.valueOf(MsgSyncStatus.SUCCESS.getValue()));
                message.setUserId(Long.valueOf(-1L));
                message.setServantSessionId(Long.valueOf(-1L));
                message.setCreateTime(new Date());
                SendMassMessageServiceImpl.this.messageService.record(message);
            }
            return null;
        }
    }

    private class SendMassMessageTask
    implements Callable<Void> {
        private List<String> openIds;
        private String appId;
        private BaseRespMsg baseRespMsg;
        private Long massMessageId;

        private SendMassMessageTask(List<String> openIds, String appId, BaseRespMsg baseRespMsg, Long massMessageId) {
            this.openIds = openIds;
            this.baseRespMsg = baseRespMsg;
            this.massMessageId = massMessageId;
            this.appId = appId;
        }

        @Override
        public Void call() throws Exception {
            try {
                log.info("start send mass msg by openIds with appId={},massMessageId={},size={}", new Object[]{this.appId, this.massMessageId, this.openIds.size()});
                long startTime = System.currentTimeMillis();
                int totalSize = this.openIds.size();
                int pageSize = 10000;
                int pageNum = totalSize / pageSize;
                if (totalSize % pageSize > 0) {
                    ++pageNum;
                }
                if (pageNum > 100) {
                    log.warn("\u7fa4\u53d1\u4eba\u6570\u591a\u4e8e100\u4e07\uff0c\u53ea\u7fa4\u53d1100w\u4eba\uff0cappId:{}\uff0c massMessageId:{}", (Object)this.appId, (Object)this.massMessageId);
                    pageNum = 100;
                }
                OfficialAccountMassMessage massMessage = (OfficialAccountMassMessage)SendMassMessageServiceImpl.this.massMessageMapper.selectByPrimaryKey((Object)this.massMessageId);
                MsgData msgData = new MsgData();
                OfficialAccountMassMessage newMassMessage = new OfficialAccountMassMessage();
                newMassMessage.setId(massMessage.getId());
                newMassMessage.setMaterialId(massMessage.getMaterialId());
                newMassMessage.setMaterialType(massMessage.getMaterialType());
                msgData.setContent(JacksonUtil.obj2Str((Object)newMassMessage));
                int failNum = 0;
                MsgId msgId = null;
                for (int i = 0; i < pageNum; ++i) {
                    OfficialAccountMassMessageDetail detail;
                    int startIndex = i * pageSize;
                    int endIndex = (i + 1) * pageSize > totalSize ? totalSize : (i + 1) * pageSize;
                    List<String> openIdSublist = this.openIds.subList(startIndex, endIndex);
                    int size = openIdSublist.size();
                    try {
                        String token = SendMassMessageServiceImpl.this.officialTokenService.getOfficialAccessToken(this.appId);
                        msgId = SendMassMessageServiceImpl.this.wxMassMsgAPI.sendByOpenId(token, this.baseRespMsg, openIdSublist);
                        log.info("save appId:{}, msgId:{}", (Object)this.appId, (Object)msgId);
                        detail = SendMassMessageServiceImpl.this.buildMassMagDetail(this.appId, msgId.getMsgId(), this.massMessageId, SendStatus.SENDING.getValue(), size, 0, 0);
                        detail.setBizId(massMessage.getBizId());
                        detail.setCorpId(massMessage.getCorpId());
                        SendMassMessageServiceImpl.this.massMessageDetailMapper.insertSelective((Object)detail);
                        SendMassMessageServiceImpl.this.pool.submit(new RecordMessageTask(this.appId, openIdSublist, massMessage.getMaterialType(), msgId, msgData, massMessage.getBizId(), massMessage.getCorpId()));
                        continue;
                    }
                    catch (WeixinException e) {
                        log.error("ask for wechat to send mass message fail", (Throwable)e);
                        detail = SendMassMessageServiceImpl.this.buildMassMagDetail(this.appId, "", this.massMessageId, SendStatus.SEND_FAIL.getValue(), size, 0, size);
                        detail.setBizId(massMessage.getBizId());
                        detail.setCorpId(massMessage.getCorpId());
                        SendMassMessageServiceImpl.this.massMessageDetailMapper.insertSelective((Object)detail);
                        ++failNum;
                        continue;
                    }
                    catch (Exception e) {
                        log.error("send subTask error", (Throwable)e);
                    }
                }
                if (failNum == pageNum) {
                    log.info("all send subTask of app_id={} failed, failNum:{}", (Object)this.appId, (Object)failNum);
                    SendMassMessageServiceImpl.this.appMassMsgFailRecord(this.appId, totalSize, this.massMessageId);
                }
                long endTime = System.currentTimeMillis();
                log.info("complete send mass msg task with appId={},massMessageId={},size={}, spend time:{}ms", new Object[]{this.appId, this.massMessageId, this.openIds.size(), endTime - startTime});
            }
            catch (Exception e) {
                log.error("SendMassMessageTask error", (Throwable)e);
            }
            return null;
        }
    }
}

