/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.message.service.impl;

import cn.kinyun.scrm.weixin.autoreply.dto.AutoReplyMsgDto;
import cn.kinyun.scrm.weixin.autoreply.dto.CommonMessageRespDto;
import cn.kinyun.scrm.weixin.autoreply.service.LogicAutoReplyService;
import cn.kinyun.scrm.weixin.enums.MaterialType;
import cn.kinyun.scrm.weixin.enums.MsgSendType;
import cn.kinyun.scrm.weixin.enums.MsgSyncStatus;
import cn.kinyun.scrm.weixin.enums.autoreply.AutoReplyMessageType;
import cn.kinyun.scrm.weixin.material.service.OfficalMaterialSyncService;
import cn.kinyun.scrm.weixin.message.dto.MsgData;
import cn.kinyun.scrm.weixin.message.dto.req.SendCustomMsgReqDto;
import cn.kinyun.scrm.weixin.message.service.MessageService;
import cn.kinyun.scrm.weixin.message.service.OfficialAccountReplyService;
import cn.kinyun.scrm.weixin.message.service.SendMessageService;
import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OfficialAccountReplyServiceImpl
implements OfficialAccountReplyService {
    private static final Logger log = LoggerFactory.getLogger(OfficialAccountReplyServiceImpl.class);
    @Autowired
    MessageService messageService;
    @Autowired
    SendMessageService sendMessageService;
    @Autowired
    OfficalMaterialSyncService officalMaterialSyncService;
    @Autowired
    private LogicAutoReplyService logicAutoReplyService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveMsgAndSend2Fans(CommonMessageRespDto dto, String appId, String openId, Integer triggerType) {
        log.info("saveMsgAndSend2Fans with dto={},appId={},openId={}", new Object[]{dto, appId, openId});
        if (dto == null || !dto.isValidate() || StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{appId, openId})) {
            return;
        }
        SendCustomMsgReqDto sendCustomMsgReqDto = this.setDto(dto, appId, openId);
        this.sendMessageService.send(sendCustomMsgReqDto.toBaseRespMsg());
        OfficialAccountMessage message = this.transfer2PlatformMessage(sendCustomMsgReqDto);
        this.messageService.record(message);
    }

    @Override
    public void saveMatMsgAndSend2Fans(Long materialId, String appId, String openId, Integer triggerType) {
        log.info("officialAccount menu click material reply with materialId={}, appId={}, openId={}", new Object[]{materialId, appId, openId});
        AutoReplyMsgDto autoReplyMsgDto = new AutoReplyMsgDto();
        autoReplyMsgDto.setType(AutoReplyMessageType.MATERIAL.getValue());
        autoReplyMsgDto.setContent(String.valueOf(materialId));
        SendCustomMsgReqDto sendCustomMsgReqDto = this.logicAutoReplyService.buildReplyMsg(autoReplyMsgDto, appId, openId);
        this.sendMessageService.send(sendCustomMsgReqDto.toBaseRespMsg());
        this.logicAutoReplyService.record(sendCustomMsgReqDto);
    }

    private SendCustomMsgReqDto setDto(CommonMessageRespDto req, String appId, String openId) {
        SendCustomMsgReqDto sendCustomMsgReqDto = new SendCustomMsgReqDto();
        sendCustomMsgReqDto.setMsgType(1 == req.getType() ? WxMsgType.Text.getValue() : WxMsgType.Image.getValue());
        sendCustomMsgReqDto.setAppId(appId);
        sendCustomMsgReqDto.setOpenId(openId);
        MsgData msgData = null;
        if (WxMsgType.Text.getValue().equalsIgnoreCase(sendCustomMsgReqDto.getMsgType())) {
            msgData = MsgData.builder().content(req.getContent()).build();
        } else if (WxMsgType.Image.getValue().equalsIgnoreCase(sendCustomMsgReqDto.getMsgType())) {
            String mediaId = this.officalMaterialSyncService.syncTmpImageMaterial(req.getContent(), appId, MaterialType.IMAGE.getValue());
            msgData = MsgData.builder().mediaId(mediaId).mediaUrl(req.getContent()).build();
        }
        sendCustomMsgReqDto.setMsgData(msgData);
        return sendCustomMsgReqDto;
    }

    private OfficialAccountMessage transfer2PlatformMessage(SendCustomMsgReqDto dto) {
        OfficialAccountMessage message = new OfficialAccountMessage();
        message.setBizId(dto.getBizId());
        message.setCorpId(dto.getCorpId());
        message.setContent(JacksonUtil.obj2Str((Object)dto.getMsgData()));
        message.setServantSessionId(Long.valueOf(-1L));
        message.setUserId(Long.valueOf(-1L));
        message.setAppId(dto.getAppId());
        message.setMsgId(Long.valueOf(-1L));
        message.setMsgType(dto.getMsgType());
        message.setOpenId(dto.getOpenId());
        message.setSendType(Integer.valueOf(MsgSendType.SYS_SEND_FANS.getValue()));
        message.setSyncStatus(Integer.valueOf(MsgSyncStatus.SUCCESS.getValue()));
        message.setFromUserId(Long.valueOf(-1L));
        return message;
    }
}

