/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.message.service.impl;

import cn.kinyun.scrm.weixin.enums.MsgSendType;
import cn.kinyun.scrm.weixin.message.dto.ConvrMsg;
import cn.kinyun.scrm.weixin.message.dto.MsgData;
import cn.kinyun.scrm.weixin.message.dto.resp.KeywordsMsgResp;
import cn.kinyun.scrm.weixin.message.service.EsMessageService;
import com.google.common.collect.Lists;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.dal.official.base.dto.AppIdOpenIdDto;
import com.kuaike.scrm.dal.official.base.dto.FansHistoryMatchHitDto;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.apache.http.Header;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.max.ParsedMax;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EsMessageServiceImpl
implements EsMessageService {
    private static final Logger log = LoggerFactory.getLogger(EsMessageServiceImpl.class);
    private String[] fields = new String[]{"msgData.content"};
    private int[] sendTypes = new int[]{MsgSendType.RECV.getValue(), MsgSendType.SEND.getValue(), MsgSendType.SYS_SEND_FANS.getValue(), MsgSendType.SYS_MASS_SEND_FANS.getValue()};
    @Value(value="${scrm.elasticsearch.officialMessageIndex}")
    private String index;
    @Autowired
    private RestHighLevelClient restHighLevelClient;

    @Override
    public void save(OfficialAccountMessage message) {
        String appId = message.getAppId();
        String openId = message.getOpenId();
        Long userId = message.getUserId();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", message.getId());
        map.put("openId", openId);
        map.put("appId", appId);
        map.put("userId", userId);
        map.put("msgId", message.getMsgId());
        map.put("servantSessionId", message.getServantSessionId());
        map.put("sendType", message.getSendType());
        map.put("syncStatus", message.getSyncStatus());
        map.put("sendTime", message.getCreateTime().getTime());
        map.put("msgType", message.getMsgType());
        try {
            MsgData data = (MsgData)JacksonUtil.str2Obj((String)message.getContent(), MsgData.class);
            map.put("msgData", data);
            IndexRequest indexRequest = new IndexRequest(this.index, "doc", message.getId() + "");
            indexRequest.source(map, XContentType.JSON);
            this.restHighLevelClient.index(indexRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("save msg to es error: ", (Throwable)e);
        }
    }

    @Override
    public List<ConvrMsg> queryList(String appId, String openId) {
        return this.queryListPaged(appId, openId, null, 20, null, false, new int[0]);
    }

    @Override
    public List<ConvrMsg> queryListPaged(String appId, String openId, Long id, Integer count) {
        return this.queryListPaged(appId, openId, id, count, false, false, new int[0]);
    }

    @Override
    public List<ConvrMsg> queryListPaged(String appId, String openId, Long id, Integer count, Boolean forward, boolean includeSelf, int ... sendTypes) {
        log.info("query message from Elastic Search with appId={}, openId={}, id={}, count={}, forward={}", new Object[]{appId, openId, id, count, forward});
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId}), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{openId}), (Object)"\u7c89\u4e1dopenId\u4e3a\u7a7a");
        LinkedList list = Lists.newLinkedList();
        if (forward == null) {
            forward = false;
        }
        if (ArrayUtils.isEmpty((int[])sendTypes)) {
            sendTypes = this.sendTypes;
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"appId", (String)appId)).must((QueryBuilder)QueryBuilders.termQuery((String)"openId", (String)openId)).must((QueryBuilder)QueryBuilders.termsQuery((String)"sendType", (int[])sendTypes));
        if (id != null && id > 0L) {
            if (forward.booleanValue()) {
                queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"id").from((Object)id, includeSelf));
            } else {
                queryBuilder.must((QueryBuilder)QueryBuilders.rangeQuery((String)"id").to((Object)id, includeSelf));
            }
        }
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        if (count != null && count > 0) {
            searchSourceBuilder.size(count.intValue());
        }
        if (forward.booleanValue()) {
            searchSourceBuilder.sort("sendTime", SortOrder.ASC);
        } else {
            searchSourceBuilder.sort("sendTime", SortOrder.DESC);
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed query official_account_message from Elastic Search.", (Throwable)e);
            return Collections.emptyList();
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        if (searchHits == null || searchHits.length == 0) {
            return Collections.emptyList();
        }
        for (SearchHit searchHit : searchHits) {
            try {
                String doc = searchHit.getSourceAsString();
                ConvrMsg msg = (ConvrMsg)JacksonUtil.str2Obj((String)doc, ConvrMsg.class);
                if (forward.booleanValue()) {
                    list.add(msg);
                    continue;
                }
                list.addFirst(msg);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    @Override
    public List<ConvrMsg> queryListBetween(String appId, String openId, Long id1, Long id2, Boolean includeId1, Boolean includeId2) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId}), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{openId}), (Object)"\u7c89\u4e1dopenId\u4e3a\u7a7a");
        Preconditions.checkArgument((id1 != null ? 1 : 0) != 0, (Object)"\u6d88\u606fid1\u4e3a\u7a7a");
        Preconditions.checkArgument((id2 != null ? 1 : 0) != 0, (Object)"\u6d88\u606fid2\u4e3a\u7a7a");
        LinkedList list = Lists.newLinkedList();
        if (includeId1 == null) {
            includeId1 = false;
        }
        if (includeId2 == null) {
            includeId2 = false;
        }
        if (id1 > id2) {
            Long lTemp = id2;
            id2 = id1;
            id1 = lTemp;
            boolean bTemp = includeId1;
            includeId1 = includeId2;
            includeId2 = bTemp;
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"appId", (String)appId)).must((QueryBuilder)QueryBuilders.termQuery((String)"openId", (String)openId)).must((QueryBuilder)QueryBuilders.rangeQuery((String)"id").from((Object)id1, includeId1.booleanValue()).to((Object)id2, includeId2.booleanValue())).must((QueryBuilder)QueryBuilders.termsQuery((String)"sendType", (int[])this.sendTypes));
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.sort("sendTime", SortOrder.ASC);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed query official_account_message from Elastic Search.", (Throwable)e);
            return Collections.emptyList();
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        if (searchHits == null || searchHits.length == 0) {
            return Collections.emptyList();
        }
        for (SearchHit searchHit : searchHits) {
            try {
                String doc = searchHit.getSourceAsString();
                ConvrMsg msg = (ConvrMsg)JacksonUtil.str2Obj((String)doc, ConvrMsg.class);
                list.add(msg);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    @Override
    public List<ConvrMsg> queryListAround(String appId, String openId, Long id, Integer count) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId}), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{openId}), (Object)"\u7c89\u4e1dopenId\u4e3a\u7a7a");
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"id is null");
        Preconditions.checkArgument((count != null && count > 0 ? 1 : 0) != 0, (Object)"count is null");
        LinkedList list = Lists.newLinkedList();
        list.addAll(this.queryListPaged(appId, openId, id, count + 1, false, true, new int[0]));
        list.addAll(this.queryListPaged(appId, openId, id, count, true, false, new int[0]));
        return list;
    }

    @Override
    public List<ConvrMsg> searchHistory(String appId, String openId, String query, PageDto page) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId}), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{openId}), (Object)"\u7c89\u4e1dopenId\u4e3a\u7a7a");
        if (StringUtils.isBlank((CharSequence)query)) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"appId", (String)appId)).must((QueryBuilder)QueryBuilders.termQuery((String)"openId", (String)openId)).must((QueryBuilder)QueryBuilders.termsQuery((String)"sendType", (int[])this.sendTypes));
        QueryBuilder keywordQuery = this.getMatchPhrashQuery(query, this.fields);
        if (keywordQuery != null) {
            queryBuilder.must(keywordQuery);
        }
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.sort("sendTime", SortOrder.DESC);
        if (page != null) {
            searchSourceBuilder.from((page.getPageNum() - 1) * page.getPageSize());
            searchSourceBuilder.size(page.getPageSize().intValue());
            ValuesSourceAggregationBuilder aggregationBuilder = AggregationBuilders.count((String)"count").field("id");
            searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        } else {
            searchSourceBuilder.size(10000);
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed query official_account_message from Elastic Search.", (Throwable)e);
            return Collections.emptyList();
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        if (searchHits == null || searchHits.length == 0) {
            return Collections.emptyList();
        }
        for (SearchHit searchHit : searchHits) {
            try {
                String doc = searchHit.getSourceAsString();
                ConvrMsg msg = (ConvrMsg)JacksonUtil.str2Obj((String)doc, ConvrMsg.class);
                list.add(msg);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (page != null) {
            ValueCount valueCount = (ValueCount)searchResponse.getAggregations().get("count");
            page.setCount(Integer.valueOf((int)valueCount.getValue()));
            page.setCurPageCount(Integer.valueOf(list.size()));
        }
        return list;
    }

    @Override
    public List<FansHistoryMatchHitDto> countHistory(Collection<AppIdOpenIdDto> fanIds, String query, Integer fansTalkCount) {
        if (CollectionUtils.isEmpty(fanIds)) {
            return Collections.emptyList();
        }
        if (StringUtils.isBlank((CharSequence)query)) {
            return Collections.emptyList();
        }
        if (fansTalkCount == null) {
            fansTalkCount = 100;
        }
        ArrayList list = Lists.newArrayList();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder idsQuery = QueryBuilders.boolQuery();
        fanIds.forEach(it -> idsQuery.should((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"appId", (String)it.getAppId())).must((QueryBuilder)QueryBuilders.termQuery((String)"openId", (String)it.getOpenId()))));
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)idsQuery);
        QueryBuilder keywordQuery = this.getMatchPhrashQuery(query, this.fields);
        if (keywordQuery != null) {
            queryBuilder.must(keywordQuery);
        }
        queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sendType", (int[])this.sendTypes));
        searchSourceBuilder.size(0);
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.sort("sendTime", SortOrder.DESC);
        String termsKey = "appId,openId";
        Script script = new Script(ScriptType.INLINE, "painless", "doc['appId'].value +','+ doc['openId'].value", new HashMap());
        TermsAggregationBuilder aggregationBuilder = ((TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)termsKey).script(script)).size(fansTalkCount.intValue()).subAggregation((AggregationBuilder)AggregationBuilders.max((String)"sendTime").field("sendTime"))).subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)"top").size(1))).order(BucketOrder.aggregation((String)"sendTime", (boolean)false));
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed query official_account_message from Elastic Search.", (Throwable)e);
            return Collections.emptyList();
        }
        Aggregations aggs = searchResponse.getAggregations();
        ParsedStringTerms agg = (ParsedStringTerms)aggs.get(termsKey);
        if (agg != null && CollectionUtils.isNotEmpty((Collection)agg.getBuckets())) {
            int len = agg.getBuckets().size();
            for (int i = 0; i < len; ++i) {
                Terms.Bucket it2 = (Terms.Bucket)agg.getBuckets().get(i);
                String appIdOpenId = it2.getKeyAsString();
                String[] ids = appIdOpenId.split(",");
                String appId = ids[0];
                String openId = ids[1];
                long count = it2.getDocCount();
                ParsedMax max = (ParsedMax)it2.getAggregations().get("sendTime");
                long sendTime = (long)max.getValue();
                FansHistoryMatchHitDto dto = new FansHistoryMatchHitDto();
                dto.setAppId(appId);
                dto.setOpenId(openId);
                dto.setCount(Long.valueOf(count));
                dto.setLatestTime(new Date(sendTime));
                list.add(dto);
            }
        }
        return list;
    }

    @Override
    public List<KeywordsMsgResp> queryKeywordMsg(String appId, String openId, List<String> keywords, Integer count) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId}), (Object)"\u516c\u4f17\u53f7appId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{openId}), (Object)"\u7c89\u4e1dopenId\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty(keywords)) {
            return Collections.emptyList();
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder keywordQuery = QueryBuilders.boolQuery();
        for (String keyword : keywords) {
            keywordQuery.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"msgData.content.keyword", (String)("*" + keyword + "*")));
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"appId", (String)appId)).must((QueryBuilder)QueryBuilders.termQuery((String)"openId", (String)openId)).must((QueryBuilder)QueryBuilders.termQuery((String)"sendType", (int)MsgSendType.RECV.getValue())).must((QueryBuilder)keywordQuery);
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        if (count != null && count > 0) {
            searchSourceBuilder.size(count.intValue());
        }
        searchSourceBuilder.sort("sendTime", SortOrder.DESC);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.index});
        searchRequest.types(new String[]{"doc"});
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed query official_account_message from Elastic Search.", (Throwable)e);
            return Collections.emptyList();
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        if (searchHits == null || searchHits.length == 0) {
            return Collections.emptyList();
        }
        ArrayList list = Lists.newArrayList();
        for (SearchHit searchHit : searchHits) {
            KeywordsMsgResp msg = null;
            try {
                String doc = searchHit.getSourceAsString();
                msg = (KeywordsMsgResp)JacksonUtil.str2Obj((String)doc, KeywordsMsgResp.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            String content = msg.getMsgData().getContent();
            ArrayList keys = Lists.newArrayListWithCapacity((int)keywords.size());
            for (String key : keywords) {
                if (!content.contains(key)) continue;
                keys.add(key);
            }
            msg.setKeywords(keys);
            list.add(msg);
        }
        return list;
    }

    private QueryBuilder getMatchPhrashQuery(String query, String ... fields) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return null;
        }
        if (fields == null || fields.length == 0) {
            return null;
        }
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        for (String field : fields) {
            boolQuery.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)field, (Object)query));
        }
        return boolQuery;
    }
}

