/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.material.service.impl;

import cn.kinyun.scrm.weixin.material.enums.MaterialFileLimit;
import cn.kinyun.scrm.weixin.material.service.PlatformRepireService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.MD5Utils;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterial;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterialFile;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialFileMapper;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class PlatformRepireServiceImpl
implements PlatformRepireService {
    @Resource
    OfficialMaterialMapper materialMapper;
    @Resource
    OfficialMaterialFileMapper materialFileMapper;

    @Override
    public void repairVideo() {
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(Integer.valueOf(0));
        pageDto.setPageSize(Integer.valueOf(200));
        List materialList = this.materialMapper.queryVideos(pageDto);
        ArrayList urlMd5List = Lists.newArrayList();
        while (CollectionUtils.isNotEmpty((Collection)materialList)) {
            for (OfficialMaterial m : materialList) {
                urlMd5List.add(MD5Utils.MD5Encode8((String)m.getUrl()));
            }
            Map<Object, Object> fileMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)urlMd5List)) {
                fileMap = this.materialFileMapper.getListByUrlMd5((List)urlMd5List).stream().collect(Collectors.toMap(a -> a.getUrlMd5(), Function.identity()));
            }
            ArrayList ids = Lists.newArrayList();
            for (OfficialMaterial m : materialList) {
                String md5Str = MD5Utils.MD5Encode8((String)m.getUrl());
                OfficialMaterialFile file = (OfficialMaterialFile)fileMap.get(md5Str);
                if (file == null || !MaterialFileLimit.WECHAT_MOMENTS_VIDEO.checkSize(file.getFileSize()) || !MaterialFileLimit.WECHAT_MOMENTS_VIDEO.checkDuration(file.getDuration()) || !MaterialFileLimit.WECHAT_MOMENTS_VIDEO.checkFormat(file.getFileFormat())) continue;
                ids.add(m.getId());
            }
            pageDto.setPageNum(Integer.valueOf(pageDto.getPageNum() + 1));
            materialList = this.materialMapper.queryVideos(pageDto);
        }
    }
}

