/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.material.service.impl;

import cn.kinyun.scrm.weixin.common.dto.UserInfoRespDto;
import cn.kinyun.scrm.weixin.common.service.UserInfoService;
import cn.kinyun.scrm.weixin.material.dto.SimpleUserInfoDto;
import cn.kinyun.scrm.weixin.material.dto.req.AddCommonMaterialReq;
import cn.kinyun.scrm.weixin.material.dto.req.BatchAddImgMaterialReq;
import cn.kinyun.scrm.weixin.material.dto.req.DelMaterialReq;
import cn.kinyun.scrm.weixin.material.dto.req.ImgMaterialReq;
import cn.kinyun.scrm.weixin.material.dto.req.MaterialListReq;
import cn.kinyun.scrm.weixin.material.dto.req.ModCommonMaterialReq;
import cn.kinyun.scrm.weixin.material.dto.resp.BatchAddImgMatResp;
import cn.kinyun.scrm.weixin.material.dto.resp.ImgMaterialCheckResp;
import cn.kinyun.scrm.weixin.material.dto.resp.NormalMaterialListResp;
import cn.kinyun.scrm.weixin.material.dto.resp.TranscodeMaterialResp;
import cn.kinyun.scrm.weixin.material.enums.MaterialFileLimit;
import cn.kinyun.scrm.weixin.material.enums.MaterialType;
import cn.kinyun.scrm.weixin.material.enums.PlatformType;
import cn.kinyun.scrm.weixin.material.service.CommonMaterialService;
import cn.kinyun.scrm.weixin.material.service.NormalMaterialService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.MD5Utils;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterial;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterialFile;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterialRecycle;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialFileMapper;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialGroupMapper;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialMapper;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialRecycleMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NormalMaterialServiceImpl
implements NormalMaterialService {
    private static final Logger log = LoggerFactory.getLogger(NormalMaterialServiceImpl.class);
    public static final String MATERIAL_NOT_EXIST = "\u7d20\u6750\u4e0d\u5b58\u5728";
    public static final String MATERIAL_FILE_NOT_FOUND = "\u94fe\u63a5\u5bf9\u5e94\u7684\u6587\u4ef6\u4e0d\u5b58\u5728";
    public static final String INVALID_VOICE_MATERIAL = "\u8be5\u8bed\u97f3\u7d20\u6750\u5927\u5c0f\u6216\u8005\u65f6\u957f\u4e0d\u6ee1\u8db3\u8981\u6c42";
    public static final String INVALID_MATERIAL_TYPE = "\u7d20\u6750\u7c7b\u578b\u4e0d\u5339\u914d";
    public static final String MATERIAl_NOT_USEABLE_AT_ALL = "\u8be5\u7d20\u6750\u5fae\u4fe1\u548c\u516c\u4f17\u53f7\u5747\u4e0d\u53ef\u7528";
    public static final String PLATFORM_NOT_MATCH = "\u7d20\u6750\u4e0d\u9002\u7528";
    @Resource
    private OfficialMaterialMapper materialMapper;
    @Resource
    private OfficialMaterialGroupMapper materialGroupMapper;
    @Resource
    private OfficialMaterialFileMapper materialFileMapper;
    @Resource
    private OfficialMaterialRecycleMapper materialRecycleMapper;
    @Autowired
    private NodeService nodeService;
    @Autowired
    CommonMaterialService commonMaterialService;
    @Autowired
    private UserInfoService userInfoService;

    @Override
    public Long addMaterial(AddCommonMaterialReq params, Long operatorId) {
        log.info("add material with params={},operatorId={}", (Object)params, (Object)operatorId);
        params.validate();
        int platformType = this.getPlateform(params.getUrl(), params.getMaterialType());
        int platformMatch = platformType & params.getPlatformType();
        if (platformMatch == 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, PLATFORM_NOT_MATCH);
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        OfficialMaterial material = new OfficialMaterial();
        material.setBizId(userInfo.getBizId());
        material.setCorpId(userInfo.getCorpId());
        material.setGroupId(params.getGroupId());
        material.setTitle(params.getTitle());
        material.setNodeId(params.getNodeId());
        material.setUrl(params.getUrl());
        material.setContent(params.getContent());
        material.setmType(params.getMaterialType());
        material.setPlatformType(Integer.valueOf(platformType));
        material.setDigest(params.getTitle());
        material.setCreatorId(operatorId);
        material.setModifierId(operatorId);
        material.setCover(params.getCover());
        material.setTranscodeUrl(params.getTranscodeUrl());
        this.materialMapper.insertSelective((Object)material);
        this.transcodeMaterialIfNecessary(material);
        return material.getId();
    }

    @Override
    public BatchAddImgMatResp batchAddImage(BatchAddImgMaterialReq params, Long operatorId) {
        log.info("batch add image with params={}, operatorId={}", (Object)params, (Object)operatorId);
        params.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        BatchAddImgMatResp resp = new BatchAddImgMatResp();
        boolean isValid = true;
        ArrayList results = Lists.newArrayList();
        ArrayList materials = Lists.newArrayList();
        List urlMd5List = params.getList().stream().map(img -> MD5Utils.MD5Encode8((String)img.getUrl())).collect(Collectors.toList());
        log.info("query material file with urlMd5List={}", urlMd5List);
        List fileList = this.materialFileMapper.getListByUrlMd5(urlMd5List);
        if (CollectionUtils.isEmpty((Collection)fileList)) {
            isValid = false;
            for (ImgMaterialReq img2 : params.getList()) {
                String url = img2.getUrl();
                results.add(new ImgMaterialCheckResp(null, url, MATERIAL_FILE_NOT_FOUND));
            }
            resp.setIsValid(isValid);
            resp.setList(results);
            return resp;
        }
        Map<String, OfficialMaterialFile> fileMap = fileList.stream().collect(Collectors.toMap(OfficialMaterialFile::getUrlMd5, it -> it));
        for (ImgMaterialReq img3 : params.getList()) {
            boolean isWechatMoments;
            String url = img3.getUrl();
            String urlMd5 = MD5Utils.MD5Encode8((String)url);
            OfficialMaterialFile file = fileMap.get(urlMd5);
            if (file == null) {
                isValid = false;
                results.add(new ImgMaterialCheckResp(null, url, MATERIAL_FILE_NOT_FOUND));
                continue;
            }
            boolean isWeixin = MaterialFileLimit.WEIXIN_IMAGE.checkFormat(file.getFileFormat()) && MaterialFileLimit.WEIXIN_IMAGE.checkSize(file.getFileSize());
            boolean isOfficialAccount = MaterialFileLimit.OFFICAL_ACCOUNT_IMAGE.checkFormat(file.getFileFormat()) && MaterialFileLimit.OFFICAL_ACCOUNT_IMAGE.checkSize(file.getFileSize());
            boolean bl = isWechatMoments = MaterialFileLimit.WECHAT_MOMENTS_IMAGE.checkFormat(file.getFileFormat()) && MaterialFileLimit.WECHAT_MOMENTS_IMAGE.checkSize(file.getFileSize());
            if (!(isWeixin || isOfficialAccount || isWechatMoments)) {
                results.add(new ImgMaterialCheckResp(null, url, MATERIAl_NOT_USEABLE_AT_ALL));
                isValid = false;
                continue;
            }
            int platformType = PlatformType.getPlateform(isWeixin, isOfficialAccount, isWechatMoments);
            int platformMatch = platformType & params.getPlatformType();
            if (platformMatch == 0) {
                results.add(new ImgMaterialCheckResp(null, url, PLATFORM_NOT_MATCH));
                isValid = false;
                continue;
            }
            OfficialMaterial material = new OfficialMaterial();
            material.setBizId(userInfo.getBizId());
            material.setCorpId(userInfo.getCorpId());
            material.setPid(Long.valueOf(0L));
            material.setNum(Integer.valueOf(0));
            material.setTitle(img3.getTitle());
            material.setDigest(img3.getTitle());
            material.setUrl(img3.getUrl());
            material.setContent("");
            material.setCover("");
            material.setAuthor("");
            material.setNodeId(params.getNodeId());
            material.setGroupId(params.getGroupId());
            material.setmType(MaterialType.IMAGE.getType());
            material.setPlatformType(Integer.valueOf(platformType));
            material.setCreateTime(new Date());
            material.setCreatorId(operatorId);
            material.setModifierId(operatorId);
            materials.add(material);
        }
        if (!isValid) {
            resp.setIsValid(isValid);
            resp.setList(results);
            return resp;
        }
        this.materialMapper.batchInsert((List)materials);
        for (OfficialMaterial mat : materials) {
            results.add(new ImgMaterialCheckResp(mat.getId(), mat.getUrl(), ""));
        }
        resp.setIsValid(isValid);
        resp.setList(results);
        return resp;
    }

    private void transcodeMaterialIfNecessary(OfficialMaterial material) {
        if (material == null) {
            return;
        }
        if (this.valid(material, MaterialType.VOICE.getType())) {
            Boolean isAmrVoice = Optional.ofNullable(material.getUrl()).map(a -> a.endsWith("amr")).orElse(false);
            if ((material.getPlatformType() & PlatformType.WEIXIN.getType()) > 0 && isAmrVoice.booleanValue()) {
                this.transcodeAmrToMp3(material);
            }
        }
    }

    private String transcodeAmrToMp3(OfficialMaterial material) {
        String transcodeUrl = material.getTranscodeUrl();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{transcodeUrl})) {
            return transcodeUrl;
        }
        String url = material.getUrl();
        return null;
    }

    private boolean valid(OfficialMaterial material, String type) {
        if (material == null || StringUtils.isBlank((CharSequence)type)) {
            return false;
        }
        return type.equals(material.getmType());
    }

    @Override
    public TranscodeMaterialResp transcode(Long materialId) {
        OfficialMaterial material;
        log.info("transcode material with materialId={}", (Object)materialId);
        if (materialId == null || (material = (OfficialMaterial)this.materialMapper.selectByPrimaryKey((Object)materialId)) == null) {
            log.warn("materialId={} doesn't exist, transcode fail", (Object)materialId);
            return null;
        }
        if (this.valid(material, MaterialType.VOICE.getType())) {
            return TranscodeMaterialResp.of(materialId, this.transcodeAmrToMp3(material));
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long modMaterial(ModCommonMaterialReq params, Long operatorId) {
        log.info("mod material with params={},operatorId={}", (Object)params, (Object)operatorId);
        params.validate(false, true);
        OfficialMaterial material = (OfficialMaterial)this.materialMapper.selectByPrimaryKey((Object)params.getId());
        if (material == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, MATERIAL_NOT_EXIST);
        }
        if (!material.getmType().equals(params.getMaterialType())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, INVALID_MATERIAL_TYPE);
        }
        int platformType = this.getPlateform(params.getUrl(), params.getMaterialType());
        material.setTitle(params.getTitle());
        material.setUrl(params.getUrl());
        material.setPlatformType(Integer.valueOf(platformType));
        material.setModifierId(operatorId);
        material.setContent(params.getContent());
        material.setCover(params.getCover());
        material.setUpdateTime(null);
        this.materialMapper.updateByPrimaryKeySelective((Object)material);
        return material.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delMaterial(DelMaterialReq params, Long operatorId) {
        log.info("del material with params={},operatorId={}", (Object)params, (Object)operatorId);
        params.validate();
        OfficialMaterial material = (OfficialMaterial)this.materialMapper.selectByPrimaryKey((Object)params.getId());
        if (material == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, MATERIAL_NOT_EXIST);
        }
        OfficialMaterialRecycle recycle = new OfficialMaterialRecycle();
        BeanUtils.copyProperties((Object)material, (Object)recycle);
        this.materialRecycleMapper.insertSelective((Object)recycle);
        this.materialMapper.deleteByPrimaryKey((Object)params.getId());
    }

    @Override
    public List<NormalMaterialListResp> list(MaterialListReq params, Long operatorId) {
        log.info("list material with params={},operatorId={}", (Object)params, (Object)operatorId);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        List materialList = this.materialMapper.queryMaterialList(params.getTitle(), params.getUserId(), params.getNodeId(), params.getGroupId(), params.getPlatformType(), params.getMType(), params.getFilterFormats(), userInfo.getBizId(), params.getPageDto());
        if (params.getPageDto() != null) {
            params.getPageDto().setCurPageCount(Integer.valueOf(materialList.size()));
            params.getPageDto().setCount(Integer.valueOf(this.materialMapper.countList(params.getTitle(), params.getUserId(), params.getNodeId(), params.getGroupId(), params.getPlatformType(), params.getMType(), params.getFilterFormats(), userInfo.getBizId(), params.getPageDto())));
        }
        if (CollectionUtils.isEmpty((Collection)materialList)) {
            return Lists.newArrayList();
        }
        HashSet userIds = Sets.newHashSet();
        HashSet groupIds = Sets.newHashSet();
        HashSet urls = Sets.newHashSet();
        for (OfficialMaterial material : materialList) {
            userIds.add(material.getCreatorId());
            userIds.add(material.getModifierId());
            groupIds.add(material.getGroupId());
            urls.add(material.getUrl());
        }
        Map<Long, UserInfoRespDto> userMap = this.userInfoService.queryUserInfoMap(userIds);
        HashMap groupMap = this.materialGroupMapper.queryListByIds((List)Lists.newArrayList((Iterable)groupIds)).stream().collect(Collectors.toMap(a -> a.getId(), a -> a.getGroupName()));
        Map nodeMap = this.nodeService.getNodeMap(userInfo.getBizId());
        Map<String, OfficialMaterialFile> materialFileMap = this.commonMaterialService.getMaterialFileInfo(urls);
        if (groupMap == null) {
            groupMap = Maps.newHashMap();
        }
        groupMap.put(-1L, "\u672a\u5206\u7ec4");
        ArrayList result = Lists.newArrayList();
        for (OfficialMaterial material : materialList) {
            NormalMaterialListResp resp = this.build(material, materialFileMap);
            Node node = (Node)nodeMap.get(material.getNodeId());
            if (node != null) {
                resp.setNodeName(node.getName());
            }
            resp.setGroupName((String)groupMap.get(material.getGroupId()));
            UserInfoRespDto creator = userMap.get(material.getCreatorId());
            UserInfoRespDto modifier = userMap.get(material.getModifierId());
            if (creator != null) {
                resp.setCreator(new SimpleUserInfoDto(material.getCreatorId(), creator.getUsername(), creator.getUsername()));
            } else {
                resp.setCreator(new SimpleUserInfoDto(material.getCreatorId(), null, null));
            }
            if (modifier != null) {
                resp.setModifier(new SimpleUserInfoDto(material.getModifierId(), modifier.getUsername(), modifier.getUsername()));
            } else {
                resp.setModifier(new SimpleUserInfoDto(material.getModifierId(), null, null));
            }
            result.add(resp);
        }
        return result;
    }

    @Override
    public List<NormalMaterialListResp> list(List<Long> ids, Long operatorId) {
        log.info("list material with ids ={},operatorId={}", ids, (Object)operatorId);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids));
        List materialList = this.materialMapper.queryListByIds(ids);
        materialList.addAll(this.materialRecycleMapper.queryListByIds(ids).stream().map(a -> a.toMaterial()).collect(Collectors.toList()));
        if (CollectionUtils.isEmpty((Collection)materialList)) {
            return Lists.newArrayList();
        }
        HashSet userIds = Sets.newHashSet();
        HashSet groupIds = Sets.newHashSet();
        HashSet urls = Sets.newHashSet();
        for (OfficialMaterial material : materialList) {
            userIds.add(material.getCreatorId());
            userIds.add(material.getModifierId());
            groupIds.add(material.getGroupId());
            urls.add(material.getUrl());
        }
        Map<Long, UserInfoRespDto> userMap = this.userInfoService.queryUserInfoMap(userIds);
        HashMap groupMap = this.materialGroupMapper.queryListByIds((List)Lists.newArrayList((Iterable)groupIds)).stream().collect(Collectors.toMap(a -> a.getId(), a -> a.getGroupName()));
        Map nodeMap = this.nodeService.getNodeMap(userInfo.getBizId());
        Map<String, OfficialMaterialFile> materialFileMap = this.commonMaterialService.getMaterialFileInfo(urls);
        if (groupMap == null) {
            groupMap = Maps.newHashMap();
        }
        groupMap.put(-1L, "\u672a\u5206\u7ec4");
        ArrayList result = Lists.newArrayList();
        for (OfficialMaterial material : materialList) {
            NormalMaterialListResp resp = this.build(material, materialFileMap);
            Node node = (Node)nodeMap.get(material.getNodeId());
            if (node != null) {
                resp.setNodeName(node.getName());
            }
            resp.setGroupName((String)groupMap.get(material.getGroupId()));
            UserInfoRespDto creator = userMap.get(material.getCreatorId());
            UserInfoRespDto modifier = userMap.get(material.getModifierId());
            if (creator != null) {
                resp.setCreator(new SimpleUserInfoDto(material.getCreatorId(), creator.getUsername(), creator.getUsername()));
            } else {
                resp.setCreator(new SimpleUserInfoDto(material.getCreatorId(), null, null));
            }
            if (modifier != null) {
                resp.setModifier(new SimpleUserInfoDto(material.getModifierId(), modifier.getUsername(), modifier.getUsername()));
            } else {
                resp.setModifier(new SimpleUserInfoDto(material.getModifierId(), null, null));
            }
            result.add(resp);
        }
        return result;
    }

    private NormalMaterialListResp build(OfficialMaterial material, Map<String, OfficialMaterialFile> materialFileMap) {
        NormalMaterialListResp resp = new NormalMaterialListResp();
        resp.setId(material.getId());
        resp.setTitle(material.getTitle());
        resp.setContent(material.getContent());
        resp.setUrl(material.getUrl());
        resp.setTranscodeUrl(material.getTranscodeUrl());
        resp.setGroupId(material.getGroupId());
        resp.setNodeId(material.getNodeId());
        resp.setCreateTime(material.getCreateTime());
        resp.setUpdateTime(material.getUpdateTime());
        resp.setDescription(material.getDigest());
        resp.setMaterialType(material.getmType());
        resp.setPlatformType(material.getPlatformType());
        OfficialMaterialFile file = materialFileMap.get(material.getUrl());
        resp.setDuration(file != null ? file.getDuration() : 0L);
        resp.setCover(material.getCover());
        return resp;
    }

    private int getPlateform(String url, String materialType) {
        if (materialType.equals(MaterialType.TEXT.getType())) {
            return PlatformType.getPlateform(true, true, true);
        }
        String urlMd5 = MD5Utils.MD5Encode8((String)url);
        OfficialMaterialFile file = this.materialFileMapper.getByUrlMd5(urlMd5);
        if (file == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, MATERIAL_FILE_NOT_FOUND);
        }
        boolean isWeixin = true;
        boolean isOfficialAccount = true;
        boolean isWechatMoments = true;
        String name = "\u7d20\u6750";
        if (materialType.equals(MaterialType.IMAGE.getType())) {
            name = "\u56fe\u7247\u7d20\u6750";
            isWeixin = isWeixin && MaterialFileLimit.WEIXIN_IMAGE.checkFormat(file.getFileFormat()) && MaterialFileLimit.WEIXIN_IMAGE.checkSize(file.getFileSize());
            isOfficialAccount = isOfficialAccount && MaterialFileLimit.OFFICAL_ACCOUNT_IMAGE.checkFormat(file.getFileFormat()) && MaterialFileLimit.OFFICAL_ACCOUNT_IMAGE.checkSize(file.getFileSize());
            isWechatMoments = isWechatMoments && MaterialFileLimit.WECHAT_MOMENTS_IMAGE.checkFormat(file.getFileFormat()) && MaterialFileLimit.WECHAT_MOMENTS_IMAGE.checkSize(file.getFileSize());
        } else if (materialType.equals(MaterialType.VOICE.getType())) {
            name = "\u8bed\u97f3\u7d20\u6750";
            isWeixin = isWeixin && MaterialFileLimit.WEIXIN_VOICE.checkFormat(file.getFileFormat()) && MaterialFileLimit.WEIXIN_VOICE.checkSize(file.getFileSize()) && MaterialFileLimit.WEIXIN_VOICE.checkDuration(file.getDuration());
            isOfficialAccount = isOfficialAccount && MaterialFileLimit.OFFICAL_ACCOUNT_VOICE.checkFormat(file.getFileFormat()) && MaterialFileLimit.OFFICAL_ACCOUNT_VOICE.checkSize(file.getFileSize()) && MaterialFileLimit.OFFICAL_ACCOUNT_VOICE.checkDuration(file.getDuration());
            isWechatMoments = false;
        } else if (materialType.equals(MaterialType.VIDEO.getType())) {
            name = "\u89c6\u9891\u7d20\u6750";
            isWeixin = isWeixin && MaterialFileLimit.WEIXIN_VIDEO.checkFormat(file.getFileFormat()) && MaterialFileLimit.WEIXIN_VIDEO.checkSize(file.getFileSize()) && MaterialFileLimit.WEIXIN_VIDEO.checkDuration(file.getDuration());
            isOfficialAccount = isOfficialAccount && MaterialFileLimit.OFFICAL_ACCOUNT_VIDEO.checkFormat(file.getFileFormat()) && MaterialFileLimit.OFFICAL_ACCOUNT_VIDEO.checkSize(file.getFileSize()) && MaterialFileLimit.OFFICAL_ACCOUNT_VIDEO.checkDuration(file.getDuration());
            isWechatMoments = isWechatMoments && MaterialFileLimit.WECHAT_MOMENTS_VIDEO.checkFormat(file.getFileFormat()) && MaterialFileLimit.WECHAT_MOMENTS_VIDEO.checkSize(file.getFileSize()) && MaterialFileLimit.WECHAT_MOMENTS_VIDEO.checkDuration(file.getDuration());
        } else if (materialType.equals(MaterialType.FILE.getType())) {
            name = "\u6587\u4ef6\u7d20\u6750";
            isWeixin = isWeixin && MaterialFileLimit.WEIXIN_FILE.checkFormat(file.getFileFormat()) && MaterialFileLimit.WEIXIN_FILE.checkSize(file.getFileSize());
            isOfficialAccount = false;
            isWechatMoments = false;
        }
        if (!(isWeixin || isOfficialAccount || isWechatMoments)) {
            if (materialType.equals(MaterialType.VOICE.getType())) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, INVALID_VOICE_MATERIAL);
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5" + name + "\u5728\u5fae\u4fe1\u3001\u516c\u4f17\u53f7\u548c\u670b\u53cb\u5708\u5747\u65e0\u6cd5\u4f7f\u7528");
        }
        return PlatformType.getPlateform(isWeixin, isOfficialAccount, isWechatMoments);
    }
}

