/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.material.service.impl;

import cn.kinyun.scrm.weixin.enums.MaterialType;
import cn.kinyun.scrm.weixin.enums.PlateformType;
import cn.kinyun.scrm.weixin.material.dto.req.MaterialCommonDtoReq;
import cn.kinyun.scrm.weixin.material.dto.resp.NormalMaterialListResp;
import cn.kinyun.scrm.weixin.material.dto.resp.SimpleMaterialRespDto;
import cn.kinyun.scrm.weixin.material.service.CommonMaterialService;
import cn.kinyun.scrm.weixin.material.service.OfficalMaterialSyncService;
import cn.kinyun.scrm.weixin.message.dto.MsgData;
import cn.kinyun.scrm.weixin.sdk.enums.WxMediaType;
import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.MD5Utils;
import com.kuaike.common.utils.lang.BeanUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMaterial;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMaterialNews;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMaterialMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMaterialNewsMapper;
import com.kuaike.scrm.dal.official.material.dto.MaterialQueryParam;
import com.kuaike.scrm.dal.official.material.dto.MaterialResultDto;
import com.kuaike.scrm.dal.official.material.dto.OfficialNewsDto;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterial;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterialFile;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterialRecycle;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialFileMapper;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialGroupMapper;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialMapper;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialRecycleMapper;
import com.kuaike.scrm.dal.permission.mapper.UserRoleMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CommonMaterialServiceImpl
implements CommonMaterialService {
    private static final Logger log = LoggerFactory.getLogger(CommonMaterialServiceImpl.class);
    private static final String TITLE_SPLIT = ";";
    @Resource
    private OfficialMaterialMapper materialMapper;
    @Resource
    private OfficialMaterialRecycleMapper materialRecycleMapper;
    @Autowired
    private OfficalMaterialSyncService officalMaterialSyncService;
    @Resource
    private OfficialAccountMaterialNewsMapper officialAccountMaterialNewsMapper;
    @Resource
    private OfficialAccountMaterialMapper officialAccountMaterialMapper;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Resource
    private OfficialMaterialGroupMapper materialGroupMapper;
    @Resource
    private OfficialMaterialFileMapper materialFileMapper;
    @Autowired
    private NodeService nodeService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void moveGroup(List<Long> ids, Long nodeId, Long groupId) {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty!");
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Set roleNodeIds = this.userRoleMapper.queryManageNodeIds(currentUser.getBizId(), currentUser.getCurRole().getRoleId(), currentUser.getId());
        ArrayList nodeIds = Lists.newArrayList((Iterable)this.nodeService.getPosterityIds((Collection)roleNodeIds, currentUser.getBizId()));
        List materialsList = this.materialMapper.queryListByIds(ids);
        for (OfficialMaterial m : materialsList) {
            if (nodeIds.contains(m.getNodeId())) continue;
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ca1\u6709\u8be5\u7d20\u6750\u6240\u5c5e\u7684\u673a\u6784\u64cd\u4f5c\u6743\u9650");
        }
        this.materialMapper.moveGroup(ids, nodeId, groupId, currentUser.getId());
    }

    @Override
    public Map<String, OfficialMaterialFile> getMaterialFileInfo(Set<String> urls) {
        if (CollectionUtils.isEmpty(urls)) {
            return Maps.newHashMap();
        }
        Map<String, String> url2Md5Map = urls.stream().collect(Collectors.toMap(a -> a, a -> MD5Utils.MD5Encode8((String)a)));
        List md5List = urls.stream().map(a -> MD5Utils.MD5Encode8((String)a)).collect(Collectors.toList());
        List list = this.materialFileMapper.getListByUrlMd5(md5List);
        Map<String, OfficialMaterialFile> md52MaterialFile = list.stream().collect(Collectors.toMap(a -> a.getUrlMd5(), a -> a));
        HashMap result = Maps.newHashMap();
        for (String url : url2Md5Map.keySet()) {
            String md5 = url2Md5Map.get(url);
            OfficialMaterialFile file = md52MaterialFile.get(md5);
            result.put(url, file);
        }
        return result;
    }

    @Override
    public List<SimpleMaterialRespDto> getMaterialSimpleList(Set<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        ArrayList<Long> materialIds = new ArrayList<Long>(ids);
        List materialList = this.materialMapper.queryListByIds(materialIds);
        materialList.addAll(this.materialRecycleMapper.queryListByIds(materialIds).stream().map(a -> a.toMaterial()).collect(Collectors.toList()));
        return BeanUtil.convertToList((Collection)materialList, SimpleMaterialRespDto.class, (String[])new String[0]);
    }

    @Override
    public OfficialMaterial getMaterial(Long materialId) {
        Preconditions.checkArgument((materialId != null ? 1 : 0) != 0, (Object)"material is null!");
        OfficialMaterial material = this.materialMapper.selectById(materialId);
        if (material != null) {
            return material;
        }
        OfficialMaterialRecycle recycle = (OfficialMaterialRecycle)this.materialRecycleMapper.selectByPrimaryKey((Object)materialId);
        if (recycle != null) {
            return recycle.toMaterial();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MsgData convertMaterialMsg(Long materialId, String appId) {
        log.info("convert material to msgData with materialId={}", (Object)materialId);
        Preconditions.checkArgument((materialId != null ? 1 : 0) != 0, (Object)"materialId is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId is null!");
        OfficialMaterial material = this.getMaterial(materialId);
        return this.convertMaterialMsg(material, appId);
    }

    @Override
    public WxMsgType toWxMsgType(String materialType) {
        WxMsgType msgType = null;
        if (MaterialType.TEXT.getValue().equals(materialType)) {
            msgType = WxMsgType.Text;
        } else if (MaterialType.IMAGE.getValue().equals(materialType)) {
            msgType = WxMsgType.Image;
        } else if (MaterialType.VOICE.getValue().equals(materialType)) {
            msgType = WxMsgType.Voice;
        } else if (MaterialType.VIDEO.getValue().equals(materialType)) {
            msgType = WxMsgType.Video;
        } else if (MaterialType.NEWS.getValue().equals(materialType)) {
            msgType = WxMsgType.MpNews;
        }
        return msgType;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MsgData convertMaterialMsg(OfficialMaterial material, String appId) {
        if (material == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7d20\u6750\u4e0d\u5b58\u5728");
        }
        if ((material.getPlatformType() & PlateformType.OFFICAL_ACCOUNT.getType()) == 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8be5\u7d20\u6750\u4e0d\u9002\u7528\u4e8e\u516c\u4f17\u53f7");
        }
        if (material.getmType().equals(MaterialType.TEXT.getValue())) {
            return this.buildTextMsgData(material);
        }
        if (material.getmType().equals(MaterialType.IMAGE.getValue())) {
            return this.officalMaterialSyncService.syncImageMaterial(material, appId);
        }
        if (material.getmType().equals(MaterialType.VOICE.getValue())) {
            return this.officalMaterialSyncService.syncVoiceMaterial(material, appId);
        }
        if (material.getmType().equals(MaterialType.VIDEO.getValue())) {
            return this.officalMaterialSyncService.syncVideoMaterial(material, appId);
        }
        if (material.getmType().equals(MaterialType.NEWS.getValue())) {
            return this.officalMaterialSyncService.syncNewsMaterial(this.getNewsDetail(material), material, appId);
        }
        return null;
    }

    private List<OfficialMaterial> getNewsDetail(OfficialMaterial newsM) {
        return this.materialMapper.getNewsDetail(newsM.getId());
    }

    private MsgData buildTextMsgData(OfficialMaterial material) {
        MsgData msgData = new MsgData();
        msgData.setTitle(material.getTitle());
        msgData.setContent(material.getContent());
        msgData.setMediaType(material.getmType());
        return msgData;
    }

    @Override
    public List<NormalMaterialListResp> getByIds(List<Long> materialIds) {
        if (CollectionUtils.isEmpty(materialIds)) {
            return Lists.newArrayList();
        }
        List materialList = this.materialMapper.queryListByIds(materialIds);
        materialList.addAll(this.materialRecycleMapper.queryListByIds(materialIds).stream().map(a -> a.toMaterial()).collect(Collectors.toList()));
        ArrayList result = Lists.newArrayList();
        for (OfficialMaterial m : materialList) {
            NormalMaterialListResp resp = new NormalMaterialListResp();
            resp.setId(m.getId());
            if (m.getmType().equals(WxMediaType.News.getValue())) {
                resp.setTitles(m.getTitle().split(TITLE_SPLIT));
                resp.setUrls(m.getUrl().split(TITLE_SPLIT));
            } else {
                resp.setTitle(m.getTitle());
                resp.setUrl(m.getUrl());
            }
            resp.setMaterialType(m.getmType());
            resp.setContent(m.getContent());
            result.add(resp);
        }
        return result;
    }

    @Override
    public List<MaterialResultDto> getByMediaIds(Set<String> mediaIds) {
        List newsMaterialList;
        log.info("getByMediaIds with mediaIds={}", mediaIds);
        if (CollectionUtils.isEmpty(mediaIds)) {
            return Lists.newArrayList();
        }
        List materialResultList = this.materialMapper.queryByMediaIds(mediaIds);
        List materialRecyList = this.materialRecycleMapper.queryByMediaIds(mediaIds);
        if (CollectionUtils.isNotEmpty((Collection)materialRecyList)) {
            materialResultList.addAll(materialRecyList);
        }
        if (CollectionUtils.isNotEmpty(newsMaterialList = materialResultList.stream().filter(a -> MaterialType.NEWS.getValue().equalsIgnoreCase(a.getmType())).collect(Collectors.toList()))) {
            List subNewsList = this.materialMapper.queryNewsByMediaIds(mediaIds);
            subNewsList.addAll(this.materialRecycleMapper.queryNewsByMediaIds(mediaIds));
            if (CollectionUtils.isNotEmpty((Collection)subNewsList)) {
                Map subNewsMap = subNewsList.stream().collect(Collectors.groupingBy(a -> a.getPid(), Collectors.toList()));
                materialResultList.forEach(a -> {
                    List list = (List)subNewsMap.get(a.getId());
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        list = list.stream().sorted().collect(Collectors.toList());
                        a.setSubNews(list);
                    }
                });
            }
        }
        return materialResultList;
    }

    @Override
    public MaterialResultDto getByMediaId(String mediaId) {
        log.info("getByMediaId with mediaId={}", (Object)mediaId);
        if (StringUtils.isEmpty((CharSequence)mediaId)) {
            return null;
        }
        List<MaterialResultDto> materialResultList = this.getByMediaIds(Sets.newHashSet((Object[])new String[]{mediaId}));
        if (CollectionUtils.isNotEmpty(materialResultList)) {
            return materialResultList.get(0);
        }
        return null;
    }

    @Override
    public List<MaterialResultDto> queryList(MaterialCommonDtoReq params) {
        List newsMaterialList;
        log.info("query materials with params = {}", (Object)params);
        if (CollectionUtils.isEmpty(params.getIds()) && StringUtils.isBlank((CharSequence)params.getQuery())) {
            return Collections.emptyList();
        }
        List materialResultList = this.materialMapper.queryList(MaterialQueryParam.builder().ids(params.getIds()).query(params.getQuery()).build());
        List materialRecyList = this.materialRecycleMapper.queryList(MaterialQueryParam.builder().ids(params.getIds()).query(params.getQuery()).build());
        if (CollectionUtils.isNotEmpty((Collection)materialRecyList)) {
            materialResultList.addAll(materialRecyList);
        }
        if (CollectionUtils.isNotEmpty(newsMaterialList = materialResultList.stream().filter(a -> MaterialType.NEWS.getValue().equalsIgnoreCase(a.getmType())).collect(Collectors.toList()))) {
            List rootNews = newsMaterialList.stream().filter(a -> a.getPid() <= 0L).collect(Collectors.toList());
            List leafNews = newsMaterialList.stream().filter(a -> a.getPid() > 0L).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(leafNews)) {
                Set parantNewsIds = leafNews.stream().map(OfficialMaterial::getPid).collect(Collectors.toSet());
                List parentNews = this.materialMapper.queryList(MaterialQueryParam.builder().ids(parantNewsIds).build());
                rootNews.addAll(parentNews);
            }
            List rootNewsIds = rootNews.stream().map(OfficialMaterial::getId).collect(Collectors.toList());
            List subNewsList = this.materialMapper.queryNewsByIds(rootNewsIds);
            subNewsList.addAll(this.materialRecycleMapper.queryNewsByIds(rootNewsIds));
            if (CollectionUtils.isNotEmpty((Collection)subNewsList)) {
                Map subNewsMap = subNewsList.stream().collect(Collectors.groupingBy(a -> a.getPid(), Collectors.toList()));
                materialResultList.forEach(a -> {
                    List list = (List)subNewsMap.get(a.getId());
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        list = list.stream().sorted().collect(Collectors.toList());
                        a.setSubNews(list);
                    }
                });
            }
        }
        return materialResultList;
    }

    @Override
    public Map<Long, MaterialResultDto> queryMaterialMap(Collection<Long> materialIds) {
        if (CollectionUtils.isEmpty(materialIds)) {
            return Collections.emptyMap();
        }
        HashSet ids = Sets.newHashSet(materialIds);
        List<MaterialResultDto> matList = this.queryList(MaterialCommonDtoReq.builder().ids(ids).build());
        if (CollectionUtils.isEmpty(matList)) {
            return Collections.emptyMap();
        }
        return matList.stream().collect(Collectors.toMap(OfficialMaterial::getId, Function.identity()));
    }

    @Override
    public OfficialNewsDto getChildNewsDetail(Long mId, String appId) {
        log.info("query child news with materialId={} appId={}", (Object)mId, (Object)appId);
        Preconditions.checkArgument((mId != null ? 1 : 0) != 0, (Object)"mId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId}), (Object)"appId is blank");
        OfficialMaterial material = this.materialMapper.selectById(mId);
        if (material == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7d20\u6750\u4e0d\u5b58\u5728");
        }
        if (!material.getmType().equalsIgnoreCase(MaterialType.NEWS.getValue())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7d20\u6750\u7c7b\u578b\u4e0d\u4e3a\u56fe\u6587");
        }
        if (material.getPid() == 0L) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7d20\u6750\u4e0d\u4e3a\u5b50\u56fe\u6587");
        }
        Long pid = material.getPid();
        OfficialAccountMaterialNews materialNews = this.officialAccountMaterialNewsMapper.queryUrlByMidAndNum(pid, material.getNum(), appId);
        if (materialNews == null) {
            this.convertMaterialMsg(pid, appId);
            materialNews = this.officialAccountMaterialNewsMapper.queryUrlByMidAndNum(pid, material.getNum(), appId);
        } else {
            OfficialAccountMaterial officialAccountMaterial = (OfficialAccountMaterial)this.officialAccountMaterialMapper.selectByPrimaryKey((Object)materialNews.getOfficialAccountMaterialId());
            if (officialAccountMaterial == null || !officialAccountMaterial.getUpdateTime().after(material.getUpdateTime())) {
                this.convertMaterialMsg(pid, appId);
                materialNews = this.officialAccountMaterialNewsMapper.queryUrlByMidAndNum(pid, material.getNum(), appId);
            }
        }
        if (materialNews == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u516c\u4f17\u53f7\u56fe\u6587\u7d20\u6750\u4fe1\u606f\u5f02\u5e38");
        }
        return OfficialNewsDto.of((Long)materialNews.getId(), (String)materialNews.getUrl());
    }
}

