/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.material.enums;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public enum MaterialFileLimit {
    OFFICAL_ACCOUNT_IMAGE("png,jpg,jpeg,gif", 2048, -1),
    OFFICAL_ACCOUNT_VOICE("mp3,wma,wav,amr", 2048, 60),
    OFFICAL_ACCOUNT_VIDEO("mp4", 10240, -1),
    OFFICAL_ACCOUNT_THUMB("jpg,jpeg", 2048, -1),
    OFFICAL_ACCOUNT_NEWS("jpg,jpeg,png", 2048, -1),
    WEIXIN_IMAGE("png,jpg,jpeg,gif", 10240, -1),
    WEIXIN_VOICE("amr", 10240, 60),
    WEIXIN_VIDEO("mp4", 51200, -1),
    WEIXIN_FILE("ppt,pptx,xls,xlsx,doc,docx,pdf,zip,rar,7z,mp3,wma,wav", 0x3200000, -1),
    WECHAT_MOMENTS_IMAGE("png,jpg,jpeg,gif", 10240, -1),
    WECHAT_MOMENTS_VIDEO("mp4", 7680, 15);

    private static Set<String> formatSet;
    private int size;
    private long duration;
    private String format;
    private Set<String> formats;

    public static boolean contains(String format) {
        String lowerFormat = StringUtils.lowerCase((String)format);
        return formatSet.contains(lowerFormat);
    }

    private MaterialFileLimit(String format, int size) {
        this(format, size, -1);
    }

    private MaterialFileLimit(String format, int size, int duration) {
        String[] array;
        this.format = format;
        this.size = size;
        this.duration = duration;
        this.formats = Sets.newHashSet();
        for (String it : array = format.split(",")) {
            this.formats.add(it);
        }
    }

    public String getFormat() {
        return this.format;
    }

    public int getSize() {
        return this.size;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean checkFormat(String format) {
        if (StringUtils.isNotBlank((CharSequence)format)) {
            String lowerFormat = StringUtils.lowerCase((String)format);
            return this.formats.contains(lowerFormat);
        }
        return false;
    }

    public boolean checkSize(int size) {
        return size <= this.size;
    }

    public boolean checkDuration(long duration) {
        if (this.duration <= 0L) {
            return true;
        }
        return duration <= this.duration;
    }

    static {
        formatSet = Sets.newHashSet();
        for (MaterialFileLimit it : MaterialFileLimit.values()) {
            formatSet.addAll(it.formats);
        }
    }
}

