/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.material.dto.req;

import cn.kinyun.scrm.weixin.material.dto.NewsMaterialDto;
import cn.kinyun.scrm.weixin.utils.NewMaterialUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.utils.MD5Utils;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ModNewsMaterialReq
implements Serializable {
    private static final long serialVersionUID = -6115967635594275189L;
    private Long id;
    private List<NewsMaterialDto> news;
    private List<String> titles;
    private List<String> covers;
    private Map<String, String> coverMap;
    private Map<String, String> imageMap;

    public void validate() {
        Preconditions.checkArgument((this.id != null ? 1 : 0) != 0, (Object)"id is null!");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.news), (Object)"news is empty!");
        Preconditions.checkArgument((this.news.size() <= 8 ? 1 : 0) != 0, (Object)"\u4e0d\u80fd\u8d85\u8fc78\u4e2a\u56fe\u6587");
        this.coverMap = Maps.newHashMap();
        this.imageMap = Maps.newHashMap();
        this.titles = Lists.newArrayList();
        this.covers = Lists.newArrayList();
        boolean i = false;
        for (NewsMaterialDto material : this.news) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)material.getTitle()), (Object)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((material.getTitle().length() <= 64 ? 1 : 0) != 0, (Object)"\u6807\u9898\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc764\u4e2a\u5b57\u7b26");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)material.getContent()), (Object)"\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((material.getContent().length() < 19000 ? 1 : 0) != 0, (Object)"\u5185\u5bb9\u4e0d\u80fd\u8d85\u8fc72\u4e07\u5b57\u7b26");
            material.setImages(NewMaterialUtils.getImgs(material.getContent()));
            this.coverMap.put(material.getCover(), MD5Utils.MD5Encode8((String)material.getCover()));
            if (material.getImages() != null && material.getImages().length > 0) {
                for (String img : material.getImages()) {
                    this.imageMap.put(img, MD5Utils.MD5Encode8((String)img));
                }
            }
            this.titles.add(material.getTitle());
            this.covers.add(StringUtils.isNotBlank((CharSequence)material.getCover()) ? material.getCover() : "");
        }
    }

    public Long getId() {
        return this.id;
    }

    public List<NewsMaterialDto> getNews() {
        return this.news;
    }

    public List<String> getTitles() {
        return this.titles;
    }

    public List<String> getCovers() {
        return this.covers;
    }

    public Map<String, String> getCoverMap() {
        return this.coverMap;
    }

    public Map<String, String> getImageMap() {
        return this.imageMap;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setNews(List<NewsMaterialDto> news) {
        this.news = news;
    }

    public void setTitles(List<String> titles) {
        this.titles = titles;
    }

    public void setCovers(List<String> covers) {
        this.covers = covers;
    }

    public void setCoverMap(Map<String, String> coverMap) {
        this.coverMap = coverMap;
    }

    public void setImageMap(Map<String, String> imageMap) {
        this.imageMap = imageMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModNewsMaterialReq)) {
            return false;
        }
        ModNewsMaterialReq other = (ModNewsMaterialReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        List<NewsMaterialDto> this$news = this.getNews();
        List<NewsMaterialDto> other$news = other.getNews();
        if (this$news == null ? other$news != null : !((Object)this$news).equals(other$news)) {
            return false;
        }
        List<String> this$titles = this.getTitles();
        List<String> other$titles = other.getTitles();
        if (this$titles == null ? other$titles != null : !((Object)this$titles).equals(other$titles)) {
            return false;
        }
        List<String> this$covers = this.getCovers();
        List<String> other$covers = other.getCovers();
        if (this$covers == null ? other$covers != null : !((Object)this$covers).equals(other$covers)) {
            return false;
        }
        Map<String, String> this$coverMap = this.getCoverMap();
        Map<String, String> other$coverMap = other.getCoverMap();
        if (this$coverMap == null ? other$coverMap != null : !((Object)this$coverMap).equals(other$coverMap)) {
            return false;
        }
        Map<String, String> this$imageMap = this.getImageMap();
        Map<String, String> other$imageMap = other.getImageMap();
        return !(this$imageMap == null ? other$imageMap != null : !((Object)this$imageMap).equals(other$imageMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModNewsMaterialReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        List<NewsMaterialDto> $news = this.getNews();
        result = result * 59 + ($news == null ? 43 : ((Object)$news).hashCode());
        List<String> $titles = this.getTitles();
        result = result * 59 + ($titles == null ? 43 : ((Object)$titles).hashCode());
        List<String> $covers = this.getCovers();
        result = result * 59 + ($covers == null ? 43 : ((Object)$covers).hashCode());
        Map<String, String> $coverMap = this.getCoverMap();
        result = result * 59 + ($coverMap == null ? 43 : ((Object)$coverMap).hashCode());
        Map<String, String> $imageMap = this.getImageMap();
        result = result * 59 + ($imageMap == null ? 43 : ((Object)$imageMap).hashCode());
        return result;
    }

    public String toString() {
        return "ModNewsMaterialReq(id=" + this.getId() + ", news=" + this.getNews() + ", titles=" + this.getTitles() + ", covers=" + this.getCovers() + ", coverMap=" + this.getCoverMap() + ", imageMap=" + this.getImageMap() + ")";
    }
}

