/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.enums.autoreply;

import com.google.common.collect.ImmutableMap;
import com.kuaike.common.enums.EnumService;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum AutoReplyType implements EnumService
{
    KEY_WORD_REPLY(1, "\u5173\u952e\u8bcd\u5339\u914d\u56de\u590d"),
    DEFAULT_REPLY(2, "\u6536\u5230\u6d88\u606f\u81ea\u52a8\u56de\u590d"),
    JOIN_GROUP_REPLY(3, "\u5165\u7fa4\u56de\u590d"),
    SUBSCRIBED_REPLY(4, "\u88ab\u5173\u6ce8\u56de\u590d"),
    FISSION_RECEIVED_TASK_REPLY(5, "\u6536\u5230\u4efb\u52a1\u81ea\u52a8\u56de\u590d"),
    FISSION_REWARD_REPLY(6, "\u5956\u52b1\u81ea\u52a8\u56de\u590d");

    private static final Map<Integer, AutoReplyType> MAP;
    private final int value;
    private final String desc;

    private AutoReplyType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static AutoReplyType getType(int value) {
        return MAP.get(value);
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static Integer getValueByDesc(String desc) {
        for (AutoReplyType type : MAP.values()) {
            if (!type.getDesc().equals(desc)) continue;
            return type.getValue();
        }
        return null;
    }

    public static String getDescByValue(Integer value) {
        AutoReplyType type = AutoReplyType.getType(value);
        if (type != null) {
            return type.getDesc();
        }
        return null;
    }

    static {
        MAP = ImmutableMap.copyOf(Arrays.stream(AutoReplyType.values()).collect(Collectors.toMap(AutoReplyType::getValue, Function.identity())));
    }
}

