/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.enums;

import com.google.common.collect.ImmutableMap;
import com.kuaike.common.enums.EnumService;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum UserSource implements EnumService
{
    SESSION(0, "\u4f1a\u8bdd"),
    FRIEND(1, "\u597d\u53cb"),
    FRIEND_CIRCLE(2, "\u670b\u53cb\u5708"),
    TENCENT_WEIBO(3, "\u817e\u8baf\u5fae\u535a"),
    HISTORY_MSG_PAGE(4, "\u5386\u53f2\u6d88\u606f\u9875"),
    OTHER(5, "\u5176\u4ed6"),
    HAVE_A_LOOK(6, "\u770b\u4e00\u770b"),
    HAVE_A_SEARCH(7, "\u641c\u4e00\u641c"),
    ALL(99999999, "\u5168\u90e8");

    private Integer value;
    private String desc;
    private static Map<Integer, UserSource> cache;

    private UserSource(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static UserSource getByValue(Integer value) {
        if (value == null) {
            return null;
        }
        return cache.get(value);
    }

    static {
        cache = ImmutableMap.copyOf(Arrays.stream(UserSource.values()).collect(Collectors.toMap(UserSource::getValue, Function.identity())));
    }
}

