/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.autoreply.service.impl;

import cn.kinyun.scrm.weixin.activity.service.ActivityHelper;
import cn.kinyun.scrm.weixin.autoreply.dto.AutoReplyMsgDto;
import cn.kinyun.scrm.weixin.autoreply.dto.AutoReplyMsgListDto;
import cn.kinyun.scrm.weixin.autoreply.dto.NewsLink;
import cn.kinyun.scrm.weixin.autoreply.dto.req.AutoReplyAddReq;
import cn.kinyun.scrm.weixin.autoreply.dto.req.AutoReplyDelReq;
import cn.kinyun.scrm.weixin.autoreply.dto.req.AutoReplyDto;
import cn.kinyun.scrm.weixin.autoreply.dto.req.AutoReplyListReq;
import cn.kinyun.scrm.weixin.autoreply.dto.req.AutoReplyModReq;
import cn.kinyun.scrm.weixin.autoreply.dto.req.KeywordAutoReplyListReq;
import cn.kinyun.scrm.weixin.autoreply.dto.resp.AutoReplyListResp;
import cn.kinyun.scrm.weixin.autoreply.dto.resp.KeywordAutoReplyListResp;
import cn.kinyun.scrm.weixin.autoreply.dto.resp.SimpleMaterialDto;
import cn.kinyun.scrm.weixin.autoreply.service.LogicAutoReplyService;
import cn.kinyun.scrm.weixin.common.dto.AppIdAndNameDto;
import cn.kinyun.scrm.weixin.common.dto.ModifierDto;
import cn.kinyun.scrm.weixin.common.dto.UserInfoRespDto;
import cn.kinyun.scrm.weixin.common.service.UserInfoService;
import cn.kinyun.scrm.weixin.enums.MaterialType;
import cn.kinyun.scrm.weixin.enums.MsgSendType;
import cn.kinyun.scrm.weixin.enums.MsgSyncStatus;
import cn.kinyun.scrm.weixin.enums.TriggerType;
import cn.kinyun.scrm.weixin.enums.autoreply.AutoReplyMessageType;
import cn.kinyun.scrm.weixin.enums.autoreply.AutoReplyRelationType;
import cn.kinyun.scrm.weixin.enums.autoreply.AutoReplyType;
import cn.kinyun.scrm.weixin.material.service.CommonMaterialService;
import cn.kinyun.scrm.weixin.message.dto.MsgData;
import cn.kinyun.scrm.weixin.message.dto.req.SendCustomMsgReqDto;
import cn.kinyun.scrm.weixin.message.service.MessageService;
import cn.kinyun.scrm.weixin.message.service.SendMessageService;
import cn.kinyun.scrm.weixin.officialAccount.service.OfficialAccountService;
import cn.kinyun.scrm.weixin.officialAccount.service.OperatorService;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.Article;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.BaseRespMsg;
import cn.kinyun.scrm.weixin.sdk.enums.WxMediaType;
import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import cn.kinyun.scrm.weixin.utils.DownloadUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMessage;
import com.kuaike.scrm.dal.official.material.dto.MaterialResultDto;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterial;
import com.kuaike.scrm.dal.official.reply.dto.AutoReplyQueryParam;
import com.kuaike.scrm.dal.official.reply.dto.CommonAutoReplyDto;
import com.kuaike.scrm.dal.official.reply.dto.KeywordAutoReplyDto;
import com.kuaike.scrm.dal.official.reply.dto.KeywordAutoReplyQueryParam;
import com.kuaike.scrm.dal.official.reply.entity.LogicAutoReply;
import com.kuaike.scrm.dal.official.reply.entity.LogicAutoReplyOfficialAccount;
import com.kuaike.scrm.dal.official.reply.mapper.LogicAutoReplyMapper;
import com.kuaike.scrm.dal.official.reply.mapper.LogicAutoReplyOfficialAccountMapper;
import com.kuaike.scrm.dal.official.reply.mapper.LogicAutoReplyWordMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import ws.schild.jave.FfmpegUtils;

@Service
public class LogicAutoReplyServiceImpl
implements LogicAutoReplyService {
    private static final Logger log = LoggerFactory.getLogger(LogicAutoReplyServiceImpl.class);
    private static final String NOT_VALID_AUTOREPLY = "\u8be5\u81ea\u52a8\u56de\u590d\u6d88\u606f\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u60a8\u65e0\u6743\u6267\u884c\u8be5\u64cd\u4f5c\u3002";
    private static final int RELATION_TYPE = AutoReplyRelationType.OFFICIAL_ACCOUNT.getValue();
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private OfficialAccountService officialAccountService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    protected CommonMaterialService commonMaterialService;
    @Resource
    protected LogicAutoReplyMapper logicAutoReplyMapper;
    @Resource
    protected LogicAutoReplyWordMapper logicAutoReplyWordMapper;
    @Resource
    protected LogicAutoReplyOfficialAccountMapper logicAutoReplyOfficialAccountMapper;
    @Autowired
    private MessageService messageService;
    @Autowired
    private SendMessageService sendMessageService;
    @Autowired
    private ActivityHelper activityHelper;

    @Override
    public OfficialAccountMessage record(SendCustomMsgReqDto msg) {
        OfficialAccountMessage message = new OfficialAccountMessage();
        message.setBizId(msg.getBizId());
        message.setCorpId(msg.getCorpId());
        message.setOpenId(msg.getOpenId());
        message.setAppId(msg.getAppId());
        message.setMsgId(Long.valueOf(-1L));
        message.setMsgType(msg.getMsgType());
        message.setContent(JacksonUtil.obj2Str((Object)msg.getMsgData()));
        message.setSendType(Integer.valueOf(MsgSendType.SYS_SEND_FANS.getValue()));
        message.setSyncStatus(Integer.valueOf(MsgSyncStatus.SUCCESS.getValue()));
        message.setUserId(Long.valueOf(-1L));
        message.setServantSessionId(Long.valueOf(-1L));
        message.setCreateTime(new Date());
        try {
            this.messageService.record(message);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u6d88\u606f\u5185\u5bb9\u5931\u8d25: ", (Throwable)e);
        }
        return message;
    }

    @Override
    @Transactional
    public Long add(AutoReplyAddReq params, AutoReplyType replyType) {
        List<CommonAutoReplyDto> exists;
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("addOrMod autoreply with params={}, user={}", (Object)params, (Object)currentUser);
        Preconditions.checkArgument((currentUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((currentUser.getId() != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()}), (Object)"\u672a\u8bbe\u7f6e\u516c\u4f17\u53f7");
        Preconditions.checkArgument((params.getType() != null ? 1 : 0) != 0, (Object)"\u672a\u8bbe\u7f6e\u81ea\u52a8\u56de\u590d\u7c7b\u578b");
        AutoReplyMessageType replyMsgType = AutoReplyMessageType.getType(params.getType());
        Preconditions.checkArgument((replyMsgType != null ? 1 : 0) != 0, (Object)"\u672a\u77e5\u7684\u81ea\u52a8\u56de\u590d\u7c7b\u578b");
        Long operatorId = currentUser.getId();
        String appId = params.getAppId();
        Preconditions.checkArgument((boolean)this.operatorService.isManager(operatorId, appId), (Object)"\u60a8\u4e0d\u662f\u516c\u4f17\u53f7\u7684\u8fd0\u8425\u8005\uff0c\u65e0\u6743\u6267\u884c\u6b64\u64cd\u4f5c\u3002");
        if (AutoReplyMessageType.MATERIAL.getValue() == params.getType().intValue()) {
            this.syncMaterial(params.getMaterialId(), params.getAppId());
        }
        if (CollectionUtils.isNotEmpty(exists = this.getByAppId(appId, replyType))) {
            exists.forEach(it -> {
                Long id = it.getId();
                this.logicAutoReplyMapper.logicDeleteById(id, operatorId);
                this.logicAutoReplyOfficialAccountMapper.logicDeleteByAutoReplyId(id, operatorId);
                this.logicAutoReplyWordMapper.logicDeleteByAutoReplyId(id, operatorId);
            });
        }
        LogicAutoReply autoReply = new LogicAutoReply();
        autoReply.setRelationType(Integer.valueOf(RELATION_TYPE));
        autoReply.setReplyType(Integer.valueOf(replyType.getValue()));
        autoReply.setBizId(currentUser.getBizId());
        autoReply.setCorpId(currentUser.getCorpId());
        autoReply.setNodeId(currentUser.getUserNodeId());
        autoReply.setCreateBy(operatorId);
        autoReply.setMessage(this.serialize(params));
        this.logicAutoReplyMapper.insertSelective((Object)autoReply);
        LogicAutoReplyOfficialAccount account = new LogicAutoReplyOfficialAccount();
        account.setAutoReplyId(autoReply.getId());
        account.setOfficialAccountId(appId);
        account.setCreateBy(operatorId);
        account.setBizId(currentUser.getBizId());
        account.setCorpId(currentUser.getCorpId());
        this.logicAutoReplyOfficialAccountMapper.insertSelective((Object)account);
        return autoReply.getId();
    }

    @Override
    @Transactional
    public boolean modify(AutoReplyModReq params, AutoReplyType replyType) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("modify recvmsg autoreply with params={}, user={}", (Object)params, (Object)currentUser);
        Preconditions.checkArgument((currentUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((currentUser.getId() != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"id\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getType() != null ? 1 : 0) != 0, (Object)"\u672a\u8bbe\u7f6e\u81ea\u52a8\u56de\u590d\u7c7b\u578b");
        Preconditions.checkArgument((AutoReplyMessageType.getType(params.getType()) != null ? 1 : 0) != 0, (Object)"\u672a\u77e5\u7684\u81ea\u52a8\u56de\u590d\u7c7b\u578b");
        CommonAutoReplyDto autoReplyDto = this.logicAutoReplyOfficialAccountMapper.getCommonAutoReplyById(params.getId());
        Preconditions.checkArgument((autoReplyDto != null ? 1 : 0) != 0, (Object)"\u8be5\u6d88\u606f\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        Preconditions.checkArgument((autoReplyDto.getRelationType() != null ? 1 : 0) != 0, (Object)NOT_VALID_AUTOREPLY);
        Preconditions.checkArgument((autoReplyDto.getReplyType() != null ? 1 : 0) != 0, (Object)NOT_VALID_AUTOREPLY);
        Preconditions.checkArgument((RELATION_TYPE == autoReplyDto.getRelationType() ? 1 : 0) != 0, (Object)NOT_VALID_AUTOREPLY);
        Preconditions.checkArgument((replyType.getValue() == autoReplyDto.getReplyType().intValue() ? 1 : 0) != 0, (Object)NOT_VALID_AUTOREPLY);
        Long operatorId = currentUser.getId();
        String appId = autoReplyDto.getAppId();
        Preconditions.checkArgument((boolean)this.operatorService.isManager(operatorId, appId), (Object)"\u60a8\u4e0d\u662f\u516c\u4f17\u53f7\u7684\u8fd0\u8425\u8005\uff0c\u65e0\u6743\u6267\u884c\u6b64\u64cd\u4f5c\u3002");
        if (AutoReplyMessageType.MATERIAL.getValue() == params.getType().intValue()) {
            this.syncMaterial(params.getMaterialId(), appId);
        }
        LogicAutoReply reply = new LogicAutoReply();
        reply.setId(autoReplyDto.getId());
        reply.setUpdateBy(operatorId);
        reply.setUpdateTime(new Date());
        reply.setMessage(this.serialize(params));
        this.logicAutoReplyMapper.updateByPrimaryKeySelective((Object)reply);
        return true;
    }

    @Override
    @Transactional
    public boolean delete(AutoReplyDelReq params, AutoReplyType replyType) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("delete autoreply with params={}, replyType={}, user={}", new Object[]{params, replyType, currentUser});
        Preconditions.checkArgument((currentUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((currentUser.getId() != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"id\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"id\u4e3a\u7a7a");
        Preconditions.checkArgument((replyType != null ? 1 : 0) != 0, (Object)"replyType\u4e3a\u7a7a");
        Long id = params.getId();
        CommonAutoReplyDto autoReplyDto = this.logicAutoReplyOfficialAccountMapper.getCommonAutoReplyById(id);
        if (autoReplyDto == null) {
            return false;
        }
        Preconditions.checkArgument((autoReplyDto.getRelationType() != null ? 1 : 0) != 0, (Object)NOT_VALID_AUTOREPLY);
        Preconditions.checkArgument((autoReplyDto.getReplyType() != null ? 1 : 0) != 0, (Object)NOT_VALID_AUTOREPLY);
        Preconditions.checkArgument((RELATION_TYPE == autoReplyDto.getRelationType() ? 1 : 0) != 0, (Object)NOT_VALID_AUTOREPLY);
        Preconditions.checkArgument((replyType.getValue() == autoReplyDto.getReplyType().intValue() ? 1 : 0) != 0, (Object)NOT_VALID_AUTOREPLY);
        Long operatorId = currentUser.getId();
        String appId = autoReplyDto.getAppId();
        Preconditions.checkArgument((boolean)this.operatorService.isManager(operatorId, appId), (Object)"\u60a8\u4e0d\u662f\u516c\u4f17\u53f7\u7684\u8fd0\u8425\u8005\uff0c\u65e0\u6743\u6267\u884c\u6b64\u64cd\u4f5c\u3002");
        this.logicAutoReplyMapper.logicDeleteById(id, operatorId);
        this.logicAutoReplyOfficialAccountMapper.logicDeleteByAutoReplyId(id, operatorId);
        this.logicAutoReplyWordMapper.logicDeleteByAutoReplyId(id, operatorId);
        return true;
    }

    @Override
    public List<CommonAutoReplyDto> getByAppId(String appId, AutoReplyType replyType) {
        AutoReplyQueryParam query = new AutoReplyQueryParam();
        query.setAppId(appId);
        query.setRelationType(Integer.valueOf(RELATION_TYPE));
        query.setReplyType(Integer.valueOf(replyType.getValue()));
        List list = this.logicAutoReplyOfficialAccountMapper.queryCommonList(query);
        return list;
    }

    @Override
    public MsgData syncMaterial(Long matId, String appId) {
        Preconditions.checkArgument((matId != null && matId > 0L ? 1 : 0) != 0, (Object)"\u7d20\u6750id\u4e3a\u7a7a");
        OfficialMaterial mat = this.commonMaterialService.getMaterial(matId);
        Preconditions.checkArgument((mat != null ? 1 : 0) != 0, (String)"\u7d20\u6750\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664, id=%d", (Object)matId);
        MsgData msgData = this.commonMaterialService.convertMaterialMsg(mat, appId);
        if ("news".equals(mat.getmType()) && msgData.getArticles() != null) {
            Preconditions.checkArgument((msgData.getArticles().size() == 1 ? 1 : 0) != 0, (Object)"\u81ea\u52a8\u56de\u590d\u53ea\u80fd\u53d1\u9001\u5355\u56fe\u6587\uff0c\u4e0d\u652f\u6301\u591a\u56fe\u6587\u3002");
        }
        return msgData;
    }

    @Override
    public void syncMaterial(Long matId, Collection<String> appIds) {
        Preconditions.checkArgument((matId != null && matId > 0L ? 1 : 0) != 0, (Object)"\u7d20\u6750id\u4e3a\u7a7a");
        OfficialMaterial mat = this.commonMaterialService.getMaterial(matId);
        Preconditions.checkArgument((mat != null ? 1 : 0) != 0, (String)"\u7d20\u6750\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664, id=%d", (Object)matId);
        for (String appId : appIds) {
            MsgData msgData = this.commonMaterialService.convertMaterialMsg(mat, appId);
            if (!"news".equals(mat.getmType()) || msgData.getArticles() == null) continue;
            Preconditions.checkArgument((msgData.getArticles().size() == 1 ? 1 : 0) != 0, (Object)"\u81ea\u52a8\u56de\u590d\u53ea\u80fd\u53d1\u9001\u5355\u56fe\u6587\uff0c\u4e0d\u652f\u6301\u591a\u56fe\u6587\u3002");
        }
    }

    @Override
    public boolean send(SendCustomMsgReqDto customMsg) {
        if (customMsg == null) {
            return false;
        }
        BaseRespMsg msg = customMsg.toBaseRespMsg();
        if (msg == null) {
            log.warn("\u4e0d\u652f\u6301\u7684\u5ba2\u670d\u6d88\u606f\u7c7b\u578b, customMsg={}", (Object)customMsg);
            return false;
        }
        try {
            this.sendMessageService.send(msg);
            this.record(customMsg);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u81ea\u52a8\u56de\u590d\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean send(AutoReplyMsgDto dto, String appId, String openId, Long bizId, String corpId) {
        SendCustomMsgReqDto customMsg = this.buildReplyMsg(dto, appId, openId);
        if (customMsg == null) {
            return false;
        }
        customMsg.setBizId(bizId);
        customMsg.setCorpId(corpId);
        if (customMsg.isCancelSend()) {
            return true;
        }
        return this.send(customMsg);
    }

    @Override
    public SendCustomMsgReqDto buildReplyMsg(AutoReplyMsgDto dto, String appId, String openId) {
        MsgData msgData;
        if (StringUtils.isBlank((CharSequence)appId) || dto == null) {
            return null;
        }
        if (AutoReplyMessageType.getType(dto.getType()) == null) {
            log.warn("\u672a\u77e5\u7684\u56de\u590d\u6d88\u606f\u7c7b\u578b, appId={}, params={}", (Object)appId, (Object)dto);
            return null;
        }
        if (StringUtils.isBlank((CharSequence)dto.getContent())) {
            log.warn("\u56de\u590d\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a, appId={}, params={}", (Object)appId, (Object)dto);
            return null;
        }
        SendCustomMsgReqDto customMsg = null;
        int type = dto.getType();
        if (AutoReplyMessageType.TEXT.getValue() == type) {
            customMsg = new SendCustomMsgReqDto();
            customMsg.setMsgType(WxMsgType.Text.getValue());
            customMsg.setMsgData(MsgData.builder().content(dto.getContent()).build());
        }
        if (AutoReplyMessageType.MATERIAL.getValue() == type) {
            Long materialId = null;
            try {
                materialId = Long.parseLong(dto.getContent());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                log.error("\u56de\u590d\u6d88\u606f\u7684\u7d20\u6750ID\u4e3a\u7a7a, appId={}, params={}", (Object)appId, (Object)dto);
                return null;
            }
            String msgType = null;
            msgData = null;
            customMsg = new SendCustomMsgReqDto();
            try {
                WxMsgType wxMsgType;
                OfficialMaterial mat = this.commonMaterialService.getMaterial(materialId);
                if (mat == null) {
                    log.warn("\u7d20\u6750\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664, material.id={}", (Object)materialId);
                    return null;
                }
                customMsg.setBizId(mat.getBizId());
                customMsg.setCorpId(mat.getCorpId());
                msgData = this.commonMaterialService.convertMaterialMsg(mat, appId);
                if (mat.getmType().equals(MaterialType.VOICE.getValue())) {
                    File file = DownloadUtils.loadFile(mat.getUrl(), null);
                    String transcodeUrl = mat.getTranscodeUrl();
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{transcodeUrl})) {
                        msgData.setMediaUrl(transcodeUrl);
                        String format = FfmpegUtils.getSuffix(transcodeUrl);
                        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{format})) {
                            msgData.setFormat(format);
                        }
                        msgData.setDuration(FfmpegUtils.getDuration(file));
                    } else {
                        this.messageService.setVoiceTranscodeInfo(appId, file, msgData);
                    }
                }
                if ((wxMsgType = this.commonMaterialService.toWxMsgType(mat.getmType())) == null) {
                    log.warn("\u7d20\u6750\u7c7b\u578b\u4e0d\u9002\u7528\u4e8e\u516c\u4f17\u53f7, material(id={}, mType={})", (Object)mat.getId(), (Object)mat.getmType());
                    return null;
                }
                msgType = wxMsgType.getValue();
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("\u83b7\u53d6\u516c\u4f17\u53f7\u7d20\u6750\u5931\u8d25", (Throwable)e);
                return null;
            }
            customMsg.setMsgType(msgType);
            customMsg.setMsgData(msgData);
        }
        if (AutoReplyMessageType.OFFICIAL_FISSION.getValue() == type) {
            Long actiId = null;
            try {
                actiId = Long.parseLong(dto.getContent());
            }
            catch (NumberFormatException e) {
                log.error("\u56de\u590d\u6d88\u606f\u7684\u516c\u4f17\u53f7\u88c2\u53d8ID\u4e3a\u7a7a, appId={}, params={}", (Object)appId, (Object)dto);
                return null;
            }
            this.activityHelper.receiveTask(actiId, appId, openId, TriggerType.OTHER.getValue());
            customMsg = new SendCustomMsgReqDto();
            customMsg.setCancelSend(true);
        }
        if (AutoReplyMessageType.NEWS.getValue() == type) {
            NewsLink newsLink;
            try {
                newsLink = (NewsLink)JacksonUtil.str2Obj((String)dto.getContent(), NewsLink.class);
            }
            catch (Exception e) {
                log.error("\u56fe\u6587\u94fe\u63a5\u53cd\u5e8f\u5217\u5316\u5931\u8d25, appId={}, params={}", (Object)appId, (Object)dto);
                return null;
            }
            Article article = new Article(newsLink.getTitle(), newsLink.getMessage(), newsLink.getIconUrl(), newsLink.getLinkUrl());
            customMsg = new SendCustomMsgReqDto();
            customMsg.setMsgType(WxMsgType.News.getValue());
            msgData = new MsgData();
            msgData.setArticles(Lists.newArrayList((Object[])new Article[]{article}));
            customMsg.setMsgData(msgData);
        }
        if (customMsg != null) {
            customMsg.setAppId(appId);
            customMsg.setOpenId(openId);
        }
        return customMsg;
    }

    @Override
    public List<KeywordAutoReplyListResp> queryKeywordList(KeywordAutoReplyListReq params) {
        log.info("query keyword autoreply list with params={}", (Object)params);
        List<String> appIds = this.operatorService.getCurrentManagerAppIds();
        if (CollectionUtils.isEmpty(appIds)) {
            return Collections.emptyList();
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()}) && !appIds.contains(params.getAppId())) {
            return Collections.emptyList();
        }
        KeywordAutoReplyQueryParam query = new KeywordAutoReplyQueryParam();
        query.setBizId(LoginUtils.getCurrentUserBizId());
        query.setPageDto(params.getPageDto());
        query.setRelationType(Integer.valueOf(RELATION_TYPE));
        query.setReplyType(Integer.valueOf(AutoReplyType.KEY_WORD_REPLY.getValue()));
        query.setSort(params.getSort());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getKeyword()})) {
            query.setKeyword(params.getKeyword());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()})) {
            query.setAppId(params.getAppId());
        } else {
            query.setAppIds(appIds);
        }
        int count = this.logicAutoReplyWordMapper.countKeywordList(query);
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(count));
        }
        if (count <= 0) {
            return Collections.emptyList();
        }
        List list = this.logicAutoReplyWordMapper.queryKeywordList(query);
        if (params.getPageDto() != null) {
            params.getPageDto().setCurPageCount(Integer.valueOf(list.size()));
        }
        List<KeywordAutoReplyListResp> result = this.toKeywordAutoReplyRespList(list);
        return result;
    }

    @Override
    public List<KeywordAutoReplyListResp> toKeywordAutoReplyRespList(List<KeywordAutoReplyDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (KeywordAutoReplyDto dto : list) {
            KeywordAutoReplyListResp resp = new KeywordAutoReplyListResp();
            resp.setKeyword(dto.getKeyword());
            resp.setQuestion(dto.getQuestion());
            resp.setMatchWay(dto.getMatchWay());
            this.copyToAutoReplyResp(resp, (CommonAutoReplyDto)dto);
            result.add(resp);
        }
        this.setAppInfo(result);
        this.setUserInfo(result);
        this.setMaterialInfo(result);
        return result;
    }

    @Override
    public List<AutoReplyListResp> queryCommonList(AutoReplyListReq params, AutoReplyType replyType) {
        log.info("query autoreply list with params={}, replyType={}", (Object)params, (Object)replyType);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((replyType != null ? 1 : 0) != 0, (Object)"\u81ea\u52a8\u56de\u590d\u7c7b\u578b\u4e3a\u7a7a");
        List<String> appIds = this.operatorService.getCurrentManagerAppIds();
        if (CollectionUtils.isEmpty(appIds)) {
            return Collections.emptyList();
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()}) && !appIds.contains(params.getAppId())) {
            return Collections.emptyList();
        }
        AutoReplyQueryParam query = new AutoReplyQueryParam();
        query.setPageDto(params.getPageDto());
        query.setRelationType(Integer.valueOf(RELATION_TYPE));
        query.setReplyType(Integer.valueOf(replyType.getValue()));
        query.setSort(params.getSort());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()})) {
            query.setAppId(params.getAppId());
        } else {
            query.setAppIds(appIds);
        }
        int count = this.logicAutoReplyOfficialAccountMapper.countCommonList(query);
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(count));
        }
        if (count <= 0) {
            return Collections.emptyList();
        }
        List list = this.logicAutoReplyOfficialAccountMapper.queryCommonList(query);
        if (params.getPageDto() != null) {
            params.getPageDto().setCurPageCount(Integer.valueOf(list.size()));
        }
        return this.toCommonAutoReplyRespList(list);
    }

    @Override
    public List<AutoReplyListResp> toCommonAutoReplyRespList(List<CommonAutoReplyDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (CommonAutoReplyDto dto : list) {
            AutoReplyListResp resp = new AutoReplyListResp();
            this.copyToAutoReplyResp(resp, dto);
            result.add(resp);
        }
        this.setAppInfo(result);
        this.setUserInfo(result);
        this.setMaterialInfo(result);
        return result;
    }

    private void copyToAutoReplyResp(AutoReplyListResp resp, CommonAutoReplyDto dto) {
        resp.setId(dto.getId());
        resp.setCreator(new ModifierDto(dto.getCreateBy(), "", ""));
        resp.setCreateTime(dto.getCreateTime());
        resp.setUpdator(new ModifierDto(dto.getUpdateBy(), "", ""));
        resp.setUpdateTime(dto.getUpdateTime());
        resp.setApp(new AppIdAndNameDto(dto.getAppId(), "", ""));
        AutoReplyMsgDto replyMsg = this.deserialize(dto.getMessage());
        if (replyMsg == null || replyMsg.getType() == null) {
            log.error("\u53cd\u5e8f\u5217\u5316\u5931\u8d25\uff0c\u65e0\u6cd5\u81ea\u52a8\u56de\u590d\u6d88\u606f\u3002AutoReplyId={}", (Object)dto.getId());
            return;
        }
        resp.setType(replyMsg.getType());
        if (AutoReplyMessageType.TEXT.getValue() == replyMsg.getType().intValue()) {
            resp.setMessage(replyMsg.getContent());
        } else if (AutoReplyMessageType.MATERIAL.getValue() == replyMsg.getType().intValue()) {
            try {
                Long materialId = Long.parseLong(replyMsg.getContent());
                SimpleMaterialDto mat = new SimpleMaterialDto();
                mat.setId(materialId);
                resp.setMaterial(mat);
            }
            catch (NumberFormatException e) {
                log.error("\u89e3\u6790\u6d88\u606f\u4e2d\u7684\u7d20\u6750id\u5931\u8d25, materialId={}", (Object)replyMsg.getContent(), (Object)e);
            }
        } else {
            log.warn("\u975e\u6cd5\u7684\u81ea\u52a8\u56de\u590d\u7c7b\u578b");
        }
    }

    @Override
    public String serialize(AutoReplyDto params) {
        ArrayList list = Lists.newArrayList();
        AutoReplyMsgDto msgDto = this.newAutoReplyMsgDto(params.getType(), params.getMessage(), params.getMaterialId());
        list.add(msgDto);
        AutoReplyMsgListDto msgListDto = new AutoReplyMsgListDto();
        msgListDto.setReplyMessage(list);
        return JacksonUtil.obj2Str((Object)msgListDto);
    }

    @Override
    public AutoReplyMsgDto deserialize(String content) {
        List<AutoReplyMsgDto> msgList;
        AutoReplyMsgDto replyMsg = null;
        AutoReplyMsgListDto json = null;
        try {
            json = (AutoReplyMsgListDto)JacksonUtil.str2Obj((String)content, AutoReplyMsgListDto.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u5173\u952e\u8bcd\u81ea\u52a8\u56de\u590d\uff0c\u53cd\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
        }
        if (json != null && CollectionUtils.isNotEmpty(msgList = json.getReplyMessage())) {
            replyMsg = msgList.get(0);
        }
        return replyMsg;
    }

    private AutoReplyMsgDto newAutoReplyMsgDto(int type, String message, Long materialId) {
        AutoReplyMsgDto msgDto = new AutoReplyMsgDto();
        msgDto.setType(type);
        if (AutoReplyMessageType.TEXT.getValue() == type) {
            msgDto.setContent(message);
        } else if (AutoReplyMessageType.MATERIAL.getValue() == type) {
            msgDto.setContent(String.valueOf(materialId));
        } else {
            log.warn("\u672a\u77e5\u7684\u81ea\u52a8\u56de\u590d\u7c7b\u578b, type={}:", (Object)type);
        }
        return msgDto;
    }

    private <T extends AutoReplyListResp> void setAppInfo(List<T> list) {
        HashSet appIds = Sets.newHashSet();
        list.forEach(it -> appIds.add(it.getApp().getId()));
        Map<String, OfficialAccount> appInfoMap = this.officialAccountService.queryByAppIds(appIds);
        list.forEach(it -> {
            AppIdAndNameDto app = it.getApp();
            OfficialAccount account = (OfficialAccount)appInfoMap.get(app.getId());
            if (account != null) {
                app.setName(account.getNickName());
                app.setHeadImgUrl(account.getHeadImg());
            }
        });
    }

    private <T extends AutoReplyListResp> void setUserInfo(List<T> list) {
        HashSet userIds = Sets.newHashSet();
        list.forEach(it -> {
            if (it.getCreator() != null) {
                userIds.add(it.getCreator().getId());
            }
            if (it.getUpdator() != null) {
                userIds.add(it.getUpdator().getId());
            }
        });
        userIds.remove(null);
        Map<Long, UserInfoRespDto> userInfoMap = this.userInfoService.queryUserInfoMap(userIds);
        list.forEach(it -> {
            ModifierDto updator;
            UserInfoRespDto u;
            ModifierDto creator = it.getCreator();
            UserInfoRespDto c = (UserInfoRespDto)userInfoMap.get(creator.getId());
            if (c != null) {
                creator.setName(c.getUsername());
                creator.setNickName(c.getNickname());
            }
            if ((u = (UserInfoRespDto)userInfoMap.get((updator = it.getUpdator()).getId())) == null) {
                u = c;
            }
            if (u != null) {
                updator.setName(u.getUsername());
                updator.setNickName(u.getNickname());
            }
        });
    }

    private <T extends AutoReplyListResp> void setMaterialInfo(List<T> list) {
        HashSet materialIds = Sets.newHashSet();
        list.forEach(it -> {
            SimpleMaterialDto mat = it.getMaterial();
            if (mat != null && mat.getId() != null) {
                materialIds.add(mat.getId());
            }
        });
        materialIds.remove(null);
        Map<Long, MaterialResultDto> matMap = this.commonMaterialService.queryMaterialMap(materialIds);
        list.forEach(it -> {
            MaterialResultDto material;
            SimpleMaterialDto mat = it.getMaterial();
            if (mat != null && mat.getId() != null && (material = (MaterialResultDto)matMap.get(mat.getId())) != null) {
                mat.setTitle(material.getTitle());
                mat.setUrl(material.getUrl());
                if (material.getmType().equals(MaterialType.VOICE.getValue()) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{material.getTranscodeUrl()})) {
                    mat.setUrl(material.getTranscodeUrl());
                }
                mat.setType(material.getmType());
                if (WxMediaType.News.getValue().equals(material.getmType())) {
                    for (MaterialResultDto news : material.getSubNews()) {
                        it.addMaterial(news.getId(), news.getTitle(), news.getAuthor(), news.getCover(), news.getDigest(), news.getContent());
                    }
                }
            }
        });
    }
}

