/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.autoreply.service.impl;

import cn.kinyun.scrm.weixin.autoreply.dto.AutoReplyMsgDto;
import cn.kinyun.scrm.weixin.autoreply.dto.req.AutoReplyDelReq;
import cn.kinyun.scrm.weixin.autoreply.dto.req.KeywordAutoReplyAddReq;
import cn.kinyun.scrm.weixin.autoreply.dto.req.KeywordAutoReplyListReq;
import cn.kinyun.scrm.weixin.autoreply.dto.req.KeywordAutoReplyModReq;
import cn.kinyun.scrm.weixin.autoreply.dto.resp.KeywordAutoReplyListResp;
import cn.kinyun.scrm.weixin.autoreply.service.KeywordAutoReplyService;
import cn.kinyun.scrm.weixin.autoreply.service.LogicAutoReplyService;
import cn.kinyun.scrm.weixin.enums.autoreply.AutoReplyMessageType;
import cn.kinyun.scrm.weixin.enums.autoreply.AutoReplyRelationType;
import cn.kinyun.scrm.weixin.enums.autoreply.AutoReplyType;
import cn.kinyun.scrm.weixin.enums.autoreply.KeywordType;
import cn.kinyun.scrm.weixin.enums.biz.SystemParamName;
import cn.kinyun.scrm.weixin.message.dto.MsgData;
import cn.kinyun.scrm.weixin.message.dto.req.SendCustomMsgReqDto;
import cn.kinyun.scrm.weixin.officialAccount.service.OfficialAccountService;
import cn.kinyun.scrm.weixin.officialAccount.service.OperatorService;
import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import com.google.common.collect.Sets;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.reply.dto.KeywordAutoReplyDto;
import com.kuaike.scrm.dal.official.reply.dto.KeywordAutoReplyQueryParam;
import com.kuaike.scrm.dal.official.reply.entity.LogicAutoReply;
import com.kuaike.scrm.dal.official.reply.entity.LogicAutoReplyOfficialAccount;
import com.kuaike.scrm.dal.official.reply.entity.LogicAutoReplyWord;
import com.kuaike.scrm.dal.official.reply.mapper.LogicAutoReplyMapper;
import com.kuaike.scrm.dal.official.reply.mapper.LogicAutoReplyOfficialAccountMapper;
import com.kuaike.scrm.dal.official.reply.mapper.LogicAutoReplyWordMapper;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KeywordAutoReplyServiceImpl
implements KeywordAutoReplyService {
    private static final Logger log = LoggerFactory.getLogger(KeywordAutoReplyServiceImpl.class);
    private static final String NOT_VALID_AUTOREPLY = "\u8be5\u6d88\u606f\u4e0d\u662f\u516c\u4f17\u53f7\u5173\u952e\u8bcd\u81ea\u52a8\u56de\u590d\uff0c\u60a8\u65e0\u6743\u6267\u884c\u8be5\u64cd\u4f5c\u3002";
    private static final int RELATION_TYPE = AutoReplyRelationType.OFFICIAL_ACCOUNT.getValue();
    private static final int REPLY_TYPE = AutoReplyType.KEY_WORD_REPLY.getValue();
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private LogicAutoReplyMapper logicAutoReplyMapper;
    @Autowired
    private LogicAutoReplyWordMapper logicAutoReplyWordMapper;
    @Autowired
    private LogicAutoReplyOfficialAccountMapper logicAutoReplyOfficialAccountMapper;
    @Autowired
    private LogicAutoReplyService logicAutoReplyService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private OfficialAccountService officialAccountService;

    @Override
    public boolean onRecvMsg(String appId, String openId, String content) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{appId, openId, content})) {
            return false;
        }
        KeywordAutoReplyDto reply = this.getMatchedReply(appId, content);
        if (reply == null) {
            return false;
        }
        AutoReplyMsgDto json = this.logicAutoReplyService.deserialize(reply.getMessage());
        if (json == null || json.getType() == null) {
            log.warn("\u53cd\u5e8f\u5217\u5316\u5931\u8d25\uff0c\u65e0\u6cd5\u81ea\u52a8\u56de\u590d\u6d88\u606f. message={}", (Object)reply.getMessage());
            return false;
        }
        OfficialAccount account = this.officialAccountService.queryByAppId(appId);
        boolean isSendQuestion = this.isSendQuestion(account.getBizId());
        if (isSendQuestion && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reply.getQuestion()})) {
            if (AutoReplyMessageType.TEXT.getValue() == json.getType().intValue()) {
                json.setContent(reply.getQuestion() + "\n" + json.getContent());
            } else {
                SendCustomMsgReqDto customMsg = new SendCustomMsgReqDto();
                customMsg.setAppId(appId);
                customMsg.setOpenId(openId);
                customMsg.setMsgType(WxMsgType.Text.getValue());
                customMsg.setMsgData(MsgData.builder().content(reply.getQuestion()).build());
                customMsg.setBizId(account.getBizId());
                customMsg.setCorpId(account.getCorpId());
                this.logicAutoReplyService.send(customMsg);
            }
        }
        return this.logicAutoReplyService.send(json, appId, openId, account.getBizId(), account.getCorpId());
    }

    private boolean isSendQuestion(Long bizId) {
        try {
            return this.settingService.getBoolean(bizId, SystemParamName.AUTO_REPLY_CONTAINS_QUESTION.getKey());
        }
        catch (Exception e) {
            log.error("get auto reply error", (Throwable)e);
            return false;
        }
    }

    private KeywordAutoReplyDto getMatchedReply(String appId, String content) {
        List fuzzyMatch;
        KeywordAutoReplyDto result = null;
        KeywordAutoReplyQueryParam query = new KeywordAutoReplyQueryParam();
        Long bizId = this.officialAccountService.queryBuIdByAppId(appId);
        query.setBizId(bizId);
        query.setAppId(appId);
        query.setRelationType(Integer.valueOf(RELATION_TYPE));
        query.setReplyType(Integer.valueOf(REPLY_TYPE));
        query.setSort("desc");
        int count = this.logicAutoReplyWordMapper.countKeywordList(query);
        if (count <= 0) {
            return result;
        }
        List list = this.logicAutoReplyWordMapper.queryKeywordList(query);
        List fullMatch = list.stream().filter(it -> it.getMatchWay().intValue() == KeywordType.FULL.getValue()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(fullMatch)) {
            for (KeywordAutoReplyDto dto : fullMatch) {
                if (!this.match(content, dto)) continue;
                return dto;
            }
        }
        if (CollectionUtils.isNotEmpty(fuzzyMatch = list.stream().filter(it -> it.getMatchWay().intValue() == KeywordType.FUZZY.getValue()).collect(Collectors.toList()))) {
            for (KeywordAutoReplyDto dto : fuzzyMatch) {
                if (!this.match(content, dto)) continue;
                return dto;
            }
        }
        return result;
    }

    private boolean match(String content, KeywordAutoReplyDto word) {
        if (word.getMatchWay() == null || StringUtils.isBlank((CharSequence)word.getKeyword())) {
            return false;
        }
        KeywordType type = KeywordType.getType(word.getMatchWay());
        if (type == null) {
            log.warn("\u4e0d\u5408\u6cd5\u7684\u5173\u952e\u8bcd\u5339\u914d\u65b9\u5f0f, autoReplyId={}, keywordId={}, keywordType={}", new Object[]{word.getId(), word.getWid(), word.getMatchWay()});
            return false;
        }
        switch (type) {
            case FULL: {
                return content.equals(word.getKeyword());
            }
            case FUZZY: {
                return content.contains(word.getKeyword());
            }
        }
        return false;
    }

    @Override
    public List<KeywordAutoReplyListResp> list(KeywordAutoReplyListReq params) {
        return this.logicAutoReplyService.queryKeywordList(params);
    }

    @Override
    @Transactional
    public void addAll(List<KeywordAutoReplyAddReq> list) {
        log.info("addOrMod keyword autoreply with list={}", list);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((currentUser.getId() != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(list), (Object)"\u53c2\u6570\u4e3a\u7a7a");
        HashSet cache = Sets.newHashSet();
        HashSet appIds = Sets.newHashSet();
        for (KeywordAutoReplyAddReq req : list) {
            Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{req.getAppId()}), (Object)"\u672a\u8bbe\u7f6e\u516c\u4f17\u53f7");
            Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{req.getKeyword()}), (Object)"\u672a\u8bbe\u7f6e\u5173\u952e\u8bcd");
            Preconditions.checkArgument((req.getMatchWay() != null ? 1 : 0) != 0, (Object)"\u672a\u8bbe\u7f6e\u5339\u914d\u65b9\u5f0f");
            Preconditions.checkArgument((KeywordType.getType(req.getMatchWay()) != null ? 1 : 0) != 0, (Object)"\u4e0d\u5408\u6cd5\u7684\u5339\u914d\u65b9\u5f0f");
            Preconditions.checkArgument((req.getType() != null ? 1 : 0) != 0, (Object)"\u672a\u8bbe\u7f6e\u81ea\u52a8\u56de\u590d\u7c7b\u578b");
            Preconditions.checkArgument((AutoReplyMessageType.getType(req.getType()) != null ? 1 : 0) != 0, (Object)"\u672a\u77e5\u7684\u81ea\u52a8\u56de\u590d\u7c7b\u578b");
            String word = req.getAppId() + "::" + req.getKeyword();
            Preconditions.checkArgument((!cache.contains(word) ? 1 : 0) != 0, (String)"\u516c\u4f17\u53f7[%s]\u8bbe\u7f6e\u4e86\u76f8\u540c\u7684\u5173\u952e\u5b57[%s]", (Object)req.getAppId(), (Object)req.getKeyword());
            cache.add(word);
            appIds.add(req.getAppId());
        }
        Preconditions.checkArgument((boolean)this.operatorService.isManager(currentUser.getId(), appIds), (Object)"\u60a8\u4e0d\u662f\u516c\u4f17\u53f7\u7684\u8fd0\u8425\u8005\uff0c\u65e0\u6743\u6267\u884c\u6b64\u64cd\u4f5c\u3002");
        for (KeywordAutoReplyAddReq req : list) {
            this.add(req);
        }
    }

    @Override
    @Transactional
    public Long add(KeywordAutoReplyAddReq params) {
        List exists;
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((currentUser.getId() != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()}), (Object)"\u672a\u8bbe\u7f6e\u516c\u4f17\u53f7");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getKeyword()}), (Object)"\u672a\u8bbe\u7f6e\u5173\u952e\u8bcd");
        Preconditions.checkArgument((KeywordType.getType(params.getMatchWay()) != null ? 1 : 0) != 0, (Object)"\u4e0d\u5408\u6cd5\u7684\u5339\u914d\u65b9\u5f0f");
        Preconditions.checkArgument((params.getType() != null ? 1 : 0) != 0, (Object)"\u672a\u8bbe\u7f6e\u81ea\u52a8\u56de\u590d\u7c7b\u578b");
        AutoReplyMessageType replyMsgType = AutoReplyMessageType.getType(params.getType());
        Preconditions.checkArgument((replyMsgType != null ? 1 : 0) != 0, (Object)"\u672a\u77e5\u7684\u81ea\u52a8\u56de\u590d\u7c7b\u578b");
        Long operatorId = currentUser.getId();
        String appId = params.getAppId();
        Preconditions.checkArgument((boolean)this.operatorService.isManager(operatorId, appId), (Object)"\u60a8\u4e0d\u662f\u516c\u4f17\u53f7\u7684\u8fd0\u8425\u8005\uff0c\u65e0\u6743\u6267\u884c\u6b64\u64cd\u4f5c\u3002");
        if (AutoReplyMessageType.MATERIAL.getValue() == params.getType().intValue()) {
            this.logicAutoReplyService.syncMaterial(params.getMaterialId(), params.getAppId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(exists = this.logicAutoReplyWordMapper.queryExistKeyword(appId, params.getKeyword())))) {
            exists.forEach(it -> {
                this.logicAutoReplyMapper.logicDeleteById(it.getId(), operatorId);
                this.logicAutoReplyOfficialAccountMapper.logicDeleteByAutoReplyId(it.getId(), operatorId);
                this.logicAutoReplyWordMapper.logicDeleteByAutoReplyId(it.getId(), operatorId);
            });
        }
        LogicAutoReply autoReply = new LogicAutoReply();
        autoReply.setRelationType(Integer.valueOf(RELATION_TYPE));
        autoReply.setReplyType(Integer.valueOf(AutoReplyType.KEY_WORD_REPLY.getValue()));
        autoReply.setBizId(currentUser.getBizId());
        autoReply.setCorpId(currentUser.getCorpId());
        autoReply.setNodeId(currentUser.getUserNodeId());
        autoReply.setCreateBy(operatorId);
        autoReply.setMessage(this.logicAutoReplyService.serialize(params));
        this.logicAutoReplyMapper.insertSelective((Object)autoReply);
        LogicAutoReplyOfficialAccount account = new LogicAutoReplyOfficialAccount();
        account.setBizId(currentUser.getBizId());
        account.setCorpId(currentUser.getCorpId());
        account.setAutoReplyId(autoReply.getId());
        account.setOfficialAccountId(appId);
        account.setCreateBy(operatorId);
        this.logicAutoReplyOfficialAccountMapper.insertSelective((Object)account);
        LogicAutoReplyWord word = new LogicAutoReplyWord();
        word.setBizId(currentUser.getBizId());
        word.setCorpId(currentUser.getCorpId());
        word.setAutoReplyId(autoReply.getId());
        word.setKeyWord(params.getKeyword());
        word.setType(params.getMatchWay());
        word.setCreateBy(operatorId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getQuestion()})) {
            word.setQuestion(params.getQuestion());
        }
        this.logicAutoReplyWordMapper.insertSelective((Object)word);
        return autoReply.getId();
    }

    @Override
    @Transactional
    public boolean modify(KeywordAutoReplyModReq params) {
        boolean modified = false;
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((currentUser.getId() != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"id\u4e3a\u7a7a");
        KeywordAutoReplyDto autoReplyDto = this.logicAutoReplyWordMapper.getKeywordAutoReplyById(params.getId());
        Preconditions.checkArgument((autoReplyDto != null ? 1 : 0) != 0, (Object)"\u8be5\u6d88\u606f\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        Preconditions.checkArgument((autoReplyDto.getRelationType() != null ? 1 : 0) != 0, (Object)NOT_VALID_AUTOREPLY);
        Preconditions.checkArgument((autoReplyDto.getReplyType() != null ? 1 : 0) != 0, (Object)NOT_VALID_AUTOREPLY);
        Preconditions.checkArgument((RELATION_TYPE == autoReplyDto.getRelationType() ? 1 : 0) != 0, (Object)NOT_VALID_AUTOREPLY);
        Preconditions.checkArgument((REPLY_TYPE == autoReplyDto.getReplyType() ? 1 : 0) != 0, (Object)NOT_VALID_AUTOREPLY);
        Long operatorId = currentUser.getId();
        String appId = autoReplyDto.getAppId();
        Preconditions.checkArgument((boolean)this.operatorService.isManager(operatorId, appId), (Object)"\u60a8\u4e0d\u662f\u516c\u4f17\u53f7\u7684\u8fd0\u8425\u8005\uff0c\u65e0\u6743\u6267\u884c\u6b64\u64cd\u4f5c\u3002");
        if (params.getType() != null && (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getMessage()}) || params.getMaterialId() != null)) {
            Preconditions.checkArgument((AutoReplyMessageType.getType(params.getType()) != null ? 1 : 0) != 0, (Object)"\u672a\u77e5\u7684\u81ea\u52a8\u56de\u590d\u7c7b\u578b");
            modified = this.logicAutoReplyService.modify(params, AutoReplyType.KEY_WORD_REPLY);
        }
        if (params.getMatchWay() != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getKeyword()})) {
            List exists;
            Preconditions.checkArgument((KeywordType.getType(params.getMatchWay()) != null ? 1 : 0) != 0, (Object)"\u9519\u8bef\u7684\u5173\u952e\u8bcd\u5339\u914d\u65b9\u5f0f");
            if (!params.getKeyword().equals(autoReplyDto.getKeyword()) && CollectionUtils.isNotEmpty((Collection)(exists = this.logicAutoReplyWordMapper.queryExistKeyword(appId, params.getKeyword())))) {
                exists.forEach(it -> {
                    Long id = it.getId();
                    this.logicAutoReplyMapper.logicDeleteById(id, operatorId);
                    this.logicAutoReplyOfficialAccountMapper.logicDeleteByAutoReplyId(id, operatorId);
                    this.logicAutoReplyWordMapper.logicDeleteByAutoReplyId(id, operatorId);
                });
            }
            LogicAutoReplyWord word = new LogicAutoReplyWord();
            word.setId(autoReplyDto.getWid());
            word.setKeyWord(params.getKeyword());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getQuestion()})) {
                word.setQuestion(params.getQuestion());
            }
            word.setType(params.getMatchWay());
            word.setUpdateBy(operatorId);
            this.logicAutoReplyWordMapper.updateByPrimaryKeySelective((Object)word);
            if (!modified) {
                LogicAutoReply reply = new LogicAutoReply();
                reply.setId(autoReplyDto.getId());
                reply.setUpdateBy(operatorId);
                reply.setUpdateTime(new Date());
                this.logicAutoReplyMapper.updateByPrimaryKeySelective((Object)reply);
            }
            modified = true;
        }
        return modified;
    }

    @Override
    @Transactional
    public boolean delete(AutoReplyDelReq params) {
        return this.logicAutoReplyService.delete(params, AutoReplyType.KEY_WORD_REPLY);
    }

    @Override
    public boolean exist(String appId, String keyword) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{appId, keyword})) {
            return false;
        }
        List exists = this.logicAutoReplyWordMapper.queryExistKeyword(appId, keyword);
        return CollectionUtils.isNotEmpty((Collection)exists);
    }
}

