/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.autoreply.service.impl;

import cn.kinyun.scrm.weixin.activity.dto.ActiTemplateMsgDto;
import cn.kinyun.scrm.weixin.activity.dto.ActivityDto;
import cn.kinyun.scrm.weixin.activity.dto.resp.EventKeyDto;
import cn.kinyun.scrm.weixin.activity.service.ActivityHelper;
import cn.kinyun.scrm.weixin.autoreply.service.ActivityAutoReplyService;
import cn.kinyun.scrm.weixin.enums.MsgSendType;
import cn.kinyun.scrm.weixin.enums.TriggerType;
import cn.kinyun.scrm.weixin.enums.activity.ActivityStatus;
import cn.kinyun.scrm.weixin.enums.activity.ActivityTaskStatus;
import cn.kinyun.scrm.weixin.enums.activity.ActivityType;
import cn.kinyun.scrm.weixin.enums.biz.ClickEventBizType;
import cn.kinyun.scrm.weixin.message.service.MessageService;
import cn.kinyun.scrm.weixin.message.service.SendMessageService;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.BaseRespMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.TextMsg;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.dal.official.fans.entity.OfficialFansExtend;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialFansExtendMapper;
import com.kuaike.scrm.dal.official.fission.entity.OfficialActi;
import com.kuaike.scrm.dal.official.fission.entity.OfficialActiTask;
import com.kuaike.scrm.dal.official.fission.mapper.OfficialActiMapper;
import com.kuaike.scrm.dal.official.fission.mapper.OfficialActiResultMapper;
import com.kuaike.scrm.dal.official.fission.mapper.OfficialActiTaskMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActivityAutoReplyServiceImpl
implements ActivityAutoReplyService {
    private static final Logger log = LoggerFactory.getLogger(ActivityAutoReplyServiceImpl.class);
    @Resource
    private OfficialActiMapper officialActiMapper;
    @Resource
    private OfficialActiTaskMapper officialActiTaskMapper;
    @Resource
    private OfficialActiResultMapper officialActiResultMapper;
    @Autowired
    private ActivityHelper activityHelper;
    @Resource
    private OfficialFansExtendMapper officialFansExtendMapper;
    @Autowired
    private SendMessageService sendMessageService;
    @Autowired
    private MessageService messageService;

    @Override
    public boolean onSubscribe(String appId, String openId, String eventKey, Long timestamp) {
        log.info("activity on subscribe, appId={}, openId={}, eventKey={}", new Object[]{appId, openId, eventKey});
        EventKeyDto dto = EventKeyDto.unpack(eventKey);
        if (dto != null && ClickEventBizType.OFFICIAL_FISSION.getKey().equals(dto.getType())) {
            ActivityDto data;
            OfficialActi acti = this.officialActiMapper.getById(dto.getId());
            if (acti == null) {
                log.info("activity is not exists, id={}", (Object)dto.getId());
                return false;
            }
            if (!this.activityEffect(acti)) {
                log.info("activity is not effect, id={}", (Object)dto.getId());
                return false;
            }
            try {
                data = (ActivityDto)JacksonUtil.str2Obj((String)acti.getContent(), ActivityDto.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("Failed parseing activity content, json={}", (Object)acti.getContent());
                return false;
            }
            List results = this.officialActiResultMapper.queryResult(dto.getId(), appId, null, openId);
            if (CollectionUtils.isNotEmpty((Collection)results) && StringUtils.isNotBlank((CharSequence)data.getNoticeStr4())) {
                return this.sendText(appId, openId, data.getNoticeStr4());
            }
            if (openId.equals(dto.getOpenId())) {
                log.info("scan by same fans, id={}, openId={}", (Object)acti.getId(), (Object)openId);
                return false;
            }
            this.activityHelper.receiveTask(dto.getId(), appId, openId, TriggerType.OTHER.getValue());
            this.activityHelper.attention(dto.getId(), appId, dto.getOpenId(), openId, new Date(timestamp));
            return true;
        }
        return this.sendActivity(appId, openId);
    }

    private boolean sendActivity(String appId, String openId) {
        log.info("send activity, appId={}, openId={}", (Object)appId, (Object)openId);
        List list = this.officialActiMapper.queryListByName(null, appId);
        if (CollectionUtils.isEmpty((Collection)list)) {
            log.info("no activity found, appId={}", (Object)appId);
            return false;
        }
        OfficialActi acti = null;
        for (OfficialActi it : list) {
            if (!this.activityEffect(it)) continue;
            acti = it;
            break;
        }
        if (acti == null) {
            log.info("No effect activity found, appId={}", (Object)appId);
            return false;
        }
        if (acti.getTemplate().equals("002")) {
            log.info("\u6da8\u7c89\u6d3b\u52a8, \u4e0d\u56de\u590d\u3002id={}", (Object)acti.getId());
            return false;
        }
        this.activityHelper.receiveTask(acti.getId(), appId, openId, TriggerType.OTHER.getValue());
        return true;
    }

    @Override
    public boolean onScan(String appId, String openId, String eventKey, Long timestamp) {
        EventKeyDto dto = EventKeyDto.unpack(eventKey);
        if (dto != null && ClickEventBizType.OFFICIAL_FISSION.getKey().equals(dto.getType())) {
            ActivityDto data;
            OfficialActi acti = this.officialActiMapper.getById(dto.getId());
            if (acti == null) {
                log.info("activity is not exists, id={}", (Object)dto.getId());
                return false;
            }
            if (!this.activityEffect(acti)) {
                log.info("activity is not effect, id={}", (Object)dto.getId());
                return false;
            }
            if (openId.equals(dto.getOpenId())) {
                OfficialActiTask task = this.officialActiTaskMapper.queryTask(dto.getId(), appId, openId);
                TextMsg text = new TextMsg();
                text.setToUserName(openId);
                text.setFromUserName(appId);
                text.println("\u6d3b\u52a8\u540d\u79f0:" + acti.getName());
                text.printf("\u5b8c\u6210\u8fdb\u5ea6: %d/%d \u4f4d\u597d\u53cb\u652f\u6301\u4e86\u4f60\u3002\n", new Object[]{task.getAmount(), task.getGoal()});
                try {
                    this.sendMessageService.send((BaseRespMsg)text);
                    this.messageService.record((BaseRespMsg)text, MsgSendType.SYS_SEND_FANS, -1L, -1L);
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
                    return false;
                }
            }
            try {
                data = (ActivityDto)JacksonUtil.str2Obj((String)acti.getContent(), ActivityDto.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                log.error("Failed parse content, json={}", (Object)acti.getContent());
                return false;
            }
            if (StringUtils.isNotBlank((CharSequence)data.getNoticeStr4())) {
                return this.sendText(appId, openId, data.getNoticeStr4());
            }
        }
        return false;
    }

    @Override
    public boolean onRecvMsg(String appId, String openId, String content) {
        ActivityDto dto;
        OfficialActiTask task = this.officialActiTaskMapper.querylastTask(null, appId, openId);
        if (task == null) {
            return false;
        }
        OfficialActi acti = this.officialActiMapper.getById(task.getActiId());
        if (acti == null || acti.getStatus().intValue() == ActivityStatus.FORBIDDEN.getStatus()) {
            return false;
        }
        ActivityTaskStatus status = ActivityTaskStatus.getStatus(task.getStatus());
        if (status == null) {
            log.warn("\u975e\u6cd5\u7684\u4efb\u52a1\u72b6\u6001: taskId={}, status={}", (Object)task.getId(), (Object)task.getStatus());
            return false;
        }
        try {
            dto = (ActivityDto)JacksonUtil.str2Obj((String)acti.getContent(), ActivityDto.class);
        }
        catch (IOException e) {
            log.error("deserialize error", (Throwable)e);
            return false;
        }
        if (dto.getPhaseCategories() == 0) {
            return false;
        }
        if (CollectionUtils.isEmpty(dto.getMsgDtoList())) {
            log.warn("\u9636\u6bb5\u5956\u52b1\u4e3a\u7a7a");
            return false;
        }
        String processKey = null;
        for (ActiTemplateMsgDto it : dto.getMsgDtoList()) {
            if (it.getType() != ActivityType.PHYSICS.getValue().intValue() || !StringUtils.isNotBlank((CharSequence)it.getProcessKey())) continue;
            processKey = it.getProcessKey();
            break;
        }
        if (processKey == null) {
            log.warn("\u6ca1\u6709\u6697\u53f7");
            return false;
        }
        if (!content.equals(processKey)) {
            log.warn("\u6ca1\u6709\u547d\u4e2d\u6697\u53f7:{}, \u6d88\u606f:{}", processKey, (Object)content);
            return false;
        }
        Integer completedPhaseNum = task.getCompletedPhaseNum();
        if (completedPhaseNum == 0) {
            return this.sendText(appId, openId, "\u60a8\u7684\u4efb\u52a1\u8fd8\u672a\u5b8c\u6210\uff0c\u8bf7\u5148\u5b8c\u6210\u4efb\u52a1\u3002");
        }
        ActiTemplateMsgDto templateMsgDto = null;
        for (int i = completedPhaseNum - 1; i >= 0; --i) {
            ActiTemplateMsgDto it = dto.getMsgDtoList().get(i);
            if (it.getType() != ActivityType.PHYSICS.getValue().intValue()) continue;
            templateMsgDto = it;
            break;
        }
        String message = null;
        if (templateMsgDto == null) {
            log.info("\u6ca1\u6709\u547d\u4e2d\u4efb\u4f55\u4e00\u4e2a\u5b9e\u4f53\u9636\u6bb5");
            return false;
        }
        OfficialFansExtend extend = this.officialFansExtendMapper.getExtend(appId, openId);
        message = extend != null ? (StringUtils.isNotBlank((CharSequence)task.getOddNo()) ? "\u60a8\u7684\u5feb\u9012\u5355\u53f7\u662f\uff1a" + task.getOddNo() : "\u5feb\u9012\u6b63\u5728\u52a0\u7d27\u6d3e\u53d1\uff0c\u8bf7\u7a0d\u540e\u518d\u6765\u67e5\u8be2\u54e6~") : "\u60a8\u7684\u4efb\u52a1\u5df2\u7ecf\u5b8c\u6210\uff0c\u8bf7\u70b9\u51fb\u3010\u4efb\u52a1\u5b8c\u6210\u901a\u77e5\u3011\u6d88\u606f\uff0c\u586b\u5199\u6536\u4ef6\u5730\u5740\u54e6~";
        if (StringUtils.isNotBlank((CharSequence)message)) {
            return this.sendText(appId, openId, message);
        }
        return false;
    }

    private boolean sendText(String appId, String openId, String message) {
        if (StringUtils.isBlank((CharSequence)message)) {
            log.warn("\u4f01\u56fe\u7ed9\u7528\u6237\u53d1\u9001\u7a7a\u6587\u672c");
            return false;
        }
        TextMsg text = new TextMsg();
        text.setToUserName(openId);
        text.setFromUserName(appId);
        text.print(message);
        try {
            this.sendMessageService.send((BaseRespMsg)text);
            this.messageService.record((BaseRespMsg)text, MsgSendType.SYS_SEND_FANS, -1L, -1L);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private boolean activityEffect(OfficialActi acti) {
        Date now = new Date();
        ActivityStatus status = ActivityStatus.getStatus(acti.getBeginTime(), acti.getEndTime(), now, acti.getStatus());
        log.info("activity status, id={}, status={}", (Object)acti.getId(), (Object)status);
        return ActivityStatus.EFFECT.getStatus() == status.getStatus();
    }
}

