/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.service.impl;

import cn.kinyun.scrm.weixin.recommend.common.dto.Behavior;
import cn.kinyun.scrm.weixin.recommend.service.BehaviorRecordService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.kuaike.scrm.dal.activity.entity.BehaviorRecord;
import com.kuaike.scrm.dal.activity.mapper.BehaviorRecordMapper;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BehaviorRecordServiceImpl
implements BehaviorRecordService {
    @Autowired
    private BehaviorRecordMapper behaviorRecordMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBehavior(Behavior behavior) {
        Preconditions.checkArgument((behavior.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null!");
        Preconditions.checkArgument((behavior.getConfId() != null ? 1 : 0) != 0, (Object)"confId is null!");
        BehaviorRecord behaviorRecord = new BehaviorRecord();
        behaviorRecord.setBizId(behavior.getBizId());
        behaviorRecord.setCorpId(behavior.getCorpId());
        behaviorRecord.setConfId(behavior.getConfId());
        behaviorRecord.setObjectId(behavior.getObjectId());
        behaviorRecord.setBehaviorTime(behavior.getBehaviorTime());
        behaviorRecord.setBehaviorContext(JSONObject.toJSONString(behavior.getContext()));
        this.behaviorRecordMapper.insertSelective((Object)behaviorRecord);
        behavior.setId(behaviorRecord.getId());
    }

    @Override
    public Map<Long, BehaviorRecord> queryRecordMap(Collection<Long> recordIds) {
        if (CollectionUtils.isEmpty(recordIds)) {
            return Maps.newHashMap();
        }
        return this.behaviorRecordMapper.queryBehaviorList(recordIds).stream().collect(Collectors.toMap(BehaviorRecord::getId, Function.identity()));
    }
}

