/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.message.dto;

import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class FansDto {
    String openId;
    String appId;
    Date date;

    public FansDto(String appId, String openId) {
        this.appId = appId;
        this.openId = openId;
        this.date = new Date();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FansDto fansDto = (FansDto)o;
        return Objects.equals(this.openId, fansDto.openId) && Objects.equals(this.appId, fansDto.appId);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.openId, this.appId);
    }

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.appId, this.openId}), (Object)"appId,openId can not be null or empty");
    }

    public String getOpenId() {
        return this.openId;
    }

    public String getAppId() {
        return this.appId;
    }

    public Date getDate() {
        return this.date;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String toString() {
        return "FansDto(openId=" + this.getOpenId() + ", appId=" + this.getAppId() + ", date=" + this.getDate() + ")";
    }
}

