/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.material.dto.req;

import cn.kinyun.scrm.weixin.common.dto.BaseParam;
import cn.kinyun.scrm.weixin.enums.MaterialType;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class MaterialGroupReq
extends BaseParam {
    private static final long serialVersionUID = 1857028560228418567L;
    String appId;
    String mediaType;
    String mediaGroup;

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.appId), (Object)"appId is null or empty");
        Preconditions.checkArgument((StringUtils.isNotEmpty((CharSequence)this.mediaType) && MaterialType.getByValue(this.mediaType) != null ? 1 : 0) != 0, (Object)"mediaType can only be image,video,voice,news");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.mediaGroup), (Object)"mediaGroup is null or empty");
        Preconditions.checkArgument((this.operatorId != null ? 1 : 0) != 0, (Object)"operatorId is null or empty");
    }

    public String getAppId() {
        return this.appId;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getMediaGroup() {
        return this.mediaGroup;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    public void setMediaGroup(String mediaGroup) {
        this.mediaGroup = mediaGroup;
    }

    @Override
    public String toString() {
        return "MaterialGroupReq(appId=" + this.getAppId() + ", mediaType=" + this.getMediaType() + ", mediaGroup=" + this.getMediaGroup() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaterialGroupReq)) {
            return false;
        }
        MaterialGroupReq other = (MaterialGroupReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$mediaType = this.getMediaType();
        String other$mediaType = other.getMediaType();
        if (this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType)) {
            return false;
        }
        String this$mediaGroup = this.getMediaGroup();
        String other$mediaGroup = other.getMediaGroup();
        return !(this$mediaGroup == null ? other$mediaGroup != null : !this$mediaGroup.equals(other$mediaGroup));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MaterialGroupReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $mediaType = this.getMediaType();
        result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
        String $mediaGroup = this.getMediaGroup();
        result = result * 59 + ($mediaGroup == null ? 43 : $mediaGroup.hashCode());
        return result;
    }
}

