/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.enums.activity;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum ActivityTaskStatus {
    INCOMPLETE(0, "\u4efb\u52a1\u672a\u5b8c\u6210"),
    COMPLETE(1, "\u4efb\u52a1\u5df2\u5b8c\u6210"),
    NO_ADDRESS(2, "\u672a\u586b\u5199\u5730\u5740"),
    UN_MAILED(3, "\u672a\u90ae\u5bc4"),
    MAILED(4, "\u5df2\u90ae\u5bc4");

    private static final Map<Integer, ActivityTaskStatus> CACHE;
    private final int status;
    private final String desc;

    private ActivityTaskStatus(int status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public int getStatus() {
        return this.status;
    }

    public static ActivityTaskStatus getStatus(Integer status) {
        return CACHE.get(status);
    }

    static {
        CACHE = Arrays.stream(ActivityTaskStatus.values()).collect(Collectors.toMap(ActivityTaskStatus::getStatus, Function.identity()));
    }
}

