/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.channel.service.impl;

import cn.kinyun.scrm.weixin.channel.dto.req.ChannelQrcodeReqDto;
import cn.kinyun.scrm.weixin.channel.dto.resp.ChannelDto;
import cn.kinyun.scrm.weixin.channel.dto.resp.ChannelQrCodeRespDto;
import cn.kinyun.scrm.weixin.channel.dto.resp.ChannelStatusDto;
import cn.kinyun.scrm.weixin.channel.service.ChannelQrcodeService;
import cn.kinyun.scrm.weixin.common.dto.AppIdAndNameDto;
import cn.kinyun.scrm.weixin.common.dto.ModifierDto;
import cn.kinyun.scrm.weixin.common.dto.UserInfoRespDto;
import cn.kinyun.scrm.weixin.common.service.UserInfoService;
import cn.kinyun.scrm.weixin.enums.biz.recommend.BehaviorType;
import cn.kinyun.scrm.weixin.officialaccount.dto.req.CreateQrcodeReqDto;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialAccountFansTagService;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialAccountService;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialQrcodeService;
import cn.kinyun.scrm.weixin.officialaccount.service.OperatorService;
import cn.kinyun.scrm.weixin.recommend.service.RecommendService;
import cn.kinyun.scrm.weixin.sdk.entity.account.CreateQrcodeResult;
import cn.kinyun.scrm.weixin.utils.FilterUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.component.AliyunOss;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.channelqrcode.dto.ChannelQrcodeQueryParam;
import com.kuaike.scrm.dal.official.channelqrcode.entity.OfficialChannelQrcode;
import com.kuaike.scrm.dal.official.channelqrcode.entity.OfficialChannelQrcodeStat;
import com.kuaike.scrm.dal.official.channelqrcode.mapper.OfficialChannelQrcodeMapper;
import com.kuaike.scrm.dal.official.channelqrcode.mapper.OfficialChannelQrcodeStatMapper;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

@Service
public class ChannelQrcodeServiceImpl
implements ChannelQrcodeService {
    private static final Logger log = LoggerFactory.getLogger(ChannelQrcodeServiceImpl.class);
    @Autowired
    private AliyunOss aliyunOss;
    @Resource
    private OfficialChannelQrcodeMapper channelQrcodeMapper;
    @Resource
    private OfficialChannelQrcodeStatMapper channelQrcodeStatMapper;
    @Resource
    private ChannelMapper channelMapper;
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private OfficialAccountService officialAccountService;
    @Autowired
    private OfficialAccountFansTagService fansTagService;
    @Autowired
    private UserInfoService userInfoService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private OfficialQrcodeService officialQrcodeService;
    @Autowired
    private RecommendService recommendService;
    private static final String CHANNEL_QR_PREFIX = "channel_qr";
    private static final String CHANNEL_QR_SPLITTER = "::";

    @Override
    public List<ChannelStatusDto> availableChannels(String appId) {
        log.info("query available channels with appId={} operatorId={}", (Object)appId, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId is blank");
        List<String> managerAppIds = this.operatorService.getCurrentManagerAppIds();
        if (CollectionUtils.isEmpty(managerAppIds) || !managerAppIds.contains(appId)) {
            return Collections.emptyList();
        }
        List customerChannels = this.channelMapper.getBizChannelList(LoginUtils.getCurrentUserBizId());
        if (CollectionUtils.isEmpty((Collection)customerChannels)) {
            return Collections.emptyList();
        }
        List usedChannelIds = this.channelQrcodeMapper.getUsedChannelIds(appId, LoginUtils.getCurrentUserBizId());
        ArrayList result = Lists.newArrayList();
        customerChannels.forEach(channel -> {
            if (!usedChannelIds.contains(channel.getId())) {
                ChannelStatusDto dto = new ChannelStatusDto();
                dto.setId(channel.getNum());
                dto.setName(channel.getName());
                dto.setAvailable(1);
                result.add(dto);
            }
        });
        return result;
    }

    @Override
    public List<ChannelQrCodeRespDto> list(ChannelQrcodeReqDto params) {
        ChannelQrcodeQueryParam queryParam;
        List channelQrcodes;
        log.info("query channel qrcode list with params={} by operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        List<String> managerAppIds = this.operatorService.getCurrentManagerAppIds();
        if (CollectionUtils.isEmpty(managerAppIds)) {
            return Collections.emptyList();
        }
        String appId = params.getAppId();
        String qrCodeName = params.getQrCodeName();
        PageDto pageDto = params.getPageDto();
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            if (managerAppIds.contains(appId)) {
                managerAppIds = Collections.singletonList(appId);
            } else {
                this.setPage(pageDto, 0, 0);
                return Collections.emptyList();
            }
        }
        if (CollectionUtils.isEmpty((Collection)(channelQrcodes = this.channelQrcodeMapper.queryList(queryParam = ChannelQrcodeQueryParam.builder().appIds(managerAppIds).qrCodeName(qrCodeName).bizId(LoginUtils.getCurrentUserBizId()).pageDto(pageDto).build())))) {
            this.setPage(pageDto, 0, 0);
            return Collections.emptyList();
        }
        if (pageDto != null) {
            this.setPage(pageDto, this.channelQrcodeMapper.count(queryParam), channelQrcodes.size());
        }
        Set<String> appIds = channelQrcodes.stream().map(a -> a.getAppId()).collect(Collectors.toSet());
        Map<String, OfficialAccount> appMap = this.officialAccountService.queryByAppIds(appIds);
        Set channelIds = channelQrcodes.stream().map(a -> a.getChannelId()).collect(Collectors.toSet());
        List channels = this.channelMapper.queryChannels(LoginUtils.getCurrentUserBizId(), channelIds);
        HashMap channelMap = Maps.newHashMap();
        for (Object channel : channels) {
            ChannelDto channelDto = new ChannelDto();
            channelDto.setId(channel.getNum());
            channelDto.setName(channel.getName());
            channelDto.setIsDel(channel.getIsDeleted());
            channelMap.put(channel.getId(), channelDto);
        }
        HashSet userIds = Sets.newHashSet();
        for (OfficialChannelQrcode channelQrcode2 : channelQrcodes) {
            userIds.add(channelQrcode2.getCreatorId());
            userIds.add(channelQrcode2.getUpdatorId());
        }
        Map<Long, UserInfoRespDto> userMap = this.userInfoService.queryUserInfoMap(userIds);
        Set ids = channelQrcodes.stream().map(OfficialChannelQrcode::getId).collect(Collectors.toSet());
        Map scanNumMap = this.channelQrcodeStatMapper.queryScanNumMap(ids, null);
        Map subscribeNumMap = this.channelQrcodeStatMapper.queryScanNumMap(ids, Integer.valueOf(1));
        Map subscribePeopleNumMap = this.channelQrcodeStatMapper.queryScanPeopleNum(ids, Integer.valueOf(1));
        ArrayList result = Lists.newArrayList();
        channelQrcodes.forEach(channelQrcode -> result.add(this.newChannelQrcodeRespDto((OfficialChannelQrcode)channelQrcode, appMap, channelMap, userMap, scanNumMap, subscribeNumMap, subscribePeopleNumMap)));
        return result;
    }

    private ChannelQrCodeRespDto newChannelQrcodeRespDto(OfficialChannelQrcode channelQrcode, Map<String, OfficialAccount> appMap, Map<Long, ChannelDto> channelMap, Map<Long, UserInfoRespDto> userMap, Map<Long, Integer> scanNumMap, Map<Long, Integer> subscribeNumMap, Map<Long, Integer> subscribePeopleNumMap) {
        UserInfoRespDto userInfo;
        OfficialAccount app;
        ChannelQrCodeRespDto dto = new ChannelQrCodeRespDto();
        Long id = channelQrcode.getId();
        dto.setId(id);
        dto.setQrCodeName(channelQrcode.getQrcodeName());
        dto.setChannelInfo(channelMap.get(channelQrcode.getChannelId()));
        dto.setUrl(channelQrcode.getUrl());
        dto.setScanNum(scanNumMap.getOrDefault(id, 0));
        dto.setSubscribeNum(subscribeNumMap.getOrDefault(id, 0));
        dto.setSubscribePeopleNum(subscribePeopleNumMap.getOrDefault(id, 0));
        dto.setCreateTime(channelQrcode.getCreateTime());
        dto.setUpdateTime(channelQrcode.getUpdateTime());
        dto.setTagIds(Lists.newArrayList());
        if (StringUtils.isNotBlank((CharSequence)channelQrcode.getTagIds())) {
            List list = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)channelQrcode.getTagIds()).stream().collect(Collectors.toList());
            dto.getTagIds().addAll(list);
        }
        if ((app = appMap.get(channelQrcode.getAppId())) != null) {
            dto.setApp(new AppIdAndNameDto(app.getAppId(), app.getNickName(), app.getHeadImg()));
        }
        if ((userInfo = userMap.get(channelQrcode.getCreatorId())) != null) {
            dto.setCreator(new ModifierDto(userInfo.getId(), userInfo.getUsername(), userInfo.getNickname()));
        }
        if ((userInfo = userMap.get(channelQrcode.getUpdatorId())) != null) {
            dto.setUpdator(new ModifierDto(userInfo.getId(), userInfo.getUsername(), userInfo.getNickname()));
        }
        return dto;
    }

    private void setPage(PageDto pageDto, int count, int currentPageCount) {
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf(count));
            pageDto.setCurPageCount(Integer.valueOf(currentPageCount));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrMod(ChannelQrcodeReqDto params) {
        log.info("add or mod channel qrcode with params={} by operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        params.validate();
        List<String> managerAppIds = this.operatorService.getCurrentManagerAppIds();
        if (CollectionUtils.isEmpty(managerAppIds) || !managerAppIds.contains(params.getAppId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ca1\u6709\u516c\u4f17\u53f7\u64cd\u4f5c\u6743\u9650");
        }
        Long channelId = this.channelMapper.getIdByNum(userInfo.getBizId(), params.getChannelId());
        OfficialChannelQrcode channelQrcode = this.constructEntity(params, channelId);
        OfficialChannelQrcode existQrcode = this.channelQrcodeMapper.getByAppIdAndChannelId(params.getAppId(), channelId);
        if (params.getId() == null) {
            if (existQrcode == null) {
                String encTicket;
                String markId = UUID.randomUUID().toString().replace("-", "");
                channelQrcode.setMarkId(markId);
                String sceneStr = "channel_qr::" + markId;
                CreateQrcodeReqDto reqDto = new CreateQrcodeReqDto();
                reqDto.setAppId(params.getAppId());
                reqDto.setSceneStr(sceneStr);
                CreateQrcodeResult result = this.officialQrcodeService.create(reqDto);
                String ticket = result.getTicket();
                try {
                    encTicket = URLEncoder.encode(ticket, "UTF-8");
                }
                catch (Exception e) {
                    encTicket = ticket;
                }
                String url = String.format("https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=%s", encTicket);
                channelQrcode.setUrl(this.uploadOfficialQrcode(url));
                this.channelQrcodeMapper.insertSelective((Object)channelQrcode);
            } else {
                if (existQrcode.getIsDel() == 0) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b58\u5728\u751f\u6548\u7684\u76f8\u540c\u516c\u4f17\u53f7\u6e20\u9053\u4e8c\u7ef4\u7801");
                }
                BeanUtils.copyProperties((Object)channelQrcode, (Object)existQrcode, (String[])new String[]{"id", "appId", "markId", "url", "createTime", "creatorId", "isDel"});
                existQrcode.setIsDel(Integer.valueOf(0));
                this.channelQrcodeMapper.updateByPrimaryKey((Object)existQrcode);
                OfficialChannelQrcodeStat stat = new OfficialChannelQrcodeStat();
                stat.setOfficialChannelQrcodeId(existQrcode.getId());
                this.channelQrcodeStatMapper.delete((Object)stat);
            }
        } else {
            OfficialChannelQrcode qrcode = this.checkChannelQrcode(params.getId());
            if (existQrcode != null && existQrcode.getIsDel() == 0 && !existQrcode.getId().equals(qrcode.getId())) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b58\u5728\u751f\u6548\u7684\u76f8\u540c\u516c\u4f17\u53f7\u6e20\u9053\u4e8c\u7ef4\u7801");
            }
            BeanUtils.copyProperties((Object)channelQrcode, (Object)qrcode, (String[])new String[]{"id", "appId", "markId", "url", "createTime", "creatorId", "isDel"});
            this.channelQrcodeMapper.updateByPrimaryKey((Object)qrcode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String uploadOfficialQrcode(String url) {
        ResponseEntity response;
        if (StringUtils.isNotBlank((CharSequence)url) && (response = this.restTemplate.getForEntity(url, byte[].class, new Object[0])).getBody() != null && ArrayUtils.isNotEmpty((byte[])((byte[])response.getBody()))) {
            File file = null;
            OutputStream out = null;
            try {
                Path uuidPath = Paths.get("tmp", new String[0]);
                Files.createDirectories(uuidPath, new FileAttribute[0]);
                Path filePath = uuidPath.resolve(UUID.randomUUID() + ".png");
                out = Files.newOutputStream(filePath, new OpenOption[0]);
                out.write((byte[])response.getBody());
                out.flush();
                file = filePath.toFile();
                String string = this.aliyunOss.uploadFile(LoginUtils.getCurrentUserCorpId(), file, file.getName());
                return string;
            }
            catch (Exception e) {
                log.error("io error", (Throwable)e);
                String string = url;
                return string;
            }
            finally {
                if (file != null) {
                    file.delete();
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        log.error("close out error: ", (Throwable)e);
                    }
                }
            }
        }
        return url;
    }

    private OfficialChannelQrcode checkChannelQrcode(Long id) {
        OfficialChannelQrcode channelQrcode = (OfficialChannelQrcode)this.channelQrcodeMapper.selectByPrimaryKey((Object)id);
        if (channelQrcode == null || channelQrcode.getIsDel() == 1) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6e20\u9053\u4e8c\u7ef4\u7801\u4e0d\u5b58\u5728");
        }
        return channelQrcode;
    }

    private OfficialChannelQrcode constructEntity(ChannelQrcodeReqDto params, Long channelId) {
        OfficialChannelQrcode entity = new OfficialChannelQrcode();
        Date now = new Date();
        entity.setQrcodeName(params.getQrCodeName());
        entity.setBizId(LoginUtils.getCurrentUserBizId());
        entity.setCorpId(LoginUtils.getCurrentUserCorpId());
        entity.setChannelId(channelId);
        entity.setUpdatorId(LoginUtils.getCurrentUserId());
        entity.setUpdateTime(now);
        if (CollectionUtils.isNotEmpty(params.getTagIds())) {
            entity.setTagIds(Joiner.on((String)",").join(params.getTagIds()));
        } else {
            entity.setTagIds("");
        }
        if (params.getId() == null) {
            entity.setAppId(params.getAppId());
            entity.setCreatorId(LoginUtils.getCurrentUserId());
            entity.setCreateTime(now);
        }
        return entity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(Long id) {
        log.info("del qrcode with id={} by operatorId={}", (Object)id, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"ID is null");
        OfficialChannelQrcode channelQrcode = this.checkChannelQrcode(id);
        List<String> managerAppIds = this.operatorService.getCurrentManagerAppIds();
        if (CollectionUtils.isEmpty(managerAppIds) || !managerAppIds.contains(channelQrcode.getAppId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ca1\u6709\u516c\u4f17\u53f7\u64cd\u4f5c\u6743\u9650");
        }
        channelQrcode.setIsDel(Integer.valueOf(1));
        this.channelQrcodeMapper.updateByPrimaryKeySelective((Object)channelQrcode);
    }

    @Override
    public boolean onScan(OfficialAccount officialAccount, String openId, String eventKey, boolean isSubscribe) {
        Preconditions.checkArgument((officialAccount != null ? 1 : 0) != 0, (Object)"app is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)openId), (Object)"openId is null");
        if (StringUtils.isBlank((CharSequence)eventKey) || !eventKey.startsWith(CHANNEL_QR_PREFIX)) {
            return false;
        }
        log.info("scan channel qrcode with appId={}, openId={}, eventKey={}, isSubscribe={}", new Object[]{officialAccount.getAppId(), openId, eventKey, isSubscribe});
        String[] eventArr = eventKey.split(CHANNEL_QR_SPLITTER);
        if (eventArr.length != 2) {
            log.warn("\u6e20\u9053\u4e8c\u7ef4\u7801\u6807\u8bc6\u89e3\u6790\u5931\u8d25, eventKey:{}", (Object)eventKey);
            return false;
        }
        String markId = eventArr[1];
        OfficialChannelQrcode channelQrcode = this.channelQrcodeMapper.getByMarkId(markId);
        if (channelQrcode == null) {
            log.warn("\u6e20\u9053\u4e8c\u7ef4\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664,markId={}", (Object)markId);
            return false;
        }
        String appId = officialAccount.getAppId();
        OfficialChannelQrcodeStat stat = new OfficialChannelQrcodeStat();
        stat.setBizId(channelQrcode.getBizId());
        stat.setCorpId(channelQrcode.getCorpId());
        stat.setAppId(appId);
        stat.setOpenId(openId);
        stat.setOfficialChannelQrcodeId(channelQrcode.getId());
        stat.setChannelId(channelQrcode.getChannelId());
        stat.setIsSubscribe(Integer.valueOf(isSubscribe ? 1 : 0));
        this.channelQrcodeStatMapper.insertSelective((Object)stat);
        String tagIdsStr = channelQrcode.getTagIds();
        if (StringUtils.isNotBlank((CharSequence)tagIdsStr)) {
            String[] tagArray = StringUtils.split((String)tagIdsStr, (String)",");
            List<String> tagIds = Arrays.asList(tagArray);
            this.fansTagService.buildFansTags(appId, openId, tagIds, -1L);
        }
        this.recommendService.trigger(officialAccount, openId, BehaviorType.SCAN_QR.getValue(), markId);
        return true;
    }

    @Override
    public OfficialChannelQrcode queryById(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        return this.channelQrcodeMapper.getById(id);
    }

    @Override
    public List<OfficialChannelQrcode> queryByIds(Collection<Long> ids) {
        Set<Long> set = FilterUtils.filterSet(ids);
        if (CollectionUtils.isEmpty(set)) {
            return Collections.emptyList();
        }
        return this.channelQrcodeMapper.getByIds(set);
    }
}

