/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.message.service.impl;

import cn.kinyun.scrm.weixin.sdk.api.WxTemplateMsgAPI;
import cn.kinyun.scrm.weixin.sdk.entity.message.mass.resp.MsgId;
import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.MiniProgram;
import cn.kinyun.scrm.weixin.sdk.entity.template.TemplateMsg;
import cn.kinyun.scrm.weixin.sdk.entity.template.TemplateParam;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.OfficialTokenService;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.enums.OfficialMsgTypeEnum;
import com.kuaike.scrm.common.service.ScrmOfficialMsgService;
import com.kuaike.scrm.common.service.dto.req.SendOfficialMsgReq;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMsgTemplate;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountTemplateMsg;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMsgTemplateMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountTemplateMsgMapper;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialAccountFansMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScrmOfficialMsgServiceImpl
implements ScrmOfficialMsgService {
    private static final Logger log = LoggerFactory.getLogger(ScrmOfficialMsgServiceImpl.class);
    @Resource
    private OfficialAccountMapper officialAccountMapper;
    @Resource
    private OfficialAccountMsgTemplateMapper msgTemplateMapper;
    @Resource
    private OfficialAccountFansMapper fansMapper;
    @Resource
    private OfficialAccountTemplateMsgMapper templateMsgMapper;
    @Resource
    private WxTemplateMsgAPI wxTemplateMsgApi;
    @Resource
    private OfficialTokenService officialTokenService;

    public void sendOfficialTemplateMsg(SendOfficialMsgReq req) {
        log.info("sendOfficialTemplateMsg,req:{}", (Object)req);
        req.validateParams();
        OfficialMsgTypeEnum msgTypeEnum = OfficialMsgTypeEnum.get((Integer)req.getMsgType());
        List msgTemplates = this.msgTemplateMapper.selectByBizIdAndTemplateName(req.getBizId(), msgTypeEnum.getTemplateName());
        if (CollectionUtils.isEmpty((Collection)msgTemplates)) {
            log.info("\u6839\u636ebizId:{},templateName:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)req.getBizId(), (Object)msgTypeEnum.getTemplateName());
            return;
        }
        Map appId2ContentMap = msgTemplates.stream().collect(Collectors.toMap(OfficialAccountMsgTemplate::getAppId, Functions.identity()));
        List officialAccounts = this.officialAccountMapper.selectAuthedByBizIdAndAppIds(req.getBizId(), appId2ContentMap.keySet());
        if (CollectionUtils.isEmpty((Collection)officialAccounts)) {
            log.info("\u6839\u636ebizId:{},appIds:{}\u672a\u67e5\u8be2\u5230\u5df2\u6388\u6743\u7684\u516c\u4f17\u53f7", (Object)req.getBizId(), appId2ContentMap.keySet());
            return;
        }
        for (OfficialAccount officialAccount : officialAccounts) {
            List openIds = this.fansMapper.selectOpenIdsByAppIdAndUnionIds(officialAccount.getAppId(), (Collection)req.getUnionIds());
            if (CollectionUtils.isEmpty((Collection)openIds)) {
                log.info("\u6839\u636eappId:{},unionIds:{}\u672a\u67e5\u8be2\u5230\u7c89\u4e1d", (Object)officialAccount.getAppId(), (Object)req.getUnionIds());
                continue;
            }
            OfficialAccountMsgTemplate msgTemplate = (OfficialAccountMsgTemplate)appId2ContentMap.get(officialAccount.getAppId());
            Map<String, TemplateParam> templateParamMap = this.buildTemplateData(msgTemplate, msgTypeEnum, req);
            if (MapUtils.isEmpty(templateParamMap)) {
                log.info("\u6839\u636etemplateContent:{}\u672a\u83b7\u53d6\u5230\u6a21\u677f\u6570\u636e", (Object)msgTemplate.getContent());
                continue;
            }
            Date expireTime = DateUtils.addMinutes((Date)new Date(), (int)15);
            String accessToken = StringUtils.isNotBlank((CharSequence)officialAccount.getAccessToken()) && expireTime.before(officialAccount.getTokenExpireTime()) ? officialAccount.getAccessToken() : this.officialTokenService.refreshAccessToken(officialAccount);
            TemplateMsg templateMsg = new TemplateMsg();
            templateMsg.setTemplateId(msgTemplate.getTemplateId());
            if (StringUtils.isNotBlank((CharSequence)req.getAppId()) && StringUtils.isNotBlank((CharSequence)req.getPagePath())) {
                MiniProgram miniProgram = new MiniProgram();
                miniProgram.setAppId(req.getAppId());
                miniProgram.setPagePath(req.getPagePath());
                templateMsg.setMiniProgram(miniProgram);
            } else if (StringUtils.isNotBlank((CharSequence)req.getPagePath())) {
                templateMsg.setUrl(req.getPagePath());
            }
            MsgId msgId = null;
            WeixinException weixinException = null;
            for (String openId : openIds) {
                templateMsg.setToUserName(openId);
                templateMsg.setData(templateParamMap);
                try {
                    msgId = this.wxTemplateMsgApi.sendTemplateMsg(accessToken, templateMsg);
                }
                catch (WeixinException e) {
                    weixinException = e;
                    log.error("params:{},\u53d1\u9001\u6a21\u677f\u6d88\u606f\u5931\u8d25:", (Object)templateMsg, (Object)e);
                }
                this.addSaveTemplateMsg(officialAccount.getAppId(), openId, msgTemplate.getTemplateId(), req.getBizId(), msgId, templateMsg, weixinException);
            }
        }
    }

    public List<String> getExistUnionIds(List<String> unionIds) {
        if (CollectionUtils.isEmpty(unionIds)) {
            log.info("unionIds is empty");
            return Collections.emptyList();
        }
        return this.fansMapper.querySubscribedUnionIdsByUnionIds(unionIds);
    }

    public String queryUnionIdAppIdOpenId(String appId, String openId) {
        return this.fansMapper.getUnionIdByOpenIdAppIdAndOpenId(appId, openId);
    }

    private Map<String, TemplateParam> buildTemplateData(OfficialAccountMsgTemplate msgTemplate, OfficialMsgTypeEnum msgTypeEnum, SendOfficialMsgReq req) {
        Map<String, String> variableMap = this.variableParser(msgTemplate.getContent());
        if (MapUtils.isEmpty(variableMap)) {
            log.info("templateContent:{}\u4e2d\u672a\u8bbe\u7f6e\u53d8\u91cf", (Object)msgTemplate.getContent());
            return Maps.newHashMap();
        }
        HashMap templateParamMap = Maps.newHashMap();
        for (Map.Entry<String, String> entry : variableMap.entrySet()) {
            TemplateParam templateParam = new TemplateParam();
            switch (msgTypeEnum) {
                case TEACHER_FEEDBACK_NOTICE: 
                case MOCK_EXAM_SCORE_NOTICE: 
                case RANKING_NOTICE: {
                    if ("\u8003\u8bd5\u7ed3\u679c".equals(entry.getKey())) {
                        templateParam.setValue(req.getContent());
                        templateParamMap.put(entry.getValue(), templateParam);
                        break;
                    }
                    if (!"\u8003\u8bd5\u65f6\u95f4".equals(entry.getKey())) break;
                    templateParam.setValue(DateUtil.dateToDateString((Date)new Date(), (String)"yyyy-MM-dd"));
                    templateParamMap.put(entry.getValue(), templateParam);
                    break;
                }
                case ASSIGNMENT_SUBMISSION_NOTICE: {
                    if ("\u8003\u8bd5\u5185\u5bb9".equals(entry.getKey())) {
                        templateParam.setValue(req.getContent());
                        templateParamMap.put(entry.getValue(), templateParam);
                        break;
                    }
                    if (!"\u8003\u8bd5\u65f6\u95f4".equals(entry.getKey())) break;
                    templateParam.setValue(DateUtil.dateToDateString((Date)new Date(), (String)"yyyy-MM-dd"));
                    templateParamMap.put(entry.getValue(), templateParam);
                    break;
                }
                case COURSE_COMMENCEMENT_NOTICE: {
                    if ("\u8bfe\u7a0b\u540d\u79f0".equals(entry.getKey())) {
                        templateParam.setValue(req.getCourseName());
                        templateParamMap.put(entry.getValue(), templateParam);
                        break;
                    }
                    if ("\u4e0a\u8bfe\u65f6\u95f4".equals(entry.getKey())) {
                        templateParam.setValue(req.getClassSchedule());
                        templateParamMap.put(entry.getValue(), templateParam);
                        break;
                    }
                    if ("\u4e0a\u8bfe\u5730\u70b9".equals(entry.getKey())) {
                        templateParam.setValue(req.getAddress());
                        templateParamMap.put(entry.getValue(), templateParam);
                        break;
                    }
                    if (!"\u4efb\u8bfe\u6559\u5e08".equals(entry.getKey())) break;
                    templateParam.setValue(req.getTeacherName());
                    templateParamMap.put(entry.getValue(), templateParam);
                    break;
                }
                case ORDER_NOTICE: {
                    if ("\u5b66\u5458\u59d3\u540d".equals(entry.getKey())) {
                        templateParam.setValue(req.getStudentName());
                        templateParamMap.put(entry.getValue(), templateParam);
                        break;
                    }
                    if ("\u5546\u54c1".equals(entry.getKey())) {
                        templateParam.setValue(req.getCourseName());
                        templateParamMap.put(entry.getValue(), templateParam);
                        break;
                    }
                    if ("\u8ba2\u5355\u7f16\u53f7".equals(entry.getKey())) {
                        templateParam.setValue(req.getOrderNum());
                        templateParamMap.put(entry.getValue(), templateParam);
                        break;
                    }
                    if ("\u4e0b\u5355\u65f6\u95f4".equals(entry.getKey())) {
                        templateParam.setValue(req.getOrderCreateTime());
                        templateParamMap.put(entry.getValue(), templateParam);
                        break;
                    }
                    if (!"\u8ba2\u5355\u91d1\u989d".equals(entry.getKey())) break;
                    templateParam.setValue(req.getTotalAmount());
                    templateParamMap.put(entry.getValue(), templateParam);
                    break;
                }
            }
        }
        return templateParamMap;
    }

    private Map<String, String> variableParser(String content) {
        Pattern pattern = Pattern.compile("([^:]+):\\{\\{([^{}]+)}}");
        Matcher matcher = pattern.matcher(content);
        HashMap<String, String> variableMap = new HashMap<String, String>();
        while (matcher.find()) {
            String key = matcher.group(1).trim();
            String value = matcher.group(2).trim().replace(".DATA", "");
            variableMap.put(key, value);
        }
        return variableMap;
    }

    private void addSaveTemplateMsg(String appId, String toUserName, String templateId, Long bizId, MsgId msgId, TemplateMsg templateMsg, WeixinException weixinException) {
        OfficialAccountTemplateMsg message = new OfficialAccountTemplateMsg();
        message.setAppId(appId);
        message.setOpenId(toUserName);
        message.setMsgId(msgId == null ? "" : msgId.getMsgId());
        message.setTemplateId(templateId);
        message.setTemplateData(JacksonUtil.obj2Str((Object)templateMsg.getData()));
        message.setBizId(bizId);
        if (Objects.nonNull((Object)weixinException)) {
            String errorMsg = weixinException.getErrorMsg();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errorMsg}) && errorMsg.length() > 400) {
                errorMsg = errorMsg.substring(0, 400);
            }
            message.setFailReason(errorMsg);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{templateMsg.getUrl()})) {
            message.setTemplateUrl(templateMsg.getUrl());
        }
        if (templateMsg.getMiniProgram() != null) {
            message.setTemplateMiniProgram(JacksonUtil.obj2Str((Object)templateMsg.getMiniProgram()));
        }
        message.setCreatorId(NumberUtils.LONG_MINUS_ONE);
        message.setCreateTime(new Date());
        this.templateMsgMapper.insertSelective((Object)message);
    }
}

