/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.message.dto;

import cn.kinyun.scrm.weixin.enums.message.SendWay;
import cn.kinyun.scrm.weixin.officialaccount.dto.req.BaseParameterDto;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.dal.weworktag.WeworkTagDto;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MassMessageSendCondition
extends BaseParameterDto {
    private static final Logger log = LoggerFactory.getLogger(MassMessageSendCondition.class);
    private Long id;
    private List<String> appIds;
    private Integer sendScope = 1;
    private List<String> tagIds;
    private List<IdAndNameDto> areaInfo;
    private Integer sex;
    private Integer tagRelation;
    private Integer sendWay = 1;
    private Date sendTime;
    private Integer sendDateType;
    private String sendTimeStr;
    private String materialType;
    private Long materialId = 0L;
    private List<WeworkTagDto> tags;
    private PageDto pageDto;
    private String content;

    public void validate(boolean strictCheck) {
        if (strictCheck) {
            this.commonValidate();
        }
        this.baseValidate();
        if (strictCheck && this.sendWay.intValue() == SendWay.DELAY.getValue()) {
            if (this.sendDateType != null && StringUtils.isNotBlank((CharSequence)this.sendTimeStr)) {
                LocalDateTime baseTime = LocalDateTime.now();
                if (this.sendDateType == 2) {
                    baseTime = baseTime.plusDays(1L);
                }
                String dateStr = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(baseTime);
                String dateTimeStr = dateStr + this.sendTimeStr;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-ddHH:mm", Locale.getDefault());
                try {
                    this.sendTime = sdf.parse(dateTimeStr);
                }
                catch (ParseException e) {
                    log.error("\u89e3\u6790\u53d1\u9001\u65f6\u95f4\u5931\u8d25, dateTimeStr={}", (Object)dateTimeStr, (Object)e);
                }
            } else {
                Preconditions.checkArgument((this.sendTime != null ? 1 : 0) != 0, (Object)"sendTime is null");
            }
        }
        Preconditions.checkArgument((SendWay.getByValue(this.sendWay) != null ? 1 : 0) != 0, (Object)"sendWay is error");
        Preconditions.checkArgument((boolean)Lists.newArrayList((Object[])new String[]{"text", "lead", "news", "voice", "image", "video", "fission"}).contains(this.materialType), (Object)"materialType is error");
        if (this.materialType.equalsIgnoreCase("text") && (this.materialId == null || this.materialId <= 0L)) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.content), (Object)"\u6587\u672c\u7fa4\u53d1\u8f93\u5165\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            Preconditions.checkArgument((this.materialId != null ? 1 : 0) != 0, (Object)"materialId is blank");
        }
    }

    public void baseValidate() {
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.appIds), (Object)"appIds are empty");
        Preconditions.checkArgument((this.sendScope != null ? 1 : 0) != 0, (Object)"sendScope is null");
        Preconditions.checkArgument((SendScope.getByValue(this.sendScope) != null ? 1 : 0) != 0, (Object)"sendScope is error");
        Preconditions.checkArgument((TagRelation.getByValue(this.tagRelation) != null ? 1 : 0) != 0, (Object)"tagRelation is null");
    }

    public Long getId() {
        return this.id;
    }

    public List<String> getAppIds() {
        return this.appIds;
    }

    public Integer getSendScope() {
        return this.sendScope;
    }

    public List<String> getTagIds() {
        return this.tagIds;
    }

    public List<IdAndNameDto> getAreaInfo() {
        return this.areaInfo;
    }

    public Integer getSex() {
        return this.sex;
    }

    public Integer getTagRelation() {
        return this.tagRelation;
    }

    public Integer getSendWay() {
        return this.sendWay;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public Integer getSendDateType() {
        return this.sendDateType;
    }

    public String getSendTimeStr() {
        return this.sendTimeStr;
    }

    public String getMaterialType() {
        return this.materialType;
    }

    public Long getMaterialId() {
        return this.materialId;
    }

    public List<WeworkTagDto> getTags() {
        return this.tags;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public String getContent() {
        return this.content;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAppIds(List<String> appIds) {
        this.appIds = appIds;
    }

    public void setSendScope(Integer sendScope) {
        this.sendScope = sendScope;
    }

    public void setTagIds(List<String> tagIds) {
        this.tagIds = tagIds;
    }

    public void setAreaInfo(List<IdAndNameDto> areaInfo) {
        this.areaInfo = areaInfo;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public void setTagRelation(Integer tagRelation) {
        this.tagRelation = tagRelation;
    }

    public void setSendWay(Integer sendWay) {
        this.sendWay = sendWay;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public void setSendDateType(Integer sendDateType) {
        this.sendDateType = sendDateType;
    }

    public void setSendTimeStr(String sendTimeStr) {
        this.sendTimeStr = sendTimeStr;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    public void setTags(List<WeworkTagDto> tags) {
        this.tags = tags;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public String toString() {
        return "MassMessageSendCondition(id=" + this.getId() + ", appIds=" + this.getAppIds() + ", sendScope=" + this.getSendScope() + ", tagIds=" + this.getTagIds() + ", areaInfo=" + this.getAreaInfo() + ", sex=" + this.getSex() + ", tagRelation=" + this.getTagRelation() + ", sendWay=" + this.getSendWay() + ", sendTime=" + this.getSendTime() + ", sendDateType=" + this.getSendDateType() + ", sendTimeStr=" + this.getSendTimeStr() + ", materialType=" + this.getMaterialType() + ", materialId=" + this.getMaterialId() + ", tags=" + this.getTags() + ", pageDto=" + this.getPageDto() + ", content=" + this.getContent() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MassMessageSendCondition)) {
            return false;
        }
        MassMessageSendCondition other = (MassMessageSendCondition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$sendScope = this.getSendScope();
        Integer other$sendScope = other.getSendScope();
        if (this$sendScope == null ? other$sendScope != null : !((Object)this$sendScope).equals(other$sendScope)) {
            return false;
        }
        Integer this$sex = this.getSex();
        Integer other$sex = other.getSex();
        if (this$sex == null ? other$sex != null : !((Object)this$sex).equals(other$sex)) {
            return false;
        }
        Integer this$tagRelation = this.getTagRelation();
        Integer other$tagRelation = other.getTagRelation();
        if (this$tagRelation == null ? other$tagRelation != null : !((Object)this$tagRelation).equals(other$tagRelation)) {
            return false;
        }
        Integer this$sendWay = this.getSendWay();
        Integer other$sendWay = other.getSendWay();
        if (this$sendWay == null ? other$sendWay != null : !((Object)this$sendWay).equals(other$sendWay)) {
            return false;
        }
        Integer this$sendDateType = this.getSendDateType();
        Integer other$sendDateType = other.getSendDateType();
        if (this$sendDateType == null ? other$sendDateType != null : !((Object)this$sendDateType).equals(other$sendDateType)) {
            return false;
        }
        Long this$materialId = this.getMaterialId();
        Long other$materialId = other.getMaterialId();
        if (this$materialId == null ? other$materialId != null : !((Object)this$materialId).equals(other$materialId)) {
            return false;
        }
        List<String> this$appIds = this.getAppIds();
        List<String> other$appIds = other.getAppIds();
        if (this$appIds == null ? other$appIds != null : !((Object)this$appIds).equals(other$appIds)) {
            return false;
        }
        List<String> this$tagIds = this.getTagIds();
        List<String> other$tagIds = other.getTagIds();
        if (this$tagIds == null ? other$tagIds != null : !((Object)this$tagIds).equals(other$tagIds)) {
            return false;
        }
        List<IdAndNameDto> this$areaInfo = this.getAreaInfo();
        List<IdAndNameDto> other$areaInfo = other.getAreaInfo();
        if (this$areaInfo == null ? other$areaInfo != null : !((Object)this$areaInfo).equals(other$areaInfo)) {
            return false;
        }
        Date this$sendTime = this.getSendTime();
        Date other$sendTime = other.getSendTime();
        if (this$sendTime == null ? other$sendTime != null : !((Object)this$sendTime).equals(other$sendTime)) {
            return false;
        }
        String this$sendTimeStr = this.getSendTimeStr();
        String other$sendTimeStr = other.getSendTimeStr();
        if (this$sendTimeStr == null ? other$sendTimeStr != null : !this$sendTimeStr.equals(other$sendTimeStr)) {
            return false;
        }
        String this$materialType = this.getMaterialType();
        String other$materialType = other.getMaterialType();
        if (this$materialType == null ? other$materialType != null : !this$materialType.equals(other$materialType)) {
            return false;
        }
        List<WeworkTagDto> this$tags = this.getTags();
        List<WeworkTagDto> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        if (this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MassMessageSendCondition;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $sendScope = this.getSendScope();
        result = result * 59 + ($sendScope == null ? 43 : ((Object)$sendScope).hashCode());
        Integer $sex = this.getSex();
        result = result * 59 + ($sex == null ? 43 : ((Object)$sex).hashCode());
        Integer $tagRelation = this.getTagRelation();
        result = result * 59 + ($tagRelation == null ? 43 : ((Object)$tagRelation).hashCode());
        Integer $sendWay = this.getSendWay();
        result = result * 59 + ($sendWay == null ? 43 : ((Object)$sendWay).hashCode());
        Integer $sendDateType = this.getSendDateType();
        result = result * 59 + ($sendDateType == null ? 43 : ((Object)$sendDateType).hashCode());
        Long $materialId = this.getMaterialId();
        result = result * 59 + ($materialId == null ? 43 : ((Object)$materialId).hashCode());
        List<String> $appIds = this.getAppIds();
        result = result * 59 + ($appIds == null ? 43 : ((Object)$appIds).hashCode());
        List<String> $tagIds = this.getTagIds();
        result = result * 59 + ($tagIds == null ? 43 : ((Object)$tagIds).hashCode());
        List<IdAndNameDto> $areaInfo = this.getAreaInfo();
        result = result * 59 + ($areaInfo == null ? 43 : ((Object)$areaInfo).hashCode());
        Date $sendTime = this.getSendTime();
        result = result * 59 + ($sendTime == null ? 43 : ((Object)$sendTime).hashCode());
        String $sendTimeStr = this.getSendTimeStr();
        result = result * 59 + ($sendTimeStr == null ? 43 : $sendTimeStr.hashCode());
        String $materialType = this.getMaterialType();
        result = result * 59 + ($materialType == null ? 43 : $materialType.hashCode());
        List<WeworkTagDto> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public static enum TagRelation {
        AND(0),
        OR(1);

        private final Integer value;
        private static final Map<Integer, TagRelation> CACHE;

        private TagRelation(Integer value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static TagRelation getByValue(Integer value) {
            if (value == null) {
                return null;
            }
            return CACHE.get(value);
        }

        static {
            CACHE = Arrays.stream(TagRelation.values()).collect(Collectors.toMap(TagRelation::getValue, Function.identity()));
        }
    }

    public static enum SendScope {
        PART(0),
        EXCLUDE(-1),
        ALL(1);

        private final Integer value;
        private static final Map<Integer, SendScope> CACHE;

        private SendScope(Integer value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static SendScope getByValue(Integer value) {
            if (value == null) {
                return null;
            }
            return CACHE.get(value);
        }

        static {
            CACHE = Arrays.stream(SendScope.values()).collect(Collectors.toMap(SendScope::getValue, Function.identity()));
        }
    }
}

