/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.menu.service.impl;

import cn.kinyun.scrm.weixin.enums.MaterialType;
import cn.kinyun.scrm.weixin.enums.PlateformType;
import cn.kinyun.scrm.weixin.enums.WechatMenuBottonType;
import cn.kinyun.scrm.weixin.enums.biz.ClickEventBizType;
import cn.kinyun.scrm.weixin.material.dto.req.MaterialCommonDtoReq;
import cn.kinyun.scrm.weixin.material.service.CommonMaterialService;
import cn.kinyun.scrm.weixin.material.service.FansMediaUploadService;
import cn.kinyun.scrm.weixin.material.service.MaterialUploadService;
import cn.kinyun.scrm.weixin.material.service.OfficalMaterialSyncService;
import cn.kinyun.scrm.weixin.menu.dto.req.AppIdReq;
import cn.kinyun.scrm.weixin.menu.dto.req.CreateMenuReq;
import cn.kinyun.scrm.weixin.menu.service.MenuManageService;
import cn.kinyun.scrm.weixin.menu.service.OfficialMenuService;
import cn.kinyun.scrm.weixin.message.dto.MsgData;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialAccountService;
import cn.kinyun.scrm.weixin.sdk.api.menu.MenuAPI;
import cn.kinyun.scrm.weixin.sdk.emoji.WxEmojiUtils;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.menu.dto.MenuButton;
import cn.kinyun.scrm.weixin.sdk.entity.menu.dto.MenuButtonConf;
import cn.kinyun.scrm.weixin.sdk.entity.menu.dto.MenuInfo;
import cn.kinyun.scrm.weixin.sdk.entity.menu.dto.NewsInfo;
import cn.kinyun.scrm.weixin.sdk.entity.menu.dto.SubButtonConf;
import cn.kinyun.scrm.weixin.sdk.entity.menu.req.MenuCreateEntity;
import cn.kinyun.scrm.weixin.sdk.entity.menu.resp.CustomizedMenuConfResp;
import cn.kinyun.scrm.weixin.sdk.entity.menu.resp.SelfMenuInfo;
import cn.kinyun.scrm.weixin.sdk.enums.menu.MenuButtonType;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.OfficialTokenService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.HttpClientUtils;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMaterial;
import com.kuaike.scrm.dal.official.base.entity.OfficialMenu;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMaterialMapper;
import com.kuaike.scrm.dal.official.material.dto.MaterialResultDto;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterial;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialMapper;
import com.kuaike.scrm.dal.official.reply.entity.OfficialMenuTextReply;
import com.kuaike.scrm.dal.official.reply.mapper.OfficialMenuTextReplyMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MenuManageServiceImpl
implements MenuManageService {
    private static final Logger log = LoggerFactory.getLogger(MenuManageServiceImpl.class);
    @Autowired
    private MenuAPI menuAPI;
    @Autowired
    private OfficialTokenService officialTokenService;
    @Autowired
    private OfficialMenuService officialMenuService;
    @Autowired
    private CommonMaterialService commonMaterialService;
    @Resource
    private OfficialMenuTextReplyMapper textReplyMapper;
    @Autowired
    private FansMediaUploadService mediaUploadService;
    @Autowired
    private MaterialUploadService materialUploadService;
    @Autowired
    private OfficalMaterialSyncService materialSyncService;
    @Resource
    private OfficialMaterialMapper materialMapper;
    @Resource
    private OfficialAccountMaterialMapper officialAccountMaterialMapper;
    @Autowired
    private OfficialAccountService officialAccountService;
    private static final String CLICK_EVENT_INTERNAL_SPLITTER = "::";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createMenu(CreateMenuReq req) {
        log.info("createMenu with req={}", (Object)req);
        Long bizId = LoginUtils.getCurrentUserBizId();
        Long bindBizId = this.officialAccountService.queryBuIdByAppId(req.getAppId());
        if (!Objects.equals(bizId, bindBizId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "appId\u53c2\u6570\u4e0d\u5bf9\u6216\u516c\u4f17\u53f7\u4e0d\u5728\u5f53\u524d\u5546\u6237\u4e0b");
        }
        StopWatchDto timer = new StopWatchDto("createMenuTimer", true, log);
        timer.start("preUpLoad");
        this.preUpLoad(req);
        timer.stop();
        timer.start("getOfficialAccessToken");
        String accessToken = this.officialTokenService.getOfficialAccessToken(req.getAppId());
        timer.stop();
        this.createWxMenu(req.getAppId(), req.getMenuList(), timer, accessToken);
        CustomizedMenuConfResp resp = this.menuAPI.queryCustomizedMenuConf(accessToken);
        this.setPlatformMatInfo(resp);
        timer.start("queryAndInsert");
        this.insertOrUpdateMenu(req.getAppId(), req.getOperatorId(), resp);
        timer.stop();
        timer.print();
    }

    private void createWxMenu(String appId, MenuCreateEntity entity, StopWatchDto timer, String accessToken) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{accessToken})) {
            timer.start("getOfficialAccessToken");
            accessToken = this.officialTokenService.getOfficialAccessToken(appId);
            timer.stop();
        }
        timer.start("createMenu");
        try {
            this.menuAPI.createMenu(accessToken, entity);
        }
        catch (WeixinException e) {
            if (e.getErrorCode() == 40033) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83dc\u5355\u5305\u542b\u4e0d\u652f\u6301\u7684\u8868\u60c5\u6216\u5b57\u7b26");
            }
            throw e;
        }
        timer.stop();
    }

    private void preUpLoad(CreateMenuReq req) {
        req.validate();
        if (CollectionUtils.isEmpty((Collection)req.getMenuList().getButton())) {
            return;
        }
        this.transfer(req.getMenuList().getButton(), req.getAppId());
    }

    private void transfer(List<MenuButton> buttons, String appId) {
        if (CollectionUtils.isEmpty(buttons)) {
            return;
        }
        for (MenuButton button : buttons) {
            Long materialId;
            if (CollectionUtils.isNotEmpty((Collection)button.getSubButton())) {
                this.transfer(button.getSubButton(), appId);
                continue;
            }
            if (!MenuButtonType.media_id.getType().equals(button.getType()) || (materialId = button.getMatId()) == null) continue;
            MsgData msgData = this.commonMaterialService.convertMaterialMsg(materialId, appId);
            button.setMediaType(msgData.getMediaType());
            button.setType(MenuButtonType.click.getType());
            button.setKey(ClickEventBizType.MATERIAL.getKey() + CLICK_EVENT_INTERNAL_SPLITTER + materialId);
        }
    }

    private CustomizedMenuConfResp insertOrUpdateMenu(String appId, Long operatorId, CustomizedMenuConfResp resp) {
        ObjectMapper objectMapper = new ObjectMapper();
        String contentJson = null;
        try {
            contentJson = objectMapper.writeValueAsString((Object)resp);
        }
        catch (JsonProcessingException e) {
            log.error("json\u89e3\u6790\u5931\u8d25, resp:{}", (Object)resp, (Object)e);
        }
        if (contentJson != null) {
            this.officialMenuService.insertOrUpdate(appId, contentJson, operatorId);
        }
        return resp;
    }

    private void transferButtons(List<MenuButtonConf> buttons, String appId) {
        if (CollectionUtils.isEmpty(buttons)) {
            return;
        }
        for (MenuButtonConf button : buttons) {
            this.transferButton(button, appId);
            this.transferButtons(Optional.ofNullable(button.getSubButton()).map(SubButtonConf::getList).orElse(null), appId);
        }
    }

    private void transferButton(MenuButtonConf button, String appId) {
        button.setName(WxEmojiUtils.decode((String)button.getName()));
        if (StringUtils.isBlank((CharSequence)button.getType())) {
            return;
        }
        Set mediaTypes = Stream.of(WechatMenuBottonType.IMG.getType(), WechatMenuBottonType.VOICE.getType(), WechatMenuBottonType.VIDEO.getType(), WechatMenuBottonType.NEWS.getType(), MenuButtonType.media_id.getType()).collect(Collectors.toSet());
        if (button.getType().equalsIgnoreCase(WechatMenuBottonType.TEXT.getType())) {
            this.transferText(button, appId);
        } else if (mediaTypes.contains(button.getType().toLowerCase(Locale.getDefault()))) {
            this.transferMedia(button, appId);
        }
    }

    private void transferMedia(MenuButtonConf button, String appId) {
        String mediaId;
        MaterialResultDto material;
        if (WechatMenuBottonType.IMG.getType().equalsIgnoreCase(button.getType())) {
            File file = this.mediaUploadService.download(appId, button.getValue());
            this.dealImgMenu(button, appId, file);
        } else if (WechatMenuBottonType.VOICE.getType().equalsIgnoreCase(button.getType())) {
            File file = this.mediaUploadService.download(appId, button.getValue());
            this.dealVoiceMenu(button, appId, file);
        } else if (WechatMenuBottonType.VIDEO.getType().equalsIgnoreCase(button.getType())) {
            button.setType(MenuButtonType.view.getType());
            button.setUrl(button.getValue());
        } else if (WechatMenuBottonType.NEWS.getType().equalsIgnoreCase(button.getType())) {
            this.dealNewsMenu(button, appId);
        } else if (MenuButtonType.media_id.getType().equalsIgnoreCase(button.getType()) && (material = this.commonMaterialService.getByMediaId(mediaId = button.getMediaId())) != null) {
            this.setButtonInfo(button, (OfficialMaterial)material);
            button.setMediaId(null);
        }
        button.setValue(null);
    }

    private void dealNewsMenu(MenuButtonConf button, String appId) {
        NewsInfo newsInfo = button.getNewsInfo();
        if (newsInfo != null && CollectionUtils.isNotEmpty((Collection)newsInfo.getList())) {
            List newInfoItems = newsInfo.getList();
            OfficialMaterial material = this.buildNewsMaterial(newInfoItems, appId, button.getValue());
            this.setButtonInfo(button, material);
        }
    }

    private void dealVoiceMenu(MenuButtonConf button, String appId, File file) {
        String mediaUrl = this.materialUploadService.upload(file, file.getName());
        OfficialMaterial material = this.checkAndSaveMaterial(mediaUrl, MaterialType.VOICE, "\u516c\u4f17\u53f7\u83dc\u5355_\u540c\u6b65\u97f3\u9891\u7d20\u6750", null, null, "\u516c\u4f17\u53f7\u83dc\u5355_\u540c\u6b65\u97f3\u9891\u7d20\u6750", null, 0, 0L);
        this.materialSyncService.syncVoiceMaterial(material, appId);
        this.setButtonInfo(button, material);
    }

    private void dealImgMenu(MenuButtonConf button, String appId, File file) {
        String mediaUrl = this.materialUploadService.upload(file, file.getName());
        OfficialMaterial material = this.checkAndSaveMaterial(mediaUrl, MaterialType.IMAGE, "\u516c\u4f17\u53f7\u83dc\u5355_\u540c\u6b65\u56fe\u7247\u7d20\u6750", null, null, "\u516c\u4f17\u53f7\u83dc\u5355_\u540c\u6b65\u56fe\u7247\u7d20\u6750", null, 0, 0L);
        this.materialSyncService.syncImageMaterial(material, appId);
        this.setButtonInfo(button, material);
    }

    private void setButtonInfo(MenuButtonConf button, OfficialMaterial material) {
        if (button != null && material != null) {
            String clickKeyPrefix = ClickEventBizType.MATERIAL.getKey() + CLICK_EVENT_INTERNAL_SPLITTER;
            button.setMediaType(material.getmType());
            button.setMatId(material.getId());
            button.setType(MenuButtonType.click.getType());
            button.setKey(clickKeyPrefix + material.getId());
        }
    }

    private OfficialMaterial buildNewsMaterial(List<NewsInfo.NewInfoItem> newInfoItems, String appId, String mediaId) {
        OfficialAccountMaterial officialAccountMaterial = this.officialAccountMaterialMapper.getByMediaId(mediaId, appId);
        if (officialAccountMaterial != null) {
            log.info("\u56fe\u6587\u7d20\u6750\u5728\u672c\u5730\u5df2\u7ecf\u5b58\u5728\uff0c\u65e0\u9700\u540c\u6b65");
            OfficialMaterial material = (OfficialMaterial)this.materialMapper.selectByPrimaryKey((Object)officialAccountMaterial.getMaterialId());
            if (material != null) {
                return material;
            }
            log.warn("official material exists, but corresponding material miss, officialMaterial={}", (Object)officialAccountMaterial);
        }
        String parentNewsTitle = newInfoItems.stream().map(NewsInfo.NewInfoItem::getTitle).collect(Collectors.joining(";"));
        String parentNewsCover = newInfoItems.stream().map(NewsInfo.NewInfoItem::getCoverUrl).collect(Collectors.joining(";"));
        OfficialMaterial parentM = this.checkAndSaveMaterial(null, MaterialType.NEWS, parentNewsTitle, "", parentNewsCover, "", "", newInfoItems.size(), 0L);
        this.officialAccountMaterialMapper.insertSelective((Object)this.buildOfficialMaterial(parentM.getId(), appId, mediaId));
        ArrayList materials = Lists.newArrayList();
        for (int i = 0; i < newInfoItems.size(); ++i) {
            NewsInfo.NewInfoItem item = newInfoItems.get(i);
            materials.add(this.buildMaterial(null, MaterialType.NEWS, item.getTitle(), item.getAuthor(), item.getCoverUrl(), item.getDigest(), MenuManageServiceImpl.getNewsContent(item.getContentUrl()), i, parentM.getId()));
        }
        this.materialMapper.insertBatch((List)materials);
        return parentM;
    }

    private OfficialAccountMaterial buildOfficialMaterial(Long materialId, String appId, String mediaId) {
        OfficialAccountMaterial officialAccountMaterial = new OfficialAccountMaterial();
        officialAccountMaterial.setMaterialId(materialId);
        officialAccountMaterial.setAppId(appId);
        officialAccountMaterial.setMediaId(mediaId);
        officialAccountMaterial.setCreateTime(new Date());
        officialAccountMaterial.setUpdateTime(new Date());
        return officialAccountMaterial;
    }

    private static String getNewsContent(String contentUrl) {
        try {
            String htmlContent = HttpClientUtils.doGet((String)contentUrl, (Map)Maps.newHashMap(), (String)"UTF-8");
            String regex = "[\\s\\S]*<div class=\"rich_media_content \" id=\"js_content\".*>([\\s\\S]*)</div>[\\s\\S]*";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(htmlContent);
            if (m.matches()) {
                int index;
                String content = m.group(1);
                for (index = 0; index < content.length() && content.charAt(index) != '<'; ++index) {
                }
                return content.substring(index);
            }
        }
        catch (Exception e) {
            log.error("get news content error", (Throwable)e);
        }
        return "";
    }

    private OfficialMaterial checkAndSaveMaterial(String mediaUrl, MaterialType materialType, String title, String author, String cover, String digest, String content, int num, long pid) {
        OfficialMaterial material;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mediaUrl}) && (material = this.materialMapper.queryByUrl(mediaUrl)) != null) {
            return material;
        }
        material = this.buildMaterial(mediaUrl, materialType, title, author, cover, digest, content, num, pid);
        this.materialMapper.insertSelective((Object)material);
        return material;
    }

    private OfficialMaterial buildMaterial(String mediaUrl, MaterialType materialType, String title, String author, String cover, String digest, String content, int num, long pid) {
        OfficialMaterial material = new OfficialMaterial();
        material.setNodeId(Optional.ofNullable(LoginUtils.getCurrentUser().getUserNodeId()).orElse(0L));
        material.setUrl(Optional.ofNullable(mediaUrl).orElse(""));
        material.setmType(materialType.getValue());
        material.setGroupId(Long.valueOf(-1L));
        material.setPlatformType(Integer.valueOf(PlateformType.OFFICAL_ACCOUNT.getType()));
        material.setTitle(Optional.ofNullable(title).orElse(""));
        material.setAuthor(Optional.ofNullable(author).orElse(""));
        material.setCover(Optional.ofNullable(cover).orElse(""));
        material.setContent(Optional.ofNullable(content).orElse(""));
        material.setDigest(Optional.ofNullable(digest).orElse(""));
        material.setNum(Integer.valueOf(num));
        material.setPid(Long.valueOf(pid));
        material.setCreatorId(LoginUtils.getCurrentUserId());
        material.setModifierId(LoginUtils.getCurrentUserId());
        material.setCreateTime(new Date());
        material.setUpdateTime(new Date());
        return material;
    }

    private void transferText(MenuButtonConf button, String appId) {
        String clickKey = ClickEventBizType.MENU_TEXT.getKey();
        OfficialMenuTextReply textReply = this.convert2MenuTextReply(button, appId);
        this.textReplyMapper.insertSelective((Object)textReply);
        button.setType(MenuButtonType.click.getType());
        button.setKey(Joiner.on((String)CLICK_EVENT_INTERNAL_SPLITTER).join((Object)clickKey, (Object)textReply.getId(), new Object[0]));
    }

    private OfficialMenuTextReply convert2MenuTextReply(MenuButtonConf button, String appId) {
        Objects.requireNonNull(button);
        OfficialMenuTextReply textReply = new OfficialMenuTextReply();
        textReply.setAppId(appId);
        textReply.setMenuItem(button.getName());
        textReply.setReplyMessage(button.getValue());
        return textReply;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CustomizedMenuConfResp getAllMenu(AppIdReq req) {
        log.info("getAllMenu with req={}", (Object)req);
        req.validate();
        Long bizId = LoginUtils.getCurrentUserBizId();
        Long bingBizId = this.officialAccountService.queryBuIdByAppId(req.getAppId());
        if (!Objects.equals(bizId, bingBizId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "appId\u53c2\u6570\u9519\u8bef\u6216\u8005\u516c\u4f17\u53f7\u6ca1\u7ed1\u5b9a\u5728\u5f53\u524d\u5546\u6237\u4e0b");
        }
        OfficialMenu menu = this.officialMenuService.queryMenu(bizId, req.getAppId());
        if (menu != null && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{menu.getMenuContent()})) {
            OfficialAccount officialAccount = this.officialAccountService.queryByAppId(req.getAppId());
            if (menu.getUpdateTime().after(officialAccount.getAuthTime())) {
                try {
                    return (CustomizedMenuConfResp)JacksonUtil.str2Obj((String)menu.getMenuContent(), CustomizedMenuConfResp.class);
                }
                catch (IOException e) {
                    log.error("\u89e3\u6790\u83dc\u5355\u5931\u8d25, {}", (Object)menu.getMenuContent(), (Object)e);
                    throw new IllegalArgumentException("\u89e3\u6790\u83dc\u5355\u5931\u8d25", e);
                }
            }
        }
        String accessToken = this.officialTokenService.getOfficialAccessToken(req.getAppId());
        CustomizedMenuConfResp resp = this.menuAPI.queryCustomizedMenuConf(accessToken);
        return this.insertOrUpdateMenu(req.getAppId(), req.getOperatorId(), resp);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String deleteMenu(AppIdReq req) {
        log.info("deleteMenu with req={}", (Object)req);
        req.validate();
        this.officialMenuService.delete(req.getAppId(), req.getOperatorId());
        String accessToken = this.officialTokenService.getOfficialAccessToken(req.getAppId());
        ErrorCode result = this.menuAPI.deleteAllMenu(accessToken);
        return result.getErrMsg();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void transferMenu(AppIdReq req) {
        String appId = req.getAppId();
        Long operatorId = req.getOperatorId();
        log.info("transfer weixin menu to api menu, appId={}, operatorId={}", (Object)appId, (Object)operatorId);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId}), (Object)"appId is null");
        StopWatchDto timer = new StopWatchDto("transferMenu", true, log);
        timer.start("getOfficialAccessToken");
        String token = this.officialTokenService.getOfficialAccessToken(appId);
        timer.stop();
        timer.start("queryCustomizedMenuConf");
        CustomizedMenuConfResp resp = this.menuAPI.queryCustomizedMenuConf(token);
        timer.stop();
        if (resp == null || resp.getSelfMenuInfo() == null || CollectionUtils.isEmpty((Collection)resp.getSelfMenuInfo().getButton())) {
            log.warn("No customized menu found.");
            return;
        }
        this.setPlatformMatInfo(resp);
        List buttons = resp.getSelfMenuInfo().getButton();
        timer.start("transferToApiMenuIfNecessary");
        this.transferButtons(buttons, appId);
        timer.stop();
        ArrayList menuButtons = Lists.newArrayList();
        this.convert2MenuButton(buttons, menuButtons);
        CreateMenuReq createMenuReq = CreateMenuReq.create(appId, menuButtons, operatorId);
        this.createWxMenu(appId, createMenuReq.getMenuList(), timer, token);
        timer.start("insertOrUpdateMenu");
        this.insertOrUpdateMenu(appId, operatorId, resp);
        timer.stop();
        timer.print();
    }

    private void setPlatformMatInfo(CustomizedMenuConfResp resp) {
        if (resp == null || resp.getSelfMenuInfo() == null) {
            log.warn("No customized menu found.");
            return;
        }
        SelfMenuInfo info = resp.getSelfMenuInfo();
        if (CollectionUtils.isEmpty((Collection)info.getButton())) {
            return;
        }
        HashSet materialIds = Sets.newHashSet();
        this.collectMaterialIds(info.getButton(), materialIds);
        HashMap materialResultDtoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)materialIds)) {
            List<MaterialResultDto> dtos = this.commonMaterialService.queryList(MaterialCommonDtoReq.builder().ids(materialIds).build());
            materialResultDtoMap.putAll(dtos.stream().collect(Collectors.toMap(OfficialMaterial::getId, Function.identity())));
        }
        this.setMaterialInfo(info.getButton(), materialResultDtoMap);
    }

    private void collectMaterialIds(List<MenuButtonConf> confs, Set<Long> materialIds) {
        if (CollectionUtils.isEmpty(confs)) {
            return;
        }
        confs.forEach(a -> {
            Object[] materialEventInfo;
            String key = a.getKey();
            if (StringUtils.isNotBlank((CharSequence)key) && key.startsWith(ClickEventBizType.MATERIAL.getKey()) && ArrayUtils.isNotEmpty((Object[])(materialEventInfo = key.split(CLICK_EVENT_INTERNAL_SPLITTER))) && materialEventInfo.length == 2) {
                materialIds.add(Long.parseLong((String)materialEventInfo[1]));
            }
            if (a.getSubButton() != null) {
                this.collectMaterialIds(a.getSubButton().getList(), materialIds);
            }
        });
    }

    private void setMaterialInfo(List<MenuButtonConf> confs, Map<Long, MaterialResultDto> materialResultDtoMap) {
        if (CollectionUtils.isEmpty(confs)) {
            return;
        }
        confs.forEach(a -> {
            MaterialResultDto dto;
            Object[] materialEventInfo;
            String key = a.getKey();
            if (StringUtils.isNotBlank((CharSequence)key) && key.startsWith(ClickEventBizType.MATERIAL.getKey()) && ArrayUtils.isNotEmpty((Object[])(materialEventInfo = key.split(CLICK_EVENT_INTERNAL_SPLITTER))) && materialEventInfo.length == 2 && (dto = (MaterialResultDto)materialResultDtoMap.get(Long.parseLong((String)materialEventInfo[1]))) != null) {
                a.setMatId(dto.getId());
                a.setMediaType(dto.getmType());
            }
            if (a.getSubButton() != null) {
                this.setMaterialInfo(a.getSubButton().getList(), materialResultDtoMap);
            }
        });
    }

    @Override
    public List<MenuInfo> flatAllEventMenu(AppIdReq req) {
        log.info("get flat event menu with req={}, operatorId={}", (Object)req, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{req.getAppId()}), (Object)"appId is blank");
        CustomizedMenuConfResp menuResp = this.getAllMenu(req);
        if (menuResp == null || menuResp.getSelfMenuInfo() == null || CollectionUtils.isEmpty((Collection)menuResp.getSelfMenuInfo().getButton())) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        this.collectAllEventMenu(menuResp.getSelfMenuInfo().getButton(), "", "", result);
        return result;
    }

    private void collectAllEventMenu(List<MenuButtonConf> buttons, String fullName, String path, List<MenuInfo> menuList) {
        if (CollectionUtils.isEmpty(buttons)) {
            return;
        }
        for (int i = 0; i < buttons.size(); ++i) {
            MenuButtonConf button = buttons.get(i);
            StringBuilder sbFullName = new StringBuilder();
            StringBuilder sbPath = new StringBuilder();
            if (fullName != null) {
                sbFullName.append(fullName);
            }
            if (path != null) {
                sbPath.append(path);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{fullName, path})) {
                sbFullName.append(" => ");
                sbPath.append('-');
            }
            sbFullName.append(button.getName());
            sbPath.append(String.valueOf(i));
            String newFullName = sbFullName.toString();
            String newPath = sbPath.toString();
            SubButtonConf subButton = button.getSubButton();
            if (MenuButtonType.click.getType().equals(button.getType())) {
                menuList.add(this.buildSingleMenuDto(newFullName, newPath, button.getType(), button.getKey()));
            }
            if (MenuButtonType.view.getType().equals(button.getType())) {
                menuList.add(this.buildSingleMenuDto(newFullName, newPath, button.getType(), button.getUrl()));
            }
            if (MenuButtonType.miniprogram.getType().equals(button.getType())) {
                menuList.add(this.buildSingleMenuDto(newFullName, newPath, button.getType(), button.getPagePath()));
            }
            if (subButton == null || !CollectionUtils.isNotEmpty((Collection)subButton.getList())) continue;
            this.collectAllEventMenu(subButton.getList(), newFullName, newPath, menuList);
        }
    }

    private MenuInfo buildSingleMenuDto(String fullName, String path, String type, String key) {
        MenuInfo dto = new MenuInfo();
        dto.setFullName(fullName);
        dto.setPath(path);
        dto.setKey(key);
        dto.setType(type);
        return dto;
    }

    private void convert2MenuButton(List<MenuButtonConf> buttonConfs, List<MenuButton> menuButtons) {
        if (CollectionUtils.isEmpty(buttonConfs)) {
            return;
        }
        for (MenuButtonConf conf : buttonConfs) {
            ArrayList subMenuButtons = null;
            SubButtonConf subButton = conf.getSubButton();
            if (subButton != null && CollectionUtils.isNotEmpty((Collection)subButton.getList())) {
                subMenuButtons = Lists.newArrayList();
                this.convert2MenuButton(subButton.getList(), subMenuButtons);
            }
            menuButtons.add(this.newMenuButton(conf, subMenuButtons));
        }
    }

    private MenuButton newMenuButton(MenuButtonConf menuButtonConf, List<MenuButton> menuButtons) {
        MenuButton menuButton = new MenuButton();
        menuButton.setType(menuButtonConf.getType());
        menuButton.setKey(menuButtonConf.getKey());
        menuButton.setName(WxEmojiUtils.encode((String)menuButtonConf.getName()));
        menuButton.setMediaId(menuButtonConf.getMediaId());
        menuButton.setUrl(menuButtonConf.getUrl());
        menuButton.setAppId(menuButtonConf.getAppId());
        menuButton.setPagePath(menuButtonConf.getPagePath());
        menuButton.setSubButton(menuButtons);
        return menuButton;
    }
}

