/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.material.service.impl;

import cn.kinyun.scrm.weixin.material.dto.req.AddMaterialGroupReq;
import cn.kinyun.scrm.weixin.material.dto.req.DelMaterialGroupReq;
import cn.kinyun.scrm.weixin.material.dto.req.ModMaterialGroupReq;
import cn.kinyun.scrm.weixin.material.dto.resp.MaterialGroupResp;
import cn.kinyun.scrm.weixin.material.service.MaterialGroupService;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterialGroup;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialGroupMapper;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MaterialGroupServiceImpl
implements MaterialGroupService {
    private static final Logger log = LoggerFactory.getLogger(MaterialGroupServiceImpl.class);
    @Resource
    private OfficialMaterialGroupMapper materialGroupMapper;
    @Resource
    private OfficialMaterialMapper materialMapper;

    @Override
    public List<MaterialGroupResp> groupTree(Long operatorId) {
        log.info("query material group list with operatorId={}", (Object)operatorId);
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        ArrayList groupList = Lists.newArrayList();
        List groups = this.materialGroupMapper.queryListByBizId(currentUser.getBizId());
        for (OfficialMaterialGroup group : groups) {
            MaterialGroupResp groupResp = new MaterialGroupResp();
            groupResp.setId(group.getId());
            groupResp.setKey(group.getId().toString());
            groupResp.setName(group.getGroupName());
            groupResp.setType(MaterialGroupResp.GroupType.MATERIAL_GROUP_NODE.getType());
            groupList.add(groupResp);
        }
        groupList.add(this.buildTmpMaterialGroup());
        return groupList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addMaterialGroup(AddMaterialGroupReq params, Long operatorId) {
        log.info("add material group with params ={},operatorId={}", (Object)params, (Object)operatorId);
        params.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        OfficialMaterialGroup group = new OfficialMaterialGroup();
        group.setBizId(userInfo.getBizId());
        group.setCorpId(userInfo.getCorpId());
        group.setNodeId(null);
        group.setGroupName(params.getGroupName());
        group.setCreatorId(operatorId);
        group.setCreateTime(new Date());
        try {
            this.materialGroupMapper.insertSelective((Object)group);
        }
        catch (DuplicateKeyException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5206\u7ec4\u540d\u91cd\u590d");
        }
        return group.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modMaterialGroup(ModMaterialGroupReq params, Long operatorId) {
        log.info("add material group with params ={},operatorId={}", (Object)params, (Object)operatorId);
        params.validate();
        OfficialMaterialGroup group = (OfficialMaterialGroup)this.materialGroupMapper.selectByPrimaryKey((Object)params.getGroupId());
        if (group == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5206\u7ec4\u4e0d\u5b58\u5728");
        }
        group.setGroupName(params.getGroupName());
        try {
            this.materialGroupMapper.updateByPrimaryKeySelective((Object)group);
        }
        catch (DuplicateKeyException e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5206\u7ec4\u540d\u91cd\u590d");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delMaterialGroup(DelMaterialGroupReq params, Long operatorId) {
        log.info("add material group with params ={},operatorId={}", (Object)params, (Object)operatorId);
        params.validate();
        OfficialMaterialGroup group = (OfficialMaterialGroup)this.materialGroupMapper.selectByPrimaryKey((Object)params.getGroupId());
        if (group == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5206\u7ec4\u4e0d\u5b58\u5728");
        }
        int count = this.materialMapper.countList(null, null, null, group.getId(), null, null, null, group.getBizId(), null);
        if (count > 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5206\u7ec4\u4e0b\u6709\u7d20\u6750\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.materialGroupMapper.deleteByPrimaryKey((Object)group.getId());
    }

    private MaterialGroupResp buildTmpMaterialGroup() {
        MaterialGroupResp resp = new MaterialGroupResp();
        resp.setId(-1L);
        resp.setKey("-1");
        resp.setName("\u672a\u5206\u7ec4");
        resp.setType(MaterialGroupResp.GroupType.MATERIAL_TMP_NODE.getType());
        return resp;
    }
}

