/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.common.service.impl;

import cn.kinyun.scrm.weixin.common.dto.UserInfoRespDto;
import cn.kinyun.scrm.weixin.common.service.UserInfoService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.scrm.dal.official.base.dto.UserQueryParam;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserInfoServiceImpl
implements UserInfoService {
    private static final Logger log = LoggerFactory.getLogger(UserInfoServiceImpl.class);
    @Resource
    private UserMapper userMapper;

    @Override
    public List<UserInfoRespDto> queryList(UserQueryParam params) {
        log.info("query user list with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0);
        if (CollectionUtils.isEmpty((Collection)params.getIds()) && StringUtils.isBlank((CharSequence)params.getQuery())) {
            return Collections.emptyList();
        }
        List users = this.userMapper.queryList(params);
        if (CollectionUtils.isEmpty((Collection)users)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        users.forEach(user -> result.add(this.from((User)user)));
        return result;
    }

    private UserInfoRespDto from(User user) {
        UserInfoRespDto dto = new UserInfoRespDto();
        dto.setId(user.getId());
        dto.setUsername(user.getName());
        dto.setNickname(user.getName());
        dto.setAvatar(user.getAvatar());
        dto.setMobile(user.getMobile());
        return dto;
    }

    @Override
    public Map<Long, UserInfoRespDto> queryUserInfoMap(Collection<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyMap();
        }
        HashSet uids = Sets.newHashSet(userIds);
        List users = this.userMapper.getUserInfoByIds((Collection)uids);
        if (CollectionUtils.isEmpty((Collection)users)) {
            return Collections.emptyMap();
        }
        return users.stream().collect(Collectors.toMap(User::getId, this::from));
    }

    @Override
    public Boolean checkIsSystemUser(Long userId) {
        User user = (User)this.userMapper.selectByPrimaryKey((Object)userId);
        if (Objects.isNull(user)) {
            return Boolean.FALSE;
        }
        return NumberUtils.INTEGER_ONE.equals(user.getIsSystem());
    }
}

