/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.activity.service.impl;

import cn.kinyun.scrm.weixin.activity.dto.ActiTemplateMsgDto;
import cn.kinyun.scrm.weixin.activity.dto.ActivityDto;
import cn.kinyun.scrm.weixin.activity.dto.req.ActivityStatisticReq;
import cn.kinyun.scrm.weixin.activity.dto.resp.OfficialActiPhaseInfo;
import cn.kinyun.scrm.weixin.activity.dto.resp.OfficialActiTaskResp;
import cn.kinyun.scrm.weixin.activity.service.ActivityStatiscService;
import cn.kinyun.scrm.weixin.enums.activity.ActivityStatus;
import cn.kinyun.scrm.weixin.enums.activity.ActivityTaskStatus;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.DateUtil;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.dal.official.fission.dto.OfficialActiResultDto;
import com.kuaike.scrm.dal.official.fission.dto.OfficialActiTaskDto;
import com.kuaike.scrm.dal.official.fission.entity.OfficialActi;
import com.kuaike.scrm.dal.official.fission.entity.OfficialActiTask;
import com.kuaike.scrm.dal.official.fission.mapper.OfficialActiMapper;
import com.kuaike.scrm.dal.official.fission.mapper.OfficialActiResultMapper;
import com.kuaike.scrm.dal.official.fission.mapper.OfficialActiTaskMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityStatiscServiceImpl
implements ActivityStatiscService {
    private static final Logger log = LoggerFactory.getLogger(ActivityStatiscServiceImpl.class);
    @Resource
    private OfficialActiTaskMapper officialActiTaskMapper;
    @Resource
    private OfficialActiResultMapper officialActiResultMapper;
    @Resource
    private OfficialActiMapper officialActiMapper;

    @Override
    public List<OfficialActiTaskDto> physics(ActivityStatisticReq params, Long operatorId) {
        return null;
    }

    @Override
    public List<OfficialActiTaskDto> electronics(ActivityStatisticReq params, Long operatorId) {
        return null;
    }

    @Override
    public List<OfficialActiTaskResp> fission(ActivityStatisticReq params, Long currentUserId) {
        log.info("get acti fission stat with params={} by operatorId={}", (Object)params, (Object)currentUserId);
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"actId is null!");
        OfficialActi acti = this.officialActiMapper.getById(params.getId());
        if (acti == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        ActivityDto activityDto = null;
        try {
            activityDto = (ActivityDto)JacksonUtil.str2Obj((String)acti.getContent(), ActivityDto.class);
        }
        catch (IOException e) {
            log.error("official statistic fission json parse error: ", (Throwable)e);
        }
        List list = this.officialActiTaskMapper.queryList(params.getId(), params.getQuery(), params.getStatus(), "001", params.getPageDto());
        if (params.getPageDto() != null) {
            params.getPageDto().setCurPageCount(Integer.valueOf(list.size()));
            params.getPageDto().setCount(Integer.valueOf(this.officialActiTaskMapper.countList(params.getId(), params.getQuery(), params.getStatus(), "001")));
        }
        boolean hasPhysicsPhase = this.hasPhysicsPhase(activityDto);
        ArrayList respList = Lists.newArrayList();
        for (OfficialActiTaskDto dto : list) {
            OfficialActiTaskResp resp = new OfficialActiTaskResp();
            BeanUtils.copyProperties((Object)dto, (Object)resp);
            resp.setActiPhaseInfoList(Lists.newArrayList());
            ArrayList goalList = Lists.newArrayList();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dto.getPhaseGoals()})) {
                goalList.addAll(Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)dto.getPhaseGoals()).stream().map(Integer::parseInt).collect(Collectors.toList()));
            }
            Integer completePhaseNum = dto.getCompletePhaseNum();
            if (CollectionUtils.isNotEmpty((Collection)goalList)) {
                for (int i = 1; i <= goalList.size(); ++i) {
                    Integer goal = (Integer)goalList.get(i - 1);
                    OfficialActiPhaseInfo phaseInfo = new OfficialActiPhaseInfo();
                    phaseInfo.setPhase(i);
                    phaseInfo.setAmountStr(dto.getAmount() + "/" + goal);
                    if (completePhaseNum >= i) {
                        phaseInfo.setStatus(1);
                        phaseInfo.setStatusDesc("\u5b8c\u6210");
                        int hasReward = dto.getHasReward() & 1 << i - 1;
                        phaseInfo.setHasReward(hasReward > 0 ? 1 : 0);
                        phaseInfo.setHasRewardDesc(hasReward > 0 ? "\u6709" : "\u65e0");
                    } else {
                        phaseInfo.setStatus(0);
                        phaseInfo.setStatusDesc("\u672a\u5b8c\u6210");
                        phaseInfo.setHasReward(0);
                        phaseInfo.setHasRewardDesc("\u65e0");
                    }
                    resp.getActiPhaseInfoList().add(phaseInfo);
                }
            }
            if (activityDto != null) {
                resp.setHasPhysicsPhase(hasPhysicsPhase);
            }
            respList.add(resp);
        }
        return respList;
    }

    private boolean hasPhysicsPhase(ActivityDto activityDto) {
        boolean result = false;
        for (ActiTemplateMsgDto msgDto : activityDto.getMsgDtoList()) {
            if (msgDto.getType() != 1) continue;
            result = true;
        }
        return result;
    }

    @Override
    public List<OfficialActiResultDto> rising(ActivityStatisticReq params, Long operatorId) {
        log.info("rising statiscs with params ={},operatorId={}", (Object)params, (Object)operatorId);
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"actId is null!");
        List list = this.officialActiResultMapper.queryList(params.getId(), "002", params.getPageDto());
        if (params.getPageDto() != null) {
            params.getPageDto().setCurPageCount(Integer.valueOf(list.size()));
            params.getPageDto().setCount(Integer.valueOf(this.officialActiResultMapper.countList(params.getId(), "002")));
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void physicsUpdate(OfficialActiTaskDto dto, Long operatorId) {
        Preconditions.checkArgument((dto.getActiId() != null ? 1 : 0) != 0, (Object)"actiId is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)dto.getAppId()), (Object)"appId is empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)dto.getOpenId()), (Object)"openId is empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)dto.getOddNo()), (Object)"oddNo is empty");
        OfficialActiTask task = this.officialActiTaskMapper.queryTask(dto.getActiId(), dto.getAppId(), dto.getOpenId());
        if (task == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u4e0d\u5b58\u5728");
        }
        if (task.getStatus() <= ActivityTaskStatus.INCOMPLETE.getStatus()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4efb\u52a1\u672a\u5b8c\u6210");
        }
        task.setOddNo(dto.getOddNo());
        task.setStatus(Integer.valueOf(ActivityTaskStatus.MAILED.getStatus()));
        this.officialActiTaskMapper.updateByPrimaryKeySelective((Object)task);
    }

    @Override
    public OfficialActiTask getCurrentTask(String appId, String processKey, String openId) {
        OfficialActi acti;
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)processKey), (Object)"processKey is null");
        OfficialActiTask task = this.officialActiTaskMapper.querylastTask(null, appId, openId);
        if (task != null && (acti = this.officialActiMapper.getById(task.getActiId())).getStatus().intValue() == ActivityStatus.FORBIDDEN.getStatus()) {
            return null;
        }
        return task;
    }

    @Override
    public String getExportFileName(Long id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"actId is null!");
        OfficialActi acti = this.officialActiMapper.getById(id);
        if (acti == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        return acti.getName() + DateUtil.getDayStr((Date)new Date()) + "\u7528\u6237\u4fe1\u606f\u8868";
    }
}

