/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.utils;

import cn.kinyun.scrm.weixin.material.dto.RamImageDto;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class ExternalImgGet {
    protected static final Set<String> AVALIABLE_MIME_TYPE = Sets.newHashSet((Object[])new String[]{"image/jpeg", "image/bmp", "image/png", "image/gif"});
    public static final int MAX_FILE_SIZE = 0x200000;
    public static final String[] USER_AGENT_LIST = new String[]{"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.6; rv2.0.1) Gecko/20100101 Firefox/4.0.1", "Mozilla/5.0 (Windows NT 6.1; rv2.0.1) Gecko/20100101 Firefox/4.0.1", "Opera/9.80 (Macintosh; Intel Mac OS X 10.6.8; U; en) Presto/2.8.131 Version/11.11", "Opera/9.80 (Windows NT 6.1; U; en) Presto/2.8.131 Version/11.11", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_0) AppleWebKit/535.11 (KHTML, like Gecko) Chrome/17.0.963.56 Safari/535.11", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.62 Safari/537.36", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.63 Safari/537.36", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/22.0.1207.1 Safari/537.1", "Mozilla/5.0 (X11; CrOS i686 2268.111.0) AppleWebKit/536.11 (KHTML, like Gecko) Chrome/20.0.1132.57 Safari/536.11", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/536.6 (KHTML, like Gecko) Chrome/20.0.1092.0 Safari/536.6", "Mozilla/5.0 (Windows NT 6.2) AppleWebKit/536.6 (KHTML, like Gecko) Chrome/20.0.1090.0 Safari/536.6", "Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/537.1 (KHTML, like Gecko) Chrome/19.77.34.5 Safari/537.1", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/536.5 (KHTML, like Gecko) Chrome/19.0.1084.9 Safari/536.5", "Mozilla/5.0 (Windows NT 6.0) AppleWebKit/536.5 (KHTML, like Gecko) Chrome/19.0.1084.36 Safari/536.5", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/536.3 (KHTML, like Gecko) Chrome/19.0.1063.0 Safari/536.3", "Mozilla/5.0 (Windows NT 5.1) AppleWebKit/536.3 (KHTML, like Gecko) Chrome/19.0.1063.0 Safari/536.3", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_8_0) AppleWebKit/536.3 (KHTML, like Gecko) Chrome/19.0.1063.0 Safari/536.3", "Mozilla/5.0 (Windows NT 6.2) AppleWebKit/536.3 (KHTML, like Gecko) Chrome/19.0.1062.0 Safari/536.3", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/536.3 (KHTML, like Gecko) Chrome/19.0.1062.0 Safari/536.3", "Mozilla/5.0 (Windows NT 6.2) AppleWebKit/536.3 (KHTML, like Gecko) Chrome/19.0.1061.1 Safari/536.3", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/536.3 (KHTML, like Gecko) Chrome/19.0.1061.1 Safari/536.3", "Mozilla/5.0 (Windows NT 6.1) AppleWebKit/536.3 (KHTML, like Gecko) Chrome/19.0.1061.1 Safari/536.3", "Mozilla/5.0 (Windows NT 6.2) AppleWebKit/536.3 (KHTML, like Gecko) Chrome/19.0.1061.0 Safari/536.3", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/535.24 (KHTML, like Gecko) Chrome/19.0.1055.1 Safari/535.24", "Mozilla/5.0 (Windows NT 6.2; WOW64) AppleWebKit/535.24 (KHTML, like Gecko) Chrome/19.0.1055.1 Safari/535.24"};

    public static String randomUserAgent() {
        int index = (int)(Math.random() * (double)USER_AGENT_LIST.length);
        return USER_AGENT_LIST[index];
    }

    public static RamImageDto get(String url) {
        RamImageDto image = null;
        URL u = null;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u56fe\u7247url\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)u.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.setRequestProperty("User-Agent", ExternalImgGet.randomUserAgent());
            conn.setRequestProperty("Cache-Control", "no-cache");
            conn.setRequestProperty("Accept", "*/*");
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                String responseMsg = conn.getResponseMessage();
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, String.format("\u83b7\u53d6\u5916\u90e8\u56fe\u7247\u5931\u8d25: %d %s", responseCode, responseMsg));
            }
            String contentType = conn.getContentType();
            if (contentType == null || !AVALIABLE_MIME_TYPE.contains(contentType.toLowerCase())) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0d\u652f\u6301\u7684\u56fe\u7247\u683c\u5f0f:" + contentType);
            }
            int contentLength = conn.getContentLength();
            if (contentLength > 0x200000) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u56fe\u7247\u5927\u5c0f\u8d85\u8fc72M");
            }
            int len = 0;
            byte[] buffer = new byte[1024];
            try (ByteArrayOutputStream out = new ByteArrayOutputStream(contentLength);
                 BufferedInputStream in = new BufferedInputStream(conn.getInputStream());){
                while ((len = in.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
                image = new RamImageDto();
                image.setData(out.toByteArray());
                image.setFormat(contentType.substring(6));
                image.setFileName(ExternalImgGet.getUrlFileName(u));
                image.setUrl(url);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u65e0\u6cd5\u83b7\u53d6\u8be5\u56fe\u7247");
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return image;
    }

    public static String getUrlFileName(URL url) {
        String fileName = url.getFile();
        int idx = fileName.indexOf("?");
        if (idx >= 0) {
            fileName = fileName.substring(0, idx);
        }
        if ((idx = fileName.lastIndexOf("/")) >= 0) {
            fileName = fileName.substring(idx + 1);
        }
        if (StringUtils.isBlank((CharSequence)fileName)) {
            fileName = UUID.randomUUID().toString().replace("-", "");
        }
        return fileName;
    }

    public static void main(String[] args) {
        RamImageDto image = ExternalImgGet.get("https://oscimg.oschina.net/oscnet/8ef5e0fdce79fb9da6cd03326471b32c169.jpg?a=b&c=d");
        System.out.println(image);
    }
}

