/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.service.impl;

import cn.kinyun.scrm.weixin.recommend.dto.StatisticDayDto;
import cn.kinyun.scrm.weixin.recommend.dto.req.StatisticReqDto;
import cn.kinyun.scrm.weixin.recommend.dto.resp.GraphStatisticRespDto;
import cn.kinyun.scrm.weixin.recommend.dto.resp.OpLogRespDto;
import cn.kinyun.scrm.weixin.recommend.service.OpRecordService;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.dal.activity.entity.OpRecord;
import com.kuaike.scrm.dal.activity.mapper.OpRecordMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OpRecordServiceImpl
implements OpRecordService {
    private static final Logger log = LoggerFactory.getLogger(OpRecordServiceImpl.class);
    @Autowired
    OpRecordMapper opRecordMapper;

    @Override
    public Long insert(OpRecord opRecord) {
        this.opRecordMapper.insertSelective((Object)opRecord);
        return opRecord.getId();
    }

    @Override
    public void callBack(Long recordId, int opStatus, String errMsg) {
        log.info("callback with recordId={}, opStatus={}, errMsg={}", new Object[]{recordId, opStatus, errMsg});
        Preconditions.checkArgument((recordId != null ? 1 : 0) != 0, (Object)"recordId is null!");
        OpRecord opRecord = (OpRecord)this.opRecordMapper.selectByPrimaryKey((Object)recordId);
        if (opRecord == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "record us null!");
        }
        OpRecord record = new OpRecord();
        record.setId(recordId);
        record.setOpStatus(Integer.valueOf(opStatus));
        record.setErrorMsg(errMsg);
        this.opRecordMapper.updateByPrimaryKeySelective((Object)record);
    }

    @Override
    public List<StatisticDayDto> statistics(String bizId, Long graphId, Integer beginDay, Integer endDay, Integer behaviorConfId) {
        log.info("statistic with bizId={}, graphId={}, beginDay={}, endDay={}, behaviorConfId={}", new Object[]{bizId, graphId, beginDay, endDay, behaviorConfId});
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null!");
        Preconditions.checkArgument((graphId != null ? 1 : 0) != 0, (Object)"graphId is null!");
        Preconditions.checkArgument((beginDay != null ? 1 : 0) != 0, (Object)"beginDay is null!");
        Preconditions.checkArgument((endDay != null ? 1 : 0) != 0, (Object)"endDay is null!");
        List<Integer> days = StatisticReqDto.getDays(beginDay, endDay);
        Map numMap = this.opRecordMapper.numMap(bizId, graphId, beginDay.intValue(), endDay.intValue(), behaviorConfId);
        Map frequencyMap = this.opRecordMapper.frequencyMap(bizId, graphId, beginDay.intValue(), endDay.intValue(), behaviorConfId);
        ArrayList results = Lists.newArrayList();
        for (Integer day : days) {
            StatisticDayDto dto = new StatisticDayDto(day, numMap.getOrDefault(day, 0), frequencyMap.getOrDefault(day, 0));
            results.add(dto);
        }
        return results;
    }

    @Override
    public OpLogRespDto opLogs(StatisticReqDto params) {
        log.info("query op logs with params={}", (Object)params);
        Preconditions.checkArgument((params.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null!");
        Preconditions.checkArgument((params.getGraphId() != null ? 1 : 0) != 0, (Object)"graphId is null!");
        Preconditions.checkArgument((params.getBeginDay() > 0 ? 1 : 0) != 0, (Object)"beginDay is null!");
        Preconditions.checkArgument((params.getEndDay() > 0 ? 1 : 0) != 0, (Object)"endDay is null!");
        PageDto pageDto = params.getPageDto();
        List logs = this.opRecordMapper.queryLogs(params.getBizId(), params.getGraphId(), params.getBeginDay(), params.getEndDay(), params.getObjectId(), params.getOpStatus(), params.getFuzzyMatchContext(), pageDto);
        if (pageDto != null) {
            pageDto.setCurPageCount(Integer.valueOf(logs.size()));
            pageDto.setCount(Integer.valueOf(this.opRecordMapper.countLogs(params.getBizId(), params.getGraphId(), params.getBeginDay(), params.getEndDay(), params.getObjectId(), params.getOpStatus(), params.getFuzzyMatchContext())));
        }
        logs.forEach(a -> {
            a.setBehaviorContext((Map)JSONObject.parseObject((String)a.getBehaviorContextStr(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]));
            a.setOpContext((Map)JSONObject.parseObject((String)a.getOpContextStr(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]));
        });
        OpLogRespDto result = new OpLogRespDto();
        result.setOpLogs(logs);
        result.setPageDto(pageDto);
        return result;
    }

    @Override
    public List<GraphStatisticRespDto> graphStatistics(String bizId, List<Long> graphIds) {
        log.info("statistic graph info with bizId={}, graphIds={}", (Object)bizId, graphIds);
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(graphIds), (Object)"graphIds empty");
        Map numMap = this.opRecordMapper.graphNumMap(bizId, graphIds);
        if (MapUtils.isEmpty((Map)numMap)) {
            return Collections.emptyList();
        }
        Map frequencyMap = this.opRecordMapper.graphFrequencyMap(bizId, graphIds);
        ArrayList result = Lists.newArrayList();
        for (Long graphId : numMap.keySet()) {
            GraphStatisticRespDto dto = new GraphStatisticRespDto();
            Integer num = numMap.getOrDefault(graphId, 0);
            Integer frequency = frequencyMap.getOrDefault(graphId, 0);
            dto.setFrequency(frequency);
            dto.setGraphId(graphId);
            dto.setNumber(num);
            result.add(dto);
        }
        return result;
    }
}

