/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.service.impl;

import cn.kinyun.scrm.weixin.recommend.common.dto.Behavior;
import cn.kinyun.scrm.weixin.recommend.common.dto.Condition;
import cn.kinyun.scrm.weixin.recommend.common.dto.Edge;
import cn.kinyun.scrm.weixin.recommend.common.dto.Graph;
import cn.kinyun.scrm.weixin.recommend.common.dto.Node;
import cn.kinyun.scrm.weixin.recommend.common.dto.Op;
import cn.kinyun.scrm.weixin.recommend.common.enums.ActivityStatus;
import cn.kinyun.scrm.weixin.recommend.common.utils.GraphSvgsUtils;
import cn.kinyun.scrm.weixin.recommend.common.utils.MatchUtils;
import cn.kinyun.scrm.weixin.recommend.dto.req.GraphModReq;
import cn.kinyun.scrm.weixin.recommend.service.GraphBehaviorService;
import cn.kinyun.scrm.weixin.recommend.service.GraphDefineService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.activity.entity.ActivityGraph;
import com.kuaike.scrm.dal.activity.entity.BehaviorConf;
import com.kuaike.scrm.dal.activity.entity.OpConf;
import com.kuaike.scrm.dal.activity.mapper.ActivityGraphMapper;
import com.kuaike.scrm.dal.activity.mapper.BehaviorConfMapper;
import com.kuaike.scrm.dal.activity.mapper.OpConfMapper;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GraphDefineServiceImpl
implements GraphDefineService {
    private static final Logger log = LoggerFactory.getLogger(GraphDefineServiceImpl.class);
    @Autowired
    private ActivityGraphMapper graphMapper;
    @Autowired
    private BehaviorConfMapper behaviorConfMapper;
    @Autowired
    private OpConfMapper opConfMapper;
    @Autowired
    private GraphBehaviorService graphBehaviorService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addGraph(GraphModReq graphModReq) {
        log.info("add graph with param={}", (Object)graphModReq);
        graphModReq.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        this.validateContext(graphModReq.getActGraph());
        ActivityGraph g = graphModReq.to(null);
        g.setBizId(userInfo.getBizId());
        g.setCorpId(userInfo.getCorpId());
        this.graphMapper.insertSelective((Object)g);
        this.graphBehaviorService.addBehaviors(g, graphModReq.getActGraph().filterBehaviorConfIds());
        return g.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modGraph(GraphModReq graphModReq) {
        log.info("mod graph with param={}", (Object)graphModReq);
        Preconditions.checkArgument((graphModReq.getId() != null ? 1 : 0) != 0, (Object)"id is null!");
        graphModReq.validate();
        this.validateContext(graphModReq.getActGraph());
        ActivityGraph g = (ActivityGraph)this.graphMapper.selectByPrimaryKey((Object)graphModReq.getId());
        if (g == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d41\u7a0b\u4e0d\u5b58\u5728");
        }
        g = graphModReq.to(g);
        this.graphMapper.updateByPrimaryKeySelective((Object)g);
        this.graphBehaviorService.updateBehaviors(g, graphModReq.getActGraph().filterBehaviorConfIds());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeStatus(int status, Long graphId) {
        log.info("change status with graphId={}, status={}", (Object)graphId, (Object)status);
        Preconditions.checkArgument((graphId != null ? 1 : 0) != 0, (Object)"graphId is null!");
        ActivityGraph graph = (ActivityGraph)this.graphMapper.selectByPrimaryKey((Object)graphId);
        if (graph == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "graph not exist");
        }
        ActivityGraph record = new ActivityGraph();
        record.setId(graph.getId());
        if ((byte)status == ActivityStatus.FORBBIDEN.getStatus()) {
            record.setGraphStatus(Integer.valueOf(ActivityStatus.FORBBIDEN.getStatus()));
        } else if ((byte)status == ActivityStatus.DELETE.getStatus()) {
            record.setGraphStatus(Integer.valueOf(ActivityStatus.DELETE.getStatus()));
        } else if (graph.getPermanent() == 0) {
            Date now = new Date();
            if (graph.getBeginTime().after(now)) {
                record.setGraphStatus(Integer.valueOf(ActivityStatus.WAIT.getStatus()));
            } else if (graph.getEndTime().after(now)) {
                record.setGraphStatus(Integer.valueOf(ActivityStatus.PROCESSING.getStatus()));
            } else {
                record.setGraphStatus(Integer.valueOf(ActivityStatus.EXPIRED.getStatus()));
            }
        } else {
            record.setGraphStatus(Integer.valueOf(ActivityStatus.PROCESSING.getStatus()));
        }
        this.graphMapper.updateByPrimaryKeySelective((Object)record);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(Long id) {
        log.info("del graph with param={}", (Object)id);
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"id is null!");
        ActivityGraph g = (ActivityGraph)this.graphMapper.selectByPrimaryKey((Object)id);
        if (g == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d41\u7a0b\u4e0d\u5b58\u5728");
        }
        this.graphMapper.deleteByPrimaryKey((Object)id);
    }

    @Override
    public boolean triggerMatch(ActivityGraph activityGraph, Behavior behavior) {
        Graph actGraph = (Graph)JSONObject.parseObject((String)activityGraph.getActContent(), Graph.class);
        BehaviorConf conf = (BehaviorConf)this.behaviorConfMapper.selectByPrimaryKey((Object)behavior.getConfId());
        if (conf == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u77e5\u884c\u4e3a");
        }
        return MatchUtils.match(actGraph.getContext(), actGraph.getTriggers(), behavior);
    }

    @Override
    public List<ActivityGraph> matchBehavior(Behavior behavior) {
        Preconditions.checkArgument((behavior.getBizId() != null ? 1 : 0) != 0, (Object)"bizId is null!");
        Preconditions.checkArgument((behavior.getConfId() != null ? 1 : 0) != 0, (Object)"confId is null!");
        List activityGraphs = this.graphMapper.queryList(behavior.getBizId(), behavior.getConfId(), new Date());
        List result = activityGraphs.stream().filter(activityGraph -> this.triggerMatch((ActivityGraph)activityGraph, behavior)).collect(Collectors.toList());
        int priority = -1;
        for (ActivityGraph graph : result) {
            if (graph.getPriority() <= priority) continue;
            priority = graph.getPriority();
        }
        int finalPriority = priority;
        return result.stream().filter(activityGraph -> activityGraph.getPriority() == finalPriority).collect(Collectors.toList());
    }

    @Override
    public String getGraphSvg(Long id) {
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"id is null!");
        ActivityGraph graph = (ActivityGraph)this.graphMapper.selectByPrimaryKey((Object)id);
        if (graph == null) {
            return "";
        }
        Graph g = (Graph)JSONObject.parseObject((String)graph.getActContent(), Graph.class);
        Map<Integer, OpConf> opConfMap = this.opConfMapper.selectAll().stream().collect(Collectors.toMap(a -> a.getId(), Function.identity()));
        Map<Integer, BehaviorConf> bConfMap = this.behaviorConfMapper.selectAll().stream().collect(Collectors.toMap(a -> a.getId(), Function.identity()));
        return GraphSvgsUtils.getGraphSvg(g, opConfMap, bConfMap);
    }

    public void validateContext(Graph actGraph) {
        Set<Integer> bConfIds = actGraph.filterBehaviorConfIds();
        Set<Integer> opConfIds = actGraph.filterOpConfIds();
        Map<Integer, BehaviorConf> bMap = this.behaviorConfMapper.queryList(bConfIds).stream().collect(Collectors.toMap(a -> a.getId(), Functions.identity()));
        Map<Integer, OpConf> opMap = this.opConfMapper.queryList(opConfIds).stream().collect(Collectors.toMap(a -> a.getId(), Function.identity()));
        List<List<Integer>> pathList = Graph.caculeAllpath(actGraph);
        Map nodeMap = actGraph.getNodes().stream().collect(Collectors.toMap(a -> a.getId(), Function.identity()));
        Map edgeMap = actGraph.getEdges().stream().collect(Collectors.groupingBy(a -> a.getFromNodeId(), Collectors.toMap(a -> a.getToNodeId(), Function.identity())));
        for (List<Integer> path : pathList) {
            HashSet contextFields = Sets.newHashSet();
            contextFields.addAll(this.getContextFields(actGraph.getTriggers(), bMap));
            for (int i = 0; i < path.size() - 1; ++i) {
                if (i > 0) {
                    Edge edge = (Edge)edgeMap.get(path.get(i - 1)).get(path.get(i));
                    contextFields.addAll(this.getContextFields(edge.getConditions(), bMap));
                }
                Node actNode = (Node)nodeMap.get(path.get(i));
                this.validate(contextFields, actNode, opMap);
            }
        }
    }

    private void validate(Set<String> contextFields, Node actNode, Map<Integer, OpConf> opMap) {
        for (Op op : actNode.getOps()) {
            Set<String> opFields = this.getOpFields(op.getConfId(), opMap);
            opFields.removeAll(contextFields);
            if (op.getContext() != null) {
                opFields.removeAll(op.getContext().keySet());
            }
            if (!CollectionUtils.isNotEmpty(opFields)) continue;
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u64cd\u4f5c\u4f9d\u8d56\u7684\u4e0a\u4e0b\u6587\u4e0d\u5b58\u5728" + opFields);
        }
    }

    private Set<String> getContextFields(List<Condition> conditions, Map<Integer, BehaviorConf> bMap) {
        HashSet result = Sets.newHashSet();
        for (Condition actCondition : conditions) {
            String[] fields;
            BehaviorConf conf = bMap.get(actCondition.getBehaviorConfId());
            if (conf == null) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u884c\u4e3a\u4e0d\u5b58\u5728\uff0c\u884c\u4e3a\u7c7b\u578b" + actCondition.getBehaviorConfId());
            }
            for (String field : fields = StringUtils.split((String)conf.getContextFields(), (String)",")) {
                result.add(field);
            }
        }
        return result;
    }

    private Set<String> getOpFields(Integer opConfId, Map<Integer, OpConf> opMap) {
        String[] fields;
        HashSet result = Sets.newHashSet();
        OpConf opConf = opMap.get(opConfId);
        if (opConf == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u64cd\u4f5c\u4e0d\u5b58\u5728\uff0c\u884c\u4e3a\u7c7b\u578b" + opConfId);
        }
        for (String field : fields = StringUtils.split((String)opConf.getContextFields(), (String)",")) {
            result.add(field);
        }
        return result;
    }

    private Set<String> getBehaviorFields(BehaviorConf behaviorConf) {
        String[] fields;
        HashSet result = Sets.newHashSet();
        for (String field : fields = StringUtils.split((String)behaviorConf.getContextFields(), (String)",")) {
            result.add(field);
        }
        return result;
    }
}

