/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.service.impl;

import cn.kinyun.scrm.weixin.recommend.service.GraphBehaviorService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.scrm.dal.activity.entity.ActivityGraph;
import com.kuaike.scrm.dal.activity.entity.GraphBehavior;
import com.kuaike.scrm.dal.activity.mapper.GraphBehaviorMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GraphBehaviorServiceImpl
implements GraphBehaviorService {
    @Autowired
    GraphBehaviorMapper graphBehaviorMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addBehaviors(ActivityGraph graph, Set<Integer> confIds) {
        if (CollectionUtils.isNotEmpty(confIds)) {
            ArrayList behaviors = Lists.newArrayList();
            for (Integer confId : confIds) {
                GraphBehavior gb = new GraphBehavior();
                gb.setGraphId(graph.getId());
                gb.setBizId(graph.getBizId());
                gb.setCorpId(graph.getCorpId());
                gb.setConfId(confId);
                behaviors.add(gb);
            }
            this.graphBehaviorMapper.batchInsert((Collection)behaviors);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateBehaviors(ActivityGraph graph, Set<Integer> confIds) {
        List existIds = this.graphBehaviorMapper.queryBehaviors(graph.getBizId(), graph.getId());
        ArrayList copyIds = Lists.newArrayList(confIds);
        copyIds.removeAll(confIds);
        if (CollectionUtils.isNotEmpty((Collection)copyIds)) {
            this.graphBehaviorMapper.batchDel(graph.getBizId(), graph.getId(), (Collection)copyIds);
        }
        confIds.removeAll(existIds);
        if (CollectionUtils.isNotEmpty(confIds)) {
            this.addBehaviors(graph, confIds);
        }
    }

    @Override
    public void delBehaviors(Long bizId, Long graphId) {
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"bizId is null!");
        Preconditions.checkArgument((graphId != null ? 1 : 0) != 0, (Object)"graphId is null!");
    }
}

