/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.common.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SvgUtils {
    private static final int NODE_W = 100;
    private static final int NODE_H = 50;
    private static final int SNODE_W = 50;
    private static final int SNODE_H = 25;
    private static final int INTERVAL_X = 100;
    private static final int INTERVAL_Y = 100;
    private static final int PEND_X = 50;
    private static final int PEND_Y = 50;
    private static final String NODE_ACTIVATION_COLOR = "#FFE4E1";
    private static final String NODE_DEFAULT_COLOR = "#FFF68F";
    private static final String LINE_ACTIVATION_COLOR = "red";
    private static final String LINE_DEFAULT_COLOR = "black";

    public static Map<Integer, List<Integer>> caculateEdgs(List<List<Integer>> paths) {
        HashMap edgs = Maps.newHashMap();
        int startNodeId = -1;
        for (List<Integer> path : paths) {
            for (int i = 0; i < path.size() - 1; ++i) {
                if (startNodeId == -1) {
                    startNodeId = path.get(i);
                }
                int from = path.get(i);
                int to = path.get(i + 1);
                List tmp = edgs.getOrDefault(from, Lists.newArrayList());
                if (!tmp.contains(to)) {
                    tmp.add(to);
                }
                edgs.put(from, tmp);
            }
        }
        ArrayList toIds = Lists.newArrayList();
        toIds.add(startNodeId);
        edgs.put(0, toIds);
        return edgs;
    }

    public static Map<Integer, Point> caculatePoint(List<List<Integer>> paths) {
        HashMap points = Maps.newHashMap();
        HashMap levels = Maps.newHashMap();
        int deep = -1;
        for (List<Integer> path : paths) {
            for (int i = 0; i < path.size(); ++i) {
                if (deep < i) {
                    deep = i;
                }
                Set ids = levels.getOrDefault(i, Sets.newHashSet());
                ids.add(path.get(i));
                levels.put(i, ids);
            }
        }
        int maxWidth = 1;
        for (int i = 0; i <= deep; ++i) {
            Set ids = levels.getOrDefault(i, Sets.newHashSet());
            Set nextIds = levels.getOrDefault(i + 1, Sets.newHashSet());
            ids.removeAll(nextIds);
            if (maxWidth < ids.size()) {
                maxWidth = ids.size();
            }
            levels.put(i, ids);
        }
        int centerx = (maxWidth - 1) * 200 + 50;
        int d = 0;
        int startNodeId = -1;
        for (int i = 0; i <= deep; ++i) {
            Set ids = levels.getOrDefault(i, Sets.newHashSet());
            if (!CollectionUtils.isNotEmpty((Collection)ids)) continue;
            ArrayList tmpIds = Lists.newArrayList((Iterable)ids);
            tmpIds.sort(Integer::compareTo);
            for (int j = 0; j < tmpIds.size(); ++j) {
                if (startNodeId == -1) {
                    startNodeId = (Integer)tmpIds.get(j);
                }
                Point p = SvgUtils.getPoint(d + 1, j + 1, centerx, tmpIds.size());
                points.put(tmpIds.get(j), p);
            }
            ++d;
        }
        Point startP = (Point)points.get(startNodeId);
        Point p = new Point();
        p.x = startP.x + 50;
        p.y = startP.y - 100 - 25;
        points.put(0, p);
        return points;
    }

    public static String getRectSvg(Point p, String text, boolean activated) {
        StringBuilder sb = new StringBuilder();
        sb.append("<rect x=\"").append(p.x).append("\" y=\"").append(p.y).append("\" rx=\"5\" ry=\"5\" width=\"").append(100).append("\"\nheight=\"").append(50).append("\" style=\"fill:");
        if (activated) {
            sb.append(NODE_ACTIVATION_COLOR);
        } else {
            sb.append(NODE_DEFAULT_COLOR);
        }
        sb.append(";stroke:black;\nstroke-width:1;opacity:0.5\"/>");
        if (StringUtils.isNotBlank((CharSequence)text)) {
            sb.append("<text x =\"").append(p.x).append("\" y=\"").append(p.y + 25).append("\" fill=\"");
            if (activated) {
                sb.append(LINE_ACTIVATION_COLOR);
            } else {
                sb.append(LINE_DEFAULT_COLOR);
            }
            sb.append("\">").append(text).append("</text>\n");
        }
        return sb.toString();
    }

    public static String getStartSvg(Point p) {
        StringBuilder sb = new StringBuilder();
        sb.append("<ellipse cx=\"").append(p.x).append("\" cy=\"").append(p.y).append("\" rx=\"").append(50).append("\" ry=\"").append(25).append("\" style=\"fill:").append(NODE_ACTIVATION_COLOR).append(";stroke:black; stroke-width:1;opacity:0.5\"/>").append("<text x =\"").append(p.x - 33 + 5).append("\" y=\"").append(p.y).append("\" fill=\"red\">").append("\u5f00\u59cb").append("</text>\n");
        return sb.toString();
    }

    public static String getSvg(Map<Integer, Point> pointMap, Map<Integer, List<Integer>> edgMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \n\"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n\n<svg width=\"100%\" height=\"100%\" version=\"1.1\"\nxmlns=\"http://www.w3.org/2000/svg\">");
        sb.append("<defs>\n\t<marker id=\"arrow\" \n\tmarkerUnits=\"strokeWidth\" \n\tmarkerWidth=\"12\" \n\tmarkerHeight=\"12\"\n\tviewBox=\"0 0 12 12\"\n\trefX=\"6\"\n\trefY=\"6\"\n\torient=\"auto\">\n\t<path d=\"M2,2 L10,6 L2,10 L6,6 L2,2\" style=\"fill: #000000;\"/>\n</marker>\n</defs>");
        sb.append(SvgUtils.getStartSvg(pointMap.get(0)));
        for (Integer nodeId : pointMap.keySet()) {
            if (nodeId == 0) continue;
            Point p = pointMap.get(nodeId);
            sb.append(SvgUtils.getRectSvg(p, nodeId.toString(), false));
        }
        for (Integer fromId : edgMap.keySet()) {
            List<Integer> toIds = edgMap.get(fromId);
            Point from = pointMap.get(fromId);
            if (!CollectionUtils.isNotEmpty(toIds)) continue;
            for (Integer toId : toIds) {
                Point to = pointMap.get(toId);
                sb.append(SvgUtils.getLine(from, to, fromId, false, "\u6307\u5411"));
            }
        }
        sb.append("</svg>");
        return sb.toString();
    }

    public static String getLine(Point from, Point to, int fromId, boolean activated, String text) {
        StringBuilder sb = new StringBuilder();
        int fromX = 0;
        int fromY = 0;
        int toX = 0;
        int toY = 0;
        if (fromId == 0) {
            fromX = from.x;
            fromY = from.y + 25;
            toX = to.x + 50;
            toY = to.y - 5;
        } else if (from.y < to.y) {
            fromX = from.x + 50;
            fromY = from.y + 50;
            toX = to.x + 50;
            toY = to.y - 5;
        } else if (from.y == to.y) {
            fromY = from.y + 25;
            toY = to.y + 25;
            if (from.x > to.x) {
                fromX = from.x + 100;
                toX = to.x;
            } else {
                fromX = from.x;
                toX = to.x + 100;
            }
        } else {
            fromX = from.x + 50;
            fromY = from.y;
            toX = to.x + 50;
            toY = to.y + 50 + 5;
        }
        sb.append("<line x1=\"").append(fromX).append("\" y1=\"").append(fromY).append("\" x2=\"").append(toX).append("\" y2=\"").append(toY);
        if (activated) {
            sb.append("\" stroke=\"").append(LINE_ACTIVATION_COLOR).append("\" stroke-width=\"2\" marker-end=\"url(#arrow)\"/>\n");
        } else {
            sb.append("\" stroke=\"").append(LINE_DEFAULT_COLOR).append("\" stroke-width=\"2\" marker-end=\"url(#arrow)\"/>\n");
        }
        if (StringUtils.isNotBlank((CharSequence)text)) {
            sb.append("<text x =\"").append((fromX + toX) / 2).append("\" y=\"").append((fromY + toY) / 2).append("\" fill=\"");
            if (activated) {
                sb.append(LINE_ACTIVATION_COLOR);
            } else {
                sb.append(LINE_DEFAULT_COLOR);
            }
            sb.append("\">").append(text).append("</text>\n");
        }
        return sb.toString();
    }

    private static Point getPoint(int deep, int xIndex, int centerX, int xSize) {
        Point p = new Point();
        p.y = deep * 150 + 50;
        double diff = (double)xIndex - (double)(xSize + 1) / 2.0;
        p.x = (int)(diff * 200.0 + (double)centerX);
        return p;
    }

    public static void main(String[] args) {
        ArrayList paths = Lists.newArrayList();
        paths.add(Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4}));
        paths.add(Lists.newArrayList((Object[])new Integer[]{1, 6, 7, 8, 9}));
        paths.add(Lists.newArrayList((Object[])new Integer[]{1, 6, 3, 4}));
        HashMap edgs = Maps.newHashMap();
        Map<Integer, Point> pointMap = SvgUtils.caculatePoint(paths);
        Map<Integer, List<Integer>> edgMap = SvgUtils.caculateEdgs(paths);
        System.out.println(SvgUtils.getSvg(pointMap, edgMap));
    }

    public static class Point {
        int x;
        int y;
    }
}

