/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.officialAccount.service.impl;

import cn.kinyun.scrm.weixin.enums.Sex;
import cn.kinyun.scrm.weixin.enums.Subscribe;
import cn.kinyun.scrm.weixin.enums.SubscribeEventType;
import cn.kinyun.scrm.weixin.enums.UserIdentity;
import cn.kinyun.scrm.weixin.enums.biz.SystemParamName;
import cn.kinyun.scrm.weixin.officialAccount.dto.req.FansModReqDto;
import cn.kinyun.scrm.weixin.officialAccount.dto.req.FansReqDto;
import cn.kinyun.scrm.weixin.officialAccount.dto.req.TagReqDto;
import cn.kinyun.scrm.weixin.officialAccount.dto.resp.FansDetailRespDto;
import cn.kinyun.scrm.weixin.officialAccount.dto.resp.FansListRespDto;
import cn.kinyun.scrm.weixin.officialAccount.dto.resp.StringIdAndNameDto;
import cn.kinyun.scrm.weixin.officialAccount.service.OfficialAccountFansService;
import cn.kinyun.scrm.weixin.officialAccount.service.OfficialAccountFansTagService;
import cn.kinyun.scrm.weixin.officialAccount.service.OperatorService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.enums.EnumConstant;
import com.kuaike.common.enums.EnumService;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.service.CustomerCenterService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.base.dto.AppIdOpenIdDto;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.official.fans.dto.AccountFansQueryParam;
import com.kuaike.scrm.dal.official.fans.entity.OfficialAccountFans;
import com.kuaike.scrm.dal.official.fans.entity.OfficialAccountFansSubscribeLog;
import com.kuaike.scrm.dal.official.fans.entity.OfficialAccountFansTag;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialAccountFansMapper;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialAccountFansSubscribeLogMapper;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialAccountFansTagMapper;
import com.kuaike.scrm.dal.weworkTag.WeworkTagDto;
import com.kuaike.scrm.dal.weworkTag.mapper.WeworkTagMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="officialAccountFansService")
public class OfficialAccountFansServiceImpl
implements OfficialAccountFansService {
    private static final Logger log = LoggerFactory.getLogger(OfficialAccountFansServiceImpl.class);
    @Resource
    private OfficialAccountFansMapper fansMapper;
    @Resource
    private OfficialAccountMapper officialAccountMapper;
    @Resource
    private OfficialAccountFansTagMapper fansTagMapper;
    @Resource
    private OfficialAccountFansSubscribeLogMapper subscribeLogMapper;
    @Resource
    private WeworkTagMapper weworkTagMapper;
    @Autowired
    private OfficialAccountFansTagService fansTagService;
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private CustomerCenterService customerCenterService;

    @Override
    public List<FansListRespDto> list(FansReqDto fansReqDto) {
        log.info("query official fans list with params={}", (Object)fansReqDto);
        Preconditions.checkArgument((fansReqDto.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId is null");
        StopWatchDto timer = new StopWatchDto("weixinFansList", true, log);
        timer.start("getCurrentManagerAppIds");
        List<String> ableHandledAppIds = this.operatorService.getCurrentManagerAppIds();
        timer.stop();
        if (StringUtils.isNotBlank((CharSequence)fansReqDto.getAppId())) {
            ableHandledAppIds.retainAll(Lists.newArrayList((Object[])new String[]{fansReqDto.getAppId()}));
        }
        if (CollectionUtils.isEmpty(ableHandledAppIds)) {
            timer.print();
            return Collections.emptyList();
        }
        timer.start("getByAppIds");
        List officialAccounts = this.officialAccountMapper.getByAppIds(ableHandledAppIds);
        timer.stop();
        Map officialAccountMap = officialAccounts.stream().collect(Collectors.toMap(OfficialAccount::getAppId, Function.identity()));
        timer.start("getBlackWechatKickOutContact");
        Boolean showBlackList = this.settingService.getIntegerOrDefault(LoginUtils.getCurrentUserBizId(), SystemParamName.BLACK_WECHAT_KICK_OUT_CONTACT.getKey(), Integer.valueOf(0)) == 0;
        timer.stop();
        PageDto pageDto = fansReqDto.getPageDto();
        AccountFansQueryParam queryParam = new AccountFansQueryParam();
        BeanUtils.copyProperties((Object)fansReqDto, (Object)queryParam);
        queryParam.setAppIds(ableHandledAppIds);
        queryParam.setShowBlackList(showBlackList);
        if (fansReqDto.getTagId() != null) {
            ArrayList tagIds = Lists.newArrayList();
            tagIds.add(fansReqDto.getTagId());
            queryParam.setTagIds((List)tagIds);
        }
        timer.start("queryList");
        List fansList = this.fansMapper.queryList(queryParam);
        timer.stop();
        timer.start("count");
        Long count = this.fansMapper.count(queryParam);
        timer.stop();
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf(count.intValue()));
            pageDto.setCurPageCount(Integer.valueOf(fansList == null ? 0 : fansList.size()));
        }
        if (CollectionUtils.isEmpty((Collection)fansList)) {
            timer.print();
            return Collections.emptyList();
        }
        List<String> fansIdList = fansList.stream().map(it -> it.getUniqueId()).collect(Collectors.toList());
        timer.start("queryFansTagInfo");
        Map<String, List<WeworkTagDto>> fansId2TagMap = this.fansTagService.queryFansTagInfo(fansIdList);
        timer.stop();
        timer.start("queryFansSubscribeRecords");
        List logs = this.subscribeLogMapper.queryFansSubscribeRecords((Set)Sets.newHashSet(fansIdList));
        timer.stop();
        Map<String, List<OfficialAccountFansSubscribeLog>> fansLogMap = logs.stream().collect(Collectors.groupingBy(OfficialAccountFansSubscribeLog::getOfficialAccountFansId));
        timer.print();
        ArrayList result = Lists.newArrayList();
        fansList.forEach(fans -> result.add(OfficialAccountFansServiceImpl.buildFansRespInfo(fans, fansId2TagMap, officialAccountMap, fansLogMap)));
        return result;
    }

    public static FansListRespDto buildFansRespInfo(OfficialAccountFans fans, Map<String, List<WeworkTagDto>> fansId2TagsMap, Map<String, OfficialAccount> officialAccountMap, Map<String, List<OfficialAccountFansSubscribeLog>> fansLogMap) {
        List<OfficialAccountFansSubscribeLog> logs;
        FansListRespDto dto = new FansListRespDto();
        dto.setId(fans.getUniqueId());
        dto.setAppId(fans.getAppId());
        dto.setNickname(fans.getNickname());
        dto.setOpenId(fans.getOpenId());
        dto.setRemark(fans.getRemark());
        dto.setSubscribeTime(fans.getSubscribeTime());
        dto.setUnsubscribeTime(fans.getUnsubscribeTime());
        List<WeworkTagDto> tagAndFlowList = fansId2TagsMap.getOrDefault(fans.getUniqueId(), Lists.newArrayList());
        dto.setTagAndFlowInfoList(tagAndFlowList.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        dto.setNoteName(fans.getNoteName());
        dto.setHeadImgUrl(fans.getHeadImgUrl());
        dto.setCountry(fans.getCountry());
        dto.setProvince(fans.getProvince());
        dto.setCity(fans.getCity());
        dto.setMobile(fans.getMobile());
        dto.setSubscribeEnum(EnumConstant.from((EnumService)Subscribe.getByValue(fans.getSubscribe())));
        dto.setSexEnum(EnumConstant.from((EnumService)Sex.getByValue(fans.getSex())));
        dto.setIsInBlackList(fans.getIsInBlacklist());
        OfficialAccount officialAccount = officialAccountMap.get(fans.getAppId());
        if (officialAccount != null) {
            dto.setOfficialAccountInfo(new StringIdAndNameDto(officialAccount.getAppId(), officialAccount.getNickName()));
        }
        ArrayList operateRecords = Lists.newArrayList();
        if (fansLogMap != null && !fansLogMap.isEmpty() && CollectionUtils.isNotEmpty(logs = fansLogMap.get(fans.getUniqueId()))) {
            logs.forEach(a -> operateRecords.add(new FansListRespDto.OperateRecord(EnumConstant.from((EnumService)SubscribeEventType.getByValue(a.getOperateType().intValue())), a.getOperateTime())));
        }
        dto.setOperateRecords(operateRecords);
        return dto;
    }

    @Override
    public FansDetailRespDto detail(FansReqDto fansReqDto) {
        OfficialAccountFans fans;
        log.info("get fans detail with params={}", (Object)fansReqDto);
        Preconditions.checkArgument((fansReqDto.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId must not be null");
        if (StringUtils.isNotBlank((CharSequence)fansReqDto.getId())) {
            fans = this.fansMapper.selectByUniqueId(fansReqDto.getId());
        } else if (StringUtils.isNotBlank((CharSequence)fansReqDto.getAppId()) && StringUtils.isNotBlank((CharSequence)fansReqDto.getOpenId())) {
            fans = this.fansMapper.getFansByAppIdAndOpenId(fansReqDto.getAppId(), fansReqDto.getOpenId());
        } else {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "id is null");
        }
        if (null == fans) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7c89\u4e1d\u4e0d\u5b58\u5728");
        }
        this.beforeHandlerFansValidate(fansReqDto.getOperatorId(), null, Lists.newArrayList((Object[])new OfficialAccountFans[]{fans}));
        Map<String, List<WeworkTagDto>> fansTagAndFlowMap = this.fansTagService.queryFansTagInfo(Lists.newArrayList((Object[])new String[]{fans.getUniqueId()}));
        FansDetailRespDto result = new FansDetailRespDto();
        BeanUtils.copyProperties((Object)fans, (Object)result);
        result.setSexEnum(EnumConstant.from((EnumService)Sex.getByValue(fans.getSex())));
        result.setId(fans.getUniqueId());
        if (!fansTagAndFlowMap.isEmpty()) {
            List<WeworkTagDto> tagAndFlowLevelDtoList = fansTagAndFlowMap.get(fans.getUniqueId());
            result.setTagAndFlowInfoList(tagAndFlowLevelDtoList);
        }
        return result;
    }

    private void beforeHandlerFansValidate(Long operatorId, Integer userIdentity, List<OfficialAccountFans> fansList) {
        List fansAppIds = fansList.stream().map(a -> a.getAppId()).collect(Collectors.toList());
        List<String> appIds = this.operatorService.getPermitAppIds(operatorId, userIdentity);
        if (!appIds.containsAll(fansAppIds)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b58\u5728\u7c89\u4e1d\u4e0d\u5c5e\u4e8e\u53ef\u4ee5\u64cd\u4f5c\u7684\u516c\u4f17\u53f7");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void postTags(TagReqDto params) {
        log.info("post tag on fans with params={}", (Object)params);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(params.getFansIds()), (Object)"fansIds must not be empty");
        params.commonValidate();
        List<String> reqTagIds = params.getTagIdAndFlowIdList();
        if (CollectionUtils.isEmpty(reqTagIds)) {
            return;
        }
        List fansList = this.fansMapper.selectByUniqueIds(params.getFansIds());
        this.beforeHandlerFansValidate(params.getOperatorId(), UserIdentity.MANAGER.getValue(), fansList);
        this.checkTags(reqTagIds);
        List existFansTags = this.fansTagMapper.queryTagsByFansIds(params.getFansIds());
        Map<String, List<OfficialAccountFansTag>> fans2TagsMap = existFansTags.stream().collect(Collectors.groupingBy(OfficialAccountFansTag::getOfficialAccountFansId));
        ArrayList saveFansTags = Lists.newArrayList();
        for (String fansId : params.getFansIds()) {
            List<OfficialAccountFansTag> fansTags = fans2TagsMap.getOrDefault(fansId, Lists.newArrayList());
            List existTagIds = fansTags.stream().map(it -> it.getOfficialAccountTagId()).collect(Collectors.toList());
            for (String tagId : reqTagIds) {
                if (existTagIds.contains(tagId)) continue;
                saveFansTags.add(this.buildFansTag(fansId, tagId, LoginUtils.getCurrentUserId()));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)saveFansTags)) {
            this.fansTagMapper.saveAll((List)saveFansTags);
        }
    }

    private OfficialAccountFansTag buildFansTag(String fansId, String tagId, Long operatorId) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        OfficialAccountFansTag fansTag = new OfficialAccountFansTag();
        fansTag.setBizId(userInfo.getBizId());
        fansTag.setCorpId(userInfo.getCorpId());
        fansTag.setOfficialAccountFansId(fansId);
        fansTag.setOfficialAccountTagId(tagId);
        fansTag.setCreatorId(operatorId);
        return fansTag;
    }

    private void checkTags(List<String> tagIds) {
        Map tagMap;
        if (CollectionUtils.isNotEmpty(tagIds) && CollectionUtils.isEmpty((tagMap = this.weworkTagMapper.selectTagIdAndNameByCorpIdAndTagIds(LoginUtils.getCurrentUserCorpId(), tagIds)).values())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6807\u7b7e\u4e0d\u5b58\u5728");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void singlePostTag(TagReqDto params) {
        OfficialAccountFans fans;
        Preconditions.checkArgument((params.getFansId() != null ? 1 : 0) != 0, (Object)"fansId must not be null");
        params.commonValidate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        ArrayList tagIds = params.getTagIdAndFlowIdList();
        if (tagIds == null) {
            tagIds = Lists.newArrayList();
        }
        if ((fans = this.fansMapper.selectByUniqueId(params.getFansId())) == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7c89\u4e1d\u4e0d\u5b58\u5728");
        }
        this.beforeHandlerFansValidate(params.getOperatorId(), null, Lists.newArrayList((Object[])new OfficialAccountFans[]{fans}));
        this.checkTags(tagIds);
        List existTags = this.fansTagMapper.queryTagByTypeAndFansId(params.getFansId());
        Set existTagIds = existTags.stream().map(OfficialAccountFansTag::getOfficialAccountTagId).collect(Collectors.toSet());
        ArrayList commonTagIds = Lists.newArrayList((Iterable)tagIds);
        commonTagIds.retainAll(existTagIds);
        tagIds.removeAll(commonTagIds);
        existTagIds.removeAll(commonTagIds);
        if (CollectionUtils.isNotEmpty((Collection)tagIds)) {
            ArrayList fansTags = Lists.newArrayList();
            tagIds.forEach(tagId -> {
                OfficialAccountFansTag fansTag = new OfficialAccountFansTag();
                fansTag.setBizId(userInfo.getBizId());
                fansTag.setCorpId(userInfo.getCorpId());
                fansTag.setOfficialAccountFansId(fans.getUniqueId());
                fansTag.setOfficialAccountTagId(tagId);
                fansTag.setCreatorId(params.getOperatorId());
                fansTags.add(fansTag);
            });
            this.fansTagMapper.saveAll((List)fansTags);
            String customerNum = fans.getCustomerNum();
            if (StringUtils.isEmpty((CharSequence)customerNum)) {
                this.customerCenterService.pushOfficialFansCustomer(fans);
                customerNum = fans.getCustomerNum();
            }
            this.customerCenterService.pushTagRelation(userInfo.getBizId(), null, customerNum, (List)tagIds, (List)Lists.newArrayList());
        }
        if (CollectionUtils.isNotEmpty(existTagIds)) {
            this.fansTagMapper.delByFansIdAndTagIds(fans.getUniqueId(), existTagIds);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void mod(FansModReqDto params) {
        log.info("mod fans info with params={}", (Object)params);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getId()), (Object)"id must not be blank");
        Preconditions.checkArgument((params.getOperatorId() != null ? 1 : 0) != 0, (Object)"operatorId must not be null");
        Preconditions.checkArgument((params.getNoteName() != null || params.getRemark() != null || params.getMobile() != null ? 1 : 0) != 0, (Object)"update info is blank");
        OfficialAccountFans fans = this.fansMapper.selectByUniqueId(params.getId());
        if (null == fans) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7c89\u4e1d\u4e0d\u5b58\u5728");
        }
        this.beforeHandlerFansValidate(params.getOperatorId(), null, Lists.newArrayList((Object[])new OfficialAccountFans[]{fans}));
        OfficialAccountFans updateFans = new OfficialAccountFans();
        updateFans.setNoteName(params.getNoteName());
        updateFans.setUniqueId(params.getId());
        updateFans.setRemark(params.getRemark());
        updateFans.setMobile(params.getMobile());
        this.fansMapper.updateByUniqueId(updateFans);
    }

    @Override
    public Map<String, OfficialAccountFans> queryByFansId(String appId, Collection<String> openIds) {
        log.info("queryByFansId with appId={},openIds={}", (Object)appId, openIds);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)appId), (Object)"appId is null or empty");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(openIds), (Object)"openIds is null or empty");
        List fans = this.fansMapper.selectByAppIdOpenIds(appId, openIds);
        return fans.stream().collect(Collectors.toMap(a -> a.getOpenId(), a -> a));
    }

    @Override
    public OfficialAccountFans queryByFansId(String appId, String openId) {
        log.info("queryByFansId with appId={},openId={}", (Object)appId, (Object)openId);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)appId), (Object)"appId is null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)openId), (Object)"openIds is null or empty");
        List fans = this.fansMapper.selectByAppIdOpenIds(appId, Collections.singletonList(openId));
        if (CollectionUtils.isNotEmpty((Collection)fans)) {
            return (OfficialAccountFans)fans.get(0);
        }
        return null;
    }

    @Override
    public List<OfficialAccountFans> searchFans(String appId, Long userId, String query, PageDto pageDto) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)query));
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0);
        List<String> permits = this.operatorService.getPermitAppIds(userId, UserIdentity.SERVICE_PERSONNEL.getValue());
        Set<Object> appIds = Sets.newHashSet(permits);
        if (CollectionUtils.isEmpty((Collection)appIds)) {
            return Collections.emptyList();
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId})) {
            if (!appIds.contains(appId)) {
                return Lists.newArrayList();
            }
            appIds = Collections.singleton(appId);
        }
        List result = this.fansMapper.search((Collection)appIds, userId, query, pageDto);
        if (pageDto != null) {
            pageDto.setCurPageCount(Integer.valueOf(result.size()));
            pageDto.setCount(Integer.valueOf(this.fansMapper.countSearch((Collection)appIds, userId, query)));
        }
        return result;
    }

    @Override
    public Map<String, OfficialAccountFans> queryByAppIdOpenId(Set<String> appIdOpenIdSets) {
        log.info("queryByAppIdOpenId with appIdOpenIdSets={}", appIdOpenIdSets);
        if (CollectionUtils.isEmpty(appIdOpenIdSets)) {
            return Maps.newHashMap();
        }
        List list = appIdOpenIdSets.stream().map(a -> {
            String[] arr = a.split("##");
            return new AppIdOpenIdDto(arr[0], arr[1]);
        }).collect(Collectors.toList());
        List fansList = this.fansMapper.selectByAppIdsAndOpenIds(list);
        if (CollectionUtils.isEmpty((Collection)fansList)) {
            return Maps.newHashMap();
        }
        return fansList.stream().collect(Collectors.toMap(a -> String.format("%s##%s", a.getAppId(), a.getOpenId()), a -> a));
    }

    @Override
    public Map<String, OfficialAccountFans> queryByAppIdOpenId(String appId, Set<String> openIdSets) {
        log.info("queryByAppIdOpenId with appId={},openIdSets={}", openIdSets);
        if (CollectionUtils.isEmpty(openIdSets)) {
            return Maps.newHashMap();
        }
        List fansList = this.fansMapper.selectByAppIdAndOpenIds(appId, openIdSets);
        if (CollectionUtils.isEmpty((Collection)fansList)) {
            return Maps.newHashMap();
        }
        return fansList.stream().collect(Collectors.toMap(a -> String.format("%s##%s", a.getAppId(), a.getOpenId()), a -> a));
    }

    @Override
    public Map<String, List<String>> queryAppBlackList(Collection<String> appIds) {
        if (CollectionUtils.isEmpty(appIds)) {
            return Collections.emptyMap();
        }
        return this.fansMapper.queryAppBlacklist(appIds);
    }

    @Override
    public Map<String, String> queryNicknameByFansId(String appId, List<String> openIds) {
        log.info("queryNicknameByFansId with appId={},openIds={}", (Object)appId, openIds);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)appId), (Object)"appId is null or empty");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(openIds), (Object)"openIds is null or empty");
        return this.fansMapper.queryNicknameByAppIdOpenIds(appId, openIds);
    }
}

