/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.message.service.impl;

import cn.kinyun.scrm.weixin.common.service.TemplateIndustryService;
import cn.kinyun.scrm.weixin.message.service.TemplateMsgService;
import cn.kinyun.scrm.weixin.sdk.api.WxTemplateMsgAPI;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.job.TemplateSendJobFinishEvent;
import cn.kinyun.scrm.weixin.sdk.entity.message.mass.resp.MsgId;
import cn.kinyun.scrm.weixin.sdk.entity.template.Industry;
import cn.kinyun.scrm.weixin.sdk.entity.template.IndustryInfo;
import cn.kinyun.scrm.weixin.sdk.entity.template.PrivateTemplate;
import cn.kinyun.scrm.weixin.sdk.entity.template.SetIndustry;
import cn.kinyun.scrm.weixin.sdk.entity.template.TemplateMsg;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.template.req.SendTemplateMsgReq;
import cn.kinyun.scrm.weixin.token.OfficialTokenService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountTemplateInfo;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountTemplateMsg;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountTemplateInfoMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountTemplateMsgMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateMsgServiceImpl
implements TemplateMsgService {
    private static final Logger log = LoggerFactory.getLogger(TemplateMsgServiceImpl.class);
    @Autowired
    private OfficialTokenService officialTokenService;
    @Autowired
    private WxTemplateMsgAPI wxTemplateMsgApi;
    @Resource
    private OfficialAccountTemplateMsgMapper templateMsgMapper;
    @Autowired
    private TemplateIndustryService templateIndustryService;
    @Resource
    private OfficialAccountTemplateInfoMapper templateInfoMapper;

    @Override
    public String send(SendTemplateMsgReq params) {
        log.info("Send template msg with params={}", (Object)params);
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u6d88\u606f\u4f53\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getAppId()}), (Object)"\u516c\u4f17\u53f7\u7684appId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getToUserName()}), (Object)"\u63a5\u53d7\u8005\u7684openid\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getTemplateId()}), (Object)"\u6d88\u606f\u6a21\u677fID\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getData() != null ? 1 : 0) != 0, (Object)"\u6a21\u677f\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((!params.getData().isEmpty() ? 1 : 0) != 0, (Object)"\u6a21\u677f\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((params.getMiniProgram() == null || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getMiniProgram().getAppId()}) ? 1 : 0) != 0, (Object)"\u5c0f\u7a0b\u5e8fappid\u4e3a\u7a7a");
        try {
            String accessToken = this.officialTokenService.getOfficialAccessToken(params.getAppId());
            WeixinException weixinException = null;
            MsgId msgId = null;
            try {
                msgId = this.wxTemplateMsgApi.sendTemplateMsg(accessToken, (TemplateMsg)params);
            }
            catch (WeixinException e) {
                weixinException = e;
            }
            OfficialAccountTemplateMsg message = new OfficialAccountTemplateMsg();
            message.setAppId(params.getAppId());
            message.setOpenId(params.getToUserName());
            message.setMsgId(msgId == null ? "" : msgId.getMsgId());
            message.setTemplateId(params.getTemplateId());
            message.setTemplateData(JacksonUtil.obj2Str((Object)params.getData()));
            message.setBizId(params.getBizId());
            if (weixinException != null) {
                String errorMsg = weixinException.getErrorMsg();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errorMsg}) && errorMsg.length() > 400) {
                    errorMsg = errorMsg.substring(0, 400);
                }
                message.setFailReason(errorMsg);
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getUrl()})) {
                message.setTemplateUrl(params.getUrl());
            }
            if (params.getMiniProgram() != null) {
                message.setTemplateMiniProgram(JacksonUtil.obj2Str((Object)params.getMiniProgram()));
            }
            message.setCreatorId(LoginUtils.getCurrentUserId());
            message.setCreateTime(new Date());
            this.templateMsgMapper.insertSelective((Object)message);
            if (weixinException != null) {
                throw weixinException;
            }
            return msgId != null ? msgId.getMsgId() : "";
        }
        catch (WeixinException e) {
            if (e.getErrorCode() != 43004) {
                log.error("Failed to send appId={}, openId={}, templateId={}", new Object[]{params.getAppId(), params.getToUserName(), params.getTemplateId(), e});
                throw e;
            }
            log.warn("Failed to send appId={}, openId={}, templateId={}", new Object[]{params.getAppId(), params.getToUserName(), params.getTemplateId(), e});
            return null;
        }
        catch (Exception e) {
            log.error("send error", (Throwable)e);
            return null;
        }
    }

    @Override
    public void onTemplateSendJobFinish(TemplateSendJobFinishEvent event) {
        log.info("on template send job finish, event={}", (Object)event);
        String msgId = event.getMsgId();
        String status = event.getStatus();
        OfficialAccountTemplateMsg record = new OfficialAccountTemplateMsg();
        record.setMsgId(msgId);
        OfficialAccountTemplateMsg templateMsg = (OfficialAccountTemplateMsg)this.templateMsgMapper.selectOne((Object)record);
        if (templateMsg == null) {
            log.warn("Template msg not found with msgId={}", (Object)msgId);
            return;
        }
        Date jobFinishTime = new Date(event.getCreateTime() * 1000L);
        Date oldJobFinishTime = templateMsg.getJobFinishTime();
        if (oldJobFinishTime == null || jobFinishTime.after(oldJobFinishTime)) {
            templateMsg.setJobStatus(status);
            templateMsg.setJobFinishTime(jobFinishTime);
            this.templateMsgMapper.updateByPrimaryKeySelective((Object)templateMsg);
        }
    }

    @Override
    public void checkAndSetTemplate(String appId, String industryId) {
        IndustryInfo industry;
        String accessToken;
        block12: {
            log.info("check and set app template with appId={}, industryId={}", (Object)appId, (Object)industryId);
            Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId}), (Object)"appId is null");
            if (StringUtils.isBlank((CharSequence)industryId)) {
                industryId = "16";
            }
            accessToken = this.officialTokenService.getOfficialAccessToken(appId);
            industry = null;
            try {
                industry = this.wxTemplateMsgApi.getIndustry(accessToken);
            }
            catch (WeixinException e) {
                log.error("get template exception", (Throwable)e);
                if (!e.getErrorCode().equals(40102)) break block12;
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u786e\u8ba4\u5fae\u4fe1\u540e\u53f0\u5df2\u7ecf\u5f00\u901a\u6a21\u677f\u6d88\u606f\u4e14\u5df2\u6388\u6743\u7ed9\u5e73\u53f0");
            }
        }
        if (industry != null) {
            Industry primaryIndustry = industry.getPrimaryIndustry();
            Industry secondaryIndustry = industry.getSecondaryIndustry();
            if (!this.templateIndustryService.isSameIndustry(primaryIndustry, industryId) && !this.templateIndustryService.isSameIndustry(secondaryIndustry, industryId)) {
                this.setIndustry(primaryIndustry, secondaryIndustry, accessToken);
            }
            List privateTemplates = this.wxTemplateMsgApi.getAllPrivateTemplate(accessToken);
            boolean existFriendAddTemplate = false;
            boolean taskFinishTemplate = false;
            for (PrivateTemplate privateTemplate : privateTemplates) {
                if (privateTemplate.getTitle().equalsIgnoreCase("\u6210\u5458\u52a0\u5165\u63d0\u9192") && privateTemplate.getContent().equalsIgnoreCase("{{first.DATA}}\n\u59d3\u540d\uff1a{{keyword1.DATA}}\n\u65f6\u95f4\uff1a{{keyword2.DATA}}\n{{remark.DATA}}")) {
                    existFriendAddTemplate = true;
                    this.templateInfoMapper.saveOrUpdate(this.constructTemplateInfo(appId, "OPENTM405761503", privateTemplate.getTemplateId()));
                }
                if (!privateTemplate.getTitle().equalsIgnoreCase("\u4efb\u52a1\u5b8c\u6210\u63d0\u9192") || !privateTemplate.getContent().equalsIgnoreCase("{{first.DATA}}\n\u4efb\u52a1\u540d\u79f0\uff1a{{keyword1.DATA}}\n\u4efb\u52a1\u5185\u5bb9\uff1a{{keyword2.DATA}}\n\u5b8c\u6210\u60c5\u51b5\uff1a{{keyword3.DATA}}\n{{remark.DATA}}")) continue;
                taskFinishTemplate = true;
                this.templateInfoMapper.saveOrUpdate(this.constructTemplateInfo(appId, "OPENTM411436762", privateTemplate.getTemplateId()));
            }
            if (existFriendAddTemplate && taskFinishTemplate) {
                return;
            }
            try {
                String templateId;
                ArrayList templateInfoList = Lists.newArrayList();
                if (!existFriendAddTemplate) {
                    templateId = this.wxTemplateMsgApi.addPrivateTemplate(accessToken, "OPENTM405761503");
                    templateInfoList.add(this.constructTemplateInfo(appId, "OPENTM405761503", templateId));
                }
                if (!taskFinishTemplate) {
                    templateId = this.wxTemplateMsgApi.addPrivateTemplate(accessToken, "OPENTM411436762");
                    templateInfoList.add(this.constructTemplateInfo(appId, "OPENTM411436762", templateId));
                }
                this.templateInfoMapper.saveAll((List)templateInfoList);
            }
            catch (WeixinException e) {
                log.error("bind template fail, appId = " + appId, (Throwable)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u516c\u4f17\u53f7\u7ed1\u5b9a\u6a21\u677f\u5931\u8d25");
            }
        }
    }

    private OfficialAccountTemplateInfo constructTemplateInfo(String appId, String publicTemplateCode, String templateId) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        OfficialAccountTemplateInfo templateInfo = new OfficialAccountTemplateInfo();
        templateInfo.setBizId(userInfo.getBizId());
        templateInfo.setCorpId(userInfo.getCorpId());
        templateInfo.setAppId(appId);
        templateInfo.setPublicTemplateCode(publicTemplateCode);
        templateInfo.setTemplateId(templateId);
        return templateInfo;
    }

    private void setIndustry(Industry primaryIndustry, Industry secondaryIndustry, String accessToken) {
        String primaryCode = this.templateIndustryService.getIndustryCode(primaryIndustry);
        String secondaryCode = this.templateIndustryService.getIndustryCode(secondaryIndustry);
        SetIndustry setIndustry = new SetIndustry();
        try {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{primaryCode})) {
                setIndustry.setIndustryId1(primaryCode);
                setIndustry.setIndustryId2("16");
            } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{secondaryCode})) {
                setIndustry.setIndustryId1("16");
                setIndustry.setIndustryId2(secondaryCode);
            } else {
                setIndustry.setIndustryId1("16");
                setIndustry.setIndustryId2("16");
            }
            this.wxTemplateMsgApi.setIndustry(accessToken, setIndustry);
        }
        catch (WeixinException e) {
            log.error("mod industry fail", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u884c\u4e1a\u4e0d\u7b26\u5408\u8981\u6c42\u4e14\u672c\u6708\u65e0\u6cd5\u4fee\u6539\u884c\u4e1a");
        }
    }
}

