/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.message.service.impl;

import cn.kinyun.scrm.weixin.enums.ServantType;
import cn.kinyun.scrm.weixin.enums.SessionStatus;
import cn.kinyun.scrm.weixin.message.service.OfficialAccountMessageService;
import cn.kinyun.scrm.weixin.message.service.ServantSessionService;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.dal.official.base.dto.AppOpenUserIdDto;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountClientSession;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMessage;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountServantSession;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountServantSessionCriteria;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountClientSessionMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountServantSessionMapper;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServantSessionServiceImpl
implements ServantSessionService {
    private static final Logger log = LoggerFactory.getLogger(ServantSessionServiceImpl.class);
    @Resource
    private OfficialAccountClientSessionMapper officialAccountClientSessionMapper;
    @Resource
    private OfficialAccountServantSessionMapper officialAccountServantSessionMapper;
    @Autowired
    private OfficialAccountMessageService messageService;

    @Override
    public OfficialAccountServantSession get(Long clientSessionId) {
        log.info("get servant session with clientSessionId={}", (Object)clientSessionId);
        Preconditions.checkArgument((clientSessionId != null ? 1 : 0) != 0, (Object)"clientSessionId is null");
        return this.officialAccountServantSessionMapper.getByClientSessionId(clientSessionId);
    }

    @Override
    public OfficialAccountServantSession getById(Long id) {
        log.info("get servant session with id={}", (Object)id);
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"id is null");
        return (OfficialAccountServantSession)this.officialAccountServantSessionMapper.selectByPrimaryKey((Object)id);
    }

    @Override
    public boolean isValid(OfficialAccountServantSession session, Long expireTime) {
        long latestTime;
        if (session == null) {
            return false;
        }
        if (session.getStatus() == null || session.getStatus().intValue() == SessionStatus.CLOSE.getValue()) {
            return false;
        }
        if (session.getLatestTime() == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        return now <= (latestTime = session.getLatestTime().getTime()) + expireTime;
    }

    @Override
    public OfficialAccountServantSession queryValidateByAppIdOpenId(String appId, String openId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)appId), (Object)"appId is null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)openId), (Object)"openId is null or empty");
        return this.officialAccountServantSessionMapper.queryByAppIdOpenId(appId, openId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OfficialAccountServantSession create(Long clientSessionId, long expireTime, ServantType type, Long timestamp) {
        log.info("create servant session with clientSessionId={},expireTime={}, type={}, timestamp={}", new Object[]{clientSessionId, expireTime, type, timestamp});
        Preconditions.checkArgument((clientSessionId != null ? 1 : 0) != 0, (Object)"clientSessionId is null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type is null");
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        OfficialAccountServantSession session = new OfficialAccountServantSession();
        session.setClientSessionId(clientSessionId);
        session.setType(Integer.valueOf(type.getValue()));
        session.setLatestTime(new Date(timestamp));
        session.setExpireTime(new Date(timestamp + expireTime));
        session.setStatus(Integer.valueOf(SessionStatus.OPEN.getValue()));
        session.setNewMsgTime(new Date(timestamp));
        this.officialAccountServantSessionMapper.insertSelective((Object)session);
        return session;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OfficialAccountServantSession create(Long clientSessionId, long expireTime, ServantType type, Long timestamp, Long userId) {
        log.info("create servant session with clientSessionId={}, expireTime={} ,type={}, timestamp={}, userId={}", new Object[]{clientSessionId, expireTime, type, timestamp, userId});
        Preconditions.checkArgument((clientSessionId != null ? 1 : 0) != 0, (Object)"clientSessionId is null");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type is null");
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        OfficialAccountServantSession session = new OfficialAccountServantSession();
        session.setClientSessionId(clientSessionId);
        session.setUserId(userId);
        session.setType(Integer.valueOf(type.getValue()));
        session.setLatestTime(new Date(timestamp));
        session.setExpireTime(new Date(timestamp + expireTime));
        session.setStatus(Integer.valueOf(SessionStatus.OPEN.getValue()));
        session.setNewMsgTime(new Date(timestamp));
        this.officialAccountServantSessionMapper.insertSelective((Object)session);
        return session;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void destroy(Long id) {
        log.info("destroy servant session with id={}", (Object)id);
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"id is null or empty");
        OfficialAccountServantSession record = new OfficialAccountServantSession();
        record.setId(id);
        record.setStatus(Integer.valueOf(SessionStatus.CLOSE.getValue()));
        record.setUpdateTime(new Date());
        this.officialAccountServantSessionMapper.updateByPrimaryKeySelective((Object)record);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void destroy(List<Long> ids) {
        log.info("destroy servant session with ids={}", ids);
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is null or empty");
        OfficialAccountServantSessionCriteria condition = new OfficialAccountServantSessionCriteria();
        condition.createCriteria().andIdIn(ids);
        OfficialAccountServantSession record = new OfficialAccountServantSession();
        record.setStatus(Integer.valueOf(SessionStatus.CLOSE.getValue()));
        record.setUpdateTime(new Date());
        this.officialAccountServantSessionMapper.updateByExampleSelective((Object)record, (Object)condition);
    }

    @Override
    public void refresh(Long id, Long expireTime, Long timestamp) {
        log.info("refresh servant session with id={},expireTime={}, timestamp={}", new Object[]{id, expireTime, timestamp});
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        OfficialAccountServantSession session = new OfficialAccountServantSession();
        session.setId(id);
        session.setLatestTime(new Date(timestamp));
        session.setExpireTime(new Date(timestamp + expireTime));
        session.setUpdateTime(new Date());
        this.officialAccountServantSessionMapper.updateByPrimaryKeySelective((Object)session);
        AppOpenUserIdDto dto = this.officialAccountServantSessionMapper.queryAppOpenUserIdById(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int transferServantSession(Long fromSessionId, String toUserId) {
        log.info("transferServantSession with fromSessionId={},toUserId={}", (Object)fromSessionId, (Object)toUserId);
        Preconditions.checkArgument((fromSessionId != null ? 1 : 0) != 0, (Object)"fromSessionId can not be null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)toUserId), (Object)"toUserId can not be null or empty");
        OfficialAccountServantSession condition = new OfficialAccountServantSession();
        condition.setClientSessionId(fromSessionId);
        condition.setStatus(Integer.valueOf(0));
        condition.setIsDel(Integer.valueOf(0));
        OfficialAccountServantSession result = (OfficialAccountServantSession)this.officialAccountServantSessionMapper.selectOne((Object)condition);
        if (result == null) {
            return 0;
        }
        result.setStatus(Integer.valueOf(SessionStatus.CLOSE.getValue()));
        result.setUpdateTime(new Date());
        OfficialAccountServantSession newItem = new OfficialAccountServantSession();
        newItem.setIsDel(Integer.valueOf(0));
        newItem.setClientSessionId(result.getClientSessionId());
        newItem.setStatus(Integer.valueOf(0));
        newItem.setType(Integer.valueOf(1));
        newItem.setLatestTime(new Date());
        newItem.setExpireTime(result.getExpireTime());
        newItem.setUserId(Long.valueOf(toUserId));
        int count = this.officialAccountServantSessionMapper.insertSelective((Object)newItem);
        this.officialAccountServantSessionMapper.updateByPrimaryKeySelective((Object)result);
        return count;
    }

    @Override
    public Long queryLatestCustomerService(String appId, String openId) {
        log.info("queryLatestCustomerService with appId={},openId={}", (Object)appId, (Object)openId);
        OfficialAccountMessage message = this.messageService.queryLatestByOpenIdAppId(openId, appId);
        if (message == null) {
            return null;
        }
        return message.getUserId();
    }

    @Override
    public List<OfficialAccountServantSession> queryValidateSession(String appId, String openId, Long userId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)appId), (Object)"appId is null or empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)openId), (Object)"openId is null or empty");
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"userId is null");
        return this.officialAccountServantSessionMapper.queryValidateSession(openId, appId, userId);
    }

    @Override
    public OfficialAccountServantSession getLatestByClientSession(Long clientSessionId) {
        Preconditions.checkArgument((clientSessionId != null ? 1 : 0) != 0, (Object)"client session id is null");
        return this.officialAccountServantSessionMapper.getLatestByClientSessionId(clientSessionId);
    }

    @Override
    public Long getCurrentServantId(String appId, String openId) {
        OfficialAccountClientSession clientSession = this.officialAccountClientSessionMapper.getSession(openId, appId, 172800000L);
        OfficialAccountServantSession servantSession = null;
        if (clientSession != null && (servantSession = this.get(clientSession.getId())) != null && ServantType.HUMAN.getValue() == servantSession.getType().intValue()) {
            return servantSession.getUserId();
        }
        return null;
    }

    @Override
    public OfficialAccountServantSession getServingConversation(String appId, String openId) {
        long idleExpireTime;
        OfficialAccountServantSession servantSession;
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId}));
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{openId}));
        OfficialAccountClientSession clientSession = this.officialAccountClientSessionMapper.getSession(openId, appId, 172800000L);
        if (clientSession != null && this.isValid(servantSession = this.get(clientSession.getId()), idleExpireTime = 0L) && servantSession.getType().intValue() == ServantType.HUMAN.getValue()) {
            return servantSession;
        }
        return null;
    }
}

