/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.message.service.impl;

import cn.kinyun.scrm.weixin.enums.SessionStatus;
import cn.kinyun.scrm.weixin.message.service.ClientSessionService;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountClientSession;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountClientSessionMapper;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountServantSessionMapper;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ClientSessionServiceImpl
implements ClientSessionService {
    private static final Logger log = LoggerFactory.getLogger(ClientSessionServiceImpl.class);
    @Resource
    private OfficialAccountClientSessionMapper clientSessionMapper;
    @Resource
    private OfficialAccountServantSessionMapper servantSessionMapper;

    @Override
    public OfficialAccountClientSession getOrCreate(String openId, String appId, Long timestamp) {
        log.info("get client session with openId={}, appId={}", (Object)openId, (Object)appId);
        Preconditions.checkArgument((openId != null ? 1 : 0) != 0, (Object)"openId is null");
        Preconditions.checkArgument((appId != null ? 1 : 0) != 0, (Object)"appId is null");
        OfficialAccountClientSession session = this.clientSessionMapper.getSession(openId, appId, 172800000L);
        if (session == null) {
            return this.create(openId, appId, timestamp);
        }
        if (!this.isValid(session)) {
            this.destroy(session.getId());
            session = null;
        }
        if (session == null) {
            session = this.create(openId, appId, timestamp);
        } else if (timestamp != null) {
            this.refresh(session, timestamp);
        }
        return session;
    }

    @Override
    public boolean isValid(OfficialAccountClientSession session) {
        long latestTime;
        if (session == null) {
            return false;
        }
        if (session.getStatus() == null || session.getStatus().intValue() == SessionStatus.CLOSE.getValue()) {
            return false;
        }
        if (session.getLatestTime() == null) {
            return false;
        }
        long now = System.currentTimeMillis();
        return now <= (latestTime = session.getLatestTime().getTime()) + 172800000L;
    }

    @Override
    public OfficialAccountClientSession queryByFansId(String appId, String openId) {
        log.info("query client session with openId={}, appId={}", (Object)openId, (Object)appId);
        Preconditions.checkArgument((openId != null ? 1 : 0) != 0, (Object)"openId is null");
        Preconditions.checkArgument((appId != null ? 1 : 0) != 0, (Object)"appId is null");
        return this.clientSessionMapper.getSession(openId, appId, 172800000L);
    }

    @Override
    public OfficialAccountClientSession create(String openId, String appId) {
        return this.create(openId, appId, System.currentTimeMillis());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OfficialAccountClientSession create(String openId, String appId, Long timestamp) {
        log.info("create client session with openId={}, appId={}", (Object)openId, (Object)appId);
        OfficialAccountClientSession clientSession = new OfficialAccountClientSession();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        clientSession.setBizId(userInfo.getBizId());
        clientSession.setCorpId(userInfo.getCorpId());
        clientSession.setOpenId(openId);
        clientSession.setAppId(appId);
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        clientSession.setLatestTime(new Date(timestamp));
        clientSession.setExpireTime(new Date(timestamp + 172800000L));
        clientSession.setStatus(Integer.valueOf(SessionStatus.OPEN.getValue()));
        this.clientSessionMapper.insertSelective((Object)clientSession);
        return clientSession;
    }

    private void refresh(OfficialAccountClientSession session, Long timestamp) {
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        session.setLatestTime(new Date(timestamp));
        session.setExpireTime(new Date(timestamp + 172800000L));
        session.setUpdateTime(new Date());
        this.clientSessionMapper.updateByPrimaryKeySelective((Object)session);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void destroy(Long id) {
        this.clientSessionMapper.updateStatusById(id, SessionStatus.CLOSE.getValue());
        this.servantSessionMapper.updateStatusByClientSessionId(id, SessionStatus.CLOSE.getValue());
    }
}

