/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.menu.service.impl;

import cn.kinyun.scrm.weixin.menu.service.OfficialMenuService;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.base.entity.OfficialMenu;
import com.kuaike.scrm.dal.official.base.entity.OfficialMenuCriteria;
import com.kuaike.scrm.dal.official.base.mapper.OfficialMenuMapper;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OfficialMenuServiceImpl
implements OfficialMenuService {
    private static final Logger log = LoggerFactory.getLogger(OfficialMenuServiceImpl.class);
    @Resource
    private OfficialMenuMapper officialMenuMapper;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insert(@NonNull String appId, @NonNull String content, @NonNull Long operatorId) {
        if (appId == null) {
            throw new NullPointerException("appId is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        if (operatorId == null) {
            throw new NullPointerException("operatorId is marked non-null but is null");
        }
        log.info("insert OfficialMenu with appId={},content={},operatorId={}", new Object[]{appId, content, operatorId});
        Preconditions.checkArgument((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{appId, content}), (Object)"appId,content can not be null or empty");
        Preconditions.checkArgument((operatorId != null ? 1 : 0) != 0, (Object)"operatorId can not be null");
        OfficialMenu menu = new OfficialMenu();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        menu.setBizId(userInfo.getBizId());
        menu.setCorpId(userInfo.getCorpId());
        menu.setAppId(appId);
        menu.setIsDelete(Integer.valueOf(0));
        menu.setMenuContent(content);
        menu.setCreatorId(operatorId);
        this.officialMenuMapper.insertSelective((Object)menu);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertOrUpdate(String appId, String content, Long operatorId) {
        log.info("insetOrUpdate with appId={},content={},operatorId={}", new Object[]{appId, content, operatorId});
        Preconditions.checkArgument((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{appId, content}), (Object)"appId,content can not be null or empty");
        Preconditions.checkArgument((operatorId != null ? 1 : 0) != 0, (Object)"operatorId can not be null");
        OfficialMenuCriteria condition = new OfficialMenuCriteria();
        condition.createCriteria().andIsDeleteEqualTo(Integer.valueOf(0)).andAppIdEqualTo(appId);
        OfficialMenu menu = new OfficialMenu();
        menu.setMenuContent(content);
        int item = this.officialMenuMapper.updateByExampleSelective((Object)menu, (Object)condition);
        if (item == 0) {
            this.insert(appId, content, operatorId);
        } else {
            int count = this.officialMenuMapper.deleteDuplicateRow(appId);
            log.info("\u5220\u9664\u4e86{}\u6761\u91cd\u590d\u7684\u8bb0\u5f55", (Object)count);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(String appId, String oldContent, String content, Long operatorId) {
        log.info("update OfficialMenu with appId={},oldContent={},content={},operatorId={}", new Object[]{appId, oldContent, content, operatorId});
        OfficialMenuCriteria criteria = new OfficialMenuCriteria();
        criteria.createCriteria().andAppIdEqualTo(appId).andIsDeleteEqualTo(Integer.valueOf(0));
        OfficialMenu menu = new OfficialMenu();
        menu.setMenuContent(content);
        menu.setUpdateId(operatorId);
        this.officialMenuMapper.updateByExampleSelective((Object)menu, (Object)criteria);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(String appId, Long operatorId) {
        log.info("delete OfficialMenu with appId={},operatorId={}", (Object)appId, (Object)operatorId);
        OfficialMenuCriteria criteria = new OfficialMenuCriteria();
        criteria.createCriteria().andAppIdEqualTo(appId).andIsDeleteEqualTo(Integer.valueOf(0));
        OfficialMenu menu = new OfficialMenu();
        menu.setAppId(appId);
        menu.setIsDelete(Integer.valueOf(1));
        menu.setUpdateId(operatorId);
        this.officialMenuMapper.updateByExampleSelective((Object)menu, (Object)criteria);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String content(String appId) {
        log.info("query OfficialMenu content with appId={}", (Object)appId);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)appId), (Object)"appId can not be null or empty");
        OfficialMenu condition = new OfficialMenu();
        condition.setAppId(appId);
        condition.setIsDelete(Integer.valueOf(0));
        OfficialMenu menu = (OfficialMenu)this.officialMenuMapper.selectOne((Object)condition);
        if (menu == null) {
            return "";
        }
        return menu.getMenuContent();
    }

    @Override
    public OfficialMenu queryMenu(String appId) {
        log.info("queryMenu with appId={}", (Object)appId);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)appId), (Object)"appId can not be null or empty");
        OfficialMenu condition = new OfficialMenu();
        condition.setAppId(appId);
        condition.setIsDelete(Integer.valueOf(0));
        return (OfficialMenu)this.officialMenuMapper.selectOne((Object)condition);
    }
}

