/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.material.service.impl;

import cn.kinyun.scrm.weixin.common.dto.UserInfoRespDto;
import cn.kinyun.scrm.weixin.common.service.UserInfoService;
import cn.kinyun.scrm.weixin.material.dto.SimpleUserInfoDto;
import cn.kinyun.scrm.weixin.material.dto.SmallRoutineRespDto;
import cn.kinyun.scrm.weixin.material.dto.req.AddSmallRoutineReq;
import cn.kinyun.scrm.weixin.material.dto.req.MaterialMoveGroupReq;
import cn.kinyun.scrm.weixin.material.dto.req.SmallRoutineListReq;
import cn.kinyun.scrm.weixin.material.service.SmallRoutineService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.IsDelete;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.Md5Util;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterialGroup;
import com.kuaike.scrm.dal.official.material.entity.SmallRoutine;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialGroupMapper;
import com.kuaike.scrm.dal.official.material.mapper.SmallRoutineMapper;
import com.kuaike.scrm.dal.permission.mapper.UserRoleMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SmallRoutineServiceImpl
implements SmallRoutineService {
    private static final Logger log = LoggerFactory.getLogger(SmallRoutineServiceImpl.class);
    @Resource
    SmallRoutineMapper smallRoutineMapper;
    @Resource
    OfficialMaterialGroupMapper materialGroupMapper;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private UserInfoService userInfoService;
    private static final String EMPTY_STR = "empty";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addSmallRoutinee(AddSmallRoutineReq req) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("add small routine with params={}, operatorId={}", (Object)req, (Object)currentUser.getId());
        Preconditions.checkArgument((req.getAppId() != null ? 1 : 0) != 0, (Object)"appId is null!");
        SmallRoutine old = this.getSmallRoutine(req.getAppId(), 0L, -1L, req.getPagePath());
        if (old != null && old.getIsDeleted().intValue() == IsDelete.NOT_DELETED.getDelStatus()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5c0f\u7a0b\u5e8f\u5df2\u7ecf\u5b58\u5728");
        }
        SmallRoutine smallRoutine = this.from(req, 0L, LoginUtils.getCurrentUser().getId());
        if (old == null) {
            this.smallRoutineMapper.insertSelective((Object)smallRoutine);
        } else {
            smallRoutine.setId(old.getId());
            smallRoutine.setIsDeleted(Integer.valueOf(IsDelete.NOT_DELETED.getDelStatus()));
            this.smallRoutineMapper.updateByPrimaryKeySelective((Object)smallRoutine);
        }
        return smallRoutine.getId();
    }

    private SmallRoutine getSmallRoutine(String appId, Long nodeId, Long groupId, String pagePath) {
        SmallRoutine record = new SmallRoutine();
        record.setAppId(appId);
        record.setNodeId(nodeId);
        record.setGroupId(groupId);
        if (StringUtils.isNotBlank((CharSequence)pagePath)) {
            record.setPagePathMd5(Md5Util.md5((String)pagePath));
        } else {
            record.setPagePathMd5(EMPTY_STR);
        }
        List list = this.smallRoutineMapper.select((Object)record);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (SmallRoutine)list.get(0);
        }
        return null;
    }

    @Override
    public List<SmallRoutineRespDto> list(SmallRoutineListReq params) {
        log.info("query smallrotine list with params={}, operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        PageDto pageDto = params.getPageDto();
        List smallRoutineList = this.smallRoutineMapper.list(params.getNickName(), params.getTitle(), params.getCreatorId(), params.getNodeId(), params.getGroupId(), Integer.valueOf(IsDelete.NOT_DELETED.getDelStatus()), pageDto);
        if (CollectionUtils.isEmpty((Collection)smallRoutineList)) {
            return Lists.newArrayList();
        }
        pageDto.setCurPageCount(Integer.valueOf(smallRoutineList.size()));
        pageDto.setCount(Integer.valueOf(this.smallRoutineMapper.countList(params.getNickName(), params.getTitle(), params.getCreatorId(), params.getNodeId(), params.getGroupId(), Integer.valueOf(IsDelete.NOT_DELETED.getDelStatus()))));
        ArrayList result = Lists.newArrayList();
        HashSet userIds = Sets.newHashSet();
        HashSet groupIds = Sets.newHashSet();
        for (SmallRoutine smallRoutine : smallRoutineList) {
            userIds.add(smallRoutine.getCreatorId());
            groupIds.add(smallRoutine.getGroupId());
        }
        Map groupMap = this.materialGroupMapper.queryListByIds((List)Lists.newArrayList((Iterable)groupIds)).stream().collect(Collectors.toMap(a -> a.getId(), Function.identity()));
        Map<Long, UserInfoRespDto> userMap = this.userInfoService.queryUserInfoMap(userIds);
        for (SmallRoutine smalRoutine : smallRoutineList) {
            OfficialMaterialGroup group = (OfficialMaterialGroup)groupMap.get(smalRoutine.getGroupId());
            UserInfoRespDto user = userMap.get(smalRoutine.getCreatorId());
            Node node = this.nodeService.getNode(smalRoutine.getNodeId(), userInfo.getBizId());
            SmallRoutineRespDto dto = this.from(smalRoutine, user, group, node);
            result.add(dto);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(Long id) {
        log.info("delete smallRoutine with id={}, operatorId={}", (Object)id, (Object)LoginUtils.getCurrentUserId());
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"id is null!");
        SmallRoutine smallRoutine = (SmallRoutine)this.smallRoutineMapper.selectByPrimaryKey((Object)id);
        if (smallRoutine == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5c0f\u7a0b\u5e8f\u4e0d\u5b58\u5728");
        }
        SmallRoutine update = new SmallRoutine();
        update.setId(id);
        update.setIsDeleted(Integer.valueOf(IsDelete.DELETED.getDelStatus()));
        this.smallRoutineMapper.updateByPrimaryKeySelective((Object)update);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void moveGroup(MaterialMoveGroupReq params) {
        log.info("move group with params={}, operatorId={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        List<Long> ids = params.getIds();
        Long nodeId = params.getNodeId();
        Long groupId = params.getGroupId();
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty!");
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Set roleNodeIds = this.userRoleMapper.queryManageNodeIds(currentUser.getBizId(), currentUser.getCurRole().getRoleId(), currentUser.getId());
        ArrayList nodeIds = Lists.newArrayList((Iterable)this.nodeService.getPosterityIds((Collection)roleNodeIds, currentUser.getBizId()));
        List list = this.smallRoutineMapper.selectByPrimaryIds(ids);
        HashSet appIds = Sets.newHashSet();
        HashMap appMap = Maps.newHashMap();
        for (SmallRoutine m : list) {
            appIds.add(m.getAppId());
            Set tmp = appMap.getOrDefault(m.getAppId(), Sets.newHashSet());
            tmp.add(m.getPagePathMd5());
            appMap.put(m.getAppId(), tmp);
        }
        List existList = this.smallRoutineMapper.querySmallRoutineList(nodeId, groupId, (Collection)appIds);
        HashSet delIds = Sets.newHashSet();
        for (SmallRoutine m : existList) {
            if (!((Set)appMap.getOrDefault(m.getAppId(), Sets.newHashSet())).contains(m.getPagePathMd5())) continue;
            delIds.add(m.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)delIds)) {
            this.smallRoutineMapper.delByIds((Collection)delIds);
        }
        this.smallRoutineMapper.moveGroup(ids, nodeId, groupId);
    }

    private SmallRoutineRespDto from(SmallRoutine smallRoutine, UserInfoRespDto user, OfficialMaterialGroup group, Node node) {
        SmallRoutineRespDto respDto = new SmallRoutineRespDto();
        respDto.setId(smallRoutine.getId());
        respDto.setAppId(smallRoutine.getAppId());
        respDto.setCreateTime(smallRoutine.getCreateTime());
        SimpleUserInfoDto creator = new SimpleUserInfoDto();
        creator.setId(smallRoutine.getCreatorId());
        if (user != null) {
            creator.setUsername(user.getUsername());
            creator.setNickname(user.getNickname());
        }
        respDto.setCreator(creator);
        respDto.setDescription(smallRoutine.getDescription());
        respDto.setGroupId(smallRoutine.getGroupId());
        if (group == null) {
            respDto.setGroupName("\u672a\u5206\u7ec4");
        } else {
            respDto.setGroupName(group.getGroupName());
        }
        respDto.setIconUrl(smallRoutine.getIconUrl());
        respDto.setNickName(smallRoutine.getNickName());
        respDto.setIsDel(smallRoutine.getIsDeleted());
        respDto.setNodeId(node.getId());
        respDto.setNodename(node.getName());
        respDto.setPagePath(smallRoutine.getPagePath());
        respDto.setThumbIconUrl(smallRoutine.getThumbIconUrl());
        respDto.setTitle(smallRoutine.getTitle());
        respDto.setUrl(smallRoutine.getUrl());
        respDto.setUserName(smallRoutine.getUserName());
        return respDto;
    }

    private Node getbranchNode(Long nodeId) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Node belongNode = this.nodeService.getNode(nodeId, currentUser.getBizId());
        if (belongNode.getType() == 1L) {
            return belongNode;
        }
        for (int i = belongNode.getIds().size() - 1; i >= 0; --i) {
            Node tmpNode = this.nodeService.getNode((Long)belongNode.getIds().get(i), currentUser.getBizId());
            if (tmpNode.getType() != 1L) continue;
            return tmpNode;
        }
        return null;
    }

    private SmallRoutine from(AddSmallRoutineReq addSmallRoutineReq, Long nodeId, Long creatorId) {
        Date now = new Date();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        SmallRoutine smallRoutine = new SmallRoutine();
        smallRoutine.setBizId(userInfo.getBizId());
        smallRoutine.setCorpId(userInfo.getCorpId());
        smallRoutine.setAppId(addSmallRoutineReq.getAppId());
        smallRoutine.setCreatorId(creatorId);
        smallRoutine.setCreateTime(now);
        smallRoutine.setDescription(addSmallRoutineReq.getDescription());
        smallRoutine.setGroupId(Long.valueOf(-1L));
        smallRoutine.setIconUrl(addSmallRoutineReq.getIconUrl());
        smallRoutine.setPagePath(addSmallRoutineReq.getPagePath());
        smallRoutine.setNickName(addSmallRoutineReq.getNickName());
        smallRoutine.setNodeId(nodeId);
        smallRoutine.setThumbIconUrl(addSmallRoutineReq.getThumbIconUrl());
        smallRoutine.setTitle(addSmallRoutineReq.getTitle());
        smallRoutine.setUrl(addSmallRoutineReq.getUrl());
        smallRoutine.setUserName(addSmallRoutineReq.getUserName());
        smallRoutine.setUpdateTime(now);
        if (StringUtils.isNotBlank((CharSequence)addSmallRoutineReq.getPagePath())) {
            smallRoutine.setPagePathMd5(Md5Util.md5((String)addSmallRoutineReq.getPagePath()));
        } else {
            smallRoutine.setPagePathMd5(EMPTY_STR);
        }
        return smallRoutine;
    }
}

