/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.material.service.impl;

import cn.kinyun.scrm.weixin.material.dto.RamImageDto;
import cn.kinyun.scrm.weixin.material.dto.req.ExternalImageReq;
import cn.kinyun.scrm.weixin.material.dto.resp.ExternalImageResp;
import cn.kinyun.scrm.weixin.material.dto.resp.MyStorage;
import cn.kinyun.scrm.weixin.material.enums.MaterialFileLimit;
import cn.kinyun.scrm.weixin.material.service.MaterialUploadService;
import cn.kinyun.scrm.weixin.utils.ExternalImgGet;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.MD5Utils;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.AliyunOssUtils;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.material.entity.OfficialMaterialFile;
import com.kuaike.scrm.dal.official.material.mapper.OfficialMaterialFileMapper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;
import org.springframework.web.multipart.MultipartFile;
import ws.schild.jave.FfmpegUtils;

@Service
public class MaterialUploadServiceImpl
implements MaterialUploadService {
    private static final Logger log = LoggerFactory.getLogger(MaterialUploadServiceImpl.class);
    @Resource
    private OfficialMaterialFileMapper materialFileMapper;
    @Value(value="${skynet.material.cover.maxWidth:160}")
    private Integer maxCoverWidth = 160;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MyStorage upload(MultipartFile multipartFile, String fileName) {
        String format = FfmpegUtils.getSuffix(fileName);
        if (!MaterialFileLimit.contains(format)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u8bc6\u522b\u7684\u683c\u5f0f");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        StopWatch watch = new StopWatch();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)multipartFile.getInputStream(), (OutputStream)output, (int)4096);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
        byte[] data = output.toByteArray();
        watch.start("\u8ba1\u7b97\u6587\u4ef6\u6307\u7eb9");
        String sha1 = FfmpegUtils.getSha1(data);
        log.info("sha1 str: {}", (Object)sha1);
        watch.stop();
        log.info("\u8ba1\u7b97\u6587\u4ef6\u6307\u7eb9\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
        watch.start();
        OfficialMaterialFile materialFile = this.materialFileMapper.getBySha1Str(sha1);
        watch.stop();
        log.info("\u67e5\u8be2\u6587\u4ef6\u6307\u7eb9\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
        File source = null;
        File target = null;
        File target2 = null;
        try {
            watch.start();
            String newFileName = this.buildNewFileName(fileName);
            source = new File("temp", newFileName).getAbsoluteFile();
            if (!source.getParentFile().exists()) {
                source.getParentFile().mkdir();
            }
            IOUtils.write((byte[])data, (OutputStream)new FileOutputStream(source));
            watch.stop();
            log.info("\u5199\u6587\u4ef6\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
            if (materialFile != null) {
                this.checkAndUpdateUrl3(materialFile, source);
                MyStorage s = this.build(materialFile, fileName);
                String existSuffix = FfmpegUtils.getSuffix(materialFile.getUrl());
                Preconditions.checkArgument((boolean)format.equalsIgnoreCase(existSuffix), (Object)("\u8be5\u7d20\u6750\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u4f46\u6587\u4ef6\u683c\u5f0f\u4e3a" + existSuffix + "\uff0c\u4e0e\u672c\u6b21\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u4e00\u81f4\u3002"));
                MyStorage myStorage = s;
                return myStorage;
            }
            materialFile = new OfficialMaterialFile();
            watch.start();
            MyStorage mainStorage = this.upload(source);
            watch.stop();
            log.info("\u4e3b\u6587\u4ef6\u4e0a\u4f20\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
            mainStorage.setFileName(fileName);
            String url = mainStorage.getUrl();
            boolean isAudio = false;
            if (FfmpegUtils.hasVideo(source)) {
                if ("mp4".equals(format)) {
                    watch.start();
                    target = FfmpegUtils.getVideoImage(source, this.maxCoverWidth);
                    watch.stop();
                    log.info("\u8f6c\u7801mp4\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
                }
            } else if (FfmpegUtils.hasAudio(source)) {
                isAudio = true;
                if ("amr".equalsIgnoreCase(format)) {
                    watch.start();
                    target = FfmpegUtils.getAudioMp3(source);
                    watch.stop();
                    log.info("\u8f6c\u7801mp3\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
                } else if ("mp3".equals(format) || "wma".equals(format) || "wav".equals(format)) {
                    watch.start();
                    target = FfmpegUtils.getAudioAmr(source);
                    watch.stop();
                    log.info("\u8f6c\u7801amr\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
                    if (!"mp3".equals(format)) {
                        target2 = FfmpegUtils.getAudioMp3(source);
                    }
                }
            }
            if (target != null) {
                watch.start();
                MyStorage childStorage = this.upload(target);
                watch.stop();
                log.info("\u526f\u6587\u4ef6\u4e0a\u4f20\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
                if (childStorage != null) {
                    String url2 = childStorage.getUrl();
                    materialFile.setUrl2(url2);
                    materialFile.setUrl2Md5(MD5Utils.MD5Encode8((String)url2));
                    mainStorage.setUrl2(childStorage.getUrl());
                }
            }
            if (target2 != null) {
                watch.start();
                MyStorage childStorage2 = this.upload(target2);
                watch.stop();
                log.info("\u526f\u6587\u4ef6\u4e0a\u4f20\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
                if (childStorage2 != null) {
                    String url3 = childStorage2.getUrl();
                    materialFile.setUrl3(url3);
                    materialFile.setUrl3Md5(MD5Utils.MD5Encode8((String)url3));
                    mainStorage.setUrl3(childStorage2.getUrl());
                }
            }
            materialFile.setFileSize(Integer.valueOf((int)(source.length() / 1024L)));
            materialFile.setSha1Str(sha1);
            materialFile.setFileFormat(format);
            if (materialFile.getDuration() == null) {
                materialFile.setDuration(Long.valueOf(FfmpegUtils.getDuration(source)));
                mainStorage.setDuration(materialFile.getDuration());
            }
            materialFile.setUrl(url);
            materialFile.setUrlMd5(MD5Utils.MD5Encode8((String)url));
            if (isAudio) {
                this.handleUrl3(format, materialFile, mainStorage);
            }
            materialFile.setBizId(userInfo.getBizId());
            materialFile.setCorpId(userInfo.getCorpId());
            this.materialFileMapper.insertSelective((Object)materialFile);
            MyStorage myStorage = mainStorage;
            return myStorage;
        }
        catch (Exception e) {
            log.error("\u7d20\u6750\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
        finally {
            if (source != null && source.exists()) {
                source.delete();
            }
            if (target != null && target.exists()) {
                target.delete();
            }
            if (target2 != null && target2.exists()) {
                target2.delete();
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public MyStorage uploadFile(MultipartFile multipartFile, String fileName) {
        String format = FfmpegUtils.getSuffix(fileName);
        if (!MaterialFileLimit.contains(format)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u8bc6\u522b\u7684\u683c\u5f0f");
        }
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        StopWatch watch = new StopWatch();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)multipartFile.getInputStream(), (OutputStream)output, (int)4096);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
        byte[] data = output.toByteArray();
        watch.start("\u8ba1\u7b97\u6587\u4ef6\u6307\u7eb9");
        String sha1 = FfmpegUtils.getSha1(data);
        log.info("sha1 str: {}", (Object)sha1);
        watch.stop();
        log.info("\u8ba1\u7b97\u6587\u4ef6\u6307\u7eb9\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
        watch.start();
        OfficialMaterialFile materialFile = this.materialFileMapper.getBySha1Str(sha1);
        watch.stop();
        log.info("\u67e5\u8be2\u6587\u4ef6\u6307\u7eb9\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
        if (materialFile != null) {
            MyStorage s = new MyStorage();
            s.setFileName(fileName);
            s.setUrl(materialFile.getUrl());
            String existSuffix = FfmpegUtils.getSuffix(materialFile.getUrl());
            Preconditions.checkArgument((boolean)format.equalsIgnoreCase(existSuffix), (Object)("\u8be5\u7d20\u6750\u6587\u4ef6\u5df2\u5b58\u5728\uff0c\u4f46\u6587\u4ef6\u683c\u5f0f\u4e3a" + existSuffix + "\uff0c\u4e0e\u672c\u6b21\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u4e00\u81f4\u3002"));
            return s;
        }
        File source = null;
        try {
            watch.start();
            String newFileName = this.buildNewFileName(fileName);
            source = new File("temp", newFileName).getAbsoluteFile();
            if (!source.getParentFile().exists()) {
                source.getParentFile().mkdir();
            }
            IOUtils.write((byte[])data, (OutputStream)new FileOutputStream(source));
            watch.stop();
            log.info("\u5199\u6587\u4ef6\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
            watch.start();
            MyStorage mainStorage = this.upload(source);
            watch.stop();
            log.info("\u4e3b\u6587\u4ef6\u4e0a\u4f20\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
            mainStorage.setFileName(fileName);
            String url = mainStorage.getUrl();
            materialFile = new OfficialMaterialFile();
            materialFile.setFileSize(Integer.valueOf((int)(source.length() / 1024L)));
            materialFile.setSha1Str(sha1);
            materialFile.setFileFormat(format);
            materialFile.setUrl(url);
            materialFile.setUrlMd5(MD5Utils.MD5Encode8((String)url));
            materialFile.setBizId(userInfo.getBizId());
            materialFile.setCorpId(userInfo.getCorpId());
            this.materialFileMapper.insertSelective((Object)materialFile);
            MyStorage myStorage = mainStorage;
            return myStorage;
        }
        catch (Exception e) {
            log.error("\u7d20\u6750\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
        finally {
            if (source != null && source.exists()) {
                source.delete();
            }
        }
    }

    private void handleUrl3(String format, OfficialMaterialFile materialFile, MyStorage mainStorage) {
        if ("mp3".equals(format)) {
            materialFile.setUrl3(materialFile.getUrl());
            materialFile.setUrl3Md5(materialFile.getUrlMd5());
            mainStorage.setUrl3(materialFile.getUrl());
        } else if ("amr".equalsIgnoreCase(format)) {
            materialFile.setUrl3(materialFile.getUrl2());
            materialFile.setUrl3Md5(materialFile.getUrl2Md5());
            mainStorage.setUrl3(materialFile.getUrl2());
        }
        mainStorage.setDuration(materialFile.getDuration());
        mainStorage.setSize(materialFile.getFileSize());
    }

    private void checkAndUpdateUrl3(OfficialMaterialFile materialFile, File source) {
        String format = materialFile.getFileFormat();
        if (FfmpegUtils.hasVideo(source) || StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{materialFile.getUrl3()})) {
            return;
        }
        if (FfmpegUtils.hasAudio(source)) {
            if ("mp3".equalsIgnoreCase(format)) {
                materialFile.setUrl3(materialFile.getUrl());
            } else if ("amr".equalsIgnoreCase(format)) {
                materialFile.setUrl3(materialFile.getUrl2());
            } else {
                File mp3File = FfmpegUtils.getAudioMp3(source);
                MyStorage storage = this.upload(mp3File);
                if (storage != null) {
                    materialFile.setUrl3(storage.getUrl());
                    materialFile.setUrl3Md5(MD5Utils.MD5Encode8((String)storage.getUrl()));
                }
            }
        }
        this.materialFileMapper.updateByPrimaryKeySelective((Object)materialFile);
    }

    private String buildNewFileName(String fileName) {
        String extension = FilenameUtils.getExtension((String)fileName);
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            return UUID.randomUUID().toString() + "." + extension;
        }
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExternalImageResp uploadExternalImage2OSS(ExternalImageReq param) {
        Preconditions.checkArgument((param != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{param.getUrl()}), (Object)"\u56fe\u7247\u5730\u5740\u4e3a\u7a7a");
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        ExternalImageResp resp = null;
        RamImageDto image = ExternalImgGet.get(param.getUrl());
        Preconditions.checkArgument((image != null ? 1 : 0) != 0, (Object)"\u83b7\u53d6\u56fe\u7247\u5931\u8d25");
        byte[] data = image.getData();
        String sha1 = FfmpegUtils.getSha1(data);
        OfficialMaterialFile materialFile = this.materialFileMapper.getBySha1Str(sha1);
        if (materialFile != null) {
            resp = new ExternalImageResp();
            resp.setFileName(image.getFileName());
            resp.setUrl(materialFile.getUrl());
            return resp;
        }
        String fileName = image.getFileName();
        String format = FfmpegUtils.getSuffix(fileName);
        if (format == null) {
            format = image.getFormat();
        }
        if (!MaterialFileLimit.WEIXIN_IMAGE.checkFormat(format)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u8bc6\u522b\u7684\u683c\u5f0f");
        }
        File source = null;
        try {
            String newFileName = UUID.randomUUID().toString() + "-" + fileName;
            source = new File("temp", newFileName).getAbsoluteFile();
            if (!source.getParentFile().exists()) {
                source.getParentFile().mkdir();
            }
            IOUtils.write((byte[])data, (OutputStream)new FileOutputStream(source));
            MyStorage mainStorage = this.upload(source);
            String url = mainStorage.getUrl();
            resp = new ExternalImageResp();
            resp.setFileName(fileName);
            resp.setUrl(url);
            materialFile = new OfficialMaterialFile();
            materialFile.setFileSize(Integer.valueOf((int)(source.length() / 1024L)));
            materialFile.setSha1Str(sha1);
            materialFile.setFileFormat(format);
            materialFile.setDuration(Long.valueOf(0L));
            materialFile.setUrl(url);
            materialFile.setUrlMd5(MD5Utils.MD5Encode8((String)url));
            materialFile.setBizId(userInfo.getBizId());
            materialFile.setCorpId(userInfo.getCorpId());
            this.materialFileMapper.insertSelective((Object)materialFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u4e0a\u4f20\u56fe\u7247\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (source != null) {
                source.delete();
                source = null;
            }
        }
        return resp;
    }

    private MyStorage upload(File file) {
        try {
            CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
            String url = AliyunOssUtils.uploadFile((String)userInfo.getCorpId(), (File)file, (String)file.getName());
            MyStorage storage = new MyStorage();
            storage.setStorageId(0L);
            storage.setUrl(url);
            storage.setFileName(file.getName());
            return storage;
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u7d20\u6750\u5931\u8d25", (Throwable)e);
            FileUtils.deleteQuietly((File)file);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
    }

    private MyStorage build(OfficialMaterialFile file, String fileName) {
        MyStorage s = new MyStorage();
        s.setFileName(fileName);
        s.setUrl(file.getUrl());
        s.setUrl2(file.getUrl2());
        s.setUrl3(file.getUrl3());
        s.setDuration(file.getDuration());
        return s;
    }

    private Optional<OfficialMaterialFile> selectByFileSha1(String sha1) {
        OfficialMaterialFile file = this.materialFileMapper.getBySha1Str(sha1);
        return Optional.ofNullable(file);
    }

    private OfficialMaterialFile saveMaterialFile(String sha1, File source, String ossUrl) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        OfficialMaterialFile materialFile = new OfficialMaterialFile();
        materialFile.setFileSize(Integer.valueOf((int)(source.length() / 1024L)));
        materialFile.setSha1Str(sha1);
        materialFile.setFileFormat("mp4");
        materialFile.setDuration(Long.valueOf(FfmpegUtils.getDuration(source)));
        materialFile.setUrl(ossUrl);
        materialFile.setUrlMd5(MD5Utils.MD5Encode8((String)ossUrl));
        materialFile.setBizId(userInfo.getBizId());
        materialFile.setCorpId(userInfo.getCorpId());
        try {
            this.materialFileMapper.insertSelective((Object)materialFile);
        }
        catch (DuplicateKeyException e) {
            log.warn("duplicate key :{}", (Object)sha1);
            materialFile = this.selectByFileSha1(sha1).orElse(new OfficialMaterialFile());
        }
        return materialFile;
    }

    private String buildVideoName() {
        return UUID.randomUUID().toString().replace("-", "") + ".mp4";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String upload(File file, String fileName) {
        String format = FfmpegUtils.getSuffix(fileName);
        StopWatch watch = new StopWatch();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)new FileInputStream(file), (OutputStream)output, (int)4096);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
        byte[] data = output.toByteArray();
        watch.start("\u8ba1\u7b97\u6587\u4ef6\u6307\u7eb9");
        String sha1 = FfmpegUtils.getSha1(data);
        log.info("sha1 str: {}", (Object)sha1);
        watch.stop();
        log.info("\u8ba1\u7b97\u6587\u4ef6\u6307\u7eb9\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
        watch.start();
        OfficialMaterialFile materialFile = this.materialFileMapper.getBySha1Str(sha1);
        watch.stop();
        log.info("\u67e5\u8be2\u6587\u4ef6\u6307\u7eb9\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
        if (materialFile != null) {
            return materialFile.getUrl();
        }
        File source = null;
        try {
            watch.start();
            String path = this.getClass().getResource(File.separator).getPath();
            source = new File(path + File.separator + fileName);
            IOUtils.write((byte[])data, (OutputStream)new FileOutputStream(source));
            watch.stop();
            log.info("\u5199\u6587\u4ef6\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
            watch.start();
            String url = AliyunOssUtils.uploadFile((String)LoginUtils.getCurrentUserCorpId(), (File)source, (String)"");
            watch.stop();
            log.info("\u6587\u4ef6\u4e0a\u4f20\u8017\u65f6\uff1a{}", (Object)watch.getLastTaskTimeMillis());
            materialFile = new OfficialMaterialFile();
            materialFile.setBizId(userInfo.getBizId());
            materialFile.setCorpId(userInfo.getCorpId());
            materialFile.setFileSize(Integer.valueOf((int)(source.length() / 1024L)));
            materialFile.setSha1Str(sha1);
            materialFile.setFileFormat(format);
            materialFile.setDuration(Long.valueOf(FfmpegUtils.getDuration(source)));
            materialFile.setUrl(url);
            materialFile.setUrlMd5(MD5Utils.MD5Encode8((String)url));
            this.materialFileMapper.insertSelective((Object)materialFile);
            String string = url;
            return string;
        }
        catch (Exception e) {
            log.error("\u7d20\u6750\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
        finally {
            if (source != null && source.exists()) {
                source.delete();
            }
        }
    }
}

