/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.material.dto.req;

import cn.kinyun.scrm.weixin.material.enums.MaterialType;
import cn.kinyun.scrm.weixin.material.enums.PlatformType;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class AddCommonMaterialReq
implements Serializable {
    private static final long serialVersionUID = -1674185605325005275L;
    private String title;
    private String cover;
    private String content;
    private String url;
    private String description;
    private Long nodeId;
    private Long groupId;
    private Integer platformType;
    private String materialType;
    private String transcodeUrl;

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.materialType), (Object)"materialType is null!");
        if (this.groupId == null) {
            this.groupId = -1L;
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.title), (Object)"\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.title.length() <= 64 ? 1 : 0) != 0, (Object)"\u6807\u9898\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc764\u4e2a\u5b57\u7b26");
        if (this.platformType == null) {
            this.platformType = PlatformType.getAllPlatform();
        }
        if (this.materialType.equals(MaterialType.TEXT.getType())) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.content), (Object)"\u6587\u672c\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            Preconditions.checkArgument((this.content.length() <= 600 ? 1 : 0) != 0, (Object)"\u6807\u9898\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7600\u5b57\u7b26");
        } else {
            if (this.materialType.equals(MaterialType.VIDEO.getType())) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.description), (Object)"\u89c6\u9891\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.url), (Object)"url\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getCover() {
        return this.cover;
    }

    public String getContent() {
        return this.content;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getNodeId() {
        return this.nodeId;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public Integer getPlatformType() {
        return this.platformType;
    }

    public String getMaterialType() {
        return this.materialType;
    }

    public String getTranscodeUrl() {
        return this.transcodeUrl;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCover(String cover) {
        this.cover = cover;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setNodeId(Long nodeId) {
        this.nodeId = nodeId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public void setPlatformType(Integer platformType) {
        this.platformType = platformType;
    }

    public void setMaterialType(String materialType) {
        this.materialType = materialType;
    }

    public void setTranscodeUrl(String transcodeUrl) {
        this.transcodeUrl = transcodeUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddCommonMaterialReq)) {
            return false;
        }
        AddCommonMaterialReq other = (AddCommonMaterialReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$nodeId = this.getNodeId();
        Long other$nodeId = other.getNodeId();
        if (this$nodeId == null ? other$nodeId != null : !((Object)this$nodeId).equals(other$nodeId)) {
            return false;
        }
        Long this$groupId = this.getGroupId();
        Long other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !((Object)this$groupId).equals(other$groupId)) {
            return false;
        }
        Integer this$platformType = this.getPlatformType();
        Integer other$platformType = other.getPlatformType();
        if (this$platformType == null ? other$platformType != null : !((Object)this$platformType).equals(other$platformType)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$cover = this.getCover();
        String other$cover = other.getCover();
        if (this$cover == null ? other$cover != null : !this$cover.equals(other$cover)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$materialType = this.getMaterialType();
        String other$materialType = other.getMaterialType();
        if (this$materialType == null ? other$materialType != null : !this$materialType.equals(other$materialType)) {
            return false;
        }
        String this$transcodeUrl = this.getTranscodeUrl();
        String other$transcodeUrl = other.getTranscodeUrl();
        return !(this$transcodeUrl == null ? other$transcodeUrl != null : !this$transcodeUrl.equals(other$transcodeUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddCommonMaterialReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $nodeId = this.getNodeId();
        result = result * 59 + ($nodeId == null ? 43 : ((Object)$nodeId).hashCode());
        Long $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : ((Object)$groupId).hashCode());
        Integer $platformType = this.getPlatformType();
        result = result * 59 + ($platformType == null ? 43 : ((Object)$platformType).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $cover = this.getCover();
        result = result * 59 + ($cover == null ? 43 : $cover.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $materialType = this.getMaterialType();
        result = result * 59 + ($materialType == null ? 43 : $materialType.hashCode());
        String $transcodeUrl = this.getTranscodeUrl();
        result = result * 59 + ($transcodeUrl == null ? 43 : $transcodeUrl.hashCode());
        return result;
    }

    public String toString() {
        return "AddCommonMaterialReq(title=" + this.getTitle() + ", cover=" + this.getCover() + ", content=" + this.getContent() + ", url=" + this.getUrl() + ", description=" + this.getDescription() + ", nodeId=" + this.getNodeId() + ", groupId=" + this.getGroupId() + ", platformType=" + this.getPlatformType() + ", materialType=" + this.getMaterialType() + ", transcodeUrl=" + this.getTranscodeUrl() + ")";
    }
}

