/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.enums.activity;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;

public enum ActivityStatus {
    DRAFT(0, "\u8349\u7a3f"),
    INEFFECTIVE(1, "\u672a\u751f\u6548"),
    EFFECT(2, "\u751f\u6548\u4e2d"),
    INVALID(3, "\u5df2\u5931\u6548"),
    FORBIDDEN(4, "\u5df2\u7981\u7528");

    private static Map<Integer, ActivityStatus> map;
    int status;
    String desc;

    private ActivityStatus(int status, String desc) {
        this.status = status;
        this.desc = desc;
    }

    public int getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    public static ActivityStatus getStatus(int status) {
        ActivityStatus actiStatus = map.get(status);
        return actiStatus;
    }

    public static ActivityStatus getStatus(Date beginTime, Date endTime, Date now, Integer status) {
        if (status.intValue() == FORBIDDEN.getStatus() || status.intValue() == DRAFT.getStatus()) {
            return ActivityStatus.getStatus(status);
        }
        if (now.before(beginTime)) {
            return INEFFECTIVE;
        }
        if (now.after(beginTime) && now.before(endTime)) {
            return EFFECT;
        }
        if (now.after(endTime)) {
            return INVALID;
        }
        return DRAFT;
    }

    static {
        map = Maps.newHashMap();
        for (ActivityStatus status : ActivityStatus.values()) {
            map.put(status.status, status);
        }
    }
}

