/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.autoreply.service.impl;

import cn.kinyun.scrm.weixin.autoreply.dto.AutoReplyMsgDto;
import cn.kinyun.scrm.weixin.autoreply.dto.req.AutoReplyAddReq;
import cn.kinyun.scrm.weixin.autoreply.dto.req.AutoReplyBatchAddReq;
import cn.kinyun.scrm.weixin.autoreply.dto.req.AutoReplyDelReq;
import cn.kinyun.scrm.weixin.autoreply.dto.req.AutoReplyListReq;
import cn.kinyun.scrm.weixin.autoreply.dto.req.AutoReplyModReq;
import cn.kinyun.scrm.weixin.autoreply.dto.resp.AutoReplyListResp;
import cn.kinyun.scrm.weixin.autoreply.service.LogicAutoReplyService;
import cn.kinyun.scrm.weixin.autoreply.service.SubscribeAutoReplyService;
import cn.kinyun.scrm.weixin.enums.autoreply.AutoReplyMessageType;
import cn.kinyun.scrm.weixin.enums.autoreply.AutoReplyType;
import cn.kinyun.scrm.weixin.message.service.ServantSessionService;
import cn.kinyun.scrm.weixin.officialAccount.service.OperatorService;
import cn.kinyun.scrm.weixin.utils.FilterUtils;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.reply.dto.CommonAutoReplyDto;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubscribeAutoReplyServiceImpl
implements SubscribeAutoReplyService {
    private static final Logger log = LoggerFactory.getLogger(SubscribeAutoReplyServiceImpl.class);
    @Autowired
    private ServantSessionService servantSessionService;
    @Autowired
    private OperatorService operatorService;
    @Autowired
    private LogicAutoReplyService logicAutoReplyService;

    @Override
    public boolean onSubscribe(String appId, String openId, Long timestamp) {
        log.info("Auto reply on subscribe appId={}, openId={}, timestamp={}", new Object[]{appId, openId, timestamp});
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{appId}), (Object)"appId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{openId}), (Object)"openId is null");
        Long servantId = this.servantSessionService.getCurrentServantId(appId, openId);
        if (servantId != null && servantId > 0L) {
            log.info("\u7c89\u4e1d\u5df2\u7ecf\u8f6c\u7531\u4eba\u5de5\u5ba2\u670d\u5bf9\u63a5");
            return false;
        }
        List<CommonAutoReplyDto> list = this.logicAutoReplyService.getByAppId(appId, AutoReplyType.SUBSCRIBED_REPLY);
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        CommonAutoReplyDto reply = list.get(0);
        if (reply == null) {
            return false;
        }
        AutoReplyMsgDto json = this.logicAutoReplyService.deserialize(reply.getMessage());
        if (json == null || json.getType() == null) {
            log.warn("\u53cd\u5e8f\u5217\u5316\u5931\u8d25\uff0c\u65e0\u6cd5\u81ea\u52a8\u56de\u590d\u6d88\u606f. message={}", (Object)reply.getMessage());
            return false;
        }
        return this.logicAutoReplyService.send(json, appId, openId, reply.getBizId(), reply.getCorpId());
    }

    @Override
    public List<AutoReplyListResp> list(AutoReplyListReq params) {
        return this.logicAutoReplyService.queryCommonList(params, AutoReplyType.SUBSCRIBED_REPLY);
    }

    @Override
    public Long add(AutoReplyAddReq params) {
        return this.logicAutoReplyService.add(params, AutoReplyType.SUBSCRIBED_REPLY);
    }

    @Override
    public boolean modify(AutoReplyModReq params) {
        return this.logicAutoReplyService.modify(params, AutoReplyType.SUBSCRIBED_REPLY);
    }

    @Override
    public boolean delete(AutoReplyDelReq params) {
        return this.logicAutoReplyService.delete(params, AutoReplyType.SUBSCRIBED_REPLY);
    }

    @Override
    public void addBatch(AutoReplyBatchAddReq params) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUser != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((currentUser.getId() != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(params.getAppIds()), (Object)"\u672a\u8bbe\u7f6e\u516c\u4f17\u53f7");
        Set<String> appIds = FilterUtils.filterSet(params.getAppIds());
        Preconditions.checkArgument((params.getType() != null ? 1 : 0) != 0, (Object)"\u672a\u8bbe\u7f6e\u81ea\u52a8\u56de\u590d\u7c7b\u578b");
        Preconditions.checkArgument((AutoReplyMessageType.getType(params.getType()) != null ? 1 : 0) != 0, (Object)"\u672a\u77e5\u7684\u81ea\u52a8\u56de\u590d\u7c7b\u578b");
        Long operatorId = currentUser.getId();
        Preconditions.checkArgument((boolean)this.operatorService.isManager(operatorId, appIds), (Object)"\u60a8\u4e0d\u662f\u516c\u4f17\u53f7\u7684\u8fd0\u8425\u8005\uff0c\u65e0\u6743\u6267\u884c\u6b64\u64cd\u4f5c\u3002");
        for (String appId : appIds) {
            AutoReplyAddReq req = new AutoReplyAddReq();
            req.setAppId(appId);
            req.setType(params.getType());
            req.setMessage(params.getMessage());
            req.setMaterialId(params.getMaterialId());
            this.add(req);
        }
    }
}

