/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.activity.service.impl;

import cn.kinyun.scrm.weixin.activity.dto.ActiTemplateMsgDto;
import cn.kinyun.scrm.weixin.activity.dto.ActivityDto;
import cn.kinyun.scrm.weixin.activity.dto.OverlayDto;
import cn.kinyun.scrm.weixin.activity.dto.resp.EventKeyDto;
import cn.kinyun.scrm.weixin.activity.service.ActivityHelper;
import cn.kinyun.scrm.weixin.activity.utils.Billboard;
import cn.kinyun.scrm.weixin.enums.MsgSendType;
import cn.kinyun.scrm.weixin.enums.activity.ActivityStatus;
import cn.kinyun.scrm.weixin.enums.activity.ActivityTaskStatus;
import cn.kinyun.scrm.weixin.enums.activity.ActivityType;
import cn.kinyun.scrm.weixin.enums.activity.BillboardOverlayType;
import cn.kinyun.scrm.weixin.enums.biz.ClickEventBizType;
import cn.kinyun.scrm.weixin.message.service.MessageService;
import cn.kinyun.scrm.weixin.message.service.SendMessageService;
import cn.kinyun.scrm.weixin.message.service.TemplateMsgService;
import cn.kinyun.scrm.weixin.officialAccount.dto.req.CreateQrcodeReqDto;
import cn.kinyun.scrm.weixin.officialAccount.service.OfficialAccountFansTagService;
import cn.kinyun.scrm.weixin.officialAccount.service.OfficialQrcodeService;
import cn.kinyun.scrm.weixin.officialAccount.service.TemplateService;
import cn.kinyun.scrm.weixin.sdk.api.WxMediaAPI;
import cn.kinyun.scrm.weixin.sdk.api.WxOAuth2API;
import cn.kinyun.scrm.weixin.sdk.entity.account.CreateQrcodeResult;
import cn.kinyun.scrm.weixin.sdk.entity.media.MediaResult;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.BaseRespMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.ImageMsg;
import cn.kinyun.scrm.weixin.sdk.entity.message.resp.TextMsg;
import cn.kinyun.scrm.weixin.sdk.entity.template.TemplateParam;
import cn.kinyun.scrm.weixin.sdk.enums.WxMediaType;
import cn.kinyun.scrm.weixin.sdk.enums.WxOAuthScope;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.template.req.SendTemplateMsgReq;
import cn.kinyun.scrm.weixin.token.OfficialTokenService;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.MD5Utils;
import com.kuaike.scrm.common.utils.AliyunOssUtils;
import com.kuaike.scrm.common.utils.RedisDistributedLock;
import com.kuaike.scrm.dal.official.fans.entity.OfficialAccountFans;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialAccountFansMapper;
import com.kuaike.scrm.dal.official.fission.entity.OfficialActi;
import com.kuaike.scrm.dal.official.fission.entity.OfficialActiResult;
import com.kuaike.scrm.dal.official.fission.entity.OfficialActiTask;
import com.kuaike.scrm.dal.official.fission.mapper.OfficialActiMapper;
import com.kuaike.scrm.dal.official.fission.mapper.OfficialActiResultMapper;
import com.kuaike.scrm.dal.official.fission.mapper.OfficialActiTaskMapper;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityHelperImpl
implements ActivityHelper {
    private static final Logger log = LoggerFactory.getLogger(ActivityHelperImpl.class);
    @Resource
    private OfficialActiMapper officialActiMapper;
    @Resource
    private OfficialActiTaskMapper officialActiTaskMapper;
    @Resource
    private OfficialActiResultMapper officialActiResultMapper;
    @Resource
    private OfficialAccountFansMapper fansMapper;
    @Autowired
    private TemplateMsgService templateMsgService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private SendMessageService sendMessageService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private OfficialQrcodeService officialQrcodeService;
    @Autowired
    private OfficialTokenService officialTokenService;
    @Autowired
    private OfficialAccountFansTagService fansTagService;
    @Autowired
    private WxMediaAPI mediaApi;
    @Autowired
    private RedisDistributedLock lock;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-mp}/address.html")
    private String fansExtendUrl;
    @Autowired
    private WxOAuth2API wxOAuth2API;
    @Value(value="${wx.component.appid}")
    private String componentAppId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean attention(Long actiId, String appId, String taskOpenId, String attentionOpenId, Date attentionTime) {
        ActivityDto dto;
        log.info("attention, actiId={}, appId={}, taskOpenId={}, attentionOpenId={}", new Object[]{actiId, appId, taskOpenId, attentionOpenId});
        Preconditions.checkArgument((actiId != null ? 1 : 0) != 0, (Object)"actiId is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)taskOpenId), (Object)"taskOpenId is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)attentionOpenId), (Object)"attentionOpenId is null!");
        if (taskOpenId.equals(attentionOpenId)) {
            log.info("same fans, id={}, openId={}", (Object)actiId, (Object)taskOpenId);
            return false;
        }
        OfficialActi acti = this.checkActivity(actiId);
        if (!this.activityEffect(acti)) {
            log.info("activity is not effect, id={}", (Object)actiId);
            return false;
        }
        try {
            dto = (ActivityDto)JacksonUtil.str2Obj((String)acti.getContent(), ActivityDto.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("Failed parse content, json={}", (Object)acti.getContent());
            return false;
        }
        List results = this.officialActiResultMapper.queryResult(actiId, appId, null, attentionOpenId);
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            log.info("Fans has already join activity, id={}, openId={}", (Object)actiId, (Object)attentionOpenId);
            return false;
        }
        this.addActiResult(actiId, appId, attentionOpenId, taskOpenId, attentionTime, acti.getBizId(), acti.getCorpId());
        if (acti.getTemplate().equals("002")) {
            this.risingDealWith(acti, dto, attentionOpenId);
            this.fansTagService.buildFansTags(appId, attentionOpenId, dto.getTagIds(), -1L);
            return true;
        }
        String key = Joiner.on((String)"##").join((Object)"actiAttention", (Object)acti, new Object[]{taskOpenId});
        try {
            int i;
            this.lock.lock(key, "", 300, 60L, 100L);
            OfficialActiTask task = this.officialActiTaskMapper.queryTask(actiId, appId, taskOpenId);
            this.updateTask(actiId, appId, taskOpenId, acti.getTemplate(), task, dto);
            ActiTemplateMsgDto templateMsgDto = null;
            List<Integer> phaseGoalList = this.getPhaseGoalList(task.getPhaseGoals());
            if (CollectionUtils.isEmpty(phaseGoalList)) {
                log.warn("\u76ee\u6807\u4eba\u6570\u4e3a\u7a7a\uff0ctask:{}", (Object)task);
                boolean bl = false;
                return bl;
            }
            for (i = 0; i < phaseGoalList.size(); ++i) {
                if (task.getAmount() > phaseGoalList.get(i)) continue;
                templateMsgDto = dto.getMsgDtoList().get(i);
                templateMsgDto.setGoal(phaseGoalList.get(i));
                break;
            }
            if (templateMsgDto == null) {
                log.warn("\u627e\u4e0d\u5230\u9636\u6bb5\u5185\u5bb9, actiDto:{}", (Object)dto);
                i = 0;
                return i != 0;
            }
            Integer completedPhaseNum = task.getCompletedPhaseNum();
            Map<String, String> templateMap = this.getMsgTemplate(appId);
            if (acti.getTemplate().equals("001")) {
                if (task.getAmount().intValue() == templateMsgDto.getGoal()) {
                    int count;
                    boolean isLimitedReward = templateMsgDto.getIsLimitedReward() == 1;
                    boolean hasReward = true;
                    if (isLimitedReward && (count = this.officialActiTaskMapper.countCompletePhaseGte(acti.getId(), completedPhaseNum)) > templateMsgDto.getLimitedRewardNum()) {
                        hasReward = false;
                    }
                    this.noticeWhenAttention(acti, task, acti.getAppId(), taskOpenId, attentionOpenId, templateMap.get("OPENTM405761503"), templateMsgDto);
                    if (hasReward) {
                        if (templateMsgDto.getType() == ActivityType.PHYSICS.getValue().intValue()) {
                            this.physicsNoticeWhenComplete(acti, task, taskOpenId, templateMap.get("OPENTM411436762"), templateMsgDto);
                        } else if (templateMsgDto.getType() == ActivityType.ELECTRONIC.getValue().intValue()) {
                            this.electronicsNoticeWhenComplete(acti, task, taskOpenId, templateMap.get("OPENTM411436762"), templateMsgDto);
                        }
                        this.noticeAttentionsWhenComplement(acti, task, dto, templateMap.get("OPENTM411436762"), templateMsgDto);
                        task.setHasReward(Integer.valueOf(1 << completedPhaseNum - 1 | task.getHasReward()));
                        this.officialActiTaskMapper.updateByPrimaryKeySelective((Object)task);
                    } else {
                        this.noticeWhenCompleteButNoReward(acti, task, taskOpenId, templateMap.get("OPENTM411436762"), templateMsgDto);
                    }
                } else if (task.getAmount() < templateMsgDto.getGoal()) {
                    this.noticeWhenAttention(acti, task, acti.getAppId(), taskOpenId, attentionOpenId, templateMap.get("OPENTM405761503"), templateMsgDto);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock(key);
        }
    }

    private List<Integer> getPhaseGoalList(String phaseGoals) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{phaseGoals})) {
            try {
                List goalsStr = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)phaseGoals);
                return goalsStr.stream().map(Integer::parseInt).collect(Collectors.toList());
            }
            catch (Exception e) {
                log.error("get phase goals error", (Throwable)e);
            }
        }
        return Lists.newArrayList();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void receiveTask(Long actiId, String appId, String openId, Integer triggerType) {
        ActivityDto dto;
        OfficialActi acti;
        log.info("receive task, actiId={}, appId={}, openId={}, triggerType={}", new Object[]{actiId, appId, openId, triggerType});
        Preconditions.checkArgument((actiId != null ? 1 : 0) != 0, (Object)"actiId is null!");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)openId), (Object)"openId is null");
        try {
            acti = this.checkActivity(actiId);
        }
        catch (Exception e) {
            this.response(appId, openId, "\u6d3b\u52a8\u5df2\u5931\u6548", triggerType);
            return;
        }
        if (!this.activityEffect(acti)) {
            this.response(appId, openId, "\u6d3b\u52a8\u5df2\u5931\u6548", triggerType);
            return;
        }
        try {
            dto = (ActivityDto)JacksonUtil.str2Obj((String)acti.getContent(), ActivityDto.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("Failed parse content, json={}", (Object)acti.getContent());
            return;
        }
        if ("002".equals(acti.getTemplate())) {
            this.response(appId, openId, dto.getAttentionResp(), triggerType);
            return;
        }
        this.fansTagService.buildFansTags(appId, openId, dto.getTagIds(), -1L);
        OfficialActiTask task = this.officialActiTaskMapper.queryTask(actiId, appId, openId);
        BillboardResult bResult = this.responseBillboard(acti, task, appId, openId);
        if (bResult == null || bResult.mediaId == null) {
            log.warn("\u751f\u6210\u7c89\u4e1d\u6d3b\u52a8\u4e13\u5c5e\u4e8c\u7ef4\u7801\u5931\u8d25");
            return;
        }
        try {
            this.response(appId, openId, dto.getAutoResp(), triggerType);
            this.responseImage(appId, openId, bResult.mediaId, triggerType);
        }
        catch (WeixinException e) {
            e.printStackTrace();
            log.error("\u53d1\u9001\u6d3b\u52a8\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            return;
        }
        if (task == null) {
            task = new OfficialActiTask();
            task.setStatus(Integer.valueOf(ActivityTaskStatus.INCOMPLETE.getStatus()));
            task.setActiId(actiId);
            task.setAmount(Integer.valueOf(0));
            task.setGoal(dto.getMaxGoal());
            List<ActiTemplateMsgDto> msgDtoList = dto.getMsgDtoList();
            List goalList = msgDtoList.stream().map(a -> a.getGoal()).collect(Collectors.toList());
            task.setPhaseGoals(Joiner.on((String)",").join(goalList));
            task.setBizId(acti.getBizId());
            task.setCorpId(acti.getCorpId());
            task.setAppId(appId);
            task.setOpenId(openId);
            task.setEndTime(acti.getEndTime());
            task.setUrlMark(MD5Utils.MD5Encode8((String)(acti.getLocation() + acti.getCover())));
            task.setBillboardUrl(bResult.url);
            this.officialActiTaskMapper.insertSelective((Object)task);
        } else if (StringUtils.isBlank((CharSequence)task.getBillboardUrl()) || !task.getBillboardUrl().equals(bResult.url)) {
            task.setBillboardUrl(bResult.url);
            this.officialActiTaskMapper.updateByPrimaryKeySelective((Object)task);
        }
    }

    private BillboardResult responseBillboard(OfficialActi acti, OfficialActiTask task, String appId, String openId) {
        String filename = String.format("tmp_billboard_%d_%s_%d.jpg", acti.getId(), openId, System.currentTimeMillis());
        File file = new File(filename);
        boolean isCache = false;
        String urlMark = MD5Utils.MD5Encode8((String)(acti.getLocation() + acti.getCover()));
        if (task != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{task.getBillboardUrl()}) && urlMark.equals(task.getUrlMark())) {
            file = this.getBillboardImage(task.getBillboardUrl(), file);
            isCache = true;
        } else {
            List<OverlayDto> overlay = null;
            if (!"002".equals(acti.getTemplate())) {
                try {
                    overlay = this.safeGetOverlay(acti, openId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u83b7\u53d6\u6d77\u62a5\u8986\u76d6\u7269\u5931\u8d25", (Throwable)e);
                    return null;
                }
            }
            file = this.getBillboardImage(acti.getCover(), overlay, file);
        }
        if (file == null) {
            log.warn("\u6d77\u62a5\u751f\u6210\u5931\u8d25\uff0c\u65e0\u6cd5\u81ea\u52a8\u56de\u590d\u6d3b\u52a8\u8bdd\u672f\u53ca\u6d77\u62a5\u3002");
            return null;
        }
        BillboardResult bResult = new BillboardResult();
        try {
            String accessToken = this.officialTokenService.getOfficialAccessToken(appId);
            MediaResult resp = this.mediaApi.upload(accessToken, WxMediaType.Image, file);
            bResult.mediaId = resp.getMediaId();
        }
        catch (WeixinException e) {
            e.printStackTrace();
            log.error("\u5c06\u6d77\u62a5\u4e0a\u4f20\u5230\u516c\u4f17\u53f7\u4e34\u65f6\u7d20\u6750\u5e93\u5931\u8d25", (Throwable)e);
            file.delete();
            return null;
        }
        String billboardUrl = !isCache ? AliyunOssUtils.uploadFile((String)acti.getCorpId(), (File)file, (String)"") : task.getBillboardUrl();
        file.delete();
        bResult.url = billboardUrl;
        return bResult;
    }

    private File getBillboardImage(String bgUrl, File output) {
        return this.getBillboardImage(bgUrl, Collections.emptyList(), output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getBillboardImage(String bgUrl, List<OverlayDto> overlay, File outputFile) {
        List results;
        Billboard billboard = new Billboard();
        ArrayList tasks = Lists.newArrayList();
        if (outputFile == null) {
            String uuid = UUID.randomUUID().toString().replace("-", "");
            String filename = "tmp_billboard_" + uuid + ".jpg";
            outputFile = new File(filename);
        }
        tasks.add(() -> billboard.setBackground(bgUrl));
        int overlayCount = 0;
        if (overlay != null && overlay.size() > 0) {
            overlayCount = overlay.size();
            for (OverlayDto dto : overlay) {
                tasks.add(() -> billboard.addImage(dto));
            }
        }
        ExecutorService exec = Executors.newFixedThreadPool(overlayCount + 1);
        try {
            results = exec.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            log.error("\u4e0b\u8f7d\u6d77\u62a5\u56fe\u7247\u5931\u8d25", (Throwable)e);
            Thread.currentThread().interrupt();
            File file = null;
            return file;
        }
        finally {
            exec.shutdown();
        }
        try {
            if (results.size() > 0) {
                for (Future f : results) {
                    Boolean b = (Boolean)f.get();
                    if (b != null && b.booleanValue()) continue;
                    return null;
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            log.error("\u65e0\u6cd5\u6b63\u5e38\u83b7\u53d6\u6d77\u62a5\u4e0b\u8f7d\u7ed3\u679c", (Throwable)e);
            return null;
        }
        if (!billboard.saveTo(outputFile)) {
            return null;
        }
        return outputFile;
    }

    private List<OverlayDto> safeGetOverlay(OfficialActi acti, String openId) {
        List overlay = null;
        try {
            String location = acti.getLocation();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{location})) {
                overlay = JacksonUtil.str2List((String)location, OverlayDto.class);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (CollectionUtils.isEmpty(overlay)) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (OverlayDto dto : overlay) {
            String type = dto.getType();
            if (StringUtils.isBlank((CharSequence)type)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u77e5\u7c7b\u578b\u7684\u6d77\u62a5\u8986\u76d6\u56fe\u7247:" + dto.getType());
            }
            if (BillboardOverlayType.QRCODE.getType().equalsIgnoreCase(type)) {
                dto.setImageUrl(this.createQrcode(acti, openId));
            } else if (BillboardOverlayType.FANS_AVATAR.getType().equalsIgnoreCase(type)) {
                dto.setImageUrl(this.getFansAvatar(acti.getAppId(), openId));
                dto.setRound(true);
            } else {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4e0d\u652f\u6301\u7684\u6d77\u62a5\u8986\u76d6\u56fe\u7247:" + dto.getType());
            }
            if (dto.getImageUrl() == null) continue;
            result.add(dto);
        }
        return result;
    }

    private String createQrcode(OfficialActi acti, String openId) {
        EventKeyDto dto = new EventKeyDto();
        dto.setType(ClickEventBizType.OFFICIAL_FISSION.getKey());
        dto.setId(acti.getId());
        dto.setOpenId(openId);
        String sceneStr = dto.pack();
        int expireSeconds = 2592000;
        CreateQrcodeReqDto req = new CreateQrcodeReqDto();
        req.setAppId(acti.getAppId());
        req.setSceneStr(sceneStr);
        req.setExpireSeconds(expireSeconds);
        CreateQrcodeResult result = null;
        try {
            result = this.officialQrcodeService.createTemp(req);
        }
        catch (WeixinException e) {
            e.printStackTrace();
            log.error("\u521b\u5efa\u6d3b\u52a8\u4e8c\u7ef4\u7801\u5931\u8d25, appId={}, openId={}", new Object[]{acti.getAppId(), openId, e});
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u6d3b\u52a8\u4e8c\u7ef4\u7801\u5931\u8d25");
        }
        String ticket = result.getTicket();
        String qrcodeUrl = this.officialQrcodeService.getQrcodeUrl(ticket);
        return qrcodeUrl;
    }

    private String getFansAvatar(String appId, String openId) {
        OfficialAccountFans fans = this.fansMapper.getFansByAppIdAndOpenId(appId, openId);
        if (fans == null || StringUtils.isBlank((CharSequence)fans.getHeadImgUrl())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u7c89\u4e1d\u5934\u50cf\u5931\u8d25");
        }
        return fans.getHeadImgUrl();
    }

    private void response(String appId, String openId, String message, Integer triggerType) {
        TextMsg text = new TextMsg();
        text.setFromUserName(appId);
        text.setToUserName(openId);
        text.setContent(message);
        this.sendMessageService.send((BaseRespMsg)text);
        this.messageService.record((BaseRespMsg)text, MsgSendType.SYS_SEND_FANS, -1L, -1L);
    }

    private void responseImage(String appId, String openId, String mediaId, Integer triggerType) {
        ImageMsg img = new ImageMsg();
        img.setFromUserName(appId);
        img.setToUserName(openId);
        img.setMediaId(mediaId);
        this.sendMessageService.send((BaseRespMsg)img);
        this.messageService.record((BaseRespMsg)img, MsgSendType.SYS_SEND_FANS, -1L, -1L);
    }

    private Map<String, String> getMsgTemplate(String appId) {
        return this.templateService.getTemplateIds(appId, Lists.newArrayList((Object[])new String[]{"OPENTM405761503", "OPENTM411436762"}));
    }

    private OfficialActi checkActivity(Long actiId) {
        OfficialActi acti = this.officialActiMapper.getById(actiId);
        if (acti == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6d3b\u52a8\u4e0d\u5b58\u5728");
        }
        return acti;
    }

    private boolean activityEffect(OfficialActi acti) {
        Date now = new Date();
        ActivityStatus status = ActivityStatus.getStatus(acti.getBeginTime(), acti.getEndTime(), now, acti.getStatus());
        return ActivityStatus.EFFECT.getStatus() == status.getStatus();
    }

    private void addActiResult(Long actiId, String appId, String attentionOpenId, String taskOpenId, Date attentionTime, Long bizId, String corpId) {
        OfficialActiResult result = new OfficialActiResult();
        result.setBizId(bizId);
        result.setCorpId(corpId);
        result.setActiId(actiId.toString());
        result.setAppId(appId);
        result.setAttentionOpenId(attentionOpenId);
        result.setTaskOpenId(taskOpenId);
        result.setAttentionTime(attentionTime);
        this.officialActiResultMapper.insertSelective((Object)result);
    }

    private void updateTask(Long actiId, String appId, String openId, String template, OfficialActiTask task, ActivityDto dto) {
        int count = this.officialActiResultMapper.countResult(actiId, appId, openId);
        task.setAmount(Integer.valueOf(count));
        List<ActiTemplateMsgDto> msgDtoList = dto.getMsgDtoList();
        msgDtoList.sort(Comparator.comparing(ActiTemplateMsgDto::getGoal));
        int lowestGoal = msgDtoList.get(0).getGoal();
        if (lowestGoal == count && task.getStatus().intValue() == ActivityTaskStatus.INCOMPLETE.getStatus()) {
            task.setStatus(Integer.valueOf(ActivityTaskStatus.COMPLETE.getStatus()));
        }
        task.setCompletedPhaseNum(Integer.valueOf(this.getCompletePhases(dto, count)));
        this.officialActiTaskMapper.updateByPrimaryKeySelective((Object)task);
    }

    private int getCompletePhases(ActivityDto activityDto, Integer amount) {
        List<ActiTemplateMsgDto> msgDtoList = activityDto.getMsgDtoList();
        for (int i = 0; i < msgDtoList.size(); ++i) {
            ActiTemplateMsgDto msgDto = msgDtoList.get(i);
            if (amount < msgDto.getGoal()) {
                if (i == 0) {
                    return 0;
                }
                return i;
            }
            if (i != msgDtoList.size() - 1 || amount < msgDto.getGoal()) continue;
            return i + 1;
        }
        return 0;
    }

    private void risingDealWith(OfficialActi acti, ActivityDto dto, String attentionOpenId) {
    }

    private void physicsNoticeWhenComplete(OfficialActi acti, OfficialActiTask task, String taskOpenId, String templateId, ActiTemplateMsgDto templateMsgDto) {
        String url = null;
        try {
            url = URLEncoder.encode(this.fansExtendUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String oauthUrl = this.wxOAuth2API.getComponentOauthPageUrl(acti.getAppId(), url, WxOAuthScope.SNSAPI_USERINFO.getValue(), String.valueOf(acti.getId()), this.componentAppId);
        log.info("oauthUrl={}", (Object)oauthUrl);
        SendTemplateMsgReq templateMsg = new SendTemplateMsgReq();
        templateMsg.setAppId(acti.getAppId());
        templateMsg.setTemplateId(templateId);
        templateMsg.setToUserName(taskOpenId);
        templateMsg.setUrl(oauthUrl);
        HashMap data = Maps.newHashMap();
        templateMsg.setData(data);
        String first = String.format("\u606d\u559c\u4f60\u53ef\u4ee5\u9886\u53d6%s", templateMsgDto.getNoticeStr2());
        String keyword1 = acti.getName();
        String keyword2 = String.format("\u9700\u83b7\u5f97%d\u4f4d\u597d\u53cb\u626b\u7801\u652f\u6301", templateMsgDto.getGoal());
        String keyword3 = String.format("\u5df2\u83b7\u5f97%d\u4f4d\u597d\u53cb\u626b\u7801\u652f\u6301", task.getAmount());
        String remark = String.format("\u70b9\u51fb\u586b\u5199\u6536\u4ef6\u4fe1\u606f\uff0c\u968f\u5373\u5c06\u6309\u7167\u586b\u5199\u7684\u6536\u4ef6\u4fe1\u606f\u5bc4\u51fa\u5305\u88f9\uff01\u56de\u590d\"%s\"\u67e5\u8be2\u5feb\u9012\u5355\u53f7", templateMsgDto.getProcessKey());
        data.put("first", new TemplateParam(first, "#ff7982"));
        data.put("keyword1", new TemplateParam(keyword1, "#173177"));
        data.put("keyword2", new TemplateParam(keyword2, "#173177"));
        data.put("keyword3", new TemplateParam(keyword3, "#173177"));
        data.put("remark", new TemplateParam(remark, "#173177"));
        try {
            this.templateMsgService.send(templateMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("send template msg failed, msg={}", (Object)templateMsg, (Object)e);
        }
    }

    private void noticeWhenCompleteButNoReward(OfficialActi acti, OfficialActiTask task, String taskOpenId, String templateId, ActiTemplateMsgDto templateMsgDto) {
        SendTemplateMsgReq templateMsg = new SendTemplateMsgReq();
        templateMsg.setAppId(acti.getAppId());
        templateMsg.setTemplateId(templateId);
        templateMsg.setToUserName(taskOpenId);
        templateMsg.setUrl("");
        HashMap data = Maps.newHashMap();
        templateMsg.setData(data);
        String keyword1 = acti.getName();
        String keyword2 = String.format("\u9700\u83b7\u5f97%d\u4f4d\u597d\u53cb\u626b\u7801\u652f\u6301", templateMsgDto.getGoal());
        String keyword3 = String.format("\u5df2\u83b7\u5f97%d\u4f4d\u597d\u53cb\u626b\u7801\u652f\u6301", task.getAmount());
        String remark = Optional.ofNullable(templateMsgDto.getLimitedRewardNoticeStr()).orElse("");
        data.put("first", new TemplateParam("", "#ff7982"));
        data.put("keyword1", new TemplateParam(keyword1, "#173177"));
        data.put("keyword2", new TemplateParam(keyword2, "#173177"));
        data.put("keyword3", new TemplateParam(keyword3, "#173177"));
        data.put("remark", new TemplateParam(remark, "#173177"));
        try {
            this.templateMsgService.send(templateMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("send template msg failed, msg={}", (Object)templateMsg, (Object)e);
        }
    }

    private void electronicsNoticeWhenComplete(OfficialActi acti, OfficialActiTask task, String taskOpenId, String templateId, ActiTemplateMsgDto templateMsgDto) {
        SendTemplateMsgReq templateMsg = new SendTemplateMsgReq();
        templateMsg.setAppId(acti.getAppId());
        templateMsg.setTemplateId(templateId);
        templateMsg.setToUserName(taskOpenId);
        templateMsg.setUrl(templateMsgDto.getDataUrl());
        HashMap data = Maps.newHashMap();
        templateMsg.setData(data);
        String first = String.format("\u606d\u559c\u4f60\u53ef\u4ee5\u9886\u53d6%s", templateMsgDto.getNoticeStr2());
        String keyword1 = acti.getName();
        String keyword2 = String.format("\u9700\u83b7\u5f97%d\u4f4d\u597d\u53cb\u626b\u7801\u652f\u6301", templateMsgDto.getGoal());
        String keyword3 = String.format("\u5df2\u83b7\u5f97%d\u4f4d\u597d\u53cb\u626b\u7801\u652f\u6301", task.getAmount());
        String remark = Optional.ofNullable(templateMsgDto.getStr3()).orElse("");
        data.put("first", new TemplateParam(first, "#ff7982"));
        data.put("keyword1", new TemplateParam(keyword1, "#173177"));
        data.put("keyword2", new TemplateParam(keyword2, "#173177"));
        data.put("keyword3", new TemplateParam(keyword3, "#173177"));
        data.put("remark", new TemplateParam(remark, "#173177"));
        try {
            this.templateMsgService.send(templateMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("send template msg failed, msg={}", (Object)templateMsg, (Object)e);
        }
    }

    private void noticeWhenAttention(OfficialActi acti, OfficialActiTask task, String appId, String taskOpenId, String attentionId, String templateId, ActiTemplateMsgDto templateMsgDto) {
        OfficialAccountFans fans = this.fansMapper.getFansByAppIdAndOpenId(appId, attentionId);
        if (fans == null) {
            return;
        }
        SendTemplateMsgReq templateMsg = new SendTemplateMsgReq();
        templateMsg.setAppId(acti.getAppId());
        templateMsg.setTemplateId(templateId);
        templateMsg.setToUserName(taskOpenId);
        templateMsg.setUrl("");
        HashMap data = Maps.newHashMap();
        templateMsg.setData(data);
        String keyword1 = fans.getNickname();
        String keyword2 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss").format(new Date());
        String remark = String.format("\u5df2\u7ecf\u6709%d\u4f4d\u597d\u53cb\u652f\u6301\u4e86\u4f60\uff0c\u8fd8\u9700\u8981%d\u4f4d\u597d\u53cb\u652f\u6301\u5373\u53ef\u9886\u53d6\u8d44\u6599", task.getAmount(), templateMsgDto.getGoal() - task.getAmount());
        data.put("keyword1", new TemplateParam(keyword1, "#91aaff"));
        data.put("keyword2", new TemplateParam(keyword2, "#91aaff"));
        data.put("remark", new TemplateParam(remark, "#173177"));
        try {
            this.templateMsgService.send(templateMsg);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("send template msg failed, msg={}", (Object)templateMsg, (Object)e);
        }
    }

    private void noticeAttentionsWhenComplement(OfficialActi acti, OfficialActiTask task, ActivityDto dto, String templateId, ActiTemplateMsgDto templateMsgDto) {
        List resultList = this.officialActiResultMapper.queryResult(acti.getId(), acti.getAppId(), task.getOpenId(), null);
        List openIds = resultList.stream().map(OfficialActiResult::getAttentionOpenId).collect(Collectors.toList());
        openIds.add(task.getOpenId());
        Map<String, String> nickNameMap = this.fansMapper.selectByAppIdOpenIds(acti.getAppId(), openIds).stream().collect(Collectors.toMap(OfficialAccountFans::getOpenId, OfficialAccountFans::getNickname));
        for (OfficialActiResult result : resultList) {
            SendTemplateMsgReq templateMsg = new SendTemplateMsgReq();
            templateMsg.setAppId(acti.getAppId());
            templateMsg.setTemplateId(templateId);
            templateMsg.setToUserName(result.getAttentionOpenId());
            templateMsg.setUrl("");
            HashMap data = Maps.newHashMap();
            templateMsg.setData(data);
            String attentionNickName = nickNameMap.getOrDefault(result.getAttentionOpenId(), "");
            String taskNickName = nickNameMap.getOrDefault(task.getOpenId(), "");
            String first = String.format("@%s\uff0c\u5728\u4f60\u7684\u652f\u6301\u4e0b\uff0c\u4f60\u7684\u597d\u53cb\u9886\u53d6%s", attentionNickName, templateMsgDto.getNoticeStr2());
            String keyword1 = dto.getName();
            String keyword2 = String.format("\u4f60\u7684\u597d\u53cb%s \u9700\u83b7\u5f97%d\u4f4d\u597d\u53cb\u626b\u7801\u652f\u6301", taskNickName, templateMsgDto.getGoal());
            String keyword3 = String.format("\u4f60\u7684\u597d\u53cb%s \u5df2\u83b7\u5f97%d\u4f4d\u597d\u53cb\u626b\u7801\u652f\u6301", taskNickName, task.getAmount());
            String remark = templateMsgDto.getNoticeStr3();
            data.put("first", new TemplateParam(first, "#ff7982"));
            data.put("keyword1", new TemplateParam(keyword1, "#173177"));
            data.put("keyword2", new TemplateParam(keyword2, "#173177"));
            data.put("keyword3", new TemplateParam(keyword3, "#173177"));
            data.put("remark", new TemplateParam(remark, "#ff7982"));
            try {
                this.templateMsgService.send(templateMsg);
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("send template msg failed, msg={}", (Object)templateMsg, (Object)e);
            }
        }
    }

    private class BillboardResult {
        String mediaId;
        String url;

        private BillboardResult() {
        }
    }
}

