/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.activity.dto.resp;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventKeyDto {
    private static final Logger log = LoggerFactory.getLogger(EventKeyDto.class);
    private String type;
    private Long id;
    private String openId;

    public static EventKeyDto unpack(String eventKey) {
        if (eventKey == null || !eventKey.contains("::")) {
            return null;
        }
        String[] args = eventKey.split("::");
        if (args == null || args.length < 3) {
            return null;
        }
        EventKeyDto result = new EventKeyDto();
        result.type = args[0];
        try {
            result.id = Long.parseLong(args[1]);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            log.error("\u65e0\u6cd5\u89e3\u6790\u6d3b\u52a8id, eventKey={}", (Object)eventKey, (Object)e);
            return null;
        }
        result.openId = args[2];
        return result;
    }

    public String pack() {
        return String.format("%s::%d::%s", this.type, this.id, this.openId);
    }

    public String getType() {
        return this.type;
    }

    public Long getId() {
        return this.id;
    }

    public String getOpenId() {
        return this.openId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventKeyDto)) {
            return false;
        }
        EventKeyDto other = (EventKeyDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$openId = this.getOpenId();
        String other$openId = other.getOpenId();
        return !(this$openId == null ? other$openId != null : !this$openId.equals(other$openId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventKeyDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $openId = this.getOpenId();
        result = result * 59 + ($openId == null ? 43 : $openId.hashCode());
        return result;
    }

    public String toString() {
        return "EventKeyDto(type=" + this.getType() + ", id=" + this.getId() + ", openId=" + this.getOpenId() + ")";
    }
}

