/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.service.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.meeting.dto.MeetingRelayQueryParam;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingBjy;
import com.kuaike.scrm.dal.meeting.entity.MeetingRelay;
import com.kuaike.scrm.dal.meeting.entity.MeetingSetting;
import com.kuaike.scrm.dal.meeting.mapper.MeetingBjyMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingRelayMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingSettingMapper;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudRelayListDto;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudRelayListResp;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudRelaySelectListResp;
import com.kuaike.scrm.meeting.dto.reponse.MeetingRelayListResp;
import com.kuaike.scrm.meeting.dto.request.BaijiacloudRelayAddReq;
import com.kuaike.scrm.meeting.dto.request.BaijiacloudRelayDelReq;
import com.kuaike.scrm.meeting.dto.request.BaijiacloudRelayEnableReq;
import com.kuaike.scrm.meeting.dto.request.BaijiacloudRelayListReq;
import com.kuaike.scrm.meeting.dto.request.MeetingRelayAddReq;
import com.kuaike.scrm.meeting.dto.request.MeetingRelayListReq;
import com.kuaike.scrm.meeting.dto.request.MeetingRelayModReq;
import com.kuaike.scrm.meeting.dto.request.MeetingRelaySelectReq;
import com.kuaike.scrm.meeting.dto.request.RelayListDto;
import com.kuaike.scrm.meeting.service.BaijiacloudApiService;
import com.kuaike.scrm.meeting.service.MeetingRelayService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MeetingRelayServiceImpl
implements MeetingRelayService {
    private static final Logger log = LoggerFactory.getLogger(MeetingRelayServiceImpl.class);
    @Autowired
    private MeetingRelayMapper meetingRelayMapper;
    @Autowired
    private MeetingMapper meetingMapper;
    @Autowired
    private MeetingSettingMapper meetingSettingMapper;
    @Autowired
    private BaijiacloudApiService baijiacloudApiService;
    @Autowired
    private MeetingBjyMapper meetingBjyMapper;
    @Autowired
    private IdGen idGen;

    @Override
    public List<MeetingRelayListResp> list(MeetingRelayListReq req) {
        log.info("list: req:{}", (Object)req);
        req.validate();
        CurrentUserInfo currentUserInfo = this.baseValidate();
        String corpId = currentUserInfo.getCorpId();
        Long bizId = currentUserInfo.getBizId();
        Long meetingId = req.getMeetingId();
        Meeting meeting = this.meetingMapper.queryById(bizId, corpId, meetingId);
        Preconditions.checkArgument((meeting != null ? 1 : 0) != 0, (Object)"\u6839\u636e\u4f1a\u8baeId\u65e0\u6cd5\u67e5\u8be2\u5230\u4f1a\u8bae");
        String roomId = meeting.getRoomId();
        if (StringUtils.isBlank((CharSequence)roomId)) {
            log.warn("list: \u4f1a\u8bae\u5173\u8054\u7684\u623f\u95f4\u53f7\u4e3a\u7a7a, bizId:{}, meetingId:{}", (Object)bizId, (Object)meetingId);
            return Lists.newArrayList();
        }
        BaijiacloudRelayListReq bjyReq = this.toBjyListReq(corpId, roomId);
        BaijiacloudRelayListResp bjyResp = null;
        try {
            bjyResp = this.baijiacloudApiService.getRelayList(bjyReq);
        }
        catch (Exception e) {
            log.error("list: \u83b7\u53d6\u767e\u5bb6\u4e91\u8f6c\u64ad\u5217\u8868\u5f02\u5e38\uff0c e = ", (Throwable)e);
        }
        log.info("list: \u83b7\u53d6\u767e\u5bb6\u4e91\u8f6c\u64ad\u5217\u8868, bizId:{}, meetingId:{}, bjyResp:{}", new Object[]{bizId, meetingId, bjyResp});
        if (bjyResp == null) {
            return Lists.newArrayList();
        }
        List<BaijiacloudRelayListDto> relayListDtos = bjyResp.getList();
        if (CollectionUtils.isEmpty(relayListDtos)) {
            return Lists.newArrayList();
        }
        ArrayList respList = Lists.newArrayList();
        for (BaijiacloudRelayListDto dto : relayListDtos) {
            MeetingRelayListResp resp = new MeetingRelayListResp();
            resp.setRoomId(roomId);
            resp.setRelayRoomId(dto.getBroadcastRoomId());
            resp.setTitle(dto.getTitle());
            if (StringUtils.isNotBlank((CharSequence)dto.getIsAuto())) {
                resp.setIsEnable(Integer.parseInt(dto.getIsAuto()));
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getStartTime())) {
                resp.setStartTime(DateUtil.getDate((String)dto.getStartTime().trim(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getEndTime())) {
                resp.setEndTime(DateUtil.getDate((String)dto.getEndTime().trim(), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            respList.add(resp);
        }
        return respList;
    }

    @Override
    public List<RelayListDto> selectLive(MeetingRelaySelectReq req) {
        log.info("selectLive: req:{}", (Object)req);
        req.validate();
        CurrentUserInfo currentUserInfo = this.baseValidate();
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        Long meetingId = req.getMeetingId();
        Meeting meeting = this.meetingMapper.queryById(bizId, corpId, meetingId);
        Preconditions.checkArgument((meeting != null ? 1 : 0) != 0, (Object)"\u6839\u636e\u4f1a\u8baeId\u65e0\u6cd5\u67e5\u8be2\u5230\u4f1a\u8bae");
        String roomId = meeting.getRoomId();
        if (StringUtils.isBlank((CharSequence)roomId)) {
            log.warn("selectLive: \u4f1a\u8bae\u5173\u8054\u7684\u623f\u95f4\u53f7\u4e3a\u7a7a, bizId:{}, meetingId:{}", (Object)bizId, (Object)meetingId);
            return Lists.newArrayList();
        }
        BaijiacloudRelayListReq bjyReq = this.toBjySelectListReq(corpId, roomId, req.getQuery(), req.getPage(), req.getPageSize());
        BaijiacloudRelaySelectListResp bjyResp = null;
        try {
            bjyResp = this.baijiacloudApiService.getSelectRelayList(bjyReq);
        }
        catch (Exception e) {
            log.error("selectLive: \u83b7\u53d6\u53ef\u9009\u7684\u8f6c\u64ad\u5217\u8868\u5f02\u5e38\uff0c e = ", (Throwable)e);
        }
        log.info("selectLive: \u83b7\u53d6\u53ef\u9009\u7684\u8f6c\u64ad\u5217\u8868, bizId:{}, meetingId:{}, bjyResp:{}", new Object[]{bizId, meetingId, bjyResp});
        if (bjyResp == null) {
            return Lists.newArrayList();
        }
        List<BaijiacloudRelayListDto> relayListDtos = bjyResp.getList();
        if (CollectionUtils.isEmpty(relayListDtos)) {
            return Lists.newArrayList();
        }
        if (req.getPageDto() != null) {
            req.getPageDto().setCount(bjyResp.getTotal());
            req.getPageDto().setCurPageCount(Integer.valueOf(relayListDtos.size()));
        }
        ArrayList respList = Lists.newArrayList();
        for (BaijiacloudRelayListDto listDto : relayListDtos) {
            RelayListDto resp = new RelayListDto();
            resp.setTitle(listDto.getTitle());
            resp.setRelayRoomId(listDto.getRoomId());
            respList.add(resp);
        }
        return respList;
    }

    @Override
    @Transactional
    public void add(MeetingRelayAddReq req) {
        log.info("add: req:{}", (Object)req);
        req.validate();
        CurrentUserInfo userInfo = this.baseValidate();
        Long bizId = userInfo.getBizId();
        Long meetingId = req.getMeetingId();
        String corpId = userInfo.getCorpId();
        Meeting meeting = this.meetingMapper.queryById(bizId, corpId, meetingId);
        Preconditions.checkArgument((meeting != null ? 1 : 0) != 0, (Object)"\u6839\u636e\u4f1a\u8baeId\u65e0\u6cd5\u67e5\u8be2\u5230\u4f1a\u8bae");
        String roomId = meeting.getRoomId();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)roomId), (Object)"\u4f1a\u8bae\u5173\u8054\u7684\u4e3b\u623f\u95f4\u53f7\u4e3a\u7a7a");
        List<RelayListDto> relayList = req.getRelayList();
        Set<String> reqRelayRoomIds = relayList.stream().map(RelayListDto::getRelayRoomId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        this.bjyInsertOrDel(userInfo, meetingId, roomId, reqRelayRoomIds);
        this.localInsertOrDel(userInfo, meetingId, roomId, relayList, reqRelayRoomIds);
    }

    @Override
    public void enable(MeetingRelayModReq req) {
        log.info("enable: req:{}", (Object)req);
        req.validate();
        CurrentUserInfo userInfo = this.baseValidate();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        String roomId = req.getRoomId();
        String relayRoomId = req.getRelayRoomId();
        Integer isEnable = NumberUtils.INTEGER_ZERO;
        String iaAuto = "0";
        if (req.getIsEnable() != null && req.getIsEnable().equals(NumberUtils.INTEGER_ONE)) {
            isEnable = NumberUtils.INTEGER_ONE;
            iaAuto = "1";
        }
        BaijiacloudRelayEnableReq bjyReq = this.toBjyEnableReq(corpId, roomId, relayRoomId, iaAuto);
        this.baijiacloudApiService.enableRelayRoom(bjyReq);
        MeetingRelay existRelay = this.meetingRelayMapper.selectByRoomId(bizId, roomId, relayRoomId);
        if (existRelay != null) {
            existRelay.setIsEnable(isEnable);
            this.meetingRelayMapper.updateByPrimaryKey((Object)existRelay);
        }
    }

    @Override
    public void delete(MeetingRelayModReq req) {
        log.info("delete: req:{}", (Object)req);
        req.validate();
        CurrentUserInfo userInfo = this.baseValidate();
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        String roomId = req.getRoomId();
        String relayRoomId = req.getRelayRoomId();
        BaijiacloudRelayDelReq bjyReq = this.toBjyDelReq(corpId, roomId, relayRoomId);
        this.baijiacloudApiService.delRelayRoom(bjyReq);
        MeetingRelay existRelay = this.meetingRelayMapper.selectByRoomId(bizId, roomId, relayRoomId);
        if (existRelay != null) {
            existRelay.setIsDeleted(NumberUtils.INTEGER_ONE);
            this.meetingRelayMapper.updateByPrimaryKey((Object)existRelay);
        }
    }

    private CurrentUserInfo baseValidate() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((currentUserInfo != null ? 1 : 0) != 0, (Object)"\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((currentUserInfo.getBizId() != null ? 1 : 0) != 0, (Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5c5e\u5546\u6237\u4fe1\u606f\u4e0d\u80fd\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
        return currentUserInfo;
    }

    private BaijiacloudRelayListReq toBjyListReq(String corpId, String roomId) {
        MeetingSetting meetingSetting = this.getMeetingSetting(corpId);
        BaijiacloudRelayListReq bjyReq = BaijiacloudRelayListReq.toReq(meetingSetting);
        bjyReq.setRoomId(roomId);
        return bjyReq;
    }

    private BaijiacloudRelayListReq toBjySelectListReq(String corpId, String roomId, String query, String page, String pageSize) {
        MeetingSetting meetingSetting = this.getMeetingSetting(corpId);
        BaijiacloudRelayListReq bjyReq = BaijiacloudRelayListReq.toReq(meetingSetting);
        bjyReq.setRoomId(roomId);
        if (StringUtils.isNotBlank((CharSequence)query)) {
            bjyReq.setQuery(query);
        }
        if (StringUtils.isNotBlank((CharSequence)page)) {
            bjyReq.setPage(page);
        }
        if (StringUtils.isNotBlank((CharSequence)pageSize)) {
            bjyReq.setPageSize(pageSize);
        }
        return bjyReq;
    }

    private BaijiacloudRelayDelReq toBjyDelReq(String corpId, String roomId, String broadcastRoomIds) {
        MeetingSetting meetingSetting = this.getMeetingSetting(corpId);
        BaijiacloudRelayDelReq bjyReq = BaijiacloudRelayDelReq.toReq(meetingSetting);
        bjyReq.setRoomId(roomId);
        bjyReq.setBroadcastRoomIds(broadcastRoomIds);
        return bjyReq;
    }

    private BaijiacloudRelayAddReq toBjyAddReq(String corpId, String roomId, String broadcastRoomIds) {
        MeetingSetting meetingSetting = this.getMeetingSetting(corpId);
        BaijiacloudRelayAddReq bjyReq = BaijiacloudRelayAddReq.toReq(meetingSetting);
        bjyReq.setRoomId(roomId);
        bjyReq.setBroadcastRoomIds(broadcastRoomIds);
        bjyReq.setIsAuto("0");
        return bjyReq;
    }

    private BaijiacloudRelayEnableReq toBjyEnableReq(String corpId, String roomId, String broadcastRoomId, String isAuto) {
        MeetingSetting meetingSetting = this.getMeetingSetting(corpId);
        BaijiacloudRelayEnableReq bjyReq = BaijiacloudRelayEnableReq.toReq(meetingSetting);
        bjyReq.setRoomId(roomId);
        bjyReq.setBroadcastRoomId(broadcastRoomId);
        bjyReq.setIsAuto(isAuto);
        return bjyReq;
    }

    private MeetingSetting getMeetingSetting(String corpId) {
        MeetingSetting meetingSetting = this.meetingSettingMapper.getSettingByCorpId(corpId);
        Preconditions.checkArgument((boolean)Objects.nonNull(meetingSetting), (Object)"\u672a\u8bbe\u7f6e\u767e\u5bb6\u4e91\u4f1a\u8bae\u914d\u7f6e\u4fe1\u606f");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)meetingSetting.getDominSite()), (Object)"\u4e13\u5c5e\u57df\u540d\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)meetingSetting.getBjyId()), (Object)"\u5f00\u53d1\u8005Partner_ID\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)meetingSetting.getBjyKey()), (Object)"\u5f00\u53d1\u8005Partner_Key\u4e3a\u7a7a");
        return meetingSetting;
    }

    private List<MeetingRelay> buildRelayList(CurrentUserInfo userInfo, Set<String> insertRelayRoomIds, Long meetingId, String roomId, Map<String, RelayListDto> reqMap, Map<String, MeetingBjy> meetingBjyMap) {
        ArrayList insertRelayList = Lists.newArrayList();
        Date cDate = new Date();
        for (String relayRoomId : insertRelayRoomIds) {
            MeetingRelay relay = new MeetingRelay();
            relay.setBizId(userInfo.getBizId());
            relay.setNum(this.idGen.getNum());
            relay.setMeetingId(meetingId);
            relay.setRoomId(roomId);
            relay.setRelayRoomId(relayRoomId);
            RelayListDto listDto = reqMap.get(relayRoomId);
            if (listDto != null) {
                relay.setTitle(listDto.getTitle());
            } else {
                relay.setTitle("");
            }
            relay.setIsEnable(NumberUtils.INTEGER_ZERO);
            relay.setIsDeleted(NumberUtils.INTEGER_ZERO);
            relay.setCreateBy(userInfo.getId());
            relay.setCreateTime(cDate);
            relay.setUpdateBy(userInfo.getId());
            relay.setUpdateTime(cDate);
            MeetingBjy meetingBjy = meetingBjyMap.get(relayRoomId);
            if (meetingBjy != null) {
                relay.setStartTime(meetingBjy.getStartTime());
                relay.setEndTime(meetingBjy.getEndTime());
            }
            insertRelayList.add(relay);
        }
        return insertRelayList;
    }

    private void bjyInsertOrDel(CurrentUserInfo userInfo, Long meetingId, String roomId, Set<String> reqRelayRoomIds) {
        Long bizId = userInfo.getBizId();
        String corpId = userInfo.getCorpId();
        Set<Object> existBjyRelayRoomIds = Sets.newHashSet();
        BaijiacloudRelayListReq bjyListReq = this.toBjyListReq(corpId, roomId);
        BaijiacloudRelayListResp bjyResp = this.baijiacloudApiService.getRelayList(bjyListReq);
        if (bjyResp == null) {
            log.error("bjyInsertOrDel: \u83b7\u53d6\u767e\u5bb6\u4e91\u8f6c\u64ad\u5217\u8868\u63a5\u53e3\u8fd4\u56de\u7a7a, bizId:{}, meetingId:{}", (Object)bizId, (Object)meetingId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u67e5\u8be2\u8f6c\u64ad\u5217\u8868\u5f02\u5e38");
        }
        log.info("bjyInsertOrDel: \u83b7\u53d6\u767e\u5bb6\u4e91\u8f6c\u64ad\u5217\u8868, bizId:{}, meetingId:{}, bjyResp:{}", new Object[]{bizId, meetingId, bjyResp});
        List<BaijiacloudRelayListDto> relayListDtos = bjyResp.getList();
        if (CollectionUtils.isNotEmpty(relayListDtos)) {
            existBjyRelayRoomIds = relayListDtos.stream().map(BaijiacloudRelayListDto::getBroadcastRoomId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        }
        Sets.SetView insertBjyRelayRoomIds = Sets.difference(reqRelayRoomIds, (Set)existBjyRelayRoomIds);
        Sets.SetView delBjyRelayRoomIds = Sets.difference((Set)existBjyRelayRoomIds, reqRelayRoomIds);
        log.info("bjyInsertOrDel: \u767e\u5bb6\u4e91\u540e\u53f0\u66f4\u65b0\uff1abizId:{}, meetingId:{}, existBjyRelayRoomIds:{}, reqRelayRoomIds:{}, insertBjyRelayRoomIds:{}, delBjyRelayRoomIds:{}", new Object[]{bizId, meetingId, existBjyRelayRoomIds, reqRelayRoomIds, insertBjyRelayRoomIds, delBjyRelayRoomIds});
        if (CollectionUtils.isNotEmpty((Collection)insertBjyRelayRoomIds)) {
            String broadcastBjyAddRoomIds = StringUtils.join((Iterable)insertBjyRelayRoomIds, (String)",");
            BaijiacloudRelayAddReq bjyAddReq = this.toBjyAddReq(corpId, roomId, broadcastBjyAddRoomIds);
            this.baijiacloudApiService.addRelayRoom(bjyAddReq);
        }
        if (CollectionUtils.isNotEmpty((Collection)delBjyRelayRoomIds)) {
            String broadcastBjyDelRoomIds = StringUtils.join((Iterable)delBjyRelayRoomIds, (String)",");
            BaijiacloudRelayDelReq bjyDelReq = this.toBjyDelReq(corpId, roomId, broadcastBjyDelRoomIds);
            this.baijiacloudApiService.delRelayRoom(bjyDelReq);
        }
    }

    private void localInsertOrDel(CurrentUserInfo userInfo, Long meetingId, String roomId, List<RelayListDto> relayList, Set<String> reqRelayRoomIds) {
        List meetingBjyList;
        Map<String, MeetingBjy> meetingBjyMap;
        List<MeetingRelay> insertRelayList;
        Long bizId = userInfo.getBizId();
        Long userId = userInfo.getId();
        Map<String, RelayListDto> reqMap = relayList.stream().collect(Collectors.toMap(RelayListDto::getRelayRoomId, a -> a, (k, v) -> v));
        MeetingRelayQueryParam param = new MeetingRelayQueryParam();
        param.setBizId(bizId);
        param.setMeetingId(meetingId);
        List existRelayList = this.meetingRelayMapper.queryListByCondition(param);
        Set existRelayRoomIds = existRelayList.stream().map(MeetingRelay::getRelayRoomId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        Sets.SetView insertRelayRoomIds = Sets.difference(reqRelayRoomIds, existRelayRoomIds);
        Sets.SetView delRelayRoomIds = Sets.difference(existRelayRoomIds, reqRelayRoomIds);
        log.info("localInsertOrDel: \u672c\u5730\u5e93\u66f4\u65b0\uff1abizId:{}, meetingId:{}, reqRelayRoomIds:{}, insertRelayRoomIds:{}, delRelayRoomIds:{}", new Object[]{bizId, meetingId, reqRelayRoomIds, insertRelayRoomIds, delRelayRoomIds});
        if (CollectionUtils.isNotEmpty((Collection)insertRelayRoomIds) && CollectionUtils.isNotEmpty(insertRelayList = this.buildRelayList(userInfo, (Set<String>)insertRelayRoomIds, meetingId, roomId, reqMap, meetingBjyMap = (meetingBjyList = this.meetingBjyMapper.queryListByRoomIds(bizId, reqRelayRoomIds)).stream().collect(Collectors.toMap(MeetingBjy::getRoomId, a -> a, (k, v) -> v))))) {
            this.meetingRelayMapper.batchInsert(insertRelayList);
        }
        if (CollectionUtils.isNotEmpty((Collection)delRelayRoomIds)) {
            this.meetingRelayMapper.batchDel(bizId, userId, meetingId, (Collection)delRelayRoomIds);
        }
    }
}

