/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.service.impl;

import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.service.CcCustomerInfoService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.enums.meeting.MeetingLiveDeliveryAuthMode;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.meeting.dto.MeetingBjyInfo;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingBjy;
import com.kuaike.scrm.dal.meeting.entity.MeetingBjyStudentInfo;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerParamEncryRelation;
import com.kuaike.scrm.dal.meeting.entity.MeetingSetting;
import com.kuaike.scrm.dal.meeting.mapper.MeetingBjyMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingBjyStudentInfoMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerOrderRelationMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerParamEncryRelationMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingSettingMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopOrderMapper;
import com.kuaike.scrm.dto.GoodsDetailOfficialAuthUrlDto;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudBatchUserResp;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudMeetingRespDto;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudPullUrlResp;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudPushUrlResp;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudRoomListResp;
import com.kuaike.scrm.meeting.dto.reponse.GoodsDetailGetOfficialAuthUrlResp;
import com.kuaike.scrm.meeting.dto.reponse.JoinMeetingRespDto;
import com.kuaike.scrm.meeting.dto.reponse.MeetingBindingMobileResp;
import com.kuaike.scrm.meeting.dto.reponse.MeetingCustomerInfoResp;
import com.kuaike.scrm.meeting.dto.reponse.MeetingImportFileResp;
import com.kuaike.scrm.meeting.dto.reponse.MeetingPushPullResp;
import com.kuaike.scrm.meeting.dto.request.AddOrEditLiveRequestDto;
import com.kuaike.scrm.meeting.dto.request.BaijiacloudBaseReqDto;
import com.kuaike.scrm.meeting.dto.request.BaijiacloudMeetingListReqDto;
import com.kuaike.scrm.meeting.dto.request.BaijiacloudPushUrlReq;
import com.kuaike.scrm.meeting.dto.request.GoodsDetailGetOfficialAuthUrlReq;
import com.kuaike.scrm.meeting.dto.request.JoinMeetingReqDto;
import com.kuaike.scrm.meeting.dto.request.MeetingBindingMobileReq;
import com.kuaike.scrm.meeting.dto.request.MeetingCustomerInfoReq;
import com.kuaike.scrm.meeting.dto.request.MeetingPushPullReq;
import com.kuaike.scrm.meeting.dto.request.PullRoomListReqDto;
import com.kuaike.scrm.meeting.dto.request.UpdateLiveRequestDto;
import com.kuaike.scrm.meeting.service.BaijiacloudApiService;
import com.kuaike.scrm.meeting.service.MeetingPlusService;
import com.kuaike.scrm.meeting.service.MeetingService;
import com.kuaike.scrm.order.enums.OrderStatus;
import com.kuaike.scrm.order.service.GoodsOrderEsService;
import com.kuaike.scrm.service.MeetingCacheService;
import com.kuaike.scrm.service.MeetingUrlCommonService;
import com.kuaike.scrm.service.MeetingUrlService;
import com.kuaike.scrm.wework.corp.service.WeworkCorpService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MeetingPlusServiceImpl
implements MeetingPlusService {
    private static final Logger log = LoggerFactory.getLogger(MeetingPlusServiceImpl.class);
    private static final String[] SHEET_HEAD_TITLES = new String[]{"\u9884\u8ba1\u901a\u77e5\u4eba\u6570", "\u5b9e\u9645\u901a\u77e5\u4eba\u6570", "\u5165\u4f1a\u4eba\u6570", "\u672a\u5165\u4f1a\u4eba\u6570"};
    private static final String[] QUALITY_HEAD_TITLES = new String[]{"\u6210\u5458", "\u5ba2\u6237", "\u5907\u6ce8", "\u624b\u673a\u53f7", "\u901a\u77e5\u662f\u5426\u53d1\u9001", "\u662f\u5426\u53c2\u4f1a", "\u5165\u4f1a\u65f6\u95f4", "\u9000\u51fa\u65f6\u95f4", "\u53c2\u4f1a\u65f6\u957f", "\u5b8c\u8bfe\u7387", "\u5165\u4f1a\u6b21\u6570", "\u8f6c\u53d1\u6b21\u6570", "\u6e20\u9053"};
    @Autowired
    private MeetingBjyMapper meetingBjyMapper;
    @Autowired
    private MeetingService meetingService;
    @Autowired
    private WeworkCorpService weworkCorpService;
    @Autowired
    private BaijiacloudApiService apiService;
    @Autowired
    private MeetingSettingMapper settingMapper;
    @Autowired
    private BaijiacloudApiService baijiacloudApiService;
    @Autowired
    private MeetingSettingMapper meetingSettingMapper;
    @Resource
    private MeetingUrlService meetingUrlService;
    @Autowired
    private MeetingMapper meetingMapper;
    @Autowired
    private MeetingBjyStudentInfoMapper studentInfoMapper;
    @Resource
    private MeetingCustomerParamEncryRelationMapper meetingCustomerParamEncryRelationMapper;
    @Resource
    private CcCustomerNumService ccCustomerNumService;
    @Resource
    private CcCustomerInfoService ccCustomerInfoService;
    @Resource
    private MeetingCustomerOrderRelationMapper meetingCustomerOrderRelationMapper;
    @Resource
    private GoodsOrderEsService goodsOrderEsService;
    @Resource
    private ShopOrderMapper shopOrderMapper;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private MeetingUrlCommonService meetingUrlCommonService;
    @Resource
    private MeetingCacheService meetingCacheService;
    @Value(value="${baijiacloud.quickenter.url}")
    private String quickEnterUrl;
    @Value(value="${baijiacloud.private.meeting.url}")
    private String privateEnterUrl;
    private static final int HEADER_ROWS = 0;
    private static final int MAX_ROWS = 5000;
    private static final String HEADER_FIRST_CELL_STR = "\u624b\u673a\u53f7\uff08\u5fc5\u586b\uff09";

    @Override
    public List<BaijiacloudMeetingRespDto> getBjyMeetingList(BaijiacloudMeetingListReqDto reqDto) {
        log.info("getBjyMeetingList: reqDto: {}", (Object)reqDto);
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("getBjyMeetingList: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        reqDto.validate();
        List meetingBjyList = this.meetingBjyMapper.getBjyMeetingList(userInfo.getBizId(), userInfo.getCorpId(), reqDto.getTitle(), Integer.valueOf(reqDto.getPageDto().getOffset()), reqDto.getPageDto().getPageSize());
        log.info("getBjyMeetingList: meetingBjyList: {}", (Object)meetingBjyList);
        if (CollectionUtils.isEmpty((Collection)meetingBjyList)) {
            return Collections.emptyList();
        }
        int count = this.meetingBjyMapper.getBjyMeetingListCount(userInfo.getBizId(), userInfo.getCorpId(), reqDto.getTitle());
        reqDto.getPageDto().setCount(Integer.valueOf(count));
        reqDto.getPageDto().setCurPageCount(Integer.valueOf(meetingBjyList.size()));
        return meetingBjyList.stream().map(this::convertBaijiaCloudMeeting).collect(Collectors.toList());
    }

    private CurrentUserInfo baseValidate() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5c5e\u5546\u6237\u4fe1\u606f\u4e0d\u80fd\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
        return currentUserInfo;
    }

    private BaijiacloudMeetingRespDto convertBaijiaCloudMeeting(MeetingBjy meetingBjy) {
        BaijiacloudMeetingRespDto respDto = new BaijiacloudMeetingRespDto();
        respDto.setId(meetingBjy.getId());
        respDto.setRoomId(meetingBjy.getRoomId());
        respDto.setTitle(meetingBjy.getTitle());
        respDto.setStartTime(meetingBjy.getStartTime());
        respDto.setEndTime(meetingBjy.getEndTime());
        respDto.setCreateTime(meetingBjy.getCreateTime());
        respDto.setIsLongTerm(meetingBjy.getIsLongTerm());
        respDto.setIsPrivate(meetingBjy.getIsPrivate());
        respDto.setIsPushLive(meetingBjy.getIsPushLive());
        respDto.setTemplateType(meetingBjy.getTemplateType());
        return respDto;
    }

    @Override
    public void export(JoinMeetingReqDto dto, HttpServletResponse response) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("export QualityCheck,params:{}, operatorId:{}, corpId:{}", new Object[]{dto, currentUser.getId(), currentUser.getCorpId()});
        dto.validate();
        int index = 0;
        if (dto.getSendStatus() == null && dto.getJoinStatus() == null) {
            index = 0;
        } else if (dto.getSendStatus() == 1 && dto.getJoinStatus() == null) {
            index = 1;
        } else if (dto.getSendStatus() == 1 && dto.getJoinStatus() == 1) {
            index = 2;
        } else if (dto.getSendStatus() == 1 && dto.getJoinStatus() == 0) {
            index = 3;
        }
        String fileName = "\u4f1a\u8bae" + SHEET_HEAD_TITLES[index] + ".xls";
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(SHEET_HEAD_TITLES[index]);
        HSSFRow row = sheet.createRow(0);
        row.setZeroHeight(false);
        row.setHeight((short)360);
        HSSFCellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFFont headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)12);
        headerCellStyle.setFont((Font)headerFont);
        for (int j = 0; j < QUALITY_HEAD_TITLES.length; ++j) {
            sheet.setColumnWidth(j, 6400);
            HSSFCell cell = row.createCell(j);
            cell.setCellStyle(headerCellStyle);
            HSSFRichTextString text = new HSSFRichTextString(QUALITY_HEAD_TITLES[j]);
            cell.setCellValue((RichTextString)text);
        }
        log.info("export meeting param dto : {}", (Object)dto);
        List<JoinMeetingRespDto> meetingRespDtos = this.meetingService.joinMeetingDetail(dto);
        if (CollectionUtils.isNotEmpty(meetingRespDtos)) {
            int rowNum = 1;
            for (JoinMeetingRespDto respDto : meetingRespDtos) {
                HSSFRow ssRow = sheet.createRow(rowNum);
                ssRow.createCell(0).setCellValue(respDto.getMemberNickname());
                String customerNickName = respDto.getCustomerNickname() == null ? "" : respDto.getCustomerNickname();
                ssRow.createCell(1).setCellValue(customerNickName);
                String corpName = respDto.getCustomerCorpName() == null ? "" : respDto.getCustomerCorpName();
                ssRow.createCell(2).setCellValue(corpName);
                String customerMobile = respDto.getCustomerPhone() == null ? "" : respDto.getCustomerPhone();
                ssRow.createCell(3).setCellValue(customerMobile);
                if (Objects.nonNull(respDto.getSendStatus())) {
                    String status = respDto.getSendStatus() == 1 ? "\u5df2\u53d1\u9001" : "\u672a\u53d1\u9001";
                    ssRow.createCell(4).setCellValue(status);
                } else {
                    ssRow.createCell(4).setCellValue("");
                }
                String joinStatus = respDto.getJoinStatus() == 1 ? "\u662f" : "\u5426";
                ssRow.createCell(5).setCellValue(joinStatus);
                if (Objects.nonNull(respDto.getCustomerJoinTime())) {
                    ssRow.createCell(6).setCellValue(DateUtil.dateToDateString((Date)respDto.getCustomerJoinTime()));
                } else if (Objects.nonNull(respDto.getMemberJoinTime())) {
                    ssRow.createCell(6).setCellValue(DateUtil.dateToDateString((Date)respDto.getMemberJoinTime()));
                } else {
                    ssRow.createCell(6).setCellValue("");
                }
                if (Objects.nonNull(respDto.getCustomerQuitTime())) {
                    ssRow.createCell(7).setCellValue(DateUtil.dateToDateString((Date)respDto.getCustomerQuitTime()));
                } else if (Objects.nonNull(respDto.getMemberQuitTime())) {
                    ssRow.createCell(7).setCellValue(DateUtil.dateToDateString((Date)respDto.getMemberQuitTime()));
                } else {
                    ssRow.createCell(7).setCellValue("");
                }
                if (Objects.nonNull(respDto.getCustomerDuration())) {
                    int min = respDto.getCustomerDuration() / 60;
                    if (respDto.getCustomerDuration() % 60 > 30) {
                        ++min;
                    }
                    ssRow.createCell(8).setCellValue((double)min);
                } else if (Objects.nonNull(respDto.getMemberDuration())) {
                    int min = respDto.getMemberDuration() / 60;
                    if (respDto.getMemberDuration() % 60 > 30) {
                        ++min;
                    }
                    ssRow.createCell(8).setCellValue((double)min);
                } else {
                    ssRow.createCell(8).setCellValue("");
                }
                String completePercent = respDto.getCompletePercent();
                if (StringUtils.isNotBlank((CharSequence)completePercent)) {
                    float percent = (float)Math.round(Float.parseFloat(completePercent) * 10000.0f) / 100.0f;
                    String comPer = percent + "%";
                    log.info("createCell percent: {}", (Object)comPer);
                    ssRow.createCell(9).setCellValue(comPer);
                } else {
                    ssRow.createCell(9).setCellValue("");
                }
                if (Objects.nonNull(respDto.getCustomerCount())) {
                    ssRow.createCell(10).setCellValue((double)respDto.getCustomerCount().intValue());
                } else if (Objects.nonNull(respDto.getMemberCount())) {
                    ssRow.createCell(10).setCellValue((double)respDto.getMemberCount().intValue());
                } else {
                    ssRow.createCell(10).setCellValue("");
                }
                if (Objects.nonNull(respDto.getForwardCount())) {
                    ssRow.createCell(11).setCellValue((double)respDto.getForwardCount().intValue());
                } else {
                    ssRow.createCell(11).setCellValue("");
                }
                String sourceDesc = respDto.getCustomerSourceDesc() == null ? "" : respDto.getCustomerSourceDesc();
                ssRow.createCell(12).setCellValue(sourceDesc);
                ++rowNum;
            }
        } else {
            log.info("export meeting detail is null");
        }
        log.info("export meeting detail excel");
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.flushBuffer();
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            log.error("\u6253\u5f00Excel\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void initScrmAccount(BaijiacloudBaseReqDto reqDto) {
        this.apiService.initScrmAccount(reqDto);
        log.info("initScrmAccount load room list");
        List settings = this.settingMapper.getSettingByPartnerId(reqDto.getPartnerId());
        if (CollectionUtils.isNotEmpty((Collection)settings)) {
            for (MeetingSetting setting : settings) {
                this.loadRoomList(reqDto, setting, null, null);
            }
        }
    }

    @Override
    public void initAllCorps() {
        List corpIds = this.weworkCorpService.getCorpIds();
        for (String corpId : corpIds) {
            MeetingSetting setting = this.settingMapper.getSettingByCorpId(corpId);
            if (setting == null) continue;
            log.info("initAllCorps corpId: {}, bjyId: {}", (Object)corpId, (Object)setting.getBjyId());
            if (!StringUtils.isNotBlank((CharSequence)setting.getBjyId())) continue;
            BaijiacloudBaseReqDto reqDto = new BaijiacloudBaseReqDto();
            reqDto.setPartnerId(setting.getBjyId());
            reqDto.setPartnerKey(setting.getBjyKey());
            reqDto.setPrivateDomain(setting.getDominSite());
            this.apiService.initScrmAccount(reqDto);
        }
    }

    @Override
    public void pullRoomList(PullRoomListReqDto pullRoomListReqDto) {
        String corpId = pullRoomListReqDto.getCorpId();
        log.info("pullRoomList corpId: {}", (Object)corpId);
        if (StringUtils.isBlank((CharSequence)corpId)) {
            return;
        }
        MeetingSetting setting = this.settingMapper.getSettingByCorpId(corpId);
        if (setting != null) {
            BaijiacloudBaseReqDto reqDto = new BaijiacloudBaseReqDto();
            reqDto.setPartnerId(setting.getBjyId());
            reqDto.setPartnerKey(setting.getBjyKey());
            reqDto.setPrivateDomain(setting.getDominSite());
            this.loadRoomList(reqDto, setting, pullRoomListReqDto.getPage(), pullRoomListReqDto.getLimit());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateRoomInfo(UpdateLiveRequestDto reqDto) {
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("updateRoomInfo, params:{}, corpId:{}, operatorId:{}", new Object[]{reqDto, userInfo.getCorpId(), userInfo.getId()});
        MeetingSetting meetingSetting = this.meetingSettingMapper.getSettingByCorpId(userInfo.getCorpId());
        Preconditions.checkArgument((boolean)Objects.nonNull(meetingSetting), (Object)"\u672a\u8bbe\u7f6e\u767e\u5bb6\u4e91\u4f1a\u8bae\u914d\u7f6e\u4fe1\u606f");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)meetingSetting.getDominSite()), (Object)"\u4e13\u5c5e\u57df\u540d\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)meetingSetting.getBjyId()), (Object)"\u5f00\u53d1\u8005Partner_ID\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)meetingSetting.getBjyKey()), (Object)"\u5f00\u53d1\u8005Partner_Key\u4e3a\u7a7a");
        Meeting meeting = this.meetingMapper.queryById(userInfo.getBizId(), userInfo.getCorpId(), reqDto.getMeetingId());
        if (Objects.isNull(meeting)) {
            log.info("updateRoomInfo, \u67e5\u8be2\u4e0d\u5230\u4f1a\u8bae:{}", (Object)reqDto.getMeetingId());
            return;
        }
        String roomId = meeting.getRoomId();
        if (StringUtils.isBlank((CharSequence)roomId)) {
            log.info("updateRoomInfo, roomId \u4e3a\u7a7a");
            return;
        }
        AddOrEditLiveRequestDto requestDto = new AddOrEditLiveRequestDto();
        requestDto.setPrivateDomain(meetingSetting.getDominSite());
        requestDto.setPartnerId(meetingSetting.getBjyId());
        requestDto.setPartnerKey(meetingSetting.getBjyKey());
        if (reqDto.getIsPrivate() == 1) {
            requestDto.setIsPrivate(6);
        } else if (reqDto.getIsPrivate() == 2) {
            requestDto.setIsPrivate(3);
        } else {
            requestDto.setIsPrivate(0);
        }
        try {
            this.baijiacloudApiService.updateRoomInfo(requestDto, roomId);
        }
        catch (BusinessException e) {
            throw e;
        }
        catch (Exception ex) {
            log.error("\u66f4\u65b0\u4f1a\u8bae\u6559\u5ba4\u4fe1\u606f\u5f02\u5e38:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u66f4\u65b0\u4f1a\u8bae\u6559\u5ba4\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        this.meetingBjyMapper.updatePrivateSetting(reqDto.getIsPrivate(), roomId, userInfo.getCorpId());
        this.meetingMapper.updatePrivate(meeting.getId(), reqDto.getIsPrivate());
        BaijiacloudBaseReqDto baseReqDto = new BaijiacloudBaseReqDto();
        baseReqDto.setPartnerId(meetingSetting.getBjyId());
        baseReqDto.setPartnerKey(meetingSetting.getBjyKey());
        baseReqDto.setPrivateDomain(meetingSetting.getDominSite());
        List infoList = this.studentInfoMapper.queryStudentList(roomId, userInfo.getBizId());
        if (CollectionUtils.isNotEmpty((Collection)infoList)) {
            List<String> uids = infoList.stream().map(MeetingBjyStudentInfo::getBjyUserId).collect(Collectors.toList());
            log.info("updateRoomInfo remove uids : {}", uids);
            try {
                this.baijiacloudApiService.removeClassBindStudentBatch(baseReqDto, roomId, uids);
                log.info("updateRoomInfo removeClassBindStudentBatch success");
            }
            catch (Exception ex) {
                log.error("\u6559\u5ba4\u89e3\u9664\u7ed1\u5b9a\u5b66\u5458\u5931\u8d25\u5f02\u5e38:", (Throwable)ex);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6559\u5ba4\u89e3\u9664\u7ed1\u5b9a\u5b66\u5458\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
        }
        if (reqDto.getIsPrivate() == 2) {
            List<String> studentUserIds = reqDto.getStudentUserIds();
            try {
                this.baijiacloudApiService.classBindStudentBatch(baseReqDto, roomId, studentUserIds);
                log.info("updateRoomInfo classBindStudentBatch success");
            }
            catch (Exception ex) {
                log.error("\u6559\u5ba4\u7ed1\u5b9a\u5b66\u5458\u5f02\u5e38:", (Throwable)ex);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6559\u5ba4\u7ed1\u5b9a\u5b66\u5458\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
        }
        String oldMeeingUrl = meeting.getMeetingUrl();
        String studentCode = meeting.getStudentCode();
        String newMeetingUrl = reqDto.getIsPrivate() == 1 || reqDto.getIsPrivate() == 2 ? this.getPrivateMeeingUrl(meetingSetting.getDominSite(), roomId) : this.getMeetingUrl(meetingSetting.getDominSite(), studentCode);
        String originMeetingUrl = "";
        if (YnEnum.YES.getValue().equals(meeting.getLiveDeliverySwitch())) {
            if (!meeting.getIsPrivate().equals(reqDto.getIsPrivate())) {
                originMeetingUrl = reqDto.getIsPrivate() == 1 || reqDto.getIsPrivate() == 2 ? this.meetingUrlCommonService.buildPrepareUrl(roomId) : this.meetingUrlCommonService.buildQuickEnterUrl(studentCode);
            }
            newMeetingUrl = this.meetingUrlCommonService.getMeetingAuthUrl(meeting.getBizId(), null, meeting.getNum(), null, false, meeting.getRoomId(), meeting.getMeetingUrl(), meeting.getLiveDeliveryAuthMode());
        }
        log.info("updateRoomInfo, oldMeeingUrl: {},  newMeetingUrl: {}", (Object)oldMeeingUrl, (Object)newMeetingUrl);
        String meetingInfo = meeting.getMeetingInfo();
        String meetingParam = meeting.getParams();
        String meetingInviteContent = meeting.getInviteContent();
        if (StringUtils.isNotBlank((CharSequence)oldMeeingUrl) && meetingInfo.contains(oldMeeingUrl)) {
            meetingInfo = meetingInfo.replace(oldMeeingUrl, newMeetingUrl);
            log.info("updateRoomInfo, meetingInfo: {}", (Object)meetingInfo);
            if (meetingParam.contains(oldMeeingUrl)) {
                meetingParam = meetingParam.replace(oldMeeingUrl, newMeetingUrl);
            }
            if (meetingInviteContent.contains(oldMeeingUrl)) {
                meetingInviteContent = meetingInviteContent.replace(oldMeeingUrl, newMeetingUrl);
            }
            this.meetingMapper.updateMeeingInfo(meetingInfo, meetingParam, meetingInviteContent, newMeetingUrl, userInfo.getCorpId(), reqDto.getMeetingId(), originMeetingUrl);
        }
        if (meeting.getLiveDeliverySwitch().equals(NumberUtils.INTEGER_ONE)) {
            meeting.setIsPrivate(reqDto.getIsPrivate());
            this.meetingCacheService.setMeetingCache(meeting);
        }
    }

    private String getMeetingUrl(String privateDomain, String studentCode) {
        if (!privateDomain.endsWith("/")) {
            privateDomain = privateDomain + "/";
        }
        return privateDomain + this.quickEnterUrl + "?code=" + studentCode + "${customstr}";
    }

    private String getPrivateMeeingUrl(String privateDomain, String roomId) {
        if (!privateDomain.endsWith("/")) {
            privateDomain = privateDomain + "/";
        }
        return privateDomain + this.privateEnterUrl + "?room_id=" + roomId + "${customstr}";
    }

    private void loadRoomList(BaijiacloudBaseReqDto reqDto, MeetingSetting setting, Integer page, Integer limit) {
        log.info("loadRoomList reqDto: {}, setting: {}, page: {}, size: {} ", new Object[]{reqDto, setting, page, limit});
        List<BaijiacloudRoomListResp> respList = this.apiService.exportRoomList(reqDto, page, limit);
        log.info("loadRoomList respList size: {}, respList: {} ", (Object)respList.size(), respList);
        if (CollectionUtils.isNotEmpty(respList)) {
            ArrayList addList = Lists.newArrayList();
            for (BaijiacloudRoomListResp resp : respList) {
                MeetingBjy meetingBjy = this.meetingBjyMapper.getBjyMeeting(resp.getRoomId(), setting.getBizId(), setting.getCorpId());
                if (meetingBjy == null) {
                    MeetingBjyInfo bjyInfo = this.getMeetingInfo(resp, setting);
                    addList.add(bjyInfo);
                    continue;
                }
                log.info("loadRoomList roomId is exist  roomId: {}", (Object)resp.getRoomId());
            }
            if (addList.size() > 0) {
                this.meetingBjyMapper.addBjyMeeting((List)addList);
                log.info("loadRoomList, add meetingList: {}", (Object)addList);
            }
        }
    }

    private MeetingBjyInfo getMeetingInfo(BaijiacloudRoomListResp resp, MeetingSetting setting) {
        MeetingBjyInfo bjyInfo = new MeetingBjyInfo();
        bjyInfo.setRoomId(resp.getRoomId());
        bjyInfo.setTitle(resp.getTitle());
        bjyInfo.setType(Integer.valueOf(resp.getType()));
        bjyInfo.setMaxUsers(Integer.valueOf(resp.getMaxUsers()));
        bjyInfo.setTeacherCode(resp.getTeacherCode());
        bjyInfo.setAdminCode(resp.getAdminCode());
        bjyInfo.setStudentCode(resp.getStudentCode());
        long startTime = Long.parseLong(resp.getStartTime()) * 1000L;
        bjyInfo.setStartTime(new Date(startTime));
        long endTime = Long.parseLong(resp.getEndTime()) * 1000L;
        bjyInfo.setEndTime(new Date(endTime));
        long createTime = Long.parseLong(resp.getCreateTime()) * 1000L;
        bjyInfo.setCreateTime(new Date(createTime));
        bjyInfo.setCorpId(setting.getCorpId());
        bjyInfo.setBizId(setting.getBizId());
        bjyInfo.setBjyId(setting.getBjyId());
        bjyInfo.setBjyKey(setting.getBjyKey());
        bjyInfo.setCreateType(Integer.valueOf(2));
        bjyInfo.setIsLongTerm(Integer.valueOf(0));
        if (resp.getIsPrivate() != null) {
            bjyInfo.setIsPrivate(Integer.valueOf(resp.getIsPrivate()));
        }
        if (resp.getIsPushLive() != null) {
            bjyInfo.setIsPushLive(Integer.valueOf(resp.getIsPushLive()));
        }
        if (StringUtils.isNotEmpty((CharSequence)resp.getTemplateName())) {
            if (resp.getTemplateName().equals("video")) {
                bjyInfo.setTemplateType(Integer.valueOf(1));
            } else {
                bjyInfo.setTemplateType(Integer.valueOf(0));
            }
        }
        return bjyInfo;
    }

    @Override
    public MeetingImportFileResp importFile(InputStream inp) {
        MeetingImportFileResp importResultDto = new MeetingImportFileResp();
        try {
            Workbook workbook = MeetingPlusServiceImpl.create(inp);
            int numberOfSheets = workbook.getNumberOfSheets();
            if (numberOfSheets != 1) {
                log.warn("excel\u6587\u4ef6sheet\u9875\u6570\u4e3a:{}", (Object)numberOfSheets);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "excel\u6587\u4ef6\u4e2dsheet\u9875\u6570\u4e0d\u4e3a1");
            }
            Sheet sheet = workbook.getSheetAt(0);
            int physicalNumberOfRows = sheet.getPhysicalNumberOfRows();
            if (physicalNumberOfRows - 0 > 5000) {
                log.warn("excel\u6587\u4ef6\u4e2d\u6570\u636e\u603b\u884c\u6570\u4e3a:{}", (Object)(physicalNumberOfRows - 0));
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5355\u6b21\u6700\u591a\u5bfc\u51655000\u6761");
            }
            Row headerRow = sheet.getRow(0);
            Cell firstCell = headerRow.getCell(NumberUtils.INTEGER_ZERO.intValue());
            String firstCellStr = firstCell.getStringCellValue();
            log.info("importFile firstCellStr: {}", (Object)firstCellStr);
            if (!HEADER_FIRST_CELL_STR.equals(firstCellStr)) {
                log.warn("\u6807\u9898\u884c\u7b2c\u4e00\u5217\u6807\u9898\u4e3a:{}", (Object)firstCellStr);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8868\u5934\u7b2c\u4e00\u5217\u4e0d\u4e3a\u3010\u624b\u673a\u53f7\uff08\u5fc5\u586b\uff09\u3011");
            }
            int totalCount = physicalNumberOfRows - 0;
            ArrayList mobiles = Lists.newArrayList();
            int invalidateCount = 0;
            int i = 0;
            int dataStartRow = -1;
            while (i < totalCount) {
                Row row;
                if (Objects.isNull(row = sheet.getRow(++dataStartRow))) continue;
                Cell cell = row.getCell(NumberUtils.INTEGER_ZERO.intValue());
                if (Objects.isNull(cell)) {
                    row.createCell(2).setCellValue("\u624b\u673a\u53f7\u672a\u586b\u5199");
                    ++invalidateCount;
                    ++i;
                    continue;
                }
                cell.setCellType(CellType.STRING);
                String mobile = cell.getStringCellValue();
                if (StringUtils.isBlank((CharSequence)mobile)) {
                    row.createCell(2).setCellValue("\u624b\u673a\u53f7\u672a\u586b\u5199");
                    ++invalidateCount;
                    ++i;
                    continue;
                }
                if (!MobileUtils.isPhone((String)mobile)) {
                    row.createCell(2).setCellValue("\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e");
                    ++invalidateCount;
                } else if (mobiles.contains(mobile)) {
                    ++invalidateCount;
                    row.createCell(2).setCellValue("\u624b\u673a\u53f7\u91cd\u590d");
                } else {
                    mobiles.add(mobile);
                }
                ++i;
            }
            Integer efficentCount = totalCount - invalidateCount;
            importResultDto.setTotalCount(totalCount);
            importResultDto.setEfficientCount(efficentCount);
            importResultDto.setMobileList(mobiles);
        }
        catch (Exception e) {
            if (e instanceof BusinessException) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, e.getMessage());
            }
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u5165\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        return importResultDto;
    }

    private static Workbook create(InputStream inp) throws IOException {
        if (!inp.markSupported()) {
            inp = new PushbackInputStream(inp, 8);
        }
        return WorkbookFactory.create((InputStream)inp);
    }

    @Override
    public List<MeetingBindingMobileResp> bindingMobile(MeetingBindingMobileReq req) {
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("bindingMobile, params:{}, corpId:{}, operatorId:{}", new Object[]{req, userInfo.getCorpId(), userInfo.getId()});
        Preconditions.checkArgument((req.getMobiles().size() < 300 ? 1 : 0) != 0, (Object)"\u5355\u6b21\u521b\u5efa\u7528\u6237\u4e0d\u80fd\u8d85\u8fc7300\u4e2a");
        MeetingSetting meetingSetting = this.meetingSettingMapper.getSettingByCorpId(userInfo.getCorpId());
        BaijiacloudBaseReqDto baseReqDto = new BaijiacloudBaseReqDto();
        baseReqDto.setPartnerId(meetingSetting.getBjyId());
        baseReqDto.setPartnerKey(meetingSetting.getBjyKey());
        baseReqDto.setPrivateDomain(meetingSetting.getDominSite());
        ArrayList mobileResps = Lists.newArrayList();
        List<Object> needBindMobiles = Lists.newArrayList();
        List bindedInfos = this.studentInfoMapper.queryAllMobiles();
        if (CollectionUtils.isNotEmpty((Collection)bindedInfos)) {
            for (String mobile : req.getMobiles()) {
                for (MeetingBjyStudentInfo studentInfo : bindedInfos) {
                    if (mobile.equals(studentInfo.getMobile())) {
                        MeetingBindingMobileResp resp = new MeetingBindingMobileResp();
                        resp.setUserId(studentInfo.getBjyUserId());
                        resp.setMobile(studentInfo.getMobile());
                        mobileResps.add(resp);
                        continue;
                    }
                    if (needBindMobiles.contains(mobile)) continue;
                    needBindMobiles.add(mobile);
                }
            }
        } else {
            needBindMobiles = req.getMobiles();
        }
        log.info("bindingMobile needBind mobiles: {}", (Object)needBindMobiles);
        List<BaijiacloudBatchUserResp> resps = null;
        try {
            resps = this.baijiacloudApiService.batchAddStudentUser(baseReqDto, (List<String>)needBindMobiles);
        }
        catch (Exception e) {
            log.error("error: ", (Throwable)e);
        }
        if (CollectionUtils.isNotEmpty(resps)) {
            resps.forEach(a -> {
                MeetingBindingMobileResp resp = new MeetingBindingMobileResp();
                resp.setUserId(a.getId());
                resp.setMobile(a.getPhoneNumber());
                mobileResps.add(resp);
            });
        }
        return mobileResps;
    }

    @Override
    public MeetingCustomerInfoResp meetingCustomerInfo(MeetingCustomerInfoReq req) {
        log.info("meetingCustomerInfo req:{}", (Object)req);
        req.validate();
        MeetingCustomerInfoResp resp = new MeetingCustomerInfoResp();
        if (StringUtils.isBlank((CharSequence)req.getCustomerStr())) {
            return resp;
        }
        MeetingCustomerParamEncryRelation select = new MeetingCustomerParamEncryRelation();
        select.setEncryNum(req.getCustomerStr());
        MeetingCustomerParamEncryRelation relation = (MeetingCustomerParamEncryRelation)this.meetingCustomerParamEncryRelationMapper.selectOne((Object)select);
        log.info("meetingCustomerInfo relation:{}", (Object)relation);
        if (relation == null) {
            return resp;
        }
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{relation.getAppId(), relation.getOpenId()}) || "-1".equals(relation.getAppId()) && "-1".equals(relation.getOpenId())) {
            return resp;
        }
        String unionId = relation.getUnionId();
        String customerNum = MeetingLiveDeliveryAuthMode.OFFICIAL_ACCOUNT.getValue().equals(req.getAuthMode()) ? this.ccCustomerNumService.getCustomerNumByOfficialFans(relation.getBizId(), relation.getAppId(), relation.getOpenId(), unionId) : this.ccCustomerNumService.getCustomerNumByMiniProgram(relation.getBizId(), relation.getAppId(), relation.getOpenId(), unionId);
        CustomerDetailResp customerDetail = this.ccCustomerInfoService.queryCustomerDetail(relation.getBizId(), customerNum);
        resp.setName(customerDetail.getName());
        resp.setMobile(StringUtils.isNotBlank((CharSequence)customerDetail.getMobile1()) ? customerDetail.getMobile1() : customerDetail.getMobile2());
        return resp;
    }

    @Override
    public void meetingOrderPayTimeout() {
        boolean flag;
        Date now = new Date();
        long startTime = now.getTime() - 1860000L;
        Date start = new Date(startTime);
        List waitPayOrderIds = this.meetingCustomerOrderRelationMapper.queryWaitPayByTime(start, OrderStatus.WAIT_PAY.getStatus());
        log.info("meetingOrderPayTimeout start:{} now:{} waitPayOrderIds:{}", new Object[]{start, now, waitPayOrderIds});
        if (CollectionUtils.isEmpty((Collection)waitPayOrderIds)) {
            return;
        }
        for (int retry = 3; retry > 0 && !(flag = this.goodsOrderEsService.batchUpdateStatusByOrderIds(waitPayOrderIds, OrderStatus.FAIL.getStatus())); --retry) {
        }
        this.shopOrderMapper.batchUpdateStatusByOrderIds(waitPayOrderIds, OrderStatus.FAIL.getStatus());
    }

    @Override
    public List<MeetingPushPullResp> queryMeeingStream(MeetingPushPullReq req) {
        BaijiacloudPullUrlResp pullUrlResp;
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("queryMeeingStream, params:{}, corpId:{}, operatorId:{}", new Object[]{req, userInfo.getCorpId(), userInfo.getId()});
        Meeting meeting = this.meetingMapper.queryById(userInfo.getBizId(), userInfo.getCorpId(), req.getId());
        if (meeting == null) {
            log.info("queryMeeingStream meetingNum: {}, bizID: {}", (Object)req.getId(), (Object)userInfo.getBizId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u76f4\u64ad");
        }
        MeetingSetting meetingSetting = this.meetingSettingMapper.getSettingByCorpId(userInfo.getCorpId());
        Preconditions.checkArgument((boolean)Objects.nonNull(meetingSetting), (Object)"\u672a\u8bbe\u7f6e\u767e\u5bb6\u4e91\u4f1a\u8bae\u914d\u7f6e\u4fe1\u606f");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)meetingSetting.getDominSite()), (Object)"\u4e13\u5c5e\u57df\u540d\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)meetingSetting.getBjyId()), (Object)"\u5f00\u53d1\u8005Partner_ID\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)meetingSetting.getBjyKey()), (Object)"\u5f00\u53d1\u8005Partner_Key\u4e3a\u7a7a");
        String roomId = meeting.getRoomId();
        BaijiacloudPushUrlReq streamReq = new BaijiacloudPushUrlReq();
        streamReq.setPartnerId(meetingSetting.getBjyId());
        streamReq.setPartnerKey(meetingSetting.getBjyKey());
        streamReq.setPrivateDomain(meetingSetting.getDominSite());
        streamReq.setRoomId(roomId);
        ArrayList resps = Lists.newArrayList();
        BaijiacloudPushUrlResp pushUrlResp = this.baijiacloudApiService.getRoomPushUrl(streamReq);
        if (pushUrlResp != null) {
            MeetingPushPullResp ppResp = new MeetingPushPullResp();
            ppResp.setType(1);
            ppResp.setPushUrl(pushUrlResp.getPushUrl());
            ppResp.setExpireTime(DateUtil.getDate((String)pushUrlResp.getExpireTime()));
            resps.add(ppResp);
        }
        if ((pullUrlResp = this.baijiacloudApiService.getRoomPullUrl(streamReq)) != null) {
            MeetingPushPullResp ppResp = new MeetingPushPullResp();
            ppResp.setType(2);
            ppResp.setRtmpUrl(pullUrlResp.getRtmpUrl());
            ppResp.setM3u8Url(pullUrlResp.getM3u8Url());
            resps.add(ppResp);
        }
        return resps;
    }

    @Override
    public GoodsDetailGetOfficialAuthUrlResp goodsDetailGetOfficialAuthUrl(GoodsDetailGetOfficialAuthUrlReq req) {
        Meeting meeting;
        log.info("goodsDetailGetOfficialAuthUrl,req:{}", (Object)req);
        req.validate();
        if (StringUtils.isNotBlank((CharSequence)req.getMeetingId())) {
            meeting = this.meetingMapper.selectByNum(req.getMeetingId());
            Preconditions.checkArgument((meeting != null ? 1 : 0) != 0, (Object)"\u76f4\u64ad\u4e0d\u5b58\u5728");
        } else {
            List meetings = this.meetingMapper.selectByRoomIdUseMeeting(req.getRoomId());
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty((Collection)meetings), (Object)"\u76f4\u64ad\u4e0d\u5b58\u5728");
            meeting = (Meeting)meetings.get(0);
        }
        GoodsDetailOfficialAuthUrlDto dto = this.meetingUrlService.buildGoodsDetailOfficialAuthUrl(meeting, req.getRedirectUrl(), req.getUserNumber(), req.getCustomerStr());
        GoodsDetailGetOfficialAuthUrlResp resp = new GoodsDetailGetOfficialAuthUrlResp();
        resp.setAuthUrl(dto.getAuthUrl());
        resp.setAuthorized(dto.getAuthorized());
        resp.setCustomerStr(dto.getCustomerStr());
        log.info("goodsDetailGetOfficialAuthUrl,resp:{}", (Object)resp);
        return resp;
    }
}

